/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import annotator.find.TreeFinder;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.type.TypeKind;
import scenelib.annotations.el.InnerTypeLocation;

public class GenericArrayLocationCriterion
implements Criterion {
    private static final boolean debug = false;
    private final List<TypeAnnotationPosition.TypePathEntry> location;

    public GenericArrayLocationCriterion() {
        this(new ArrayList<TypeAnnotationPosition.TypePathEntry>());
    }

    public GenericArrayLocationCriterion(InnerTypeLocation innerTypeLocation) {
        this(innerTypeLocation.location);
    }

    private GenericArrayLocationCriterion(List<TypeAnnotationPosition.TypePathEntry> list) {
        this.location = list;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    private boolean containsOnlyArray(List<TypeAnnotationPosition.TypePathEntry> list) {
        for (TypeAnnotationPosition.TypePathEntry typePathEntry : list) {
            if (typePathEntry.tag == TypeAnnotationPosition.TypePathEntryKind.ARRAY) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        Tree tree;
        Object object;
        Object object2;
        if (treePath == null || treePath.getParentPath() == null) {
            return false;
        }
        Object object3 = treePath;
        Tree tree2 = treePath.getLeaf();
        Tree tree3 = null;
        if (tree2.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
            tree3 = ((ParameterizedTypeTree)tree2).getType();
        } else if (tree2.getKind() == Tree.Kind.VARIABLE) {
            tree3 = ((VariableTree)tree2).getType();
        } else if (tree2.getKind() == Tree.Kind.NEW_CLASS) {
            tree3 = ((NewClassTree)tree2).getIdentifier();
        } else if (tree2.getKind() == Tree.Kind.NEW_ARRAY && !this.location.isEmpty()) {
            tree3 = ((NewArrayTree)tree2).getType();
        }
        if (tree3 != null && tree3.getKind() == Tree.Kind.MEMBER_SELECT) {
            object2 = ((JCTree.JCFieldAccess)tree3).getExpression();
            if (((JCTree.JCExpression)object2).type != null && ((JCTree.JCExpression)object2).type.getKind() == TypeKind.PACKAGE || this.location.isEmpty() || this.location.get((int)(this.location.size() - 1)).tag != TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE) {
                return false;
            }
        }
        if (tree2.getKind() == Tree.Kind.MEMBER_SELECT) {
            object2 = (JCTree.JCFieldAccess)tree2;
            if (this.isStatic((JCTree.JCFieldAccess)object2)) {
                if (this.location.isEmpty()) {
                    return true;
                }
                if (this.isGenericOrArray(treePath.getParentPath().getLeaf()) && this.isGenericOrArray(treePath.getParentPath().getParentPath().getLeaf())) {
                    object3 = treePath.getParentPath();
                }
            } else {
                object = ((JCTree.JCFieldAccess)object2).getExpression();
                if (object.getKind() == Tree.Kind.MEMBER_SELECT && ((JCTree.JCExpression)object).type != null && ((JCTree.JCExpression)object).type.getKind() == TypeKind.PACKAGE) {
                    if (this.location.isEmpty()) {
                        return true;
                    }
                } else if (!this.location.isEmpty() && this.location.get((int)(this.location.size() - 1)).tag != TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE) {
                    return false;
                }
            }
        }
        if (this.location.isEmpty()) {
            tree2 = treePath.getLeaf();
            object2 = treePath.getParentPath().getLeaf();
            boolean bl = tree2.getKind() == Tree.Kind.NEW_ARRAY || tree2.getKind() == Tree.Kind.NEW_CLASS || tree2.getKind() == Tree.Kind.ANNOTATED_TYPE && this.isSatisfiedBy(TreePath.getPath(treePath, (Tree)((AnnotatedTypeTree)tree2).getUnderlyingType())) || (this.isGenericOrArray(tree2) || tree2.getKind() == Tree.Kind.IDENTIFIER || tree2.getKind() == Tree.Kind.METHOD || tree2.getKind() == Tree.Kind.TYPE_PARAMETER || tree2.getKind() == Tree.Kind.PRIMITIVE_TYPE) && !this.isGenericOrArray((Tree)object2);
            return bl;
        }
        while (((TreePath)object3).getParentPath().getLeaf().getKind() == Tree.Kind.MEMBER_SELECT) {
            object3 = ((TreePath)object3).getParentPath();
        }
        object2 = new ArrayList<TypeAnnotationPosition.TypePathEntry>(this.location);
        while (object2.size() != 0) {
            Object object4;
            tree2 = ((TreePath)object3).getLeaf();
            if (tree2.getKind() == Tree.Kind.NEW_ARRAY && this.containsOnlyArray((List<TypeAnnotationPosition.TypePathEntry>)object2)) {
                return true;
            }
            object = ((TreePath)object3).getParentPath();
            if (object == null) {
                return false;
            }
            tree = ((TreePath)object).getLeaf();
            if (tree.getKind() == Tree.Kind.ANNOTATED_TYPE) {
                object = ((TreePath)object).getParentPath();
                tree = ((TreePath)object).getLeaf();
            }
            TypeAnnotationPosition.TypePathEntry typePathEntry = (TypeAnnotationPosition.TypePathEntry)object2.get(object2.size() - 1);
            if (typePathEntry.tag == TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE) {
                if (tree2.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                    tree2 = tree;
                    object = ((TreePath)object).getParentPath();
                    tree = ((TreePath)object).getLeaf();
                }
                if (tree2.getKind() != Tree.Kind.MEMBER_SELECT) {
                    return false;
                }
                object4 = (JCTree.JCFieldAccess)tree2;
                if (this.isStatic((JCTree.JCFieldAccess)object4)) {
                    return false;
                }
                object2.remove(object2.size() - 1);
                tree2 = ((JCTree.JCFieldAccess)object4).selected;
                object3 = object;
                continue;
            }
            if (typePathEntry.tag == TypeAnnotationPosition.TypePathEntryKind.WILDCARD && tree2.getKind() == Tree.Kind.UNBOUNDED_WILDCARD) {
                if (object2.size() == 0) {
                    return false;
                }
                object4 = ((TreePath)object).getParentPath();
                if (object4 != null) {
                    Tree tree4 = ((TreePath)object4).getLeaf();
                    if (tree4.getKind() == Tree.Kind.INSTANCE_OF) {
                        TreeFinder.warn.debug("WARNING: wildcard bounds not allowed in 'instanceof' expression; skipping insertion%n", new Object[0]);
                        return false;
                    }
                    if (tree4.getKind() == Tree.Kind.PARAMETERIZED_TYPE && (object4 = ((TreePath)object4).getParentPath()) != null && ((TreePath)object4).getLeaf().getKind() == Tree.Kind.ARRAY_TYPE) {
                        TreeFinder.warn.debug("WARNING: wildcard bounds not allowed in generic array type; skipping insertion%n", new Object[0]);
                        return false;
                    }
                }
                object2.remove(object2.size() - 1);
                continue;
            }
            if (tree.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                if (typePathEntry.tag != TypeAnnotationPosition.TypePathEntryKind.TYPE_ARGUMENT) {
                    return false;
                }
                object4 = ((ParameterizedTypeTree)tree).getType();
                int n = object2.size() - 1;
                object2.remove(n--);
                while (object4.getKind() == Tree.Kind.MEMBER_SELECT && !this.isStatic((JCTree.JCFieldAccess)object4) && n >= 0) {
                    if (((TypeAnnotationPosition.TypePathEntry)object2.get((int)n)).tag != TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE) {
                        return false;
                    }
                    object2.remove(n--);
                    object4 = ((MemberSelectTree)object4).getExpression();
                    if (object4.getKind() == Tree.Kind.ANNOTATED_TYPE) {
                        object4 = ((AnnotatedTypeTree)object4).getUnderlyingType();
                    }
                    if (object4.getKind() != Tree.Kind.PARAMETERIZED_TYPE) continue;
                    object4 = ((ParameterizedTypeTree)object4).getType();
                }
                if (n >= 0 && ((TypeAnnotationPosition.TypePathEntry)object2.get((int)n)).tag == TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE) {
                    return false;
                }
                List<? extends Tree> list = ((ParameterizedTypeTree)tree).getTypeArguments();
                boolean bl = false;
                if (list.size() > typePathEntry.arg) {
                    Tree tree5 = list.get(typePathEntry.arg);
                    if (tree5.getKind() == Tree.Kind.ANNOTATED_TYPE) {
                        tree5 = ((AnnotatedTypeTree)tree5).getUnderlyingType();
                    }
                    if (tree5 == tree2) {
                        TreePath treePath2 = ((TreePath)object).getParentPath();
                        while (treePath2.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT && !this.isStatic((JCTree.JCFieldAccess)treePath2.getLeaf())) {
                            if ((treePath2 = treePath2.getParentPath()).getLeaf().getKind() == Tree.Kind.ANNOTATED_TYPE) {
                                treePath2 = treePath2.getParentPath();
                            }
                            if (treePath2.getLeaf().getKind() != Tree.Kind.PARAMETERIZED_TYPE) break;
                            object = treePath2;
                            treePath2 = treePath2.getParentPath();
                        }
                        object3 = object;
                        bl = true;
                    }
                }
                if (bl) continue;
                return false;
            }
            if (tree.getKind() == Tree.Kind.EXTENDS_WILDCARD || tree.getKind() == Tree.Kind.SUPER_WILDCARD) {
                if (typePathEntry.tag != TypeAnnotationPosition.TypePathEntryKind.WILDCARD || object2.size() == 1) {
                    return false;
                }
                object2.remove(object2.size() - 1);
                object4 = (WildcardTree)tree;
                Tree tree6 = object4.getBound();
                if (tree6.equals(tree2)) {
                    if (object2.isEmpty()) {
                        return true;
                    }
                    object3 = object;
                    continue;
                }
                return false;
            }
            if (tree.getKind() == Tree.Kind.ARRAY_TYPE) {
                if (typePathEntry.tag != TypeAnnotationPosition.TypePathEntryKind.ARRAY) {
                    return false;
                }
                object2.remove(object2.size() - 1);
                object = TreeFinder.largestContainingArray((TreePath)object);
                tree = ((TreePath)object).getLeaf();
                object4 = ((ArrayTypeTree)tree).getType();
                while (object2.size() > 0 && ((TypeAnnotationPosition.TypePathEntry)object2.get((int)(object2.size() - 1))).tag == TypeAnnotationPosition.TypePathEntryKind.ARRAY) {
                    if (object4.getKind() != Tree.Kind.ARRAY_TYPE) {
                        return false;
                    }
                    object4 = ((ArrayTypeTree)object4).getType();
                    object2.remove(object2.size() - 1);
                }
                boolean bl = object4.equals(tree2);
                if (bl) {
                    object3 = object;
                    continue;
                }
                return false;
            }
            if (tree.getKind() == Tree.Kind.NEW_ARRAY) {
                return typePathEntry.tag == TypeAnnotationPosition.TypePathEntryKind.ARRAY;
            }
            return false;
        }
        object = ((TreePath)object3).getParentPath();
        if (object == null) {
            return false;
        }
        tree = ((TreePath)object3).getParentPath().getLeaf();
        return !this.isGenericOrArray(tree);
    }

    private boolean isStatic(JCTree.JCFieldAccess jCFieldAccess) {
        return jCFieldAccess.type != null && jCFieldAccess.type.getKind() == TypeKind.DECLARED && jCFieldAccess.type.tsym.isStatic();
    }

    private boolean isGenericOrArray(Tree tree) {
        return tree.getKind() == Tree.Kind.PARAMETERIZED_TYPE || tree.getKind() == Tree.Kind.ARRAY_TYPE || tree.getKind() == Tree.Kind.EXTENDS_WILDCARD || tree.getKind() == Tree.Kind.SUPER_WILDCARD || tree.getKind() == Tree.Kind.ANNOTATED_TYPE && this.isGenericOrArray(((AnnotatedTypeTree)tree).getUnderlyingType());
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.GENERIC_ARRAY_LOCATION;
    }

    public String toString() {
        return "GenericArrayLocationCriterion at " + (this.location.isEmpty() ? "outermost type" : "( " + this.location.toString() + " )");
    }

    public List<TypeAnnotationPosition.TypePathEntry> getLocation() {
        return Collections.unmodifiableList(this.location);
    }
}

