/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.Main;
import annotator.find.ASTPathCriterion;
import annotator.find.CastInsertion;
import annotator.find.CloseParenthesisInsertion;
import annotator.find.Criteria;
import annotator.find.GenericArrayLocationCriterion;
import annotator.find.InClassCriterion;
import annotator.find.Insertion;
import annotator.find.NewInsertion;
import annotator.find.TypedInsertion;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeKind;
import scenelib.annotations.el.InnerTypeLocation;
import scenelib.annotations.io.ASTIndex;
import scenelib.annotations.io.ASTPath;
import scenelib.annotations.io.ASTRecord;
import scenelib.annotations.io.ImmutableStack;
import scenelib.type.ArrayType;
import scenelib.type.BoundedType;
import scenelib.type.DeclaredType;
import scenelib.type.Type;

public class Insertions
implements Iterable<Insertion> {
    private Map<String, Map<String, Set<Insertion>>> store = new HashMap<String, Map<String, Set<Insertion>>>();
    private int size = 0;
    private static final Comparator<Insertion> byASTRecord = new Comparator<Insertion>(){

        @Override
        public int compare(Insertion insertion, Insertion insertion2) {
            ASTRecord aSTRecord;
            Criteria criteria = insertion.getCriteria();
            Criteria criteria2 = insertion2.getCriteria();
            ASTPath aSTPath = criteria.getASTPath();
            ASTPath aSTPath2 = criteria2.getASTPath();
            ASTRecord aSTRecord2 = new ASTRecord(null, criteria.getClassName(), criteria.getMethodName(), criteria.getFieldName(), aSTPath == null ? ASTPath.empty() : aSTPath);
            int n = aSTRecord2.compareTo(aSTRecord = new ASTRecord(null, criteria2.getClassName(), criteria2.getMethodName(), criteria2.getFieldName(), aSTPath2 == null ? ASTPath.empty() : aSTPath2));
            if (n != 0) {
                return n;
            }
            n = Integer.compare(Insertions.kindLevel(insertion2), Insertions.kindLevel(insertion));
            if (n != 0) {
                return n;
            }
            n = insertion.toString().compareTo(insertion2.toString());
            return n;
        }
    };

    public Set<Insertion> forClass(CompilationUnitTree compilationUnitTree, String string) {
        LinkedHashSet<Insertion> linkedHashSet = new LinkedHashSet<Insertion>();
        this.forClass(compilationUnitTree, string, linkedHashSet);
        return linkedHashSet;
    }

    public Set<Insertion> forOuterClass(CompilationUnitTree compilationUnitTree, String string) {
        Map<String, Set<Insertion>> map = this.store.get(string);
        if (map == null || map.isEmpty()) {
            return Collections.emptySet();
        }
        if (Main.temporaryDebug) {
            System.out.printf("forOuterClass(%s): map = %s%n", string, map);
        }
        LinkedHashSet<Insertion> linkedHashSet = new LinkedHashSet<Insertion>();
        for (String string2 : map.keySet()) {
            String string3 = string + string2;
            this.forClass(compilationUnitTree, string3, linkedHashSet);
        }
        return linkedHashSet;
    }

    private void forClass(CompilationUnitTree compilationUnitTree, String string, Set<Insertion> set) {
        String string2;
        Map<String, Set<Insertion>> map;
        if (Main.temporaryDebug) {
            System.out.printf("calling forClass(cut, %s, set of size %d)%n", string, set.size());
        }
        if ((map = this.store.get(string2 = Insertions.outerClassName(string))) != null) {
            TreeSet<Insertion> treeSet = new TreeSet<Insertion>(byASTRecord);
            treeSet.addAll((Collection<Insertion>)map.get(Insertions.innerClassName(string)));
            if (Main.temporaryDebug) {
                System.out.println("organizeTypedInsertions argument set size = " + treeSet.size());
            }
            Set<Insertion> set2 = this.organizeTypedInsertions(compilationUnitTree, string, treeSet);
            if (Main.temporaryDebug) {
                System.out.println("organizeTypedInsertions result set size = " + set2.size());
            }
            set.addAll(set2);
        }
    }

    public void add(Insertion insertion) {
        Set<Insertion> set;
        String string;
        String string2;
        InClassCriterion inClassCriterion = insertion.getCriteria().getInClass();
        if (inClassCriterion == null) {
            string2 = "";
            string = "";
        } else {
            string2 = Insertions.outerClassName(inClassCriterion.className);
            string = Insertions.innerClassName(inClassCriterion.className);
        }
        Map<String, Set<Insertion>> map = this.store.get(string2);
        if (map == null) {
            map = new HashMap<String, Set<Insertion>>();
            this.store.put(string2, map);
        }
        if ((set = map.get(string)) == null) {
            set = new LinkedHashSet<Insertion>();
            map.put(string, set);
        }
        this.size -= set.size();
        set.add(insertion);
        this.size += set.size();
    }

    public void addAll(Collection<? extends Insertion> collection) {
        for (Insertion insertion : collection) {
            this.add(insertion);
        }
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<Insertion> iterator() {
        return new Iterator<Insertion>(){
            private Iterator<Map<String, Set<Insertion>>> miter;
            private Iterator<Set<Insertion>> siter;
            private Iterator<Insertion> iiter;
            {
                this.miter = Insertions.this.store.values().iterator();
                this.siter = Collections.emptySet().iterator();
                this.iiter = Collections.emptySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.iiter.hasNext()) {
                    return true;
                }
                if (this.siter.hasNext()) {
                    this.iiter = this.siter.next().iterator();
                    return this.hasNext();
                }
                if (this.miter.hasNext()) {
                    this.siter = this.miter.next().values().iterator();
                    return this.hasNext();
                }
                return false;
            }

            @Override
            public Insertion next() {
                if (this.hasNext()) {
                    return this.iiter.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public java.util.List<Insertion> toList() {
        ArrayList<Insertion> arrayList = new ArrayList<Insertion>(this.size);
        for (Insertion insertion : this) {
            arrayList.add(insertion);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private Set<Insertion> organizeTypedInsertions(CompilationUnitTree compilationUnitTree, String string, Collection<Insertion> collection) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Criteria criteria;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        ArrayList<Insertion> arrayList = new ArrayList<Insertion>();
        LinkedHashSet<Insertion> linkedHashSet2 = new LinkedHashSet<Insertion>();
        if (Main.temporaryDebug) {
            System.out.printf("organizeTypedInsertions (1): insertions.size()= %d%n", collection.size());
        }
        for (Insertion insertion : collection) {
            Object object9;
            if (Main.temporaryDebug) {
                System.out.printf("Considering insertion %s (isInserted=%s)%n", insertion, insertion.isInserted());
            }
            if (insertion.isInserted()) continue;
            criteria = insertion.getCriteria();
            object8 = criteria.getGenericArrayLocation();
            object7 = criteria.getASTPath();
            if (object7 == null || ((ASTPath)object7).isEmpty() || object8 != null && !((GenericArrayLocationCriterion)object8).getLocation().isEmpty() || insertion instanceof CastInsertion || insertion instanceof CloseParenthesisInsertion) {
                if (Main.temporaryDebug) {
                    System.out.printf("Adding to organized (size %d): %s%n", linkedHashSet2.size(), insertion);
                }
                linkedHashSet2.add(insertion);
                if (!Main.temporaryDebug) continue;
                System.out.printf("  organized now has size %d%n", linkedHashSet2.size());
                continue;
            }
            object6 = new ASTRecord(compilationUnitTree, criteria.getClassName(), criteria.getMethodName(), criteria.getFieldName(), (ASTPath)object7);
            object5 = ((ASTRecord)object6).astPath.getLast();
            object4 = ((ASTPath.ASTEntry)object5).getTreeKind() == Tree.Kind.NEW_ARRAY && ((ASTPath.ASTEntry)object5).childSelectorIs("type") && ((ASTPath.ASTEntry)object5).getArgument() == 0 ? ((object4 = ASTIndex.getNode(compilationUnitTree, ((ASTRecord)object6).replacePath((ASTPath)(object9 = ((ASTRecord)object6).astPath.getParentPath())))) instanceof JCTree.JCNewArray ? TypeTree.fromJavacType(((JCTree.JCNewArray)object4).type) : null) : ASTIndex.getNode(compilationUnitTree, object6);
            if (insertion instanceof TypedInsertion) {
                object9 = (TypedInsertion)hashMap.get(object6);
                if (insertion instanceof NewInsertion) {
                    object3 = (NewInsertion)insertion;
                    if (((ASTPath.ASTEntry)object5).getTreeKind() == Tree.Kind.NEW_ARRAY && ((ASTPath.ASTEntry)object5).childSelectorIs("type")) {
                        int n = ((ASTPath.ASTEntry)object5).getArgument();
                        object2 = new ArrayList(n);
                        object = null;
                        if (n == 0) {
                            object = ((ASTRecord)object6).replacePath(((ASTPath)object7).getParentPath());
                            Tree tree = ASTIndex.getNode(compilationUnitTree, (ASTRecord)object);
                            if (tree == null || tree.toString().startsWith("{")) {
                                object = null;
                            } else {
                                object6 = object;
                                object = ((ASTRecord)object6).extend(Tree.Kind.NEW_ARRAY, "type", 0);
                            }
                        } else if (object4 != null && !((TypedInsertion)object3).getInnerTypeInsertions().isEmpty()) {
                            if (object4.getKind() == Tree.Kind.IDENTIFIER) {
                                object4 = ASTIndex.getNode(compilationUnitTree, ((ASTRecord)object6).replacePath(((ASTPath)object7).getParentPath()));
                            }
                            if (!(object4.getKind() != Tree.Kind.NEW_ARRAY && object4.getKind() != Tree.Kind.ARRAY_TYPE || object4.toString().startsWith("{"))) {
                                object6 = ((ASTRecord)object6).replacePath(((ASTPath)object7).getParentPath());
                                Collections.fill(object2, TypeAnnotationPosition.TypePathEntry.ARRAY);
                                object = ((ASTRecord)object6).extend(Tree.Kind.NEW_ARRAY, "type", 0);
                            }
                        }
                        if (object != null) {
                            for (Insertion runtimeException : ((TypedInsertion)object3).getInnerTypeInsertions()) {
                                Criteria criteria2 = runtimeException.getCriteria();
                                GenericArrayLocationCriterion genericArrayLocationCriterion = criteria2.getGenericArrayLocation();
                                if (genericArrayLocationCriterion == null) continue;
                                int n2 = genericArrayLocationCriterion.getLocation().size();
                                ArrayList<TypeAnnotationPosition.TypePathEntry> arrayList2 = new ArrayList<TypeAnnotationPosition.TypePathEntry>(n + n2);
                                arrayList2.addAll((Collection<TypeAnnotationPosition.TypePathEntry>)object2);
                                arrayList2.addAll(genericArrayLocationCriterion.getLocation());
                                ASTRecord aSTRecord = this.extendToInnerType((ASTRecord)object, arrayList2, (Tree)object4);
                                criteria2.add(new GenericArrayLocationCriterion());
                                criteria2.add(new ASTPathCriterion(aSTRecord.astPath));
                                runtimeException.setInserted(false);
                                if (Main.temporaryDebug) {
                                    System.out.printf("Adding to organized (size %d): %s%n", linkedHashSet2.size(), insertion);
                                }
                                linkedHashSet2.add(runtimeException);
                                if (!Main.temporaryDebug) continue;
                                System.out.printf("  organized now has size %d%n", linkedHashSet2.size());
                            }
                            ((TypedInsertion)object3).getInnerTypeInsertions().clear();
                        }
                    }
                }
                if (object9 == null) {
                    hashMap.put(object6, (TypedInsertion)insertion);
                    continue;
                }
                if (!((TypedInsertion)object9).getType().equals(((TypedInsertion)insertion).getType())) continue;
                this.mergeTypedInsertions((TypedInsertion)object9, (TypedInsertion)insertion);
                continue;
            }
            int n = this.newArrayInnerTypeDepth((ASTPath)object7);
            if (n > 0) {
                object3 = object7;
                while (!(((ASTPath)object3).isEmpty() || object4 != null && object4.getKind() == Tree.Kind.NEW_ARRAY)) {
                    object3 = ((ASTPath)object3).getParentPath();
                    object4 = ASTIndex.getNode(compilationUnitTree, ((ASTRecord)object6).replacePath((ASTPath)object3));
                }
                if (object4 == null) {
                    throw new Error("node == null case not yet implemented");
                }
                object3 = ((ASTPath)object3).extend(new ASTPath.ASTEntry(Tree.Kind.NEW_ARRAY, "type", 0));
                if (object4.toString().startsWith("{")) {
                    TypedInsertion typedInsertion = (TypedInsertion)hashMap.get(((ASTRecord)object6).replacePath((ASTPath)object3));
                    if (typedInsertion == null) {
                        throw new Error("tins == null case not yet implemented");
                    }
                    typedInsertion.getInnerTypeInsertions().add(insertion);
                    insertion.setInserted(true);
                } else {
                    java.util.List<TypeAnnotationPosition.TypePathEntry> list;
                    java.util.List<? extends ExpressionTree> list2 = ((NewArrayTree)object4).getDimensions();
                    object2 = ((ASTRecord)object6).replacePath(((ASTPath)object7).getParentPath()).extend(Tree.Kind.NEW_ARRAY, "type", 0);
                    object = criteria.getGenericArrayLocation();
                    for (int i = 0; i < n; ++i) {
                        object2 = ((ASTRecord)object2).extend(Tree.Kind.ARRAY_TYPE, "type");
                    }
                    if (object != null && !(list = ((GenericArrayLocationCriterion)object).getLocation()).isEmpty()) {
                        try {
                            Tree tree = list2.get(n - 1);
                            object2 = this.extendToInnerType((ASTRecord)object2, list, tree);
                            criteria.add(new ASTPathCriterion(((ASTRecord)object2).astPath));
                            criteria.add(new GenericArrayLocationCriterion());
                        }
                        catch (RuntimeException genericArrayLocationCriterion) {
                            // empty catch block
                        }
                    }
                }
            }
            arrayList.add(insertion);
        }
        if (Main.temporaryDebug) {
            System.out.printf("organized.size() (1) = %d%n", linkedHashSet2.size());
        }
        if (Main.temporaryDebug) {
            System.out.printf("innerInsertionsList size (1) = %d%n", arrayList.size());
        }
        Collections.sort(arrayList, byASTRecord);
        if (Main.temporaryDebug) {
            System.out.printf("innerInsertionsList size (2) = %d%n", arrayList.size());
        }
        if (Main.temporaryDebug) {
            System.out.printf("innerInsertions size (1) = %d%n", linkedHashSet.size());
        }
        linkedHashSet.addAll(arrayList);
        if (Main.temporaryDebug) {
            System.out.printf("innerInsertions size (2) = %d%n", linkedHashSet.size());
        }
        block21: for (Insertion insertion : linkedHashSet) {
            void var22_40;
            void var22_39;
            int n;
            Object object9;
            Object object10;
            Tree tree;
            Tree.Kind kind;
            criteria = insertion.getCriteria();
            object8 = criteria.getMethodName();
            object7 = criteria.getFieldName();
            object6 = criteria.getASTPath();
            object5 = new ArrayList();
            if (object6 == null) {
                linkedHashSet2.add(insertion);
                continue;
            }
            object4 = new ArrayDeque<Comparable<ASTPath>>(((ASTPath)object6).size());
            ASTPath aSTPath = object6;
            do {
                object4.push(aSTPath);
            } while (!(aSTPath = aSTPath.getParentPath()).isEmpty());
            do {
                aSTPath = (ASTPath)object4.pop();
                kind = aSTPath.getLast().getTreeKind();
                object3 = new ASTRecord(compilationUnitTree, string, (String)object8, (String)object7, aSTPath);
            } while (!object4.isEmpty() && !hashMap.containsKey(object3));
            object2 = (TypedInsertion)hashMap.get(object3);
            object = ASTIndex.getTreePath(compilationUnitTree, (ASTRecord)object3);
            Tree tree2 = tree = object == null ? null : ((TreePath)object).getLeaf();
            if (tree == null && aSTPath.isEmpty()) {
                linkedHashSet2.add(insertion);
                continue;
            }
            if (object2 == null) {
                GenericArrayLocationCriterion aSTPath2 = criteria.getGenericArrayLocation();
                if (tree == null) {
                    linkedHashSet2.add(insertion);
                    continue;
                }
                Tree tree3 = ((TreePath)object).getLeaf();
                switch (tree3.getKind()) {
                    case NEW_ARRAY: {
                        int n3 = 0;
                        ASTPath.ASTEntry aSTEntry = ((ASTPath)object6).getLast();
                        object10 = null;
                        ArrayList<Insertion> arrayList3 = new ArrayList<Insertion>();
                        object9 = TypeTree.javacTypeToType(((JCTree.JCNewArray)tree3).type);
                        if (aSTEntry.getTreeKind() == Tree.Kind.NEW_ARRAY) {
                            n3 += aSTEntry.getArgument();
                        }
                        if (aSTPath2 != null) {
                            object10 = aSTPath2.getLocation();
                            n = object10.size();
                            while (--n >= 0 && ((TypeAnnotationPosition.TypePathEntry)object10.get((int)n)).tag == TypeAnnotationPosition.TypePathEntryKind.ARRAY) {
                                ++n3;
                            }
                            object10 = n < 0 ? null : object10.subList(0, ++n);
                        }
                        criteria.add(new ASTPathCriterion(((ASTRecord)object3).astPath.getParentPath().extendNewArray(n3)));
                        criteria.add(object10 == null || object10.isEmpty() ? new GenericArrayLocationCriterion() : new GenericArrayLocationCriterion(new InnerTypeLocation((java.util.List<TypeAnnotationPosition.TypePathEntry>)object10)));
                        arrayList3.add(insertion);
                        object2 = new NewInsertion((scenelib.type.Type)object9, criteria, arrayList3);
                        ((Insertion)object2).setInserted(true);
                        hashMap.put(object3, object2);
                        break;
                    }
                }
                object = ((TreePath)object).getParentPath();
            }
            if (tree == null) {
                ASTPath n4 = aSTPath;
                if (!n4.isEmpty()) {
                    void var22_36;
                    ASTPath aSTPath2;
                    while ((tree = ASTIndex.getNode(compilationUnitTree, ((ASTRecord)object3).replacePath(aSTPath2 = var22_36.getParentPath()))) == null && !aSTPath2.isEmpty()) {
                    }
                }
                if (tree == null) {
                    linkedHashSet2.add(insertion);
                    continue;
                }
                Symbol.ClassSymbol classSymbol = null;
                switch (((Insertion)object2).getKind()) {
                    case CONSTRUCTOR: {
                        if (tree instanceof JCTree.JCMethodDecl) {
                            Symbol.MethodSymbol methodSymbol = ((JCTree.JCMethodDecl)tree).sym;
                            classSymbol = (Symbol.ClassSymbol)methodSymbol.owner;
                            tree = TypeTree.fromJavacType(classSymbol.type);
                            break;
                        }
                        if (tree instanceof JCTree.JCClassDecl) {
                            classSymbol = ((JCTree.JCClassDecl)tree).sym;
                            if (classSymbol.owner instanceof Symbol.ClassSymbol) {
                                classSymbol = (Symbol.ClassSymbol)classSymbol.owner;
                                tree = TypeTree.fromJavacType(classSymbol.type);
                                break;
                            }
                        }
                        throw new RuntimeException();
                    }
                    case NEW: {
                        if (tree instanceof JCTree.JCNewArray) {
                            if (tree.toString().startsWith("{")) {
                                tree = TypeTree.fromJavacType(((JCTree.JCNewArray)tree).type);
                                break;
                            }
                            linkedHashSet2.add(insertion);
                            continue block21;
                        }
                        throw new RuntimeException();
                    }
                    case RECEIVER: {
                        if (tree instanceof JCTree.JCMethodDecl) {
                            JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)tree;
                            classSymbol = (Symbol.ClassSymbol)jCMethodDecl.sym.owner;
                            if ("<init>".equals(jCMethodDecl.name.toString())) {
                                classSymbol = (Symbol.ClassSymbol)classSymbol.owner;
                            }
                        } else if (tree instanceof JCTree.JCClassDecl) {
                            classSymbol = ((JCTree.JCClassDecl)tree).sym;
                        }
                        if (classSymbol != null) {
                            tree = TypeTree.fromJavacType(classSymbol.type);
                            break;
                        }
                        throw new RuntimeException();
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            int n5 = aSTPath.size();
            int n6 = ((ASTPath)object6).size();
            int n7 = 0;
            int n8 = 0;
            while (var22_39 < n6 && ((kind = ((ASTPath.ASTEntry)(object10 = (ASTPath.ASTEntry)((ImmutableStack)object6).get((int)var22_39))).getTreeKind()) == Tree.Kind.METHOD || kind == Tree.Kind.VARIABLE)) {
                ++var22_39;
            }
            while (var22_40 < n6) {
                object10 = (ASTPath.ASTEntry)((ImmutableStack)object6).get((int)var22_40);
                object3 = ((ASTRecord)object3).extend((ASTPath.ASTEntry)object10);
                kind = ((ASTPath.ASTEntry)object10).getTreeKind();
                while (tree.getKind() == Tree.Kind.ANNOTATED_TYPE) {
                    tree = ((AnnotatedTypeTree)tree).getUnderlyingType();
                }
                if (n8 == 0) {
                    n8 = this.localDepth(tree);
                }
                switch (kind) {
                    case ARRAY_TYPE: {
                        if (n8 == 0 && tree.getKind() == kind) {
                            tree = ((ArrayTypeTree)tree).getType();
                            while (--n7 >= 0) {
                                object5.add(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
                            }
                            object5.add(TypeAnnotationPosition.TypePathEntry.ARRAY);
                            break;
                        }
                        throw new RuntimeException();
                    }
                    case MEMBER_SELECT: {
                        if (--n8 >= 0) {
                            tree = ((MemberSelectTree)tree).getExpression();
                            ++n7;
                            break;
                        }
                        throw new RuntimeException();
                    }
                    case NEW_ARRAY: {
                        assert (object5.isEmpty());
                        aSTPath = aSTPath.add(new ASTPath.ASTEntry(Tree.Kind.NEW_ARRAY, "type", 0));
                        if (n8 == 0 && tree.getKind() == kind) {
                            if (tree instanceof JCTree.JCNewArray) {
                                int n9 = ((ASTPath.ASTEntry)object10).getArgument();
                                if (n9 > 0) {
                                    tree = ((JCTree.JCNewArray)tree).elemtype;
                                    object5.add(TypeAnnotationPosition.TypePathEntry.ARRAY);
                                    while (--n9 > 0 && tree instanceof JCTree.JCArrayTypeTree) {
                                        tree = ((JCTree.JCArrayTypeTree)tree).elemtype;
                                        object5.add(TypeAnnotationPosition.TypePathEntry.ARRAY);
                                    }
                                    if (n9 <= 0) break;
                                    throw new RuntimeException();
                                }
                                tree = TypeTree.fromJavacType(((JCTree.JCNewArray)tree).type);
                                break;
                            }
                            throw new RuntimeException("NYI");
                        }
                        throw new RuntimeException();
                    }
                    case PARAMETERIZED_TYPE: {
                        if (tree.getKind() == kind) {
                            ParameterizedTypeTree parameterizedTypeTree = (ParameterizedTypeTree)tree;
                            if (((ASTPath.ASTEntry)object10).childSelectorIs("type")) {
                                tree = parameterizedTypeTree.getType();
                                break;
                            }
                            if (n8 == 0 && ((ASTPath.ASTEntry)object10).childSelectorIs("typeArgument")) {
                                object9 = parameterizedTypeTree.getTypeArguments();
                                n = ((ASTPath.ASTEntry)object10).getArgument();
                                if (n >= 0 && n < object9.size()) {
                                    n7 = 0;
                                    n8 = this.localDepth(parameterizedTypeTree.getType());
                                    while (--n8 >= 0) {
                                        object5.add(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
                                    }
                                    tree = (Tree)object9.get(n);
                                    object5.add(new TypeAnnotationPosition.TypePathEntry(TypeAnnotationPosition.TypePathEntryKind.TYPE_ARGUMENT, n));
                                    break;
                                }
                            }
                        }
                        throw new RuntimeException();
                    }
                    case UNBOUNDED_WILDCARD: {
                        if (!(!ASTPath.isWildcard(tree.getKind()) || n8 != 0 || var22_40 >= true && ((ASTPath.ASTEntry)((ImmutableStack)object6).get((int)(var22_40 - true))).getTreeKind() == Tree.Kind.INSTANCE_OF || var22_40 >= 2 && ((ASTPath.ASTEntry)((ImmutableStack)object6).get((int)(var22_40 - 2))).getTreeKind() == Tree.Kind.ARRAY_TYPE)) {
                            while (--n7 >= 0) {
                                object5.add(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
                            }
                            object5.add(TypeAnnotationPosition.TypePathEntry.WILDCARD);
                            break;
                        }
                        throw new RuntimeException();
                    }
                    default: {
                        tree = ASTIndex.getNode(compilationUnitTree, (ASTRecord)object3);
                    }
                }
                ++var22_40;
            }
            while (--n7 >= 0) {
                object5.add(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
            }
            linkedHashSet2.add(insertion);
            if (object5.isEmpty()) continue;
            criteria.add(new ASTPathCriterion(aSTPath));
            criteria.add(new GenericArrayLocationCriterion(new InnerTypeLocation((java.util.List<TypeAnnotationPosition.TypePathEntry>)object5)));
            ((TypedInsertion)object2).getInnerTypeInsertions().add(insertion);
        }
        if (Main.temporaryDebug) {
            System.out.printf("organized.size() (2) = %d%n", linkedHashSet2.size());
        }
        linkedHashSet2.addAll(hashMap.values());
        if (Main.temporaryDebug) {
            System.out.printf("organized.size() (3) = %d%n", linkedHashSet2.size());
        }
        return linkedHashSet2;
    }

    private int newArrayInnerTypeDepth(ASTPath aSTPath) {
        int n = 0;
        while (!aSTPath.isEmpty()) {
            ASTPath.ASTEntry aSTEntry = aSTPath.getLast();
            switch (aSTEntry.getTreeKind()) {
                case MEMBER_SELECT: 
                case PARAMETERIZED_TYPE: 
                case UNBOUNDED_WILDCARD: 
                case ANNOTATED_TYPE: {
                    n = 0;
                    break;
                }
                case ARRAY_TYPE: {
                    ++n;
                    break;
                }
                case NEW_ARRAY: {
                    if (aSTEntry.childSelectorIs("type") && aSTEntry.hasArgument()) {
                        n += aSTEntry.getArgument();
                    }
                    return n;
                }
                default: {
                    return 0;
                }
            }
            aSTPath = aSTPath.getParentPath();
        }
        return 0;
    }

    private ASTRecord extendToInnerType(ASTRecord aSTRecord, java.util.List<TypeAnnotationPosition.TypePathEntry> list) {
        ASTRecord aSTRecord2 = aSTRecord;
        Iterator<TypeAnnotationPosition.TypePathEntry> iterator = list.iterator();
        int n = 0;
        block6: while (iterator.hasNext()) {
            TypeAnnotationPosition.TypePathEntry typePathEntry = iterator.next();
            switch (typePathEntry.tag) {
                case ARRAY: {
                    while (n-- > 0) {
                        aSTRecord2 = aSTRecord2.extend(Tree.Kind.MEMBER_SELECT, "expression");
                    }
                    aSTRecord2 = aSTRecord2.extend(Tree.Kind.ARRAY_TYPE, "type");
                    continue block6;
                }
                case INNER_TYPE: {
                    ++n;
                    continue block6;
                }
                case TYPE_ARGUMENT: {
                    n = 0;
                    aSTRecord2 = aSTRecord2.extend(Tree.Kind.PARAMETERIZED_TYPE, "typeArgument", typePathEntry.arg);
                    continue block6;
                }
                case WILDCARD: {
                    while (n-- > 0) {
                        aSTRecord2 = aSTRecord2.extend(Tree.Kind.MEMBER_SELECT, "expression");
                    }
                    aSTRecord2 = aSTRecord2.extend(Tree.Kind.UNBOUNDED_WILDCARD, "bound");
                    continue block6;
                }
            }
            throw new RuntimeException();
        }
        while (n-- > 0) {
            aSTRecord2 = aSTRecord2.extend(Tree.Kind.MEMBER_SELECT, "expression");
        }
        return aSTRecord2;
    }

    private ASTRecord extendToInnerType(ASTRecord aSTRecord, java.util.List<TypeAnnotationPosition.TypePathEntry> list, Tree tree) {
        ASTRecord aSTRecord2 = aSTRecord;
        Tree tree2 = tree;
        Iterator<TypeAnnotationPosition.TypePathEntry> iterator = list.iterator();
        TypeAnnotationPosition.TypePathEntry typePathEntry = iterator.next();
        block8: while (true) {
            int n = this.localDepth(tree);
            switch (tree2.getKind()) {
                case ANNOTATED_TYPE: {
                    aSTRecord2 = aSTRecord2.extend(Tree.Kind.ANNOTATED_TYPE, "type");
                    tree2 = ((JCTree.JCAnnotatedType)tree2).getUnderlyingType();
                    break;
                }
                case ARRAY_TYPE: {
                    if (n == 0 && typePathEntry.tag == TypeAnnotationPosition.TypePathEntryKind.ARRAY) {
                        ASTPath.ASTEntry aSTEntry;
                        int n2 = 0;
                        if (!aSTRecord2.astPath.isEmpty() && (aSTEntry = aSTRecord2.astPath.getLast()).getTreeKind() == Tree.Kind.NEW_ARRAY && aSTEntry.childSelectorIs("type")) {
                            n2 = 1 + aSTEntry.getArgument();
                        }
                        aSTRecord2 = n2 > 0 ? aSTRecord2.replacePath(aSTRecord2.astPath.getParentPath()).extend(Tree.Kind.NEW_ARRAY, "type", n2) : aSTRecord2.extend(Tree.Kind.ARRAY_TYPE, "type");
                        tree2 = ((ArrayTypeTree)tree2).getType();
                        break;
                    }
                    throw new RuntimeException();
                }
                case MEMBER_SELECT: {
                    if (n > 0 && typePathEntry.tag == TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE) {
                        Tree tree3 = tree2;
                        do {
                            tree3 = ((JCTree.JCFieldAccess)tree3).getExpression();
                            if (!iterator.hasNext()) {
                                do {
                                    aSTRecord2 = aSTRecord2.extend(Tree.Kind.MEMBER_SELECT, "expression");
                                } while (--n > 0);
                                return aSTRecord2;
                            }
                            typePathEntry = iterator.next();
                            if (--n == 0) continue block8;
                        } while (typePathEntry.tag == TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE);
                    }
                    throw new RuntimeException();
                }
                case NEW_ARRAY: {
                    if (n == 0) {
                        ASTPath.ASTEntry aSTEntry;
                        if (!aSTRecord2.astPath.isEmpty() && (aSTEntry = aSTRecord2.astPath.getLast()).getTreeKind() == Tree.Kind.NEW_ARRAY) {
                            int n3 = 0;
                            while (typePathEntry.tag == TypeAnnotationPosition.TypePathEntryKind.ARRAY) {
                                ++n3;
                                if (!iterator.hasNext()) break;
                                typePathEntry = iterator.next();
                            }
                            aSTRecord2 = aSTRecord2.replacePath(aSTRecord2.astPath.getParentPath()).extend(Tree.Kind.NEW_ARRAY, "type", n3);
                            break;
                        }
                        aSTRecord2 = aSTRecord2.extend(Tree.Kind.ARRAY_TYPE, "type");
                        tree2 = ((JCTree.JCArrayTypeTree)tree2).getType();
                        break;
                    }
                    throw new RuntimeException();
                }
                case PARAMETERIZED_TYPE: {
                    if (n == 0 && typePathEntry.tag == TypeAnnotationPosition.TypePathEntryKind.TYPE_ARGUMENT) {
                        aSTRecord2 = aSTRecord2.extend(Tree.Kind.PARAMETERIZED_TYPE, "typeArgument", typePathEntry.arg);
                        tree2 = (Tree)((List)((JCTree.JCTypeApply)tree2).getTypeArguments()).get(typePathEntry.arg);
                        break;
                    }
                    if (n > 0 && typePathEntry.tag == TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE) {
                        JCTree jCTree = ((JCTree.JCTypeApply)tree2).getType();
                        aSTRecord2 = aSTRecord2.extend(Tree.Kind.PARAMETERIZED_TYPE, "type");
                        tree2 = jCTree;
                        do {
                            jCTree = ((JCTree.JCFieldAccess)jCTree).getExpression();
                            if (!iterator.hasNext()) {
                                do {
                                    aSTRecord2 = aSTRecord2.extend(Tree.Kind.MEMBER_SELECT, "expression");
                                } while (--n > 0);
                                return aSTRecord2;
                            }
                            typePathEntry = iterator.next();
                            if (--n == 0) continue block8;
                        } while (typePathEntry.tag == TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE);
                    }
                    throw new RuntimeException();
                }
                case UNBOUNDED_WILDCARD: 
                case EXTENDS_WILDCARD: 
                case SUPER_WILDCARD: {
                    if (typePathEntry.tag == TypeAnnotationPosition.TypePathEntryKind.WILDCARD) {
                        tree2 = ((JCTree.JCWildcard)tree2).getBound();
                        break;
                    }
                    throw new RuntimeException();
                }
                default: {
                    if (!iterator.hasNext()) break;
                    throw new RuntimeException();
                }
            }
            if (!iterator.hasNext()) {
                return aSTRecord2;
            }
            typePathEntry = iterator.next();
        }
    }

    private void mergeTypedInsertions(TypedInsertion typedInsertion, TypedInsertion typedInsertion2) {
        this.mergeTypes(typedInsertion.getType(), typedInsertion2.getType());
    }

    private void mergeTypes(scenelib.type.Type type, scenelib.type.Type type2) {
        if (type == type2) {
            return;
        }
        switch (type.getKind()) {
            case ARRAY: {
                ArrayType arrayType = (ArrayType)type;
                ArrayType arrayType2 = (ArrayType)type2;
                this.mergeTypes(arrayType.getComponentType(), arrayType2.getComponentType());
                return;
            }
            case BOUNDED: {
                BoundedType boundedType = (BoundedType)type;
                BoundedType boundedType2 = (BoundedType)type2;
                if (boundedType.getBoundKind() != boundedType2.getBoundKind()) {
                    throw new Error(String.format("Types have different bounds: %s %s", type, type2));
                }
                this.mergeTypes(boundedType.getBound(), boundedType2.getBound());
                this.mergeTypes(boundedType.getName(), boundedType2.getName());
                return;
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)type;
                DeclaredType declaredType2 = (DeclaredType)type2;
                java.util.List<scenelib.type.Type> list = declaredType.getTypeParameters();
                java.util.List<scenelib.type.Type> list2 = declaredType2.getTypeParameters();
                int n = list.size();
                if (list2.size() != n) {
                    throw new Error(String.format("Types have different numbers of parameters: %s %s", type, type2));
                }
                this.mergeTypes(declaredType.getInnerType(), declaredType2.getInnerType());
                for (String string : declaredType2.getAnnotations()) {
                    if (declaredType.getAnnotations().contains(string)) continue;
                    declaredType.addAnnotation(string);
                }
                for (int i = 0; i < n; ++i) {
                    this.mergeTypes(list.get(i), list2.get(i));
                }
                return;
            }
        }
        throw new RuntimeException();
    }

    private int localDepth(Tree tree) {
        Tree tree2 = tree;
        int n = 0;
        block4: while (tree2 != null) {
            switch (tree2.getKind()) {
                case ANNOTATED_TYPE: {
                    tree2 = ((AnnotatedTypeTree)tree2).getUnderlyingType();
                    continue block4;
                }
                case MEMBER_SELECT: {
                    if (tree2 instanceof JCTree.JCFieldAccess) {
                        JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)tree2;
                        if (jCFieldAccess.sym.kind == 1) {
                            tree2 = jCFieldAccess.getExpression();
                            continue block4;
                        }
                    }
                    tree2 = ((MemberSelectTree)tree2).getExpression();
                    ++n;
                    continue block4;
                }
            }
            break;
        }
        return n;
    }

    private static int kindLevel(Insertion insertion) {
        switch (insertion.getKind()) {
            case CONSTRUCTOR: {
                return 3;
            }
            case NEW: 
            case RECEIVER: {
                return 2;
            }
            case CAST: {
                return 1;
            }
            case ANNOTATION: 
            case CLOSE_PARENTHESIS: {
                return 0;
            }
        }
        throw new Error("unrecognized case");
    }

    private static String outerClassName(String string) {
        int n = string.indexOf(36);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private static String innerClassName(String string) {
        int n = string.indexOf(36);
        if (n == -1) {
            return "";
        }
        return string.substring(n);
    }

    static abstract class TypeTree
    implements ExpressionTree {
        private static Map<String, TypeTag> primTags = new HashMap<String, TypeTag>();

        TypeTree() {
            primTags.put("byte", TypeTag.BYTE);
            primTags.put("char", TypeTag.CHAR);
            primTags.put("short", TypeTag.SHORT);
            primTags.put("long", TypeTag.LONG);
            primTags.put("float", TypeTag.FLOAT);
            primTags.put("int", TypeTag.INT);
            primTags.put("double", TypeTag.DOUBLE);
            primTags.put("boolean", TypeTag.BOOLEAN);
        }

        static TypeTree fromJCTree(JCTree jCTree) {
            if (jCTree != null) {
                Tree.Kind kind = jCTree.getKind();
                switch (kind) {
                    case ANNOTATED_TYPE: {
                        return TypeTree.fromJCTree(((JCTree.JCAnnotatedType)jCTree).getUnderlyingType());
                    }
                    case IDENTIFIER: {
                        return new IdentifierTT(((JCTree.JCIdent)jCTree).sym.getSimpleName().toString());
                    }
                    case ARRAY_TYPE: {
                        return new ArrayTT(TypeTree.fromJCTree(((JCTree.JCArrayTypeTree)jCTree).getType()));
                    }
                    case MEMBER_SELECT: {
                        return new MemberSelectTT(TypeTree.fromJCTree(((JCTree.JCFieldAccess)jCTree).getExpression()), ((JCTree.JCFieldAccess)jCTree).getIdentifier());
                    }
                    case EXTENDS_WILDCARD: 
                    case SUPER_WILDCARD: {
                        return new WildcardTT(kind, TypeTree.fromJCTree(((JCTree.JCWildcard)jCTree).getBound()));
                    }
                    case UNBOUNDED_WILDCARD: {
                        return new WildcardTT();
                    }
                    case PARAMETERIZED_TYPE: {
                        java.util.List list = ((JCTree.JCTypeApply)jCTree).getTypeArguments();
                        ArrayList<TypeTree> arrayList = new ArrayList<TypeTree>(((List)list).size());
                        for (JCTree.JCExpression jCExpression : list) {
                            arrayList.add(TypeTree.fromJCTree(jCExpression));
                        }
                        return new ParameterizedTypeTT(TypeTree.fromJCTree(((JCTree.JCTypeApply)jCTree).getType()), arrayList);
                    }
                }
            }
            return null;
        }

        static TypeTree fromType(scenelib.type.Type type) {
            switch (type.getKind()) {
                case ARRAY: {
                    ArrayType arrayType = (ArrayType)type;
                    TypeTree typeTree = TypeTree.fromType(arrayType.getComponentType());
                    return new ArrayTT(typeTree);
                }
                case BOUNDED: {
                    BoundedType boundedType = (BoundedType)type;
                    BoundedType.BoundKind boundKind = boundedType.getBoundKind();
                    String string = boundedType.getName().getName();
                    TypeTree typeTree = TypeTree.fromType(boundedType.getBound());
                    return new TypeParameterTT(string, boundKind, typeTree);
                }
                case DECLARED: {
                    DeclaredType declaredType = (DeclaredType)type;
                    if (declaredType.isWildcard()) {
                        return new WildcardTT();
                    }
                    String string = declaredType.getName();
                    TypeTag typeTag = primTags.get(string);
                    if (typeTag == null) {
                        IdentifierTT identifierTT;
                        TypeTree typeTree = identifierTT = new IdentifierTT(string);
                        java.util.List<scenelib.type.Type> list = declaredType.getTypeParameters();
                        DeclaredType declaredType2 = declaredType.getInnerType();
                        if (!list.isEmpty()) {
                            ArrayList<TypeTree> arrayList = new ArrayList<TypeTree>(list.size());
                            for (scenelib.type.Type type2 : list) {
                                arrayList.add(TypeTree.fromType(type2));
                            }
                            typeTree = new ParameterizedTypeTT(identifierTT, arrayList);
                        }
                        return declaredType2 == null ? typeTree : TypeTree.addPrefix(TypeTree.fromType(declaredType2), typeTree);
                    }
                    TypeKind typeKind = typeTag.getPrimitiveTypeKind();
                    return new PrimitiveTypeTT(typeKind);
                }
            }
            throw new RuntimeException("unknown type kind " + (Object)((Object)type.getKind()));
        }

        static TypeTree fromJavacType(Type type) {
            return TypeTree.fromType(TypeTree.javacTypeToType(type));
        }

        static scenelib.type.Type javacTypeToType(Type type) {
            switch (type.getKind()) {
                case ARRAY: {
                    Type.ArrayType arrayType = (Type.ArrayType)type;
                    return new ArrayType(TypeTree.javacTypeToType(arrayType.elemtype));
                }
                case DECLARED: {
                    Type.ClassType classType;
                    Type type2 = type;
                    DeclaredType declaredType = null;
                    do {
                        DeclaredType declaredType2 = declaredType;
                        classType = (Type.ClassType)type2;
                        declaredType = new DeclaredType(classType.tsym.name.toString());
                        declaredType.setInnerType(declaredType2);
                        declaredType2 = declaredType;
                        for (Type type3 : classType.getTypeArguments()) {
                            declaredType.addTypeParameter(TypeTree.javacTypeToType(type3));
                        }
                    } while ((type2 = classType.getEnclosingType()).getKind() == TypeKind.DECLARED);
                    return declaredType;
                }
                case WILDCARD: {
                    Type.WildcardType wildcardType = (Type.WildcardType)type;
                    if (wildcardType.kind == BoundKind.UNBOUND) {
                        return new DeclaredType("?");
                    }
                    return new BoundedType(new DeclaredType(type.tsym.name.toString()), wildcardType.kind, (DeclaredType)TypeTree.javacTypeToType(wildcardType.bound));
                }
                case TYPEVAR: {
                    scenelib.type.Type type4 = TypeTree.javacTypeToType(((Type.TypeVar)type).getUpperBound());
                    if (type4.getKind() == Type.Kind.DECLARED) {
                        return new BoundedType(new DeclaredType(type.tsym.name.toString()), BoundedType.BoundKind.EXTENDS, (DeclaredType)type4);
                    }
                    return type4;
                }
                case INTERSECTION: {
                    return new DeclaredType(type.tsym.erasure_field.tsym.name.toString());
                }
                case UNION: {
                    throw new Error("UNION case not yet implemented");
                }
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case DOUBLE: 
                case LONG: 
                case SHORT: 
                case FLOAT: 
                case INT: {
                    return new DeclaredType(type.tsym.name.toString());
                }
                case ERROR: {
                    return new DeclaredType(type.toString());
                }
            }
            throw new Error("Found unknown type: " + type + " (" + (Object)((Object)type.getKind()) + "). Check your setup.");
        }

        private static TypeTree addPrefix(TypeTree typeTree, TypeTree typeTree2) {
            switch (typeTree.getKind()) {
                case IDENTIFIER: {
                    IdentifierTT identifierTT = (IdentifierTT)typeTree;
                    return new MemberSelectTT(typeTree2, identifierTT.getName());
                }
                case MEMBER_SELECT: {
                    MemberSelectTT memberSelectTT = (MemberSelectTT)typeTree;
                    return new MemberSelectTT(TypeTree.addPrefix(memberSelectTT.getExpression(), typeTree2), memberSelectTT.getIdentifier());
                }
                case PARAMETERIZED_TYPE: {
                    ParameterizedTypeTT parameterizedTypeTT = (ParameterizedTypeTT)typeTree;
                    return new ParameterizedTypeTT(TypeTree.addPrefix(parameterizedTypeTT.getType(), typeTree2), parameterizedTypeTT.getTypeArguments());
                }
            }
            throw new IllegalArgumentException("unexpected type " + typeTree);
        }

        static final class TypeName
        implements Name {
            private final String str;

            TypeName(String string) {
                this.str = string;
            }

            @Override
            public int length() {
                return this.str.length();
            }

            @Override
            public char charAt(int n) {
                return this.str.charAt(n);
            }

            @Override
            public CharSequence subSequence(int n, int n2) {
                return this.str.subSequence(n, n2);
            }

            @Override
            public boolean contentEquals(CharSequence charSequence) {
                return this.str.contentEquals(charSequence);
            }

            @Override
            public String toString() {
                return this.str;
            }
        }

        static final class TypeParameterTT
        extends TypeTree
        implements TypeParameterTree {
            private final String bname;
            private final BoundedType.BoundKind bk;
            private final Tree bound;

            TypeParameterTT(String string, BoundedType.BoundKind boundKind, TypeTree typeTree) {
                this.bname = string;
                this.bk = boundKind;
                this.bound = typeTree;
            }

            @Override
            public Tree.Kind getKind() {
                return Tree.Kind.TYPE_PARAMETER;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> treeVisitor, D d) {
                return treeVisitor.visitTypeParameter(this, d);
            }

            @Override
            public Name getName() {
                return new TypeName(this.bname);
            }

            @Override
            public java.util.List<? extends Tree> getBounds() {
                return Collections.singletonList(this.bound);
            }

            @Override
            public java.util.List<? extends AnnotationTree> getAnnotations() {
                return Collections.emptyList();
            }

            public String toString() {
                return this.bname + " " + this.bk.toString() + " " + this.bound.toString();
            }
        }

        static final class WildcardTT
        extends TypeTree
        implements WildcardTree {
            private final TypeTree bound;
            private final Tree.Kind kind;

            WildcardTT() {
                this(Tree.Kind.UNBOUNDED_WILDCARD, null);
            }

            WildcardTT(TypeTree typeTree, BoundedType.BoundKind boundKind) {
                this(boundKind == BoundedType.BoundKind.SUPER ? Tree.Kind.SUPER_WILDCARD : Tree.Kind.EXTENDS_WILDCARD, typeTree);
            }

            WildcardTT(Tree.Kind kind, TypeTree typeTree) {
                this.kind = kind;
                this.bound = typeTree;
            }

            @Override
            public Tree.Kind getKind() {
                return this.kind;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> treeVisitor, D d) {
                return treeVisitor.visitWildcard(this, d);
            }

            @Override
            public Tree getBound() {
                return this.bound;
            }

            public String toString() {
                return "?";
            }
        }

        static final class IdentifierTT
        extends TypeTree
        implements IdentifierTree {
            private final String name;

            IdentifierTT(String string) {
                this.name = string;
            }

            @Override
            public Tree.Kind getKind() {
                return Tree.Kind.IDENTIFIER;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> treeVisitor, D d) {
                return treeVisitor.visitIdentifier(this, d);
            }

            @Override
            public Name getName() {
                return new TypeName(this.name);
            }

            public String toString() {
                return this.name;
            }
        }

        static final class PrimitiveTypeTT
        extends TypeTree
        implements PrimitiveTypeTree {
            private final TypeKind typeKind;

            PrimitiveTypeTT(TypeKind typeKind) {
                this.typeKind = typeKind;
            }

            @Override
            public Tree.Kind getKind() {
                return Tree.Kind.PRIMITIVE_TYPE;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> treeVisitor, D d) {
                return treeVisitor.visitPrimitiveType(this, d);
            }

            @Override
            public TypeKind getPrimitiveTypeKind() {
                return this.typeKind;
            }

            public String toString() {
                switch (this.typeKind) {
                    case BOOLEAN: {
                        return "boolean";
                    }
                    case BYTE: {
                        return "byte";
                    }
                    case CHAR: {
                        return "char";
                    }
                    case DOUBLE: {
                        return "double";
                    }
                    case FLOAT: {
                        return "float";
                    }
                    case INT: {
                        return "int";
                    }
                    case LONG: {
                        return "long";
                    }
                    case SHORT: {
                        return "short";
                    }
                }
                throw new IllegalArgumentException("unexpected type kind " + (Object)((Object)this.typeKind));
            }
        }

        static final class ParameterizedTypeTT
        extends TypeTree
        implements ParameterizedTypeTree {
            private final TypeTree base;
            private final java.util.List<? extends Tree> typeArgs;

            ParameterizedTypeTT(TypeTree typeTree, java.util.List<? extends Tree> list) {
                this.base = typeTree;
                this.typeArgs = list;
            }

            @Override
            public Tree.Kind getKind() {
                return Tree.Kind.PARAMETERIZED_TYPE;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> treeVisitor, D d) {
                return treeVisitor.visitParameterizedType(this, d);
            }

            @Override
            public TypeTree getType() {
                return this.base;
            }

            @Override
            public java.util.List<? extends Tree> getTypeArguments() {
                return this.typeArgs;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder(this.base.toString());
                String string = "<";
                for (Tree tree : this.typeArgs) {
                    stringBuilder.append(string);
                    stringBuilder.append(tree.toString());
                    string = ", ";
                }
                stringBuilder.append('>');
                return stringBuilder.toString();
            }
        }

        static final class MemberSelectTT
        extends TypeTree
        implements MemberSelectTree {
            private final TypeTree expr;
            private final Name name;

            MemberSelectTT(TypeTree typeTree, Name name) {
                this.expr = typeTree;
                this.name = name;
            }

            @Override
            public Tree.Kind getKind() {
                return Tree.Kind.MEMBER_SELECT;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> treeVisitor, D d) {
                return treeVisitor.visitMemberSelect(this, d);
            }

            @Override
            public TypeTree getExpression() {
                return this.expr;
            }

            @Override
            public Name getIdentifier() {
                return this.name;
            }

            public String toString() {
                return this.expr + "." + this.name;
            }
        }

        static final class ArrayTT
        extends TypeTree
        implements ArrayTypeTree {
            private final TypeTree componentType;

            ArrayTT(TypeTree typeTree) {
                this.componentType = typeTree;
            }

            @Override
            public Tree.Kind getKind() {
                return Tree.Kind.ARRAY_TYPE;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> treeVisitor, D d) {
                return treeVisitor.visitArrayType(this, d);
            }

            @Override
            public TypeTree getType() {
                return this.componentType;
            }

            public String toString() {
                return this.componentType + "[]";
            }
        }
    }
}

