/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import annotator.find.InClassCriterion;
import annotator.scanner.CommonScanner;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;

final class IsCriterion
implements Criterion {
    private final Tree.Kind kind;
    private final String name;

    IsCriterion(Tree.Kind kind, String string) {
        this.kind = kind;
        this.name = string;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.HAS_KIND;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Tree tree = treePath.getLeaf();
        if (CommonScanner.hasClassKind(tree)) {
            return InClassCriterion.isSatisfiedBy(treePath, this.name, true);
        }
        if (tree.getKind() != this.kind) {
            return false;
        }
        switch (tree.getKind()) {
            case VARIABLE: {
                String string = ((VariableTree)tree).getName().toString();
                return string.equals(this.name);
            }
            case METHOD: {
                String string = ((MethodTree)tree).getName().toString();
                return string.equals(this.name);
            }
        }
        throw new Error("unknown tree kind " + (Object)((Object)this.kind));
    }

    public String toString() {
        return "is " + this.kind.toString().toLowerCase() + " '" + this.name + "'";
    }
}

