/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.Main;
import annotator.find.Criteria;
import annotator.find.Criterion;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

final class PackageCriterion
implements Criterion {
    private final String name;

    PackageCriterion(String string) {
        this.name = string;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.PACKAGE;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        assert (treePath == null || treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        CompilationUnitTree compilationUnitTree;
        Tree tree = treePath.getLeaf();
        Criteria.dbug.debug("PackageCriterion.isSatisfiedBy(%s, %s); this=%s%n", Main.leafString(treePath), tree, this.toString());
        if (tree.getKind() == Tree.Kind.COMPILATION_UNIT && (compilationUnitTree = (CompilationUnitTree)tree).getSourceFile().getName().endsWith("package-info.java")) {
            ExpressionTree expressionTree = compilationUnitTree.getPackageName();
            assert (expressionTree instanceof IdentifierTree || expressionTree instanceof MemberSelectTree);
            if (this.name.equals(expressionTree.toString())) {
                return true;
            }
        }
        Criteria.dbug.debug("PackageCriterion.isSatisfiedBy => false%n", new Object[0]);
        return false;
    }

    public String toString() {
        return "package '" + this.name + "'";
    }
}

