/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.AnnotationInsertion;
import annotator.find.Criteria;
import annotator.find.Insertion;
import annotator.find.TypedInsertion;
import java.util.List;
import scenelib.type.DeclaredType;

public class ReceiverInsertion
extends TypedInsertion {
    private boolean addComma = false;
    private boolean qualifyThis = false;

    public ReceiverInsertion(DeclaredType declaredType, Criteria criteria, List<Insertion> list) {
        super(declaredType, criteria, list);
    }

    public void setAddComma(boolean bl) {
        this.addComma = bl;
    }

    public void setQualifyType(boolean bl) {
        this.qualifyThis = bl;
    }

    @Override
    protected String getText(boolean bl, boolean bl2) {
        if (this.annotationsOnly) {
            StringBuilder stringBuilder = new StringBuilder();
            List<String> list = this.type.getAnnotations();
            if (list.isEmpty()) {
                return "";
            }
            for (String string : list) {
                stringBuilder.append(string);
                stringBuilder.append(' ');
            }
            return new AnnotationInsertion(stringBuilder.toString(), this.getCriteria(), this.isSeparateLine()).getText(bl, bl2);
        }
        DeclaredType declaredType = this.getBaseType();
        boolean bl3 = bl && declaredType.getName().isEmpty();
        String string = this.typeToString(this.type, bl3, bl2);
        if (!declaredType.getName().isEmpty()) {
            string = string + " ";
            if (this.qualifyThis) {
                for (DeclaredType declaredType2 = declaredType; declaredType2 != null; declaredType2 = declaredType2.getInnerType()) {
                    string = string + declaredType2.getName() + ".";
                }
            }
            string = string + "this";
            if (this.addComma) {
                string = string + ",";
            }
            if (bl) {
                string = "/*>>> " + string + " */";
            }
        }
        return string;
    }

    @Override
    protected boolean addLeadingSpace(boolean bl, int n, char c) {
        if (c == '.' && this.getBaseType().getName().isEmpty()) {
            return false;
        }
        return super.addLeadingSpace(bl, n, c);
    }

    @Override
    protected boolean addTrailingSpace(boolean bl) {
        if (!this.getBaseType().getName().isEmpty() && !this.addComma) {
            return false;
        }
        return super.addTrailingSpace(bl);
    }

    @Override
    public Insertion.Kind getKind() {
        return Insertion.Kind.RECEIVER;
    }
}

