/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.Main;
import annotator.find.AnnotationInsertion;
import annotator.find.CastInsertion;
import annotator.find.ConstructorInsertion;
import annotator.find.Criteria;
import annotator.find.GenericArrayLocationCriterion;
import annotator.find.InClassCriterion;
import annotator.find.Insertion;
import annotator.find.Insertions;
import annotator.find.NewInsertion;
import annotator.find.ReceiverInsertion;
import annotator.find.TypedInsertion;
import annotator.scanner.CommonScanner;
import annotator.specification.IndexFileSpecification;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.type.NullType;
import org.checkerframework.com.google.common.collect.LinkedHashMultimap;
import org.checkerframework.com.google.common.collect.Multimaps;
import org.checkerframework.com.google.common.collect.SetMultimap;
import org.checkerframework.org.plumelib.util.Pair;
import scenelib.annotations.io.ASTIndex;
import scenelib.annotations.io.ASTPath;
import scenelib.annotations.io.ASTRecord;
import scenelib.annotations.io.DebugWriter;
import scenelib.annotations.io.ImmutableStack;
import scenelib.type.DeclaredType;
import scenelib.type.Type;

public class TreeFinder
extends TreeScanner<Void, java.util.List<Insertion>> {
    public static final DebugWriter dbug = new DebugWriter();
    public static final DebugWriter stak = new DebugWriter();
    public static final DebugWriter warn = new DebugWriter();
    private static final String comment = "//.*$|/\\*[^*]*+\\*++(?:[^*/][^*]*+\\*++)*+/";
    private static final String literal = "'(?:(?:\\\\(?:'|[^']*+))|[^\\\\'])'|\"(?:\\\\.|[^\\\\\"])*\"";
    private static final String nonDelimSlash = "/(?=[^*/])";
    Map<Tree, TreePath> treePathCache = new HashMap<Tree, TreePath>();
    private final TypePositionFinder tpf;
    private final DeclarationPositionFinder dpf;
    private final JCTree.JCCompilationUnit tree;
    private final SetMultimap<Pair<Integer, ASTPath>, Insertion> insertions;
    private final SetMultimap<ASTRecord, Insertion> astInsertions;

    private static final String otherThan(char c) {
        String string;
        switch (c) {
            case '\"': 
            case '\'': 
            case '/': {
                string = "";
                break;
            }
            case '[': 
            case '\\': 
            case ']': {
                string = "\\" + c;
                break;
            }
            default: {
                string = "" + c;
            }
        }
        return "[^/'" + string + "\"]||" + literal + "|" + comment + (c == '/' ? "" : nonDelimSlash);
    }

    public static TreePath largestContainingArray(TreePath treePath) {
        if (treePath.getLeaf().getKind() != Tree.Kind.ARRAY_TYPE) {
            return null;
        }
        while (treePath.getParentPath().getLeaf().getKind() == Tree.Kind.ARRAY_TYPE) {
            treePath = treePath.getParentPath();
        }
        assert (treePath.getLeaf().getKind() == Tree.Kind.ARRAY_TYPE);
        return treePath;
    }

    private int getFirstInstanceAfter(char c, int n) {
        return this.getNthInstanceInRange(c, n, Integer.MAX_VALUE, 1);
    }

    private int getNthInstanceInRange(char c, int n, int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("negative end position");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("negative count");
        }
        try {
            CharSequence charSequence = this.tree.getSourceFile().getCharContent(true);
            int n4 = n3;
            int n5 = -1;
            int n6 = Math.min(n2, charSequence.length());
            String string = c == '/' ? nonDelimSlash : Pattern.quote("" + c);
            String string2 = "(?:" + TreeFinder.otherThan(c) + ")*+" + string;
            Pattern pattern = Pattern.compile(string2, 8);
            Matcher matcher = pattern.matcher(charSequence).region(n, n6);
            while (matcher.find()) {
                n5 = matcher.end() - 1;
                if (--n4 != 0) continue;
            }
            return n4 > 0 ? -1 : n5;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private Tree parent(Tree tree) {
        return this.getPath(tree).getParentPath().getLeaf();
    }

    public TreePath getPath(Tree tree) {
        if (this.treePathCache.containsKey(tree)) {
            return this.treePathCache.get(tree);
        }
        TreePath treePath = TreePath.getPath(this.tree, tree);
        this.treePathCache.put(tree, treePath);
        return treePath;
    }

    private ASTRecord astRecord(Tree tree) {
        Map<Tree, ASTRecord> map = ASTIndex.indexOf(this.tree);
        return map.get(tree);
    }

    public TreeFinder(JCTree.JCCompilationUnit jCCompilationUnit) {
        this.tree = jCCompilationUnit;
        this.insertions = LinkedHashMultimap.create();
        this.astInsertions = LinkedHashMultimap.create();
        this.tpf = new TypePositionFinder();
        this.dpf = new DeclarationPositionFinder();
    }

    boolean handled(Tree tree) {
        switch (tree.getKind()) {
            case IDENTIFIER: 
            case PRIMITIVE_TYPE: 
            case ARRAY_TYPE: 
            case PARAMETERIZED_TYPE: 
            case EXTENDS_WILDCARD: 
            case SUPER_WILDCARD: 
            case UNBOUNDED_WILDCARD: 
            case ANNOTATION: 
            case CLASS: 
            case COMPILATION_UNIT: 
            case ENUM: 
            case EXPRESSION_STATEMENT: 
            case INTERFACE: 
            case METHOD: 
            case NEW_ARRAY: 
            case NEW_CLASS: 
            case TYPE_PARAMETER: 
            case VARIABLE: {
                return true;
            }
        }
        return tree instanceof ExpressionTree;
    }

    private boolean wildcardLast(java.util.List<TypeAnnotationPosition.TypePathEntry> list) {
        return list.get((int)(list.size() - 1)).tag == TypeAnnotationPosition.TypePathEntryKind.WILDCARD;
    }

    @Override
    public Void scan(Tree tree, java.util.List<Insertion> list) {
        if (tree == null || list.isEmpty()) {
            return null;
        }
        dbug.debug("TreeFinder.scan(%s, %d insertions):%n%s%n", new Object[]{tree.getKind(), list.size(), tree});
        if (Main.temporaryDebug) {
            new Error("backtrace at TreeFinder.scan()").printStackTrace();
        }
        if (!this.handled(tree)) {
            String string = tree.toString();
            if (string.equals("")) {
                string = "<empty>";
            }
            dbug.debug("TreeFinder.scan(%s) skipping, unhandled: %s%n", tree.getClass(), tree);
            return (Void)super.scan(tree, list);
        }
        TreePath treePath = this.getPath(tree);
        assert (treePath == null || treePath.getLeaf() == tree) : String.format("Mismatch: '%s' '%s' '%s'%n", treePath, treePath.getLeaf(), tree);
        if (treePath != null) {
            for (Object object : treePath) {
                if (object.getKind() == Tree.Kind.PARAMETERIZED_TYPE) break;
                if (object.getKind() != Tree.Kind.ANNOTATION) continue;
                return (Void)super.scan(tree, list);
            }
        }
        dbug.debug("Considering %d insertions.%n", list.size());
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            Integer n;
            Object object;
            object = (Insertion)iterator.next();
            dbug.debug("Considering insertion at tree:%n", new Object[0]);
            dbug.debug("  Insertion: %s%n", object);
            dbug.debug("  First line of node: %s%n", Main.firstLine(tree.toString()));
            dbug.debug("  Type of node: %s%n", tree.getClass());
            if (((Insertion)object).isInserted()) {
                dbug.debug("  ... already inserted%n", new Object[0]);
                iterator.remove();
                continue;
            }
            if (!((Insertion)object).getCriteria().isSatisfiedBy(treePath, tree)) {
                dbug.debug("  ... not satisfied%n", new Object[0]);
                continue;
            }
            dbug.debug("  ... satisfied!%n", new Object[0]);
            dbug.debug("    First line of node: %s%n", Main.firstLine(tree.toString()));
            dbug.debug("    Type of node: %s%n", tree.getClass());
            ASTPath aSTPath = ((Insertion)object).getCriteria().getASTPath();
            dbug.debug("    astPath = %s%n", aSTPath);
            Integer n2 = aSTPath == null ? this.findPosition(treePath, (Insertion)object) : (n = Main.convert_jaifs ? null : this.findPositionByASTPath(aSTPath, treePath, (Insertion)object));
            if (n != null) {
                dbug.debug("  ... satisfied! at %d for node of type %s: %s%n", n, tree.getClass(), Main.treeToString(tree));
                this.insertions.put(Pair.of(n, aSTPath), (Insertion)object);
            }
            iterator.remove();
        }
        return (Void)super.scan(tree, list);
    }

    Integer findPosition(TreePath treePath, Insertion insertion) {
        Tree tree = treePath.getLeaf();
        try {
            Object object;
            Object object2;
            Object object3;
            if (insertion.getCriteria().isOnReceiver() && treePath.getParentPath().getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
                warn.debug("WARNING: Cannot insert a receiver parameter on a method declaration of an anonymous inner class.  This insertion will be skipped.%n    Insertion: %s%n", insertion);
                return null;
            }
            if (this.alreadyPresent(treePath, insertion) && !(insertion instanceof TypedInsertion)) {
                return null;
            }
            if (insertion.getKind() == Insertion.Kind.CONSTRUCTOR) {
                object3 = (ConstructorInsertion)insertion;
                if (tree.getKind() == Tree.Kind.METHOD) {
                    object2 = (JCTree.JCMethodDecl)tree;
                    if (((JCTree.JCMethodDecl)object2).sym.owner.isAnonymous()) {
                        return null;
                    }
                    if ((((JCTree.JCMethodDecl)object2).mods.flags & 0x1000000000L) != 0L) {
                        this.addConstructor(treePath, (ConstructorInsertion)object3, (MethodTree)object2);
                    } else {
                        ((TypedInsertion)object3).setAnnotationsOnly(true);
                        ((ConstructorInsertion)object3).setInserted(true);
                        insertion = ((ConstructorInsertion)object3).getReceiverInsertion();
                        if (insertion == null) {
                            return null;
                        }
                    }
                } else {
                    ((TypedInsertion)object3).setAnnotationsOnly(true);
                }
            }
            if (insertion.getKind() == Insertion.Kind.RECEIVER && tree.getKind() == Tree.Kind.METHOD) {
                object3 = (ReceiverInsertion)insertion;
                object2 = (MethodTree)tree;
                object = object2.getReceiverParameter();
                if (object == null) {
                    this.addReceiverType(treePath, (ReceiverInsertion)object3, (MethodTree)object2);
                }
            }
            if (insertion.getKind() == Insertion.Kind.NEW && tree.getKind() == Tree.Kind.NEW_ARRAY) {
                object3 = (NewInsertion)insertion;
                object2 = (NewArrayTree)tree;
                if (object2.toString().startsWith("{")) {
                    this.addNewType(treePath, (NewInsertion)object3, (NewArrayTree)object2);
                }
            }
            object3 = -1;
            object2 = ASTIndex.indexOf(this.tree);
            object = (ASTRecord)object2.get(tree);
            dbug.debug("TreeFinder.scan: node=%s%n  critera=%s%n", tree, insertion.getCriteria());
            if (CommonScanner.hasClassKind(tree) && insertion.getCriteria().isOnTypeDeclarationExtendsClause() && ((ClassTree)tree).getExtendsClause() == null) {
                return this.implicitClassBoundPosition((JCTree.JCClassDecl)tree, insertion);
            }
            if (tree.getKind() == Tree.Kind.METHOD && insertion.getCriteria().isOnReturnType()) {
                JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)tree;
                JCTree jCTree = jCMethodDecl.getReturnType();
                object = ((ASTRecord)object).extend(Tree.Kind.METHOD, "type");
                if (jCTree == null) {
                    object3 = this.findMethodName(jCMethodDecl);
                    if ((Integer)object3 < 0) {
                        return null;
                    }
                    dbug.debug("pos = %d at constructor name: %s%n", object3, jCMethodDecl.sym.toString());
                } else {
                    Pair pair = (Pair)this.tpf.scan(jCTree, insertion);
                    object = (ASTRecord)pair.a;
                    object3 = (Integer)pair.b;
                    assert (this.handled(tree));
                    dbug.debug("pos = %d at return type node: %s%n", object3, jCTree.getClass());
                }
            } else if (tree.getKind() == Tree.Kind.TYPE_PARAMETER && insertion.getCriteria().onBoundZero() && (((TypeParameterTree)tree).getBounds().isEmpty() || ((JCTree.JCExpression)((TypeParameterTree)tree).getBounds().get((int)0)).type.tsym.isInterface()) || tree instanceof WildcardTree && ((WildcardTree)tree).getBound() == null && this.wildcardLast(insertion.getCriteria().getGenericArrayLocation().getLocation())) {
                Pair pair = (Pair)this.tpf.scan(tree, insertion);
                object = (ASTRecord)pair.a;
                object3 = (Integer)pair.b;
                if (insertion.getKind() == Insertion.Kind.ANNOTATION) {
                    if (tree.getKind() == Tree.Kind.TYPE_PARAMETER && !((TypeParameterTree)tree).getBounds().isEmpty()) {
                        Tree tree2 = ((TypeParameterTree)tree).getBounds().get(0);
                        object3 = ((JCTree.JCExpression)tree2).getStartPosition();
                        ((AnnotationInsertion)insertion).setGenerateBound(true);
                    } else {
                        int n = ((JCTree)this.parent(tree)).getEndPosition(this.tree.endPositions);
                        Integer n2 = this.getNthInstanceInRange(',', (Integer)object3 + 1, n, 1);
                        Integer n3 = this.getNthInstanceInRange('>', (Integer)object3 + 1, n, 1);
                        object3 = n2 != -1 && n2 < n3 ? n2 : n3;
                        ((AnnotationInsertion)insertion).setGenerateExtends(true);
                    }
                }
            } else if (insertion.getKind() == Insertion.Kind.CAST) {
                DeclaredType declaredType;
                scenelib.type.Type type = ((CastInsertion)insertion).getType();
                JCTree jCTree = (JCTree)tree;
                object3 = jCTree.getStartPosition();
                if (type.getKind() == Type.Kind.DECLARED && (declaredType = (DeclaredType)type).getName().isEmpty()) {
                    declaredType.setName(jCTree.type instanceof NullType ? "Object" : jCTree.type.toString());
                }
            } else if (insertion.getKind() == Insertion.Kind.CLOSE_PARENTHESIS) {
                JCTree jCTree = (JCTree)tree;
                object3 = jCTree.getEndPosition(this.tree.endPositions);
            } else {
                boolean bl = true;
                if (tree.getKind() == Tree.Kind.METHOD) {
                    bl = insertion.getCriteria().isOnReceiver();
                } else if (CommonScanner.hasClassKind(tree)) {
                    boolean bl2 = bl = !insertion.isSeparateLine();
                }
                if (bl) {
                    dbug.debug("Calling tpf.scan(%s: %s, %s)%n", tree.getClass(), tree, insertion);
                    Pair pair = (Pair)this.tpf.scan(tree, insertion);
                    object = (ASTRecord)pair.a;
                    object3 = (Integer)pair.b;
                    assert (this.handled(tree));
                    dbug.debug("pos = %d (insertRecord=%s) at type: %s (%s)%n", object3, object, tree.toString(), tree.getClass());
                } else if (tree.getKind() == Tree.Kind.METHOD && insertion.getKind() == Insertion.Kind.CONSTRUCTOR && (((JCTree.JCMethodDecl)tree).mods.flags & 0x1000000000L) != 0L) {
                    Tree tree3 = treePath.getParentPath().getLeaf();
                    object3 = ((JCTree.JCClassDecl)tree3).getEndPosition(this.tree.endPositions) - 1;
                    object = null;
                } else {
                    object3 = (Integer)this.dpf.scan(tree, null);
                    object = this.astRecord(tree);
                    dbug.debug("pos = %s at declaration: %s%n", object3, tree.getClass());
                }
            }
            if (object3 != null) {
                assert ((Integer)object3 >= 0) : String.format("pos: %s%nnode: %s%ninsertion: %s%n", object3, tree, insertion);
                this.astInsertions.put((ASTRecord)object, insertion);
            }
            return object3;
        }
        catch (Throwable throwable) {
            TreeFinder.reportInsertionError(insertion, throwable);
            return null;
        }
    }

    Integer findPositionByASTPath(ASTPath aSTPath, TreePath treePath, Insertion insertion) {
        Tree tree = treePath.getLeaf();
        try {
            Object object;
            Object object2;
            ASTPath.ASTEntry aSTEntry = aSTPath.getLast();
            if (aSTEntry.getTreeKind() == Tree.Kind.METHOD && aSTEntry.childSelectorIs("parameter") && aSTEntry.getArgument() == -1 && treePath.getParentPath().getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
                warn.debug("WARNING: Cannot insert a receiver parameter on a method declaration of an anonymous inner class.  This insertion will be skipped.%n    Insertion: %s%n", insertion);
                return null;
            }
            if (this.alreadyPresent(treePath, insertion)) {
                return null;
            }
            if (insertion.getKind() == Insertion.Kind.CONSTRUCTOR) {
                object2 = (ConstructorInsertion)insertion;
                if (tree.getKind() == Tree.Kind.METHOD) {
                    object = (JCTree.JCMethodDecl)tree;
                    if ((((JCTree.JCMethodDecl)object).mods.flags & 0x1000000000L) != 0L) {
                        this.addConstructor(treePath, (ConstructorInsertion)object2, (MethodTree)object);
                    } else {
                        ((TypedInsertion)object2).setAnnotationsOnly(true);
                        ((ConstructorInsertion)object2).setInserted(true);
                        insertion = ((ConstructorInsertion)object2).getReceiverInsertion();
                        if (insertion == null) {
                            return null;
                        }
                    }
                } else {
                    ((TypedInsertion)object2).setAnnotationsOnly(true);
                }
            }
            if (insertion.getKind() == Insertion.Kind.RECEIVER && tree.getKind() == Tree.Kind.METHOD) {
                object2 = (ReceiverInsertion)insertion;
                object = (MethodTree)tree;
                if (object.getReceiverParameter() == null) {
                    this.addReceiverType(treePath, (ReceiverInsertion)object2, (MethodTree)object);
                }
            }
            if (insertion.getKind() == Insertion.Kind.NEW && tree.getKind() == Tree.Kind.NEW_ARRAY) {
                object2 = (NewInsertion)insertion;
                object = (NewArrayTree)tree;
                if (object.toString().startsWith("{")) {
                    this.addNewType(treePath, (NewInsertion)object2, (NewArrayTree)object);
                }
            }
            object2 = -1;
            object = ASTIndex.indexOf(this.tree);
            ASTRecord aSTRecord = (ASTRecord)object.get(tree);
            dbug.debug("TreeFinder.scan: node=%s%n  criteria=%s%n", tree, insertion.getCriteria());
            if (CommonScanner.hasClassKind(tree) && aSTEntry.childSelectorIs("bound") && aSTEntry.getArgument() < 0 && ((ClassTree)tree).getExtendsClause() == null) {
                return this.implicitClassBoundPosition((JCTree.JCClassDecl)tree, insertion);
            }
            if (tree.getKind() == Tree.Kind.METHOD && insertion.getCriteria().isOnMethod("<init>()V") && aSTEntry.childSelectorIs("parameter") && aSTEntry.getArgument() < 0) {
                if (insertion.getKind() != Insertion.Kind.CONSTRUCTOR) {
                    return null;
                }
                Tree tree2 = treePath.getParentPath().getLeaf();
                aSTRecord = aSTRecord.extend(Tree.Kind.METHOD, "parameter", -1);
                object2 = ((JCTree)tree2).getEndPosition(this.tree.endPositions) - 1;
            } else if (tree.getKind() == Tree.Kind.METHOD && aSTEntry.childSelectorIs("type")) {
                JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)tree;
                JCTree jCTree = jCMethodDecl.getReturnType();
                aSTRecord = aSTRecord.extend(Tree.Kind.METHOD, "type");
                if (jCTree == null) {
                    object2 = this.findMethodName(jCMethodDecl);
                    if ((Integer)object2 < 0) {
                        return null;
                    }
                    dbug.debug("pos = %d at constructor name: %s%n", object2, jCMethodDecl.sym.toString());
                } else {
                    Pair pair = (Pair)this.tpf.scan(jCTree, insertion);
                    aSTRecord = (ASTRecord)pair.a;
                    object2 = (Integer)pair.b;
                    assert (this.handled(tree));
                    dbug.debug("pos = %d at return type node: %s%n", object2, jCTree.getClass());
                }
            } else if (tree.getKind() == Tree.Kind.TYPE_PARAMETER && aSTEntry.getTreeKind() == Tree.Kind.TYPE_PARAMETER && (((TypeParameterTree)tree).getBounds().isEmpty() || ((JCTree.JCExpression)((TypeParameterTree)tree).getBounds().get((int)0)).type.tsym.isInterface()) || ASTPath.isWildcard(tree.getKind()) && (aSTEntry.getTreeKind() == Tree.Kind.TYPE_PARAMETER || ASTPath.isWildcard(aSTEntry.getTreeKind())) && aSTEntry.childSelectorIs("bound") && (!aSTEntry.hasArgument() || aSTEntry.getArgument() == 0)) {
                Pair pair = (Pair)this.tpf.scan(tree, insertion);
                aSTRecord = (ASTRecord)pair.a;
                object2 = (Integer)pair.b;
                if (insertion.getKind() == Insertion.Kind.ANNOTATION) {
                    if (tree.getKind() == Tree.Kind.TYPE_PARAMETER && !((TypeParameterTree)tree).getBounds().isEmpty()) {
                        Tree tree3 = ((TypeParameterTree)tree).getBounds().get(0);
                        object2 = ((JCTree.JCExpression)tree3).getStartPosition();
                        ((AnnotationInsertion)insertion).setGenerateBound(true);
                    } else {
                        int n = ((JCTree)this.parent(tree)).getEndPosition(this.tree.endPositions);
                        Integer n2 = this.getNthInstanceInRange(',', (Integer)object2 + 1, n, 1);
                        Integer n3 = this.getNthInstanceInRange('>', (Integer)object2 + 1, n, 1);
                        object2 = n2 != -1 && n2 < n3 ? n2 : n3;
                        ((AnnotationInsertion)insertion).setGenerateExtends(true);
                    }
                }
            } else if (insertion.getKind() == Insertion.Kind.CAST) {
                DeclaredType declaredType;
                scenelib.type.Type type = ((CastInsertion)insertion).getType();
                JCTree jCTree = (JCTree)tree;
                if (jCTree.getKind() == Tree.Kind.VARIABLE && !aSTPath.isEmpty() && aSTPath.getLast().childSelectorIs("initializer")) {
                    if ((tree = ((JCTree.JCVariableDecl)tree).getInitializer()) == null) {
                        return null;
                    }
                    jCTree = (JCTree)tree;
                }
                object2 = jCTree.getStartPosition();
                if (type.getKind() == Type.Kind.DECLARED && (declaredType = (DeclaredType)type).getName().isEmpty()) {
                    if (jCTree.type instanceof NullType) {
                        declaredType.setName("Object");
                    } else {
                        type = Insertions.TypeTree.javacTypeToType(jCTree.type);
                        type.setAnnotations(declaredType.getAnnotations());
                        ((CastInsertion)insertion).setType(type);
                    }
                }
            } else if (insertion.getKind() == Insertion.Kind.CLOSE_PARENTHESIS) {
                JCTree jCTree = (JCTree)tree;
                if (jCTree.getKind() == Tree.Kind.VARIABLE && !aSTPath.isEmpty() && aSTPath.getLast().childSelectorIs("initializer")) {
                    if ((tree = ((JCTree.JCVariableDecl)tree).getInitializer()) == null) {
                        return null;
                    }
                    jCTree = (JCTree)tree;
                }
                object2 = jCTree.getEndPosition(this.tree.endPositions);
            } else {
                boolean bl = true;
                if (tree.getKind() == Tree.Kind.METHOD) {
                    bl = IndexFileSpecification.isOnReceiver(insertion.getCriteria());
                } else if (tree.getKind() == Tree.Kind.CLASS) {
                    boolean bl2 = bl = !insertion.isSeparateLine();
                }
                if (bl) {
                    dbug.debug("Calling tpf.scan(%s: %s)%n", tree.getClass(), tree);
                    Pair pair = (Pair)this.tpf.scan(tree, insertion);
                    aSTRecord = (ASTRecord)pair.a;
                    object2 = (Integer)pair.b;
                    assert (this.handled(tree));
                    dbug.debug("pos = %d at type: %s (%s)%n", object2, tree.toString(), tree.getClass());
                } else if (tree.getKind() == Tree.Kind.METHOD && insertion.getKind() == Insertion.Kind.CONSTRUCTOR && (((JCTree.JCMethodDecl)tree).mods.flags & 0x1000000000L) != 0L) {
                    Tree tree4 = treePath.getParentPath().getLeaf();
                    object2 = ((JCTree.JCClassDecl)tree4).getEndPosition(this.tree.endPositions) - 1;
                    aSTRecord = null;
                } else {
                    object2 = (Integer)this.dpf.scan(tree, null);
                    aSTRecord = this.astRecord(tree);
                    assert (object2 != null);
                    dbug.debug("pos = %d at declaration: %s%n", object2, tree.getClass());
                }
            }
            if (object2 != null) {
                assert ((Integer)object2 >= 0) : String.format("pos: %s%nnode: %s%ninsertion: %s%n", object2, tree, insertion);
                this.astInsertions.put(aSTRecord, insertion);
            }
            return object2;
        }
        catch (Throwable throwable) {
            TreeFinder.reportInsertionError(insertion, throwable);
            return null;
        }
    }

    private Integer implicitClassBoundPosition(JCTree.JCClassDecl jCClassDecl, Insertion insertion) {
        Integer n;
        if (jCClassDecl.sym == null || jCClassDecl.sym.isAnonymous() || insertion.getKind() != Insertion.Kind.ANNOTATION) {
            return null;
        }
        JCTree.JCModifiers jCModifiers = jCClassDecl.getModifiers();
        String string = jCClassDecl.getSimpleName().toString();
        if (jCClassDecl.typarams == null || jCClassDecl.typarams.isEmpty()) {
            int n2 = jCClassDecl.getStartPosition();
            int n3 = Math.max(n2, jCModifiers.getEndPosition(this.tree.endPositions) + 1);
            String string2 = jCClassDecl.toString().substring(n3 - n2);
            Pattern pattern = Pattern.compile("(?:\\s|//.*$|/\\*[^*]*+\\*++(?:[^*/][^*]*+\\*++)*+/)*+class(?:\\s|//.*$|/\\*[^*]*+\\*++(?:[^*/][^*]*+\\*++)*+/)++" + Pattern.quote(string) + "\\b");
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.find() || matcher.start() != 0) {
                return null;
            }
            n = n3 + matcher.end() - 1;
        } else {
            JCTree.JCTypeParameter jCTypeParameter = jCClassDecl.typarams.get(jCClassDecl.typarams.length() - 1);
            int n4 = jCTypeParameter.getEndPosition(this.tree.endPositions);
            n = this.getFirstInstanceAfter('>', n4) + 1;
        }
        ((AnnotationInsertion)insertion).setGenerateExtends(true);
        return n;
    }

    private int findMethodName(JCTree.JCMethodDecl jCMethodDecl) {
        String string = jCMethodDecl.sym.toString();
        String string2 = string.substring(0, string.indexOf(40));
        JCTree.JCModifiers jCModifiers = jCMethodDecl.getModifiers();
        JCTree.JCBlock jCBlock = jCMethodDecl.body;
        if ((jCModifiers.flags & 0x1000000000L) != 0L) {
            return -1;
        }
        int n = jCMethodDecl.getStartPosition();
        int n2 = jCMethodDecl.getEndPosition(this.tree.endPositions);
        int n3 = n2 - n;
        int n4 = jCModifiers.getEndPosition(this.tree.endPositions) - jCModifiers.getStartPosition();
        int n5 = jCBlock == null ? 1 : jCBlock.getEndPosition(this.tree.endPositions) - jCBlock.getStartPosition();
        int n6 = n + n4;
        int n7 = n + n3 - n5;
        int n8 = string2.lastIndexOf(62);
        if (n8 >= 0) {
            string2 = string2.substring(n8 + 1);
        }
        try {
            CharSequence charSequence = this.tree.getSourceFile().getCharContent(true);
            String string3 = "\\b" + Pattern.quote(string2) + "\\b";
            Pattern pattern = Pattern.compile(string3, 8);
            Matcher matcher = pattern.matcher(charSequence).region(n6, n7);
            return matcher.find() ? matcher.start() : -1;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private boolean alreadyPresent(TreePath treePath, Insertion insertion) {
        Object object;
        java.util.List<? extends AnnotationTree> list = null;
        ExpressionTree expressionTree = null;
        if (treePath != null) {
            for (Tree tree : treePath) {
                if (tree.getKind() == Tree.Kind.CLASS) {
                    list = ((ClassTree)tree).getModifiers().getAnnotations();
                    break;
                }
                if (tree.getKind() == Tree.Kind.METHOD) {
                    list = ((MethodTree)tree).getModifiers().getAnnotations();
                    break;
                }
                if (tree.getKind() == Tree.Kind.VARIABLE) {
                    object = (VariableTree)tree;
                    if (expressionTree != null && object.getInitializer() == expressionTree) break;
                    list = object.getModifiers().getAnnotations();
                    break;
                }
                if (tree.getKind() == Tree.Kind.TYPE_CAST) {
                    object = ((TypeCastTree)tree).getType();
                    if (object.getKind() != Tree.Kind.ANNOTATED_TYPE) break;
                    list = ((AnnotatedTypeTree)object).getAnnotations();
                    break;
                }
                if (tree.getKind() == Tree.Kind.INSTANCE_OF) {
                    object = ((InstanceOfTree)tree).getType();
                    if (object.getKind() != Tree.Kind.ANNOTATED_TYPE) break;
                    list = ((AnnotatedTypeTree)object).getAnnotations();
                    break;
                }
                if (tree.getKind() == Tree.Kind.NEW_CLASS) {
                    object = (JCTree.JCNewClass)tree;
                    if (((JCTree.JCNewClass)object).clazz.getKind() != Tree.Kind.ANNOTATED_TYPE) break;
                    list = ((AnnotatedTypeTree)((Object)((JCTree.JCNewClass)object).clazz)).getAnnotations();
                    break;
                }
                if (tree.getKind() == Tree.Kind.PARAMETERIZED_TYPE) break;
                if (tree.getKind() == Tree.Kind.ARRAY_TYPE) {
                    object = ((ArrayTypeTree)tree).getType();
                    if (object.getKind() != Tree.Kind.ANNOTATED_TYPE) break;
                    list = ((AnnotatedTypeTree)object).getAnnotations();
                    break;
                }
                if (tree.getKind() == Tree.Kind.ANNOTATED_TYPE) {
                    list = ((AnnotatedTypeTree)tree).getAnnotations();
                    break;
                }
                expressionTree = tree instanceof ExpressionTree ? (ExpressionTree)tree : null;
            }
        }
        if (Main.temporaryDebug) {
            Iterator iterator = treePath.getLeaf();
            System.out.printf("alreadyPresent(%s, %s)%n  leaf (%s) = %s%n  => %s%n", new Object[]{treePath, insertion, iterator.getKind(), iterator, list});
        }
        if (list != null) {
            for (AnnotationTree annotationTree : list) {
                object = annotationTree.getAnnotationType().toString();
                String string = insertion.getText();
                String string2 = ((String)Main.removeArgs((String)string).a).trim().substring(string.startsWith("@") ? 1 : 0);
                String string3 = (String)Insertion.removePackage((String)string2).b;
                if (!((String)object).equals(string2) && !((String)object).equals(string3)) continue;
                dbug.debug("Already present, not reinserting: %s%n", object);
                return true;
            }
        }
        return false;
    }

    public static void reportInsertionError(Insertion insertion, Throwable throwable) {
        System.err.println("Error processing insertion:");
        System.err.println("\t" + insertion);
        if (throwable.getMessage() != null) {
            System.err.println("\tError: " + throwable.getMessage().replace("\n", "\n\t\t"));
        }
        if (dbug.or(stak).isEnabled()) {
            throwable.printStackTrace();
        } else {
            System.err.println("\tRun with --print_error_stack to see the stack trace.");
        }
        System.err.println("\tThis insertion will be skipped.");
    }

    private void addReceiverType(TreePath treePath, ReceiverInsertion receiverInsertion, MethodTree methodTree) {
        Object object;
        boolean bl;
        TreePath treePath2 = treePath;
        Tree tree = treePath2.getLeaf();
        Tree.Kind kind = tree.getKind();
        scenelib.type.Type type = receiverInsertion.getType();
        DeclaredType declaredType = receiverInsertion.getBaseType();
        DeclaredType declaredType2 = null;
        DeclaredType declaredType3 = null;
        boolean bl2 = bl = ((MethodTree)treePath2.getLeaf()).getReturnType() == null;
        while (kind != Tree.Kind.COMPILATION_UNIT && kind != Tree.Kind.NEW_CLASS) {
            if (kind == Tree.Kind.CLASS || kind == Tree.Kind.INTERFACE || kind == Tree.Kind.ENUM || kind == Tree.Kind.ANNOTATION_TYPE) {
                object = (ClassTree)tree;
                String string = object.getSimpleName().toString();
                boolean bl3 = kind == Tree.Kind.INTERFACE || kind == Tree.Kind.ENUM || object.getModifiers().getFlags().contains((Object)Modifier.STATIC);
                if (bl2 &= !bl3) {
                    bl2 = false;
                    receiverInsertion.setQualifyType(true);
                } else if (!string.isEmpty()) {
                    DeclaredType declaredType4 = new DeclaredType(string);
                    if (declaredType3 == null) {
                        for (TypeParameterTree typeParameterTree : object.getTypeParameters()) {
                            declaredType4.addTypeParameter(new DeclaredType(typeParameterTree.getName().toString()));
                        }
                    }
                    if (declaredType3 == null && bl3) {
                        declaredType4.setAnnotations(type.getAnnotations());
                        type.clearAnnotations();
                        declaredType3 = declaredType4;
                    }
                    if (declaredType2 == null) {
                        declaredType2 = declaredType4;
                    } else {
                        declaredType4.setInnerType(declaredType2);
                        declaredType2 = declaredType4;
                    }
                }
            }
            treePath2 = treePath2.getParentPath();
            tree = treePath2.getLeaf();
            kind = tree.getKind();
        }
        if (bl && declaredType2 == null) {
            throw new IllegalArgumentException("can't annotate (non-existent) receiver of non-inner constructor");
        }
        declaredType.setName(declaredType2.getName());
        declaredType.setTypeParameters(declaredType2.getTypeParameters());
        declaredType.setInnerType(declaredType2.getInnerType());
        if (declaredType3 != null && !declaredType2.getAnnotations().isEmpty()) {
            type.setAnnotations(declaredType2.getAnnotations());
        }
        object = declaredType3 == null ? declaredType : declaredType3;
        Insertion.decorateType(receiverInsertion.getInnerTypeInsertions(), (scenelib.type.Type)object, receiverInsertion.getCriteria().getASTPath());
        receiverInsertion.setAddComma(methodTree.getParameters().size() > 0);
    }

    private void addNewType(TreePath treePath, NewInsertion newInsertion, NewArrayTree newArrayTree) {
        DeclaredType declaredType = newInsertion.getBaseType();
        if (declaredType.getName().isEmpty()) {
            java.util.List<String> list = newInsertion.getType().getAnnotations();
            scenelib.type.Type type = Insertions.TypeTree.javacTypeToType(((JCTree.JCNewArray)newArrayTree).type);
            for (String string : list) {
                type.addAnnotation(string);
            }
            newInsertion.setType(type);
        }
        Insertion.decorateType(newInsertion.getInnerTypeInsertions(), newInsertion.getType(), newInsertion.getCriteria().getASTPath());
    }

    private void addConstructor(TreePath treePath, ConstructorInsertion constructorInsertion, MethodTree methodTree) {
        Object object;
        Object object2;
        Object object3;
        ReceiverInsertion receiverInsertion = constructorInsertion.getReceiverInsertion();
        MethodTree methodTree2 = (MethodTree)treePath.getLeaf();
        ClassTree classTree = (ClassTree)treePath.getParentPath().getLeaf();
        DeclaredType declaredType = constructorInsertion.getBaseType();
        if (declaredType.getName().isEmpty()) {
            object3 = declaredType.getAnnotations();
            object2 = classTree.getSimpleName().toString();
            object = new DeclaredType((String)object2);
            constructorInsertion.setType((scenelib.type.Type)object);
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ((scenelib.type.Type)object).addAnnotation(string);
            }
        }
        if (receiverInsertion != null) {
            object3 = constructorInsertion.getInnerTypeInsertions().iterator();
            object2 = new ArrayList();
            this.addReceiverType(treePath, receiverInsertion, methodTree2);
            while (object3.hasNext()) {
                object = (Insertion)object3.next();
                if (!((Insertion)object).getCriteria().isOnReceiver()) continue;
                object2.add(object);
                object3.remove();
            }
            Insertion.decorateType((java.util.List<Insertion>)object2, receiverInsertion.getType(), constructorInsertion.getCriteria().getASTPath());
        }
        Insertion.decorateType(constructorInsertion.getInnerTypeInsertions(), constructorInsertion.getType(), constructorInsertion.getCriteria().getASTPath());
    }

    public SetMultimap<ASTRecord, Insertion> getPaths() {
        return Multimaps.unmodifiableSetMultimap(this.astInsertions);
    }

    public SetMultimap<Pair<Integer, ASTPath>, Insertion> getInsertionsByPosition(JCTree.JCCompilationUnit jCCompilationUnit, java.util.List<Insertion> list) {
        ArrayList<Insertion> arrayList = new ArrayList<Insertion>(list);
        this.scan((Tree)jCCompilationUnit, (java.util.List<Insertion>)arrayList);
        java.util.List list2 = jCCompilationUnit.getTypeDecls();
        for (Insertion insertion : arrayList) {
            InClassCriterion inClassCriterion = insertion.getCriteria().getInClass();
            if (inClassCriterion == null) continue;
            for (Tree tree : list2) {
                if (!inClassCriterion.isSatisfiedBy(TreePath.getPath(jCCompilationUnit, tree)) || insertion.getCriteria().isOnMethod("<init>()V") || insertion.getCriteria().isOnLocalVariable()) continue;
                System.err.printf("Found class %s, but unable to insert %s:%n  %s%n", inClassCriterion.className, insertion.getText(), insertion);
            }
        }
        if (dbug.isEnabled()) {
            for (Insertion insertion : arrayList) {
                System.err.println("Unable to insert: " + insertion);
            }
        }
        dbug.debug("getPositions => %d positions%n", this.insertions.size());
        return Multimaps.unmodifiableSetMultimap(this.insertions);
    }

    public SetMultimap<Pair<Integer, ASTPath>, Insertion> getPositions(JCTree.JCCompilationUnit jCCompilationUnit, Insertions insertions) {
        ArrayList<Insertion> arrayList = new ArrayList<Insertion>();
        this.treePathCache.clear();
        if (Main.temporaryDebug) {
            System.out.println("insertions size: " + insertions.size());
            System.out.println("insertions.forOuterClass(\"\") size: " + insertions.forOuterClass(jCCompilationUnit, "").size());
            System.out.println("list pre-size: " + arrayList.size());
        }
        arrayList.addAll(insertions.forOuterClass(jCCompilationUnit, ""));
        if (Main.temporaryDebug) {
            System.out.println("list post-size: " + arrayList.size());
        }
        for (JCTree jCTree : jCCompilationUnit.getTypeDecls()) {
            if (jCTree.getTag() != JCTree.Tag.CLASSDEF) continue;
            String string = ((JCTree.JCClassDecl)jCTree).sym.className();
            Set<Insertion> set = insertions.forOuterClass(jCCompilationUnit, string);
            if (Main.temporaryDebug) {
                System.out.println("insertions size: " + insertions.size());
                System.out.println("insertions.forOuterClass(" + string + ") size: " + set.size());
                System.out.println("list pre-size: " + arrayList.size());
            }
            arrayList.addAll(set);
            if (!Main.temporaryDebug) continue;
            System.out.println("list post-size: " + arrayList.size());
        }
        return this.getInsertionsByPosition(jCCompilationUnit, arrayList);
    }

    private class DeclarationPositionFinder
    extends TreeScanner<Integer, Void> {
        private DeclarationPositionFinder() {
        }

        @Override
        public Integer visitMethod(MethodTree methodTree, Void void_) {
            super.visitMethod(methodTree, void_);
            ModifiersTree modifiersTree = methodTree.getModifiers();
            java.util.List<? extends AnnotationTree> list = modifiersTree.getAnnotations();
            JCTree jCTree = list.size() > 1 ? (JCTree.JCAnnotation)list.get(0) : (methodTree.getReturnType() != null ? (JCTree)methodTree.getReturnType() : (JCTree)((Object)methodTree));
            int n = jCTree.getStartPosition();
            int n2 = ((JCTree.JCModifiers)modifiersTree).pos().getStartPosition();
            if (n2 != -1) {
                n = Math.min(n, n2);
            }
            return n;
        }

        @Override
        public Integer visitCompilationUnit(CompilationUnitTree compilationUnitTree, Void void_) {
            JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)compilationUnitTree;
            return jCCompilationUnit.getStartPosition();
        }

        @Override
        public Integer visitClass(ClassTree classTree, Void void_) {
            JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)classTree;
            int n = -1;
            if (jCClassDecl.mods != null && (jCClassDecl.mods.flags != 0L || jCClassDecl.mods.annotations.size() > 0)) {
                n = jCClassDecl.mods.getPreferredPosition();
            }
            if (n < 0) {
                n = jCClassDecl.getPreferredPosition();
            }
            assert (n >= 0 || jCClassDecl.name.isEmpty()) : String.format("%d %d %d%n", jCClassDecl.getStartPosition(), jCClassDecl.getPreferredPosition(), jCClassDecl.pos);
            return n < 0 ? null : Integer.valueOf(n);
        }
    }

    private class TypePositionFinder
    extends TreeScanner<Pair<ASTRecord, Integer>, Insertion> {
        private TypePositionFinder() {
        }

        private Pair<ASTRecord, Integer> pathAndPos(JCTree jCTree) {
            return Pair.of(TreeFinder.this.astRecord(jCTree), jCTree.pos);
        }

        private Pair<ASTRecord, Integer> pathAndPos(JCTree jCTree, int n) {
            return Pair.of(TreeFinder.this.astRecord(jCTree), n);
        }

        private Pair<ASTRecord, Integer> getBaseTypePosition(JCTree jCTree) {
            block9: while (true) {
                switch (jCTree.getKind()) {
                    case IDENTIFIER: 
                    case PRIMITIVE_TYPE: {
                        return this.pathAndPos(jCTree);
                    }
                    case MEMBER_SELECT: {
                        Object object;
                        JCTree jCTree2 = jCTree;
                        do {
                            object = (JCTree.JCFieldAccess)jCTree2;
                            jCTree2 = ((JCTree.JCFieldAccess)object).getExpression();
                            if (!((JCTree.JCFieldAccess)object).sym.isStatic()) continue;
                            return this.pathAndPos(jCTree2, TreeFinder.this.getFirstInstanceAfter('.', jCTree2.getEndPosition(((TreeFinder)TreeFinder.this).tree.endPositions)) + 1);
                        } while (jCTree2 instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)jCTree2).sym.getKind() != ElementKind.PACKAGE);
                        if (jCTree2 != null) {
                            if (jCTree2.getKind() == Tree.Kind.IDENTIFIER && !((Symbol)(object = ((JCTree.JCIdent)jCTree2).sym)).isStatic() && ((Symbol)object).getKind() != ElementKind.PACKAGE) {
                                return this.pathAndPos(jCTree, jCTree.getStartPosition());
                            }
                            jCTree = jCTree2;
                        }
                        return this.pathAndPos(jCTree, TreeFinder.this.getFirstInstanceAfter('.', jCTree.getEndPosition(((TreeFinder)TreeFinder.this).tree.endPositions)) + 1);
                    }
                    case ARRAY_TYPE: {
                        jCTree = ((JCTree.JCArrayTypeTree)jCTree).elemtype;
                        continue block9;
                    }
                    case PARAMETERIZED_TYPE: {
                        return this.pathAndPos(jCTree, jCTree.getStartPosition());
                    }
                    case EXTENDS_WILDCARD: 
                    case SUPER_WILDCARD: {
                        jCTree = ((JCTree.JCWildcard)jCTree).inner;
                        continue block9;
                    }
                    case UNBOUNDED_WILDCARD: {
                        return this.pathAndPos(jCTree);
                    }
                    case ANNOTATED_TYPE: {
                        jCTree = ((JCTree.JCAnnotatedType)jCTree).underlyingType;
                        continue block9;
                    }
                }
                break;
            }
            throw new RuntimeException(String.format("Unrecognized type (kind=%s, class=%s): %s", new Object[]{jCTree.getKind(), jCTree.getClass(), jCTree}));
        }

        @Override
        public Pair<ASTRecord, Integer> visitVariable(VariableTree variableTree, Insertion insertion) {
            Name name = variableTree.getName();
            JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)variableTree;
            JCTree jCTree = jCVariableDecl.getType();
            Criteria criteria = insertion.getCriteria();
            dbug.debug("TypePositionFinder.visitVariable: %s %s%n", jCTree, jCTree.getClass());
            if (name != null && criteria.isOnFieldDeclaration()) {
                return Pair.of(TreeFinder.this.astRecord(variableTree), jCVariableDecl.getStartPosition());
            }
            if (jCTree instanceof JCTree.JCTypeApply) {
                JCTree.JCExpression jCExpression = ((JCTree.JCTypeApply)jCTree).clazz;
                return this.pathAndPos(jCExpression);
            }
            return Pair.of(TreeFinder.this.astRecord(variableTree), jCVariableDecl.pos);
        }

        @Override
        public Pair<ASTRecord, Integer> visitMethod(MethodTree methodTree, Insertion insertion) {
            dbug.debug("TypePositionFinder.visitMethod%n", new Object[0]);
            super.visitMethod(methodTree, insertion);
            JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)methodTree;
            JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)methodTree.getReceiverParameter();
            if (jCVariableDecl != null) {
                return this.pathAndPos(jCVariableDecl);
            }
            int n = -1;
            ASTRecord aSTRecord = TreeFinder.this.astRecord(jCMethodDecl).extend(Tree.Kind.METHOD, "parameter", -1);
            if (methodTree.getParameters().isEmpty()) {
                n = TreeFinder.this.findMethodName(jCMethodDecl);
                if (n >= 0) {
                    n = TreeFinder.this.getFirstInstanceAfter('(', n);
                }
                if (++n <= 0) {
                    throw new RuntimeException("Couldn't find param opening paren for: " + jCMethodDecl);
                }
            } else {
                n = ((JCTree)((Object)methodTree.getParameters().get(0))).getStartPosition();
            }
            return Pair.of(aSTRecord, n);
        }

        @Override
        public Pair<ASTRecord, Integer> visitIdentifier(IdentifierTree identifierTree, Insertion insertion) {
            dbug.debug("TypePositionFinder.visitIdentifier(%s)%n", identifierTree);
            ASTRecord aSTRecord = ASTIndex.indexOf(TreeFinder.this.tree).get(identifierTree);
            ASTPath aSTPath = insertion.getCriteria().getASTPath();
            Tree tree = TreeFinder.this.parent(identifierTree);
            Integer n = null;
            JCTree.JCIdent jCIdent = (JCTree.JCIdent)identifierTree;
            if (tree.getKind() == Tree.Kind.NEW_ARRAY) {
                ASTPath.ASTEntry aSTEntry;
                dbug.debug("TypePositionFinder.visitIdentifier: recognized array%n", new Object[0]);
                if (aSTPath == null) {
                    aSTEntry = new ASTPath.ASTEntry(Tree.Kind.NEW_ARRAY, "type", 0);
                    aSTPath = ((TreeFinder)TreeFinder.this).astRecord((Tree)tree).extend((ASTPath.ASTEntry)aSTEntry).astPath;
                } else {
                    aSTEntry = (ASTPath.ASTEntry)aSTPath.get(aSTPath.size() - 1);
                }
                if (aSTEntry.childSelectorIs("type")) {
                    int n2 = aSTEntry.getArgument();
                    n = jCIdent.getStartPosition();
                    if (n2 < this.getDimsSize((JCTree.JCExpression)tree)) {
                        n = TreeFinder.this.getNthInstanceInRange('[', n, ((JCTree.JCNewArray)tree).getEndPosition(((TreeFinder)TreeFinder.this).tree.endPositions), n2 + 1);
                    }
                }
                if (n == null) {
                    n = jCIdent.getEndPosition(((TreeFinder)TreeFinder.this).tree.endPositions);
                }
            } else if (tree.getKind() == Tree.Kind.NEW_CLASS) {
                dbug.debug("TypePositionFinder.visitIdentifier: recognized class%n", new Object[0]);
                JCTree.JCNewClass jCNewClass = (JCTree.JCNewClass)tree;
                dbug.debug("TypePositionFinder.visitIdentifier: clazz %s (%d) constructor %s%n", jCNewClass.clazz, jCNewClass.clazz.getPreferredPosition(), jCNewClass.constructor);
                n = jCNewClass.clazz.getPreferredPosition();
                if (aSTPath == null) {
                    aSTPath = ((TreeFinder)TreeFinder.this).astRecord((Tree)identifierTree).astPath;
                }
            } else {
                ASTRecord aSTRecord2 = TreeFinder.this.astRecord(identifierTree);
                aSTPath = aSTRecord2.astPath;
                n = ((JCTree.JCIdent)identifierTree).pos;
            }
            dbug.debug("visitIdentifier(%s) => %d where parent (%s) = %s%n", identifierTree, n, tree.getClass(), tree);
            return Pair.of(aSTRecord.replacePath(aSTPath), n);
        }

        @Override
        public Pair<ASTRecord, Integer> visitMemberSelect(MemberSelectTree memberSelectTree, Insertion insertion) {
            dbug.debug("TypePositionFinder.visitMemberSelect(%s)%n", memberSelectTree);
            JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)memberSelectTree;
            return Pair.of(TreeFinder.this.astRecord(memberSelectTree), jCFieldAccess.getEndPosition(((TreeFinder)TreeFinder.this).tree.endPositions) - jCFieldAccess.name.length());
        }

        @Override
        public Pair<ASTRecord, Integer> visitTypeParameter(TypeParameterTree typeParameterTree, Insertion insertion) {
            JCTree.JCTypeParameter jCTypeParameter = (JCTree.JCTypeParameter)typeParameterTree;
            return Pair.of(TreeFinder.this.astRecord(typeParameterTree), jCTypeParameter.getStartPosition());
        }

        @Override
        public Pair<ASTRecord, Integer> visitWildcard(WildcardTree wildcardTree, Insertion insertion) {
            JCTree.JCWildcard jCWildcard = (JCTree.JCWildcard)wildcardTree;
            return Pair.of(TreeFinder.this.astRecord(wildcardTree), jCWildcard.getStartPosition());
        }

        @Override
        public Pair<ASTRecord, Integer> visitPrimitiveType(PrimitiveTypeTree primitiveTypeTree, Insertion insertion) {
            dbug.debug("TypePositionFinder.visitPrimitiveType(%s)%n", primitiveTypeTree);
            return this.pathAndPos((JCTree)((Object)primitiveTypeTree));
        }

        @Override
        public Pair<ASTRecord, Integer> visitParameterizedType(ParameterizedTypeTree parameterizedTypeTree, Insertion insertion) {
            Tree tree = TreeFinder.this.parent(parameterizedTypeTree);
            dbug.debug("TypePositionFinder.visitParameterizedType %s parent=%s%n", parameterizedTypeTree, tree);
            Integer n = (Integer)this.getBaseTypePosition((JCTree)((JCTree.JCTypeApply)parameterizedTypeTree).getType()).b;
            return Pair.of(TreeFinder.this.astRecord(parameterizedTypeTree), n);
        }

        private int arrayLevels(Type type) {
            return type.accept(new Types.SimpleVisitor<Integer, Integer>(){

                @Override
                public Integer visitArrayType(Type.ArrayType arrayType, Integer n) {
                    return arrayType.elemtype.accept(this, n + 1);
                }

                @Override
                public Integer visitType(Type type, Integer n) {
                    return n;
                }
            }, 0);
        }

        private int arrayLevels(Tree tree) {
            int n = 0;
            while (tree.getKind() == Tree.Kind.ARRAY_TYPE) {
                ++n;
                tree = ((ArrayTypeTree)tree).getType();
            }
            return n;
        }

        private JCTree arrayContentType(JCTree.JCArrayTypeTree jCArrayTypeTree) {
            JCTree jCTree = jCArrayTypeTree;
            while ((jCTree = ((JCTree.JCArrayTypeTree)jCTree).getType()).getKind() == Tree.Kind.ARRAY_TYPE) {
            }
            return jCTree;
        }

        private ArrayTypeTree largestContainingArray(Tree tree) {
            TreePath treePath = TreeFinder.this.getPath(tree);
            Tree tree2 = TreeFinder.largestContainingArray(treePath).getLeaf();
            assert (tree2.getKind() == Tree.Kind.ARRAY_TYPE);
            return (ArrayTypeTree)tree2;
        }

        @Override
        public Pair<ASTRecord, Integer> visitArrayType(ArrayTypeTree arrayTypeTree, Insertion insertion) {
            dbug.debug("TypePositionFinder.visitArrayType(%s)%n", arrayTypeTree);
            JCTree.JCArrayTypeTree jCArrayTypeTree = (JCTree.JCArrayTypeTree)arrayTypeTree;
            dbug.debug("TypePositionFinder.visitArrayType(%s) preferred = %s%n", arrayTypeTree, jCArrayTypeTree.getPreferredPosition());
            ArrayTypeTree arrayTypeTree2 = this.largestContainingArray(arrayTypeTree);
            int n = this.arrayLevels(arrayTypeTree2);
            int n2 = this.arrayLevels(arrayTypeTree);
            int n3 = this.arrayContentType(jCArrayTypeTree).getPreferredPosition() + 1;
            int n4 = jCArrayTypeTree.getEndPosition(((TreeFinder)TreeFinder.this).tree.endPositions);
            int n5 = this.arrayInsertPos(n3, n4);
            dbug.debug("  levels=%d largestLevels=%d%n", n2, n);
            for (int i = n2; i < n; ++i) {
                n5 = TreeFinder.this.getFirstInstanceAfter('[', n5 + 1);
                dbug.debug("  pos %d at i=%d%n", n5, i);
            }
            return Pair.of(TreeFinder.this.astRecord(arrayTypeTree), n5);
        }

        private int arrayInsertPos(int n, int n2) {
            try {
                CharSequence charSequence = TreeFinder.this.tree.getSourceFile().getCharContent(true);
                int n3 = TreeFinder.this.getNthInstanceInRange('[', n, n2, 1);
                if (n3 < 0) {
                    String string = TreeFinder.otherThan('.');
                    String string2 = "(?:(?:\\.\\.?)?" + string + ")*(\\.\\.\\.)";
                    Pattern pattern = Pattern.compile(string2, 8);
                    Matcher matcher = pattern.matcher(charSequence).region(n, n2);
                    if (matcher.find()) {
                        n3 = matcher.start(1);
                    }
                    if (n3 < 0) {
                        throw new RuntimeException("no \"[\" or \"...\" in array type");
                    }
                }
                return n3;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        @Override
        public Pair<ASTRecord, Integer> visitCompilationUnit(CompilationUnitTree compilationUnitTree, Insertion insertion) {
            dbug.debug("TypePositionFinder.visitCompilationUnit%n", new Object[0]);
            JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)compilationUnitTree;
            return Pair.of(TreeFinder.this.astRecord(compilationUnitTree), jCCompilationUnit.getStartPosition());
        }

        @Override
        public Pair<ASTRecord, Integer> visitClass(ClassTree classTree, Insertion insertion) {
            dbug.debug("TypePositionFinder.visitClass%n", new Object[0]);
            JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)classTree;
            JCTree jCTree = jCClassDecl.mods == null ? jCClassDecl : jCClassDecl.mods;
            return Pair.of(TreeFinder.this.astRecord(jCClassDecl), jCTree.getPreferredPosition());
        }

        private int getDimsSize(JCTree.JCExpression jCExpression) {
            if (jCExpression instanceof JCTree.JCNewArray) {
                JCTree.JCNewArray jCNewArray = (JCTree.JCNewArray)jCExpression;
                if (jCNewArray.dims.size() != 0) {
                    return this.arrayLevels(jCNewArray.type);
                }
                if (jCNewArray.elemtype != null) {
                    return this.getDimsSize(jCNewArray.elemtype) + 1;
                }
                assert (jCNewArray.elems != null);
                int n = 0;
                for (JCTree.JCExpression jCExpression2 : jCNewArray.elems) {
                    if (jCExpression2 instanceof JCTree.JCNewArray) {
                        int n2 = this.getDimsSize((JCTree.JCNewArray)jCExpression2);
                        n = Math.max(n, n2);
                        continue;
                    }
                    if (!(jCExpression2 instanceof JCTree.JCArrayTypeTree)) continue;
                    System.out.printf("JCArrayTypeTree: %s%n", jCExpression2);
                }
                return n + 1;
            }
            if (jCExpression instanceof JCTree.JCAnnotatedType) {
                return this.getDimsSize(((JCTree.JCAnnotatedType)jCExpression).underlyingType);
            }
            if (jCExpression instanceof JCTree.JCArrayTypeTree) {
                return 1 + this.getDimsSize(((JCTree.JCArrayTypeTree)jCExpression).elemtype);
            }
            return 0;
        }

        @Override
        public Pair<ASTRecord, Integer> visitNewArray(NewArrayTree newArrayTree, Insertion insertion) {
            Object object;
            int n;
            int n2;
            Object object2;
            int n3;
            dbug.debug("TypePositionFinder.visitNewArray%n", new Object[0]);
            JCTree.JCNewArray jCNewArray = (JCTree.JCNewArray)newArrayTree;
            GenericArrayLocationCriterion genericArrayLocationCriterion = insertion.getCriteria().getGenericArrayLocation();
            ASTRecord aSTRecord = ASTIndex.indexOf(TreeFinder.this.tree).get(newArrayTree);
            Object object3 = insertion.getCriteria().getASTPath();
            String string = null;
            int n4 = this.getDimsSize(jCNewArray);
            int n5 = n3 = genericArrayLocationCriterion == null ? 0 : genericArrayLocationCriterion.getLocation().size();
            if (object3 == null) {
                object3 = ((TreeFinder)TreeFinder.this).astRecord((Tree)newArrayTree).astPath.extendNewArray(n3);
                string = "type";
            } else {
                object2 = null;
                n = n2 = ((ASTPath)object3).size();
                while (--n >= 0 && ((ASTPath.ASTEntry)(object2 = (ASTPath.ASTEntry)((ImmutableStack)object3).get(n))).getTreeKind() != Tree.Kind.NEW_ARRAY) {
                }
                assert (n >= 0) : "no matching path entry (kind=NEW_ARRAY)";
                if (n2 > n + 1) {
                    assert (n3 + 1 == n4);
                    Tree tree = jCNewArray.elemtype;
                    int n6 = n + n3 + 1;
                    while (--n3 >= 0) {
                        tree = ((ArrayTypeTree)tree).getType();
                    }
                    block8: while (n6 < n2) {
                        ASTPath.ASTEntry aSTEntry = (ASTPath.ASTEntry)((ImmutableStack)object3).get(n6);
                        switch (aSTEntry.getTreeKind()) {
                            case ANNOTATED_TYPE: {
                                tree = ((AnnotatedTypeTree)tree).getUnderlyingType();
                                continue block8;
                            }
                            case ARRAY_TYPE: {
                                tree = ((ArrayTypeTree)tree).getType();
                                break;
                            }
                            case MEMBER_SELECT: {
                                if (!(tree instanceof JCTree.JCFieldAccess)) break block8;
                                JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)tree;
                                tree = jCFieldAccess.getExpression();
                                if (jCFieldAccess.sym.getKind() != ElementKind.PACKAGE) break;
                                continue block8;
                            }
                            case PARAMETERIZED_TYPE: {
                                if (aSTEntry.childSelectorIs("typeArgument")) {
                                    int n7 = aSTEntry.getArgument();
                                    java.util.List<? extends Tree> list = ((ParameterizedTypeTree)tree).getTypeArguments();
                                    tree = list.get(n7);
                                    break;
                                }
                                tree = ((ParameterizedTypeTree)tree).getType();
                                break;
                            }
                            default: {
                                break block8;
                            }
                        }
                        ++n6;
                    }
                    if (n6 < n2) {
                        return this.getBaseTypePosition(jCNewArray);
                    }
                    return tree.accept(this, insertion);
                }
                string = ((ASTPath.ASTEntry)object2).getChildSelector();
                if (n3 > 0 && "type".equals(string)) {
                    int n8;
                    object = ASTPath.empty();
                    n3 += ((ASTPath.ASTEntry)object2).getArgument();
                    for (n8 = 0; n8 < n; ++n8) {
                        object = ((ASTPath)object).extend((ASTPath.ASTEntry)((ImmutableStack)object3).get(n8));
                    }
                    object2 = new ASTPath.ASTEntry(Tree.Kind.NEW_ARRAY, "type", n3);
                    object = ((ASTPath)object).extend((ASTPath.ASTEntry)object2);
                    while (n8 < n2) {
                        object = ((ASTPath)object).extend((ASTPath.ASTEntry)((ImmutableStack)object3).get(n8));
                        ++n8;
                    }
                    object3 = object;
                } else {
                    n3 = ((ASTPath.ASTEntry)object2).getArgument();
                }
            }
            if ("type".equals(string)) {
                if (jCNewArray.toString().startsWith("{")) {
                    if (insertion.getKind() == Insertion.Kind.ANNOTATION) {
                        Tree tree;
                        object2 = TreePath.getPath(TreeFinder.this.tree, (Tree)jCNewArray).getParentPath();
                        if (object2 != null && (tree = ((TreePath)object2).getLeaf()).getKind() == Tree.Kind.VARIABLE) {
                            AnnotationInsertion annotationInsertion = (AnnotationInsertion)insertion;
                            object = ((JCTree.JCVariableDecl)tree).getType();
                            annotationInsertion.setType(((JCTree)object).toString());
                            return Pair.of(aSTRecord.replacePath((ASTPath)object3), jCNewArray.getStartPosition());
                        }
                        System.err.println("WARNING: array initializer " + newArrayTree + " has no explicit type; skipping insertion " + insertion);
                        return null;
                    }
                    return Pair.of(aSTRecord.replacePath((ASTPath)object3), jCNewArray.getStartPosition());
                }
                if (n3 == n4) {
                    if (jCNewArray.elemtype == null) {
                        System.err.println("WARNING: array initializer " + newArrayTree + " has no explicit type; skipping insertion " + insertion);
                        return null;
                    }
                    return this.getBaseTypePosition(jCNewArray.elemtype);
                }
                if (jCNewArray.dims.size() != 0) {
                    int n9 = jCNewArray.getStartPosition();
                    n2 = jCNewArray.getEndPosition(((TreeFinder)TreeFinder.this).tree.endPositions);
                    n = TreeFinder.this.getNthInstanceInRange('[', n9, n2, n3 + 1);
                    return Pair.of(aSTRecord.replacePath((ASTPath)object3), n);
                }
                if (n3 == 0) {
                    if (jCNewArray.elemtype == null) {
                        return Pair.of(aSTRecord.replacePath((ASTPath)object3), jCNewArray.getStartPosition());
                    }
                    int n10 = jCNewArray.elemtype.getStartPosition();
                    return Pair.of(aSTRecord.replacePath((ASTPath)object3), TreeFinder.this.getFirstInstanceAfter('[', n10 + 1));
                }
                if (n3 == n4) {
                    return Pair.of(aSTRecord.replacePath((ASTPath)object3), jCNewArray.getType().pos().getStartPosition());
                }
                object2 = (JCTree.JCArrayTypeTree)jCNewArray.elemtype;
                for (n2 = 1; n2 < n3; ++n2) {
                    JCTree.JCExpression jCExpression = ((JCTree.JCArrayTypeTree)object2).elemtype;
                    if (jCExpression.hasTag(JCTree.Tag.ANNOTATED_TYPE)) {
                        jCExpression = ((JCTree.JCAnnotatedType)jCExpression).underlyingType;
                    }
                    assert (jCExpression.hasTag(JCTree.Tag.TYPEARRAY));
                    object2 = (JCTree.JCArrayTypeTree)jCExpression;
                }
                return Pair.of(aSTRecord.replacePath((ASTPath)object3), ((JCTree)object2).pos().getPreferredPosition());
            }
            if ("dimension".equals(string)) {
                object2 = jCNewArray.getInitializers();
                if (n3 < object2.size()) {
                    JCTree.JCExpression jCExpression = (JCTree.JCExpression)object2.get(n3);
                    return Pair.of(TreeFinder.this.astRecord(jCExpression), jCExpression.getStartPosition());
                }
                return null;
            }
            if ("initializer".equals(string)) {
                object2 = (JCTree.JCExpression)((List)jCNewArray.getDimensions()).get(n3);
                return Pair.of(TreeFinder.this.astRecord((Tree)object2), ((JCTree)object2).getStartPosition());
            }
            assert (false) : "Unexpected child selector in AST path: " + (string == null ? "null" : "\"" + string + "\"");
            return null;
        }

        @Override
        public Pair<ASTRecord, Integer> visitNewClass(NewClassTree newClassTree, Insertion insertion) {
            JCTree.JCNewClass jCNewClass = (JCTree.JCNewClass)newClassTree;
            JCTree.JCExpression jCExpression = jCNewClass.clazz;
            while (jCExpression.getKind() != Tree.Kind.IDENTIFIER) {
                if (jCExpression instanceof JCTree.JCAnnotatedType) {
                    jCExpression = ((JCTree.JCAnnotatedType)jCExpression).underlyingType;
                    continue;
                }
                if (jCExpression instanceof JCTree.JCTypeApply) {
                    jCExpression = ((JCTree.JCTypeApply)jCExpression).clazz;
                    continue;
                }
                if (jCExpression instanceof JCTree.JCFieldAccess) {
                    jCExpression = ((JCTree.JCFieldAccess)jCExpression).selected;
                    continue;
                }
                throw new Error(String.format("unrecognized JCNewClass.clazz (%s): %s%n   surrounding new class tree: %s%n", jCExpression.getClass(), jCExpression, newClassTree));
            }
            return this.visitIdentifier((IdentifierTree)((Object)jCExpression), insertion);
        }
    }
}

