/*
 * Decompiled with CFR 0.152.
 */
package annotator.scanner;

import annotator.scanner.CommonScanner;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InstanceOfScanner
extends CommonScanner {
    private int index = -1;
    private boolean done = false;
    private final Tree tree;
    private static Map<String, List<Integer>> methodNameToInstanceOfOffsets = new HashMap<String, List<Integer>>();

    public static int indexOfInstanceOfTree(TreePath treePath, Tree tree) {
        TreePath treePath2 = InstanceOfScanner.findCountingContext(treePath);
        if (treePath2 == null) {
            return -1;
        }
        InstanceOfScanner instanceOfScanner = new InstanceOfScanner(tree);
        instanceOfScanner.scan(treePath2, null);
        return instanceOfScanner.index;
    }

    private InstanceOfScanner(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Void visitInstanceOf(InstanceOfTree instanceOfTree, Void void_) {
        if (!this.done) {
            ++this.index;
        }
        if (this.tree == instanceOfTree) {
            this.done = true;
        }
        return (Void)super.visitInstanceOf(instanceOfTree, void_);
    }

    public static void addInstanceOfToMethod(String string, Integer n) {
        List<Integer> list = methodNameToInstanceOfOffsets.get(string);
        if (list == null) {
            list = new ArrayList<Integer>();
            methodNameToInstanceOfOffsets.put(string, list);
        }
        list.add(n);
    }

    public static Integer getMethodInstanceOfIndex(String string, Integer n) {
        List<Integer> list = methodNameToInstanceOfOffsets.get(string);
        if (list == null) {
            return -1;
        }
        return list.indexOf(n);
    }
}

