/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.substringindex;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.index.OffsetDependentTypesHelper;
import org.checkerframework.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.checker.index.qual.SubstringIndexFor;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.upperbound.UBQualifier;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.framework.util.dependenttypes.DependentTypesHelper;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;

public class SubstringIndexAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    public final AnnotationMirror UNKNOWN;
    public final AnnotationMirror BOTTOM;

    public SubstringIndexAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.UNKNOWN = AnnotationBuilder.fromClass(this.elements, SubstringIndexUnknown.class);
        this.BOTTOM = AnnotationBuilder.fromClass(this.elements, SubstringIndexBottom.class);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(SubstringIndexUnknown.class, SubstringIndexFor.class, SubstringIndexBottom.class));
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new SubstringIndexQualifierHierarchy(factory);
    }

    @Override
    protected DependentTypesHelper createDependentTypesHelper() {
        return new OffsetDependentTypesHelper(this);
    }

    public AnnotationMirror convertUBQualifierToAnnotation(UBQualifier qualifier) {
        if (qualifier.isUnknown()) {
            return this.UNKNOWN;
        }
        if (qualifier.isBottom()) {
            return this.BOTTOM;
        }
        UBQualifier.LessThanLengthOf ltlQualifier = (UBQualifier.LessThanLengthOf)qualifier;
        return ltlQualifier.convertToSubstringIndexAnnotation(this.processingEnv);
    }

    private final class SubstringIndexQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        public SubstringIndexQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory);
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (AnnotationUtils.areSame(a1, SubstringIndexAnnotatedTypeFactory.this.UNKNOWN)) {
                return a2;
            }
            if (AnnotationUtils.areSame(a2, SubstringIndexAnnotatedTypeFactory.this.UNKNOWN)) {
                return a1;
            }
            if (AnnotationUtils.areSame(a1, SubstringIndexAnnotatedTypeFactory.this.BOTTOM)) {
                return a1;
            }
            if (AnnotationUtils.areSame(a2, SubstringIndexAnnotatedTypeFactory.this.BOTTOM)) {
                return a2;
            }
            UBQualifier ubq1 = UBQualifier.createUBQualifier(a1);
            UBQualifier ubq2 = UBQualifier.createUBQualifier(a2);
            UBQualifier glb = ubq1.glb(ubq2);
            return SubstringIndexAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(glb);
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (AnnotationUtils.areSame(a1, SubstringIndexAnnotatedTypeFactory.this.UNKNOWN)) {
                return a1;
            }
            if (AnnotationUtils.areSame(a2, SubstringIndexAnnotatedTypeFactory.this.UNKNOWN)) {
                return a2;
            }
            if (AnnotationUtils.areSame(a1, SubstringIndexAnnotatedTypeFactory.this.BOTTOM)) {
                return a2;
            }
            if (AnnotationUtils.areSame(a2, SubstringIndexAnnotatedTypeFactory.this.BOTTOM)) {
                return a1;
            }
            UBQualifier ubq1 = UBQualifier.createUBQualifier(a1);
            UBQualifier ubq2 = UBQualifier.createUBQualifier(a2);
            UBQualifier lub = ubq1.lub(ubq2);
            return SubstringIndexAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(lub);
        }

        @Override
        public boolean isSubtype(AnnotationMirror subAnno, AnnotationMirror superAnno) {
            if (AnnotationUtils.areSameByClass(superAnno, SubstringIndexUnknown.class)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(subAnno, SubstringIndexBottom.class)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(subAnno, SubstringIndexUnknown.class)) {
                return false;
            }
            if (AnnotationUtils.areSameByClass(superAnno, SubstringIndexBottom.class)) {
                return false;
            }
            UBQualifier subtype = UBQualifier.createUBQualifier(subAnno);
            UBQualifier supertype = UBQualifier.createUBQualifier(superAnno);
            return subtype.isSubtype(supertype);
        }
    }
}

