/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.regex;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.checker.regex.RegexAnnotatedTypeFactory;
import org.checkerframework.checker.regex.qual.Regex;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.TreeUtils;

public class RegexVisitor
extends BaseTypeVisitor<RegexAnnotatedTypeFactory> {
    private final ExecutableElement matchResultEnd;
    private final ExecutableElement matchResultGroup;
    private final ExecutableElement matchResultStart;
    private final ExecutableElement patternCompile;
    private final VariableElement patternLiteral;

    public RegexVisitor(BaseTypeChecker checker) {
        super(checker);
        ProcessingEnvironment env = checker.getProcessingEnvironment();
        this.matchResultEnd = TreeUtils.getMethod(MatchResult.class.getName(), "end", 1, env);
        this.matchResultGroup = TreeUtils.getMethod(MatchResult.class.getName(), "group", 1, env);
        this.matchResultStart = TreeUtils.getMethod(MatchResult.class.getName(), "start", 1, env);
        this.patternCompile = TreeUtils.getMethod(Pattern.class.getName(), "compile", 2, env);
        this.patternLiteral = TreeUtils.getField(Pattern.class.getName(), "LITERAL", env);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        ProcessingEnvironment env = this.checker.getProcessingEnvironment();
        if (TreeUtils.isMethodInvocation(node, this.patternCompile, env)) {
            MemberSelectTree memSelect;
            ExpressionTree flagParam = node.getArguments().get(1);
            if (flagParam.getKind() == Tree.Kind.MEMBER_SELECT && TreeUtils.isSpecificFieldAccess(memSelect = (MemberSelectTree)flagParam, this.patternLiteral)) {
                Void r = (Void)this.scan(node.getTypeArguments(), p);
                r = this.reduce(this.scan((Tree)node.getMethodSelect(), p), r);
                r = this.reduce(this.scan(node.getArguments(), p), r);
                return r;
            }
        } else if (TreeUtils.isMethodInvocation(node, this.matchResultEnd, env) || TreeUtils.isMethodInvocation(node, this.matchResultGroup, env) || TreeUtils.isMethodInvocation(node, this.matchResultStart, env)) {
            ExpressionTree group = node.getArguments().get(0);
            if (group.getKind() == Tree.Kind.INT_LITERAL) {
                LiteralTree literal = (LiteralTree)group;
                int paramGroups = (Integer)literal.getValue();
                ExpressionTree receiver = TreeUtils.getReceiverTree(node);
                if (receiver == null) {
                    return super.visitMethodInvocation(node, p);
                }
                int annoGroups = 0;
                AnnotatedTypeMirror receiverType = ((RegexAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(receiver);
                if (receiverType != null && receiverType.hasAnnotation(Regex.class)) {
                    annoGroups = ((RegexAnnotatedTypeFactory)this.atypeFactory).getGroupCount(receiverType.getAnnotation(Regex.class));
                }
                if (paramGroups > annoGroups) {
                    this.checker.report(Result.failure("group.count.invalid", paramGroups, annoGroups, receiver), group);
                }
            } else {
                this.checker.report(Result.warning("group.count.unknown", new Object[0]), group);
            }
        }
        return super.visitMethodInvocation(node, p);
    }

    @Override
    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedDeclaredType declarationType, AnnotatedTypeMirror.AnnotatedDeclaredType useType, Tree tree) {
        return super.isValidUse(declarationType, useType, tree);
    }

    @Override
    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedPrimitiveType type, Tree tree) {
        return super.isValidUse(type, tree);
    }
}

