/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.com.github.javaparser.ast.validator;

import org.checkerframework.com.github.javaparser.ast.ImportDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.AnnotationDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.EnumDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.Parameter;
import org.checkerframework.com.github.javaparser.ast.expr.AnnotationExpr;
import org.checkerframework.com.github.javaparser.ast.expr.ClassExpr;
import org.checkerframework.com.github.javaparser.ast.expr.LambdaExpr;
import org.checkerframework.com.github.javaparser.ast.expr.StringLiteralExpr;
import org.checkerframework.com.github.javaparser.ast.modules.ModuleDeclaration;
import org.checkerframework.com.github.javaparser.ast.nodeTypes.NodeWithTokenRange;
import org.checkerframework.com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import org.checkerframework.com.github.javaparser.ast.nodeTypes.NodeWithTypeParameters;
import org.checkerframework.com.github.javaparser.ast.stmt.AssertStmt;
import org.checkerframework.com.github.javaparser.ast.stmt.ForEachStmt;
import org.checkerframework.com.github.javaparser.ast.stmt.SwitchEntryStmt;
import org.checkerframework.com.github.javaparser.ast.stmt.TryStmt;
import org.checkerframework.com.github.javaparser.ast.type.UnionType;
import org.checkerframework.com.github.javaparser.ast.validator.SimpleValidator;
import org.checkerframework.com.github.javaparser.ast.validator.SingleNodeTypeValidator;
import org.checkerframework.com.github.javaparser.ast.validator.TreeVisitorValidator;
import org.checkerframework.com.github.javaparser.ast.validator.Validator;
import org.checkerframework.com.github.javaparser.ast.validator.Validators;
import org.checkerframework.com.github.javaparser.ast.validator.chunks.CommonValidators;
import org.checkerframework.com.github.javaparser.ast.validator.chunks.ModifierValidator;
import org.checkerframework.com.github.javaparser.ast.validator.chunks.NoBinaryIntegerLiteralsValidator;
import org.checkerframework.com.github.javaparser.ast.validator.chunks.NoUnderscoresInIntegerLiteralsValidator;

public class Java1_0Validator
extends Validators {
    protected final Validator modifiersWithoutStrictfpAndDefaultAndStaticInterfaceMethodsAndPrivateInterfaceMethods = new ModifierValidator(false, false, false);
    protected final Validator noAssertKeyword = new SimpleValidator<AssertStmt>(AssertStmt.class, n -> true, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, "'assert' keyword is not supported.", new Object[0]));
    protected final Validator noInnerClasses = new SimpleValidator<ClassOrInterfaceDeclaration>(ClassOrInterfaceDeclaration.class, n -> !n.isTopLevelType(), (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, "inner classes or interfaces are not supported.", new Object[0]));
    protected final Validator noReflection = new SimpleValidator<ClassExpr>(ClassExpr.class, n -> true, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, "Reflection is not supported.", new Object[0]));
    protected final Validator noGenerics = new TreeVisitorValidator((node, reporter) -> {
        if (node instanceof NodeWithTypeArguments && ((NodeWithTypeArguments)((Object)node)).getTypeArguments().isPresent()) {
            reporter.report(node, "Generics are not supported.", new Object[0]);
        }
        if (node instanceof NodeWithTypeParameters && ((NodeWithTypeParameters)((Object)node)).getTypeParameters().isNonEmpty()) {
            reporter.report(node, "Generics are not supported.", new Object[0]);
        }
    });
    protected final SingleNodeTypeValidator<TryStmt> tryWithoutResources = new SingleNodeTypeValidator<TryStmt>(TryStmt.class, (n, reporter) -> {
        if (n.getCatchClauses().isEmpty() && !n.getFinallyBlock().isPresent()) {
            reporter.report(n, "Try has no finally and no catch.", new Object[0]);
        }
        if (n.getResources().isNonEmpty()) {
            reporter.report(n, "Catch with resource is not supported.", new Object[0]);
        }
    });
    protected final Validator noAnnotations = new TreeVisitorValidator((node, reporter) -> {
        if (node instanceof AnnotationExpr || node instanceof AnnotationDeclaration) {
            reporter.report(node, "Annotations are not supported.", new Object[0]);
        }
    });
    protected final Validator noEnums = new SimpleValidator<EnumDeclaration>(EnumDeclaration.class, n -> true, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, "Enumerations are not supported.", new Object[0]));
    protected final Validator noVarargs = new SimpleValidator<Parameter>(Parameter.class, Parameter::isVarArgs, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, "Varargs are not supported.", new Object[0]));
    protected final Validator noForEach = new SimpleValidator<ForEachStmt>(ForEachStmt.class, n -> true, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, "For-each loops are not supported.", new Object[0]));
    protected final Validator noStaticImports = new SimpleValidator<ImportDeclaration>(ImportDeclaration.class, ImportDeclaration::isStatic, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, "Static imports are not supported.", new Object[0]));
    protected final Validator noStringsInSwitch = new SimpleValidator<SwitchEntryStmt>(SwitchEntryStmt.class, n -> n.getLabel().map(l -> l instanceof StringLiteralExpr).orElse(false), (n, reporter) -> reporter.report(n.getLabel().get(), "Strings in switch statements are not supported.", new Object[0]));
    protected final Validator noBinaryIntegerLiterals = new NoBinaryIntegerLiteralsValidator();
    protected final Validator noUnderscoresInIntegerLiterals = new NoUnderscoresInIntegerLiteralsValidator();
    protected final Validator noMultiCatch = new SimpleValidator<UnionType>(UnionType.class, n -> true, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, "Multi-catch is not supported.", new Object[0]));
    protected final Validator noLambdas = new SimpleValidator<LambdaExpr>(LambdaExpr.class, n -> true, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, "Lambdas are not supported.", new Object[0]));
    protected final Validator noModules = new SimpleValidator<ModuleDeclaration>(ModuleDeclaration.class, n -> true, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, "Modules are not supported.", new Object[0]));

    public Java1_0Validator() {
        super(new CommonValidators());
        this.add(this.modifiersWithoutStrictfpAndDefaultAndStaticInterfaceMethodsAndPrivateInterfaceMethods);
        this.add(this.noAssertKeyword);
        this.add(this.noInnerClasses);
        this.add(this.noReflection);
        this.add(this.noGenerics);
        this.add(this.tryWithoutResources);
        this.add(this.noAnnotations);
        this.add(this.noEnums);
        this.add(this.noVarargs);
        this.add(this.noForEach);
        this.add(this.noStaticImports);
        this.add(this.noStringsInSwitch);
        this.add(this.noBinaryIntegerLiterals);
        this.add(this.noUnderscoresInIntegerLiterals);
        this.add(this.noMultiCatch);
        this.add(this.noLambdas);
        this.add(this.noModules);
    }
}

