/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.ImplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.util.BaseContext;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.Resolver;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;
import org.checkerframework.javacutil.trees.TreeBuilder;

public class FlowExpressionParseUtil {
    protected static final String IDENTIFIER_REGEX = "[a-zA-Z_$][a-zA-Z_$0-9]*";
    protected static final String PARAMETER_REGEX = "#([1-9][0-9]*)";
    protected static final String STRING_REGEX = "\"(?:[^\"\\\\]|\\\\.)*\"";
    protected static final Pattern UNANCHORED_PARAMETER_PATTERN = Pattern.compile("#([1-9][0-9]*)");
    protected static final Pattern PARAMETER_PATTERN = FlowExpressionParseUtil.anchored("#([1-9][0-9]*)");
    protected static final Pattern IDENTIFIER_PATTERN = FlowExpressionParseUtil.anchored("[a-zA-Z_$][a-zA-Z_$0-9]*");
    protected static final Pattern STARTS_WITH_IDENTIFIER_PATTERN = FlowExpressionParseUtil.anchored("([a-zA-Z_$][a-zA-Z_$0-9]*).*");
    protected static final Pattern INT_PATTERN = FlowExpressionParseUtil.anchored("[-+]?[0-9]+");
    protected static final Pattern LONG_PATTERN = FlowExpressionParseUtil.anchored("[-+]?[0-9]+[Ll]");
    protected static final Pattern FLOAT_PATTERN = FlowExpressionParseUtil.anchored("[+-]?([0-9]+[.][0-9]*|[.][0-9]+)");
    protected static final Pattern STRING_PATTERN = FlowExpressionParseUtil.anchored("\"(?:[^\"\\\\]|\\\\.)*\"");
    protected static final Pattern PARENTHESES_PATTERN = FlowExpressionParseUtil.anchored("\\((.*)\\)");
    protected static final Pattern STARTS_WITH_STRING_PATTERN = FlowExpressionParseUtil.anchored("(\"(?:[^\"\\\\]|\\\\.)*\").*");
    protected static final Pattern STRING_SELECT_PATTERN = FlowExpressionParseUtil.anchored("(\"(?:[^\"\\\\]|\\\\.)*\")\\.(.*)");

    private static Pattern anchored(String regex) {
        return Pattern.compile("^" + regex + "$");
    }

    public static FlowExpressions.Receiver parse(String expression, FlowExpressionContext context, TreePath localScope, boolean useLocalScope) throws FlowExpressionParseException {
        FlowExpressions.Receiver result = FlowExpressionParseUtil.parseHelper(expression, context = context.copyAndSetUseLocalScope(useLocalScope), localScope);
        if (result instanceof FlowExpressions.ClassName && !expression.endsWith("class")) {
            throw FlowExpressionParseUtil.constructParserException(expression, "a class name cannot terminate a flow expression string");
        }
        return result;
    }

    private static FlowExpressions.Receiver parseHelper(String expression, FlowExpressionContext context, TreePath path) throws FlowExpressionParseException {
        expression = expression.trim();
        ProcessingEnvironment env = context.checkerContext.getProcessingEnvironment();
        Types types = env.getTypeUtils();
        if (FlowExpressionParseUtil.isNullLiteral(expression, context)) {
            return FlowExpressionParseUtil.parseNullLiteral(expression, types);
        }
        if (FlowExpressionParseUtil.isIntLiteral(expression, context)) {
            return FlowExpressionParseUtil.parseIntLiteral(expression, types);
        }
        if (FlowExpressionParseUtil.isLongLiteral(expression, context)) {
            return FlowExpressionParseUtil.parseLongLiteral(expression, types);
        }
        if (FlowExpressionParseUtil.isFloatLiteral(expression, context)) {
            throw FlowExpressionParseUtil.constructParserException(expression, String.format("floating-point values '%s' cannot be parsed", expression));
        }
        if (FlowExpressionParseUtil.isStringLiteral(expression, context)) {
            return FlowExpressionParseUtil.parseStringLiteral(expression, types, env.getElementUtils());
        }
        if (FlowExpressionParseUtil.isThisLiteral(expression, context)) {
            return FlowExpressionParseUtil.parseThis(expression, context);
        }
        if (FlowExpressionParseUtil.isSuperLiteral(expression, context)) {
            return FlowExpressionParseUtil.parseSuper(expression, types, context);
        }
        if (FlowExpressionParseUtil.isIdentifier(expression, context)) {
            return FlowExpressionParseUtil.parseIdentifier(expression, env, path, context);
        }
        if (FlowExpressionParseUtil.isParameter(expression, context)) {
            return FlowExpressionParseUtil.parseParameter(expression, context);
        }
        if (FlowExpressionParseUtil.isArray(expression, context)) {
            return FlowExpressionParseUtil.parseArray(expression, context, path);
        }
        if (FlowExpressionParseUtil.isMethodCall(expression, context)) {
            return FlowExpressionParseUtil.parseMethodCall(expression, context, path, env);
        }
        if (FlowExpressionParseUtil.isMemberSelect(expression, context)) {
            return FlowExpressionParseUtil.parseMemberSelect(expression, env, context, path);
        }
        if (FlowExpressionParseUtil.isParentheses(expression, context)) {
            return FlowExpressionParseUtil.parseParentheses(expression, context, path);
        }
        String message = expression.equals("#0") ? "one should use \"this\" for the receiver or \"#1\" for the first formal parameter" : String.format("is an unrecognized expression", new Object[0]);
        if (context.parsingMember) {
            message = message + " in a context with parsingMember=true";
        }
        throw FlowExpressionParseUtil.constructParserException(expression, message);
    }

    private static boolean isMemberSelect(String s2, FlowExpressionContext context) {
        return FlowExpressionParseUtil.parseMemberSelect(s2) != null;
    }

    private static Pair<String, String> parseMemberSelect(String s2) {
        Pair<Pair<String, String>, String> method = FlowExpressionParseUtil.parseMethodCall(s2);
        if (method != null && ((String)method.second).startsWith(".")) {
            return Pair.of((String)((Pair)method.first).first + "(" + (String)((Pair)method.first).second + ")", ((String)method.second).substring(1));
        }
        Pair<Pair<String, String>, String> array = FlowExpressionParseUtil.parseArray(s2);
        if (array != null && ((String)array.second).startsWith(".")) {
            return Pair.of((String)((Pair)array.first).first + "[" + (String)((Pair)array.first).second + "]", ((String)array.second).substring(1));
        }
        Matcher m3 = STRING_SELECT_PATTERN.matcher(s2);
        if (m3.matches()) {
            return Pair.of(m3.group(1), m3.group(2));
        }
        int nextRParenPos = FlowExpressionParseUtil.matchingCloseParen(s2, 0, '(', ')');
        if (nextRParenPos != -1) {
            if (nextRParenPos + 1 < s2.length() && s2.charAt(nextRParenPos + 1) == '.') {
                String receiver = s2.substring(0, nextRParenPos + 1);
                String remaining = s2.substring(nextRParenPos + 2);
                return Pair.of(receiver, remaining);
            }
            return null;
        }
        int i = s2.indexOf(".");
        if (i == -1) {
            return null;
        }
        String receiver = s2.substring(0, i);
        String remaining = s2.substring(i + 1);
        return Pair.of(receiver, remaining);
    }

    private static FlowExpressions.Receiver parseMemberSelect(String s2, ProcessingEnvironment env, FlowExpressionContext context, TreePath path) throws FlowExpressionParseException {
        String memberSelected;
        FlowExpressions.Receiver receiver;
        Pair<String, String> select = FlowExpressionParseUtil.parseMemberSelect(s2);
        assert (select != null) : "isMemberSelect must be called first";
        Resolver resolver = new Resolver(env);
        Pair<FlowExpressions.ClassName, String> classAndRemainingString = FlowExpressionParseUtil.matchPackageAndClassNameWithinExpression(s2, resolver, path);
        if (classAndRemainingString != null) {
            receiver = (FlowExpressions.Receiver)classAndRemainingString.first;
            memberSelected = (String)classAndRemainingString.second;
            if (memberSelected == null) {
                throw FlowExpressionParseUtil.constructParserException(s2, "a class cannot terminate a flow expression string");
            }
        } else {
            String receiverString = (String)select.first;
            memberSelected = (String)select.second;
            receiver = FlowExpressionParseUtil.parseHelper(receiverString, context, path);
        }
        if (memberSelected.equals("class")) {
            if (receiver instanceof FlowExpressions.ClassName && !context.parsingMember) {
                return receiver;
            }
            throw FlowExpressionParseUtil.constructParserException(s2, "class is not a legal identifier");
        }
        FlowExpressionContext newContext = context.copyChangeToParsingMemberOfReceiver(receiver);
        return FlowExpressionParseUtil.parseHelper(memberSelected, newContext, path);
    }

    private static boolean isNullLiteral(String s2, FlowExpressionContext context) {
        if (context.parsingMember) {
            return false;
        }
        return s2.equals("null");
    }

    private static FlowExpressions.Receiver parseNullLiteral(String expression, Types types) {
        return new FlowExpressions.ValueLiteral((TypeMirror)types.getNullType(), (Object)null);
    }

    private static boolean isIntLiteral(String s2, FlowExpressionContext context) {
        if (context.parsingMember) {
            return false;
        }
        Matcher intMatcher = INT_PATTERN.matcher(s2);
        return intMatcher.matches();
    }

    private static FlowExpressions.Receiver parseIntLiteral(String s2, Types types) {
        int val = Integer.parseInt(s2);
        return new FlowExpressions.ValueLiteral((TypeMirror)types.getPrimitiveType(TypeKind.INT), val);
    }

    private static boolean isLongLiteral(String s2, FlowExpressionContext context) {
        if (context.parsingMember) {
            return false;
        }
        Matcher longMatcher = LONG_PATTERN.matcher(s2);
        return longMatcher.matches();
    }

    private static FlowExpressions.Receiver parseLongLiteral(String s2, Types types) {
        s2 = s2.substring(0, s2.length() - 1);
        long val = Long.parseLong(s2);
        return new FlowExpressions.ValueLiteral((TypeMirror)types.getPrimitiveType(TypeKind.LONG), val);
    }

    private static boolean isFloatLiteral(String s2, FlowExpressionContext context) {
        if (context.parsingMember) {
            return false;
        }
        Matcher floatMatcher = FLOAT_PATTERN.matcher(s2);
        return floatMatcher.matches();
    }

    private static boolean isStringLiteral(String s2, FlowExpressionContext context) {
        if (context.parsingMember) {
            return false;
        }
        Matcher stringMatcher = STRING_PATTERN.matcher(s2);
        return stringMatcher.matches();
    }

    private static FlowExpressions.Receiver parseStringLiteral(String s2, Types types, Elements elements) {
        TypeElement stringTypeElem = elements.getTypeElement("java.lang.String");
        return new FlowExpressions.ValueLiteral((TypeMirror)types.getDeclaredType(stringTypeElem, new TypeMirror[0]), s2.substring(1, s2.length() - 1));
    }

    private static boolean isThisLiteral(String s2, FlowExpressionContext context) {
        if (context.parsingMember) {
            return false;
        }
        return s2.equals("this");
    }

    private static FlowExpressions.Receiver parseThis(String s2, FlowExpressionContext context) {
        if (context.receiver != null && !context.receiver.containsUnknown()) {
            return context.receiver;
        }
        return new FlowExpressions.ThisReference(context.receiver == null ? null : context.receiver.getType());
    }

    private static boolean isSuperLiteral(String s2, FlowExpressionContext context) {
        if (context.parsingMember) {
            return false;
        }
        return s2.equals("super");
    }

    private static FlowExpressions.Receiver parseSuper(String s2, Types types, FlowExpressionContext context) throws FlowExpressionParseException {
        List<? extends TypeMirror> superTypes = types.directSupertypes(context.receiver.getType());
        TypeMirror superType = null;
        for (TypeMirror typeMirror : superTypes) {
            Type.ClassType tt;
            if (!(typeMirror instanceof Type.ClassType) || (tt = (Type.ClassType)typeMirror).isInterface()) continue;
            superType = typeMirror;
            break;
        }
        if (superType == null) {
            throw FlowExpressionParseUtil.constructParserException(s2, "super class not found");
        }
        return new FlowExpressions.ThisReference(superType);
    }

    private static boolean isIdentifier(String s2, FlowExpressionContext context) {
        return IDENTIFIER_PATTERN.matcher(s2).matches();
    }

    private static FlowExpressions.Receiver parseIdentifier(String s2, ProcessingEnvironment env, TreePath path, FlowExpressionContext context) throws FlowExpressionParseException {
        VariableElement varElem;
        Resolver resolver = new Resolver(env);
        if (!context.parsingMember && context.useLocalScope && (varElem = resolver.findLocalVariableOrParameterOrField(s2, path)) != null) {
            if (varElem.getKind() == ElementKind.FIELD) {
                boolean isOriginalReceiver = context.receiver instanceof FlowExpressions.ThisReference;
                return FlowExpressionParseUtil.getReceiverField(s2, context, isOriginalReceiver, varElem);
            }
            return new FlowExpressions.LocalVariable(varElem);
        }
        TypeMirror receiverType = context.receiver.getType();
        boolean originalReceiver = true;
        Element fieldElem = null;
        if (receiverType.getKind() == TypeKind.ARRAY && s2.equals("length")) {
            fieldElem = resolver.findField(s2, receiverType, path);
        }
        while (receiverType.getKind() == TypeKind.DECLARED && (fieldElem = resolver.findField(s2, receiverType, path)) == null) {
            receiverType = FlowExpressionParseUtil.getTypeOfEnclosingClass((DeclaredType)receiverType);
            originalReceiver = false;
        }
        if (fieldElem != null && fieldElem.getKind() == ElementKind.FIELD) {
            return FlowExpressionParseUtil.getReceiverField(s2, context, originalReceiver, (VariableElement)fieldElem);
        }
        Element classElem = resolver.findClass(s2, path);
        TypeMirror classType = ElementUtils.getType(classElem);
        if (classType != null) {
            return new FlowExpressions.ClassName(classType);
        }
        MethodTree enclMethod = TreeUtils.enclosingMethod(path);
        if (enclMethod != null) {
            List<? extends VariableTree> params = enclMethod.getParameters();
            for (int i = 0; i < params.size(); ++i) {
                if (!params.get(i).getName().contentEquals(s2)) continue;
                throw FlowExpressionParseUtil.constructParserException(s2, String.format("Use \"#%d\" rather than \"%s\"", i + 1, s2));
            }
        }
        throw FlowExpressionParseUtil.constructParserException(s2, "identifier not found");
    }

    private static FlowExpressions.Receiver getReceiverField(String s2, FlowExpressionContext context, boolean originalReceiver, VariableElement fieldElem) throws FlowExpressionParseException {
        TypeMirror receiverType = context.receiver.getType();
        TypeMirror fieldType = ElementUtils.getType(fieldElem);
        if (ElementUtils.isStatic(fieldElem)) {
            Element classElem = fieldElem.getEnclosingElement();
            FlowExpressions.ClassName staticClassReceiver = new FlowExpressions.ClassName(ElementUtils.getType(classElem));
            return new FlowExpressions.FieldAccess(staticClassReceiver, fieldType, fieldElem);
        }
        FlowExpressions.Receiver locationOfField = originalReceiver ? context.receiver : FlowExpressions.internalReprOf(context.checkerContext.getAnnotationProvider(), new ImplicitThisLiteralNode(receiverType));
        if (locationOfField instanceof FlowExpressions.ClassName) {
            throw FlowExpressionParseUtil.constructParserException(s2, "a non-static field cannot have a class name as a receiver.");
        }
        return new FlowExpressions.FieldAccess(locationOfField, fieldType, fieldElem);
    }

    private static boolean isParameter(String s2, FlowExpressionContext context) {
        if (context.parsingMember) {
            return false;
        }
        Matcher parameterMatcher = PARAMETER_PATTERN.matcher(s2);
        return parameterMatcher.matches();
    }

    private static FlowExpressions.Receiver parseParameter(String s2, FlowExpressionContext context) throws FlowExpressionParseException {
        int idx;
        block5: {
            Matcher parameterMatcher = PARAMETER_PATTERN.matcher(s2);
            if (!parameterMatcher.matches()) {
                return null;
            }
            if (context.arguments == null) {
                throw FlowExpressionParseUtil.constructParserException(s2, "no parameter found");
            }
            idx = -1;
            try {
                idx = Integer.parseInt(parameterMatcher.group(1));
            }
            catch (NumberFormatException e) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        if (idx > context.arguments.size()) {
            throw new FlowExpressionParseException("flowexpr.parse.index.too.big", Integer.toString(idx));
        }
        return context.arguments.get(idx - 1);
    }

    private static Pair<Pair<String, String>, String> parseMethodCall(String s2) {
        Matcher m3 = STARTS_WITH_IDENTIFIER_PATTERN.matcher(s2);
        if (!m3.matches()) {
            return null;
        }
        String ident = m3.group(1);
        int i = ident.length();
        int rparenPos = FlowExpressionParseUtil.matchingCloseParen(s2, i, '(', ')');
        if (rparenPos == -1) {
            return null;
        }
        String arguments = s2.substring(i + 1, rparenPos);
        String remaining = s2.substring(rparenPos + 1);
        return Pair.of(Pair.of(ident, arguments), remaining);
    }

    private static boolean isMethodCall(String s2, FlowExpressionContext contex) {
        Pair<Pair<String, String>, String> result = FlowExpressionParseUtil.parseMethodCall(s2);
        return result != null && ((String)result.second).isEmpty();
    }

    private static FlowExpressions.Receiver parseMethodCall(String s2, FlowExpressionContext context, TreePath path, ProcessingEnvironment env) throws FlowExpressionParseException {
        Pair<Pair<String, String>, String> method = FlowExpressionParseUtil.parseMethodCall(s2);
        if (method == null) {
            return null;
        }
        String methodName = (String)((Pair)method.first).first;
        String parameterList = (String)((Pair)method.first).second;
        List parameters = ParameterListParser.parseParameterList(parameterList, true, context.copyAndUseOuterReceiver(), path);
        ArrayList<TypeMirror> parameterTypes = new ArrayList<TypeMirror>();
        for (FlowExpressions.Receiver p : parameters) {
            parameterTypes.add(p.getType());
        }
        ExecutableElement methodElement = null;
        try {
            Element element = null;
            Resolver resolver = new Resolver(env);
            TypeMirror receiverType = context.receiver.getType();
            if (receiverType.getKind() == TypeKind.ARRAY) {
                element = resolver.findMethod(methodName, receiverType, path, parameterTypes);
            }
            while (receiverType.getKind() == TypeKind.DECLARED && (element = resolver.findMethod(methodName, receiverType, path, parameterTypes)).getKind() != ElementKind.METHOD) {
                receiverType = FlowExpressionParseUtil.getTypeOfEnclosingClass((DeclaredType)receiverType);
            }
            if (element == null) {
                throw FlowExpressionParseUtil.constructParserException(s2, "element==null");
            }
            if (element.getKind() != ElementKind.METHOD) {
                throw FlowExpressionParseUtil.constructParserException(s2, "element.getKind()==" + (Object)((Object)element.getKind()));
            }
            methodElement = (ExecutableElement)element;
            for (int i = 0; i < parameters.size(); ++i) {
                VariableElement formal = methodElement.getParameters().get(i);
                TypeMirror formalType = formal.asType();
                FlowExpressions.Receiver actual = (FlowExpressions.Receiver)parameters.get(i);
                TypeMirror actualType = actual.getType();
                if (!TypesUtils.isBoxedPrimitive(formalType) || !TypesUtils.isPrimitive(actualType)) continue;
                Symbol.MethodSymbol valueOfMethod = TreeBuilder.getValueOfMethod(env, formalType);
                ArrayList<FlowExpressions.Receiver> p = new ArrayList<FlowExpressions.Receiver>();
                p.add(actual);
                FlowExpressions.MethodCall boxedParam = new FlowExpressions.MethodCall(formalType, valueOfMethod, new FlowExpressions.ClassName(formalType), p);
                parameters.set(i, boxedParam);
            }
        }
        catch (Throwable t) {
            if (t.getMessage() == null) {
                throw new Error("no detail message in " + t.getClass(), t);
            }
            throw FlowExpressionParseUtil.constructParserException(s2, t.getMessage());
        }
        assert (methodElement != null);
        if (ElementUtils.isStatic(methodElement)) {
            Element classElem = methodElement.getEnclosingElement();
            FlowExpressions.ClassName staticClassReceiver = new FlowExpressions.ClassName(ElementUtils.getType(classElem));
            return new FlowExpressions.MethodCall(ElementUtils.getType(methodElement), methodElement, staticClassReceiver, parameters);
        }
        if (context.receiver instanceof FlowExpressions.ClassName) {
            throw FlowExpressionParseUtil.constructParserException(s2, "a non-static method call cannot have a class name as a receiver");
        }
        TypeMirror methodType = TypesUtils.substituteMethodReturnType(methodElement, context.receiver.getType(), env);
        return new FlowExpressions.MethodCall(methodType, methodElement, context.receiver, parameters);
    }

    private static Pair<Pair<String, String>, String> parseArray(String s2) {
        int nextLBracketPos;
        int nextRBracketPos;
        int i;
        for (i = 0; i < s2.length() && s2.charAt(i) != '['; ++i) {
        }
        if (i >= s2.length()) {
            return null;
        }
        while (true) {
            if ((nextRBracketPos = FlowExpressionParseUtil.matchingCloseParen(s2, i, '[', ']')) == -1) {
                return null;
            }
            nextLBracketPos = nextRBracketPos + 1;
            if (nextLBracketPos >= s2.length() || s2.charAt(nextLBracketPos) != '[') break;
            i = nextLBracketPos;
        }
        return Pair.of(Pair.of(s2.substring(0, i), s2.substring(i + 1, nextRBracketPos)), s2.substring(nextLBracketPos));
    }

    private static int matchingCloseParen(String s2, int openPos, char open, char close) {
        if (s2.length() <= openPos || s2.charAt(openPos) != open) {
            return -1;
        }
        int i = openPos + 1;
        int depth = 1;
        while (i < s2.length()) {
            char ch;
            if ((ch = s2.charAt(i++)) == '\"') {
                Matcher m3;
                if (!(m3 = STARTS_WITH_STRING_PATTERN.matcher(s2.substring(--i))).matches()) break;
                i += m3.group(1).length();
                continue;
            }
            if (ch == open) {
                ++depth;
                continue;
            }
            if (ch != close || --depth != 0) continue;
            return i - 1;
        }
        return -1;
    }

    private static boolean isArray(String s2, FlowExpressionContext context) {
        Pair<Pair<String, String>, String> result = FlowExpressionParseUtil.parseArray(s2);
        return result != null && ((String)result.second).isEmpty();
    }

    private static FlowExpressions.Receiver parseArray(String s2, FlowExpressionContext context, TreePath path) throws FlowExpressionParseException {
        Pair<Pair<String, String>, String> array = FlowExpressionParseUtil.parseArray(s2);
        if (array == null) {
            return null;
        }
        String receiverStr = (String)((Pair)array.first).first;
        String indexStr = (String)((Pair)array.first).second;
        FlowExpressions.Receiver receiver = FlowExpressionParseUtil.parseHelper(receiverStr, context, path);
        FlowExpressionContext contextForIndex = context.copyAndUseOuterReceiver();
        FlowExpressions.Receiver index = FlowExpressionParseUtil.parseHelper(indexStr, contextForIndex, path);
        TypeMirror receiverType = receiver.getType();
        if (!(receiverType instanceof Type.ArrayType)) {
            throw FlowExpressionParseUtil.constructParserException(s2, String.format("receiver not an array: %s : %s", receiver, receiverType));
        }
        Type componentType = ((Type.ArrayType)receiverType).getComponentType();
        FlowExpressions.ArrayAccess result = new FlowExpressions.ArrayAccess(componentType, receiver, index);
        return result;
    }

    private static boolean isParentheses(String s2, FlowExpressionContext contex) {
        return s2.length() > 2 && s2.charAt(0) == '(' && s2.charAt(s2.length() - 1) == ')';
    }

    private static FlowExpressions.Receiver parseParentheses(String s2, FlowExpressionContext context, TreePath path) throws FlowExpressionParseException {
        if (!FlowExpressionParseUtil.isParentheses(s2, context)) {
            return null;
        }
        String expressionString = s2.substring(1, s2.length() - 1);
        return FlowExpressionParseUtil.parseHelper(expressionString, context, path);
    }

    private static Pair<FlowExpressions.ClassName, String> matchPackageAndClassNameWithinExpression(String expression, Resolver resolver, TreePath path) throws FlowExpressionParseException {
        Symbol.ClassSymbol classSymbol;
        String remainingString;
        String classNameString;
        Pair<Symbol.PackageSymbol, String> packageSymbolAndRemainingString = FlowExpressionParseUtil.matchPackageNameWithinExpression(expression, resolver, path);
        if (packageSymbolAndRemainingString == null) {
            return null;
        }
        Symbol.PackageSymbol packageSymbol = (Symbol.PackageSymbol)packageSymbolAndRemainingString.first;
        String packageRemainingString = (String)packageSymbolAndRemainingString.second;
        Pair<String, String> select = FlowExpressionParseUtil.parseMemberSelect(packageRemainingString);
        if (select != null) {
            classNameString = (String)select.first;
            remainingString = (String)select.second;
        } else {
            classNameString = packageRemainingString;
            remainingString = null;
        }
        try {
            classSymbol = resolver.findClassInPackage(classNameString, packageSymbol, path);
        }
        catch (Throwable t) {
            if (t.getMessage() == null) {
                throw new Error("no detail message in " + t.getClass(), t);
            }
            throw FlowExpressionParseUtil.constructParserException(expression, t.getMessage() + " while looking up class " + classNameString + " in package " + packageSymbol.toString());
        }
        if (classSymbol == null) {
            throw FlowExpressionParseUtil.constructParserException(expression, "classSymbol==null when looking up class " + classNameString + " in package " + packageSymbol.toString());
        }
        TypeMirror classType = ElementUtils.getType(classSymbol);
        if (classType == null) {
            throw FlowExpressionParseUtil.constructParserException(expression, "classType==null when looking for class symbol " + classSymbol);
        }
        return Pair.of(new FlowExpressions.ClassName(classType), remainingString);
    }

    private static Pair<Symbol.PackageSymbol, String> matchPackageNameWithinExpression(String expression, Resolver resolver, TreePath path) throws FlowExpressionParseException {
        Symbol.PackageSymbol result;
        String remainingString;
        block11: {
            Symbol.PackageSymbol wholeExpressionAsPackage;
            Pair<String, String> select = FlowExpressionParseUtil.parseMemberSelect(expression);
            if (select == null) {
                return null;
            }
            String packageName = (String)select.first;
            String remainingStringIfPackageMatched = remainingString = (String)select.second;
            result = null;
            while (true) {
                Symbol.PackageSymbol longerResult;
                try {
                    longerResult = resolver.findPackage(packageName, path);
                }
                catch (Throwable t) {
                    if (t.getMessage() == null) {
                        throw new Error("no detail message in " + t.getClass(), t);
                    }
                    throw FlowExpressionParseUtil.constructParserException(expression, t.getMessage() + " while looking up package " + packageName);
                }
                if (longerResult == null) break block11;
                result = longerResult;
                remainingString = remainingStringIfPackageMatched;
                select = FlowExpressionParseUtil.parseMemberSelect(remainingString);
                if (select == null) break;
                packageName = packageName + "." + (String)select.first;
                remainingStringIfPackageMatched = (String)select.second;
            }
            try {
                wholeExpressionAsPackage = resolver.findPackage(expression, path);
            }
            catch (Throwable t) {
                if (t.getMessage() == null) {
                    throw new Error("no detail message in " + t.getClass(), t);
                }
                throw FlowExpressionParseUtil.constructParserException(expression, t.getMessage() + " while looking up package " + expression);
            }
            if (wholeExpressionAsPackage != null) {
                throw FlowExpressionParseUtil.constructParserException(expression, "a flow expression string cannot be just a package name");
            }
        }
        if (result == null) {
            return null;
        }
        assert (remainingString != null);
        return Pair.of(result, remainingString);
    }

    public static List<Integer> parameterIndices(String s2) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Matcher matcher = UNANCHORED_PARAMETER_PATTERN.matcher(s2);
        while (matcher.find()) {
            int idx = Integer.parseInt(matcher.group(1));
            result.add(idx);
        }
        return result;
    }

    private static TypeMirror getTypeOfEnclosingClass(DeclaredType type) {
        if (type instanceof Type.ClassType) {
            Symbol sym = ((Type.ClassType)type).tsym.owner;
            if (sym == null) {
                return Type.noType;
            }
            Symbol.ClassSymbol cs = sym.enclClass();
            if (cs == null) {
                return Type.noType;
            }
            return cs.asType();
        }
        return type.getEnclosingType();
    }

    public static FlowExpressions.Receiver internalReprOfVariable(AnnotatedTypeFactory provider, VariableTree tree) throws FlowExpressionParseException {
        VariableElement elt = TreeUtils.elementFromDeclaration(tree);
        if (elt.getKind() == ElementKind.LOCAL_VARIABLE || elt.getKind() == ElementKind.RESOURCE_VARIABLE || elt.getKind() == ElementKind.EXCEPTION_PARAMETER || elt.getKind() == ElementKind.PARAMETER) {
            return new FlowExpressions.LocalVariable(elt);
        }
        FlowExpressions.Receiver receiverF = FlowExpressions.internalReprOfImplicitReceiver(elt);
        FlowExpressionContext context = new FlowExpressionContext(receiverF, null, provider.getContext());
        return FlowExpressionParseUtil.parse(tree.getName().toString(), context, provider.getPath(tree), false);
    }

    private static FlowExpressionParseException constructParserException(String expr, String explanation) {
        if (expr == null) {
            throw new Error("Must have an expression.");
        }
        if (explanation == null) {
            throw new Error("Must have an explanation.");
        }
        return new FlowExpressionParseException((Throwable)null, "flowexpr.parse.error", "Invalid '" + expr + "' because " + explanation);
    }

    public static class FlowExpressionParseException
    extends Exception {
        private static final long serialVersionUID = 2L;
        private @CompilerMessageKey String errorKey;
        public final Object[] args;

        public FlowExpressionParseException(@CompilerMessageKey String errorKey, Object ... args) {
            this(null, errorKey, args);
        }

        public FlowExpressionParseException(Throwable cause, @CompilerMessageKey String errorKey, Object ... args) {
            super(cause);
            this.errorKey = errorKey;
            this.args = args;
        }

        @Override
        public String getMessage() {
            return this.errorKey + " " + Arrays.toString(this.args);
        }

        public Result getResult() {
            return Result.failure(this.errorKey, this.args);
        }

        public boolean isFlowParseError() {
            return this.errorKey.endsWith("flowexpr.parse.error");
        }
    }

    public static class FlowExpressionContext {
        public final FlowExpressions.Receiver receiver;
        public final List<FlowExpressions.Receiver> arguments;
        public final FlowExpressions.Receiver outerReceiver;
        public final BaseContext checkerContext;
        public final boolean parsingMember;
        public final boolean useLocalScope;

        public FlowExpressionContext(FlowExpressions.Receiver receiver, List<FlowExpressions.Receiver> arguments, BaseContext checkerContext) {
            this(receiver, receiver, arguments, checkerContext);
        }

        private FlowExpressionContext(FlowExpressions.Receiver receiver, FlowExpressions.Receiver outerReceiver, List<FlowExpressions.Receiver> arguments, BaseContext checkerContext) {
            this(receiver, outerReceiver, arguments, checkerContext, false, true);
        }

        private FlowExpressionContext(FlowExpressions.Receiver receiver, FlowExpressions.Receiver outerReceiver, List<FlowExpressions.Receiver> arguments, BaseContext checkerContext, boolean parsingMember, boolean useLocalScope) {
            assert (checkerContext != null);
            this.receiver = receiver;
            this.arguments = arguments;
            this.outerReceiver = outerReceiver;
            this.checkerContext = checkerContext;
            this.parsingMember = parsingMember;
            this.useLocalScope = useLocalScope;
        }

        public static FlowExpressionContext buildContextForMethodDeclaration(MethodTree methodDeclaration, Tree enclosingTree, BaseContext checkerContext) {
            return FlowExpressionContext.buildContextForMethodDeclaration(methodDeclaration, TreeUtils.typeOf(enclosingTree), checkerContext);
        }

        public static FlowExpressionContext buildContextForMethodDeclaration(MethodTree methodDeclaration, TypeMirror enclosingType, BaseContext checkerContext) {
            Node receiver;
            if (methodDeclaration.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                TypeElement classElt = ElementUtils.enclosingClass(TreeUtils.elementFromDeclaration(methodDeclaration));
                receiver = new ClassNameNode(enclosingType, classElt);
            } else {
                receiver = new ImplicitThisLiteralNode(enclosingType);
            }
            FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), receiver);
            ArrayList<FlowExpressions.Receiver> internalArguments = new ArrayList<FlowExpressions.Receiver>();
            for (VariableTree variableTree : methodDeclaration.getParameters()) {
                internalArguments.add(FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), new LocalVariableNode(variableTree, receiver)));
            }
            FlowExpressionContext flowExprContext = new FlowExpressionContext(internalReceiver, internalArguments, checkerContext);
            return flowExprContext;
        }

        public static FlowExpressionContext buildContextForLambda(LambdaExpressionTree lambdaTree, TreePath path, BaseContext checkerContext) {
            TypeMirror enclosingType = TreeUtils.typeOf(TreeUtils.enclosingClass(path));
            ImplicitThisLiteralNode receiver = new ImplicitThisLiteralNode(enclosingType);
            FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), receiver);
            ArrayList<FlowExpressions.Receiver> internalArguments = new ArrayList<FlowExpressions.Receiver>();
            for (VariableTree variableTree : lambdaTree.getParameters()) {
                internalArguments.add(FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), new LocalVariableNode(variableTree, receiver)));
            }
            FlowExpressionContext flowExprContext = new FlowExpressionContext(internalReceiver, internalArguments, checkerContext);
            return flowExprContext;
        }

        public static FlowExpressionContext buildContextForMethodDeclaration(MethodTree methodDeclaration, TreePath currentPath, BaseContext checkerContext) {
            ClassTree classTree = TreeUtils.enclosingClass(currentPath);
            return FlowExpressionContext.buildContextForMethodDeclaration(methodDeclaration, classTree, checkerContext);
        }

        public static FlowExpressionContext buildContextForClassDeclaration(ClassTree classTree, BaseContext checkerContext) {
            ImplicitThisLiteralNode receiver = new ImplicitThisLiteralNode(TreeUtils.typeOf(classTree));
            FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), receiver);
            ArrayList<FlowExpressions.Receiver> internalArguments = new ArrayList<FlowExpressions.Receiver>();
            FlowExpressionContext flowExprContext = new FlowExpressionContext(internalReceiver, internalArguments, checkerContext);
            return flowExprContext;
        }

        public static FlowExpressionContext buildContextForMethodUse(MethodInvocationNode methodInvocation, BaseContext checkerContext) {
            Node receiver = methodInvocation.getTarget().getReceiver();
            FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), receiver);
            ArrayList<FlowExpressions.Receiver> internalArguments = new ArrayList<FlowExpressions.Receiver>();
            for (Node arg : methodInvocation.getArguments()) {
                internalArguments.add(FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), arg));
            }
            FlowExpressionContext flowExprContext = new FlowExpressionContext(internalReceiver, internalArguments, checkerContext);
            return flowExprContext;
        }

        public static FlowExpressionContext buildContextForMethodUse(MethodInvocationTree methodInvocation, BaseContext checkerContext) {
            ExpressionTree receiverTree = TreeUtils.getReceiverTree(methodInvocation);
            FlowExpressions.Receiver receiver = receiverTree == null ? FlowExpressions.internalReprOfImplicitReceiver(TreeUtils.elementFromUse(methodInvocation)) : FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), receiverTree);
            List<? extends ExpressionTree> args = methodInvocation.getArguments();
            ArrayList<FlowExpressions.Receiver> argReceivers = new ArrayList<FlowExpressions.Receiver>(args.size());
            for (ExpressionTree expressionTree : args) {
                argReceivers.add(FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), expressionTree));
            }
            return new FlowExpressionContext(receiver, argReceivers, checkerContext);
        }

        public static FlowExpressionContext buildContextForNewClassUse(ObjectCreationNode n, BaseContext checkerContext) {
            FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), n);
            ArrayList<FlowExpressions.Receiver> internalArguments = new ArrayList<FlowExpressions.Receiver>();
            for (Node arg : n.getArguments()) {
                internalArguments.add(FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), arg));
            }
            FlowExpressionContext flowExprContext = new FlowExpressionContext(internalReceiver, internalArguments, checkerContext);
            return flowExprContext;
        }

        public FlowExpressionContext copyChangeToParsingMemberOfReceiver(FlowExpressions.Receiver receiver) {
            return new FlowExpressionContext(receiver, this.outerReceiver, this.arguments, this.checkerContext, true, this.useLocalScope);
        }

        public FlowExpressionContext copyAndUseOuterReceiver() {
            return new FlowExpressionContext(this.outerReceiver, this.outerReceiver, this.arguments, this.checkerContext, false, this.useLocalScope);
        }

        public FlowExpressionContext copyAndSetUseLocalScope(boolean useLocalScope) {
            return new FlowExpressionContext(this.receiver, this.outerReceiver, this.arguments, this.checkerContext, this.parsingMember, useLocalScope);
        }
    }

    private static class ParameterListParser {
        private ParameterListParser() {
        }

        private static List<FlowExpressions.Receiver> parseParameterList(String parameterString, boolean allowEmptyList, FlowExpressionContext context, TreePath path) throws FlowExpressionParseException {
            ArrayList<FlowExpressions.Receiver> result = new ArrayList<FlowExpressions.Receiver>();
            int idx = 0;
            int callLevel = 0;
            boolean inString = false;
            block7: while (true) {
                if (idx == parameterString.length()) {
                    if (inString) {
                        throw FlowExpressionParseUtil.constructParserException(parameterString, "unterminated string");
                    }
                    if (callLevel > 0) {
                        throw FlowExpressionParseUtil.constructParserException(parameterString, "unterminated method invocation, callLevel==" + callLevel);
                    }
                    ParameterListParser.finishParam(parameterString, allowEmptyList, context, path, result, idx);
                    return result;
                }
                char next = parameterString.charAt(idx);
                ++idx;
                switch (next) {
                    case ',': {
                        if (inString || callLevel != 0) continue block7;
                        ParameterListParser.finishParam(parameterString, allowEmptyList, context, path, result, idx - 1);
                        List<FlowExpressions.Receiver> rest = ParameterListParser.parseParameterList(parameterString.substring(idx), false, context, path);
                        result.addAll(rest);
                        return result;
                    }
                    case '\"': {
                        inString = !inString;
                        break;
                    }
                    case '(': {
                        if (inString) continue block7;
                        ++callLevel;
                        break;
                    }
                    case ')': {
                        if (inString) continue block7;
                        if (callLevel == 0) {
                            throw FlowExpressionParseUtil.constructParserException(parameterString, "callLevel==0");
                        }
                        --callLevel;
                        break;
                    }
                    case '\\': {
                        ++idx;
                        break;
                    }
                }
            }
        }

        private static void finishParam(String parameterString, boolean allowEmptyList, FlowExpressionContext context, TreePath path, ArrayList<FlowExpressions.Receiver> result, int idx) throws FlowExpressionParseException {
            if (idx == 0) {
                if (allowEmptyList) {
                    return;
                }
                throw FlowExpressionParseUtil.constructParserException(parameterString, "empty parameter list; idx==0");
            }
            result.add(FlowExpressionParseUtil.parseHelper(parameterString.substring(0, idx), context, path));
        }
    }
}

