/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.PolymorphicQualifier;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.poly.QualifierPolymorphism;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.BugInCF;

public class MultiGraphQualifierHierarchy
extends QualifierHierarchy {
    protected final Map<AnnotationMirror, Set<AnnotationMirror>> supertypesGraph;
    protected final Map<AnnotationMirror, Set<AnnotationMirror>> supertypesMap;
    protected final Set<AnnotationMirror> tops;
    protected final Set<AnnotationMirror> bottoms;
    protected final AnnotationMirror polymorphicQualifier;
    protected final Map<AnnotationMirror, AnnotationMirror> polyQualifiers;
    private final Set<AnnotationMirror> typeQualifiers;
    private Map<AnnotationPair, AnnotationMirror> lubs = null;
    private Map<AnnotationPair, AnnotationMirror> glbs = null;

    public MultiGraphQualifierHierarchy(MultiGraphFactory f) {
        this(f, null);
    }

    public MultiGraphQualifierHierarchy(MultiGraphFactory f, Object ... args) {
        this.supertypesGraph = Collections.unmodifiableMap(f.supertypes);
        Map<AnnotationMirror, Set<AnnotationMirror>> fullMap = this.buildFullMap(f.supertypes);
        Set<AnnotationMirror> newtops = this.findTops(fullMap);
        Set<AnnotationMirror> newbottoms = this.findBottoms(fullMap);
        this.polymorphicQualifier = AnnotationBuilder.fromClass(f.atypeFactory.getElementUtils(), PolymorphicQualifier.class);
        this.polyQualifiers = f.polyQualifiers;
        this.addPolyRelations(this, fullMap, this.polyQualifiers, newtops, newbottoms);
        this.finish(this, fullMap, this.polyQualifiers, newtops, newbottoms, args);
        this.tops = Collections.unmodifiableSet(newtops);
        this.bottoms = Collections.unmodifiableSet(newbottoms);
        this.supertypesMap = Collections.unmodifiableMap(fullMap);
        Set<AnnotationMirror> typeQualifiers = AnnotationUtils.createAnnotationSet();
        typeQualifiers.addAll(this.supertypesMap.keySet());
        this.typeQualifiers = Collections.unmodifiableSet(typeQualifiers);
    }

    protected void finish(QualifierHierarchy qualHierarchy, Map<AnnotationMirror, Set<AnnotationMirror>> fullMap, Map<AnnotationMirror, AnnotationMirror> polyQualifiers, Set<AnnotationMirror> tops, Set<AnnotationMirror> bottoms, Object ... args) {
    }

    @SideEffectFree
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Supertypes Graph: ");
        for (Map.Entry<AnnotationMirror, Set<AnnotationMirror>> qual : this.supertypesGraph.entrySet()) {
            sb.append("\n\t");
            sb.append(qual.getKey());
            sb.append(" = ");
            sb.append(qual.getValue());
        }
        sb.append("\nSupertypes Map: ");
        for (Map.Entry<AnnotationMirror, Set<AnnotationMirror>> qual : this.supertypesMap.entrySet()) {
            sb.append("\n\t");
            sb.append(qual.getKey());
            sb.append(" = [");
            Set<AnnotationMirror> supertypes = qual.getValue();
            if (supertypes.size() == 1) {
                sb.append(supertypes.iterator().next());
            } else {
                Iterator<AnnotationMirror> iterator = supertypes.iterator();
                while (iterator.hasNext()) {
                    sb.append("\n\t\t");
                    sb.append(iterator.next());
                    sb.append(iterator.hasNext() ? ", " : "");
                }
                sb.append("\n\t\t");
            }
            sb.append("]");
        }
        sb.append("\nTops: ");
        sb.append(this.tops);
        sb.append("\nBottoms: ");
        sb.append(this.bottoms);
        return sb.toString();
    }

    @Override
    public Set<? extends AnnotationMirror> getTopAnnotations() {
        return this.tops;
    }

    @Override
    public AnnotationMirror getTopAnnotation(AnnotationMirror start) {
        for (AnnotationMirror top : this.tops) {
            if (!AnnotationUtils.areSame(start, top) && !this.isSubtype(start, top)) continue;
            return top;
        }
        throw new BugInCF("MultiGraphQualifierHierarchy: did not find the top corresponding to qualifier " + start + " all tops: " + this.tops);
    }

    @Override
    public Set<? extends AnnotationMirror> getBottomAnnotations() {
        return this.bottoms;
    }

    @Override
    public AnnotationMirror getBottomAnnotation(AnnotationMirror start) {
        for (AnnotationMirror bot : this.bottoms) {
            if (!AnnotationUtils.areSame(start, bot) && !this.isSubtype(bot, start)) continue;
            return bot;
        }
        throw new BugInCF("MultiGraphQualifierHierarchy: did not find the bottom corresponding to qualifier " + start + "; all bottoms: " + this.bottoms + "; this: " + this);
    }

    @Override
    public AnnotationMirror getPolymorphicAnnotation(AnnotationMirror start) {
        AnnotationMirror top = this.getTopAnnotation(start);
        for (AnnotationMirror key : this.polyQualifiers.keySet()) {
            if (!AnnotationUtils.areSame(key, top)) continue;
            return this.polyQualifiers.get(key);
        }
        if (AnnotationUtils.containsSame(this.polyQualifiers.keySet(), this.polymorphicQualifier)) {
            return this.polyQualifiers.get(this.polymorphicQualifier);
        }
        throw new BugInCF("MultiGraphQualifierHierarchy: did not find the polymorphic qualifier corresponding to qualifier " + start + "; all polymorphic qualifiers: " + this.polyQualifiers + "; this: " + this);
    }

    @Override
    public boolean isSubtype(Collection<? extends AnnotationMirror> rhs, Collection<? extends AnnotationMirror> lhs) {
        rhs = this.replacePolyAll(rhs);
        if ((lhs = this.replacePolyAll(lhs)).isEmpty() || rhs.isEmpty()) {
            throw new BugInCF("MultiGraphQualifierHierarchy: empty annotations in lhs: " + lhs + " or rhs: " + rhs);
        }
        if (lhs.size() != rhs.size()) {
            throw new BugInCF("MultiGraphQualifierHierarchy: mismatched number of annotations in lhs: " + lhs + " and rhs: " + rhs);
        }
        int valid = 0;
        for (AnnotationMirror annotationMirror : lhs) {
            for (AnnotationMirror annotationMirror2 : rhs) {
                if (!AnnotationUtils.areSame(this.getTopAnnotation(annotationMirror), this.getTopAnnotation(annotationMirror2)) || !this.isSubtype(annotationMirror2, annotationMirror)) continue;
                ++valid;
            }
        }
        return lhs.size() == valid;
    }

    @Override
    public boolean isSubtypeTypeVariable(Collection<? extends AnnotationMirror> subAnnos, Collection<? extends AnnotationMirror> superAnnos) {
        for (AnnotationMirror annotationMirror : this.getTopAnnotations()) {
            AnnotationMirror lhsForTop;
            AnnotationMirror rhsForTop = this.findAnnotationInHierarchy(subAnnos, annotationMirror);
            if (this.isSubtypeTypeVariable(rhsForTop, lhsForTop = this.findAnnotationInHierarchy(superAnnos, annotationMirror))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<? extends AnnotationMirror> getTypeQualifiers() {
        return this.typeQualifiers;
    }

    @Override
    public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
        if (!AnnotationUtils.areSameByName(this.getTopAnnotation(a1), this.getTopAnnotation(a2))) {
            return null;
        }
        if (this.isSubtype(a1, a2)) {
            return a2;
        }
        if (this.isSubtype(a2, a1)) {
            return a1;
        }
        if (AnnotationUtils.areSameByName(a1, a2)) {
            return this.getTopAnnotation(a1);
        }
        if (this.lubs == null) {
            this.lubs = this.calculateLubs();
        }
        AnnotationPair pair = new AnnotationPair(a1, a2);
        return this.lubs.get(pair);
    }

    @Override
    public AnnotationMirror leastUpperBoundTypeVariable(AnnotationMirror a1, AnnotationMirror a2) {
        if (a1 == null || a2 == null) {
            return null;
        }
        return this.leastUpperBound(a1, a2);
    }

    @Override
    public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
        if (AnnotationUtils.areSameByName(a1, a2)) {
            return AnnotationUtils.areSame(a1, a2) ? a1 : this.getBottomAnnotation(a1);
        }
        if (this.glbs == null) {
            this.glbs = this.calculateGlbs();
        }
        AnnotationPair pair = new AnnotationPair(a1, a2);
        return this.glbs.get(pair);
    }

    @Override
    public AnnotationMirror greatestLowerBoundTypeVariable(AnnotationMirror a1, AnnotationMirror a2) {
        if (a1 == null) {
            return a2;
        }
        if (a2 == null) {
            return a1;
        }
        return this.greatestLowerBound(a1, a2);
    }

    @Override
    public boolean isSubtype(AnnotationMirror subAnno, AnnotationMirror superAnno) {
        this.checkAnnoInGraph(subAnno);
        this.checkAnnoInGraph(superAnno);
        if (AnnotationUtils.areSameByName(subAnno, superAnno)) {
            return AnnotationUtils.areSame(subAnno, superAnno);
        }
        Set<AnnotationMirror> supermap1 = this.supertypesMap.get(subAnno);
        return AnnotationUtils.containsSame(supermap1, superAnno);
    }

    @Override
    public boolean isSubtypeTypeVariable(AnnotationMirror subAnno, AnnotationMirror superAnno) {
        if (superAnno == null) {
            return true;
        }
        if (subAnno == null) {
            return false;
        }
        return this.isSubtype(subAnno, superAnno);
    }

    private final void checkAnnoInGraph(AnnotationMirror a) {
        if (AnnotationUtils.containsSame(this.supertypesMap.keySet(), a) || AnnotationUtils.containsSame(this.polyQualifiers.values(), a)) {
            return;
        }
        if (a == null) {
            throw new BugInCF("MultiGraphQualifierHierarchy found an unqualified type.  Please ensure that your implicit rules cover all cases and/or use a @DefaultQualifierInHierarchy annotation.");
        }
        throw new BugInCF("MultiGraphQualifierHierarchy found the unrecognized qualifier: " + a + ". Please ensure that the qualifier is correctly included in the subtype hierarchy.");
    }

    protected Set<AnnotationMirror> findTops(Map<AnnotationMirror, Set<AnnotationMirror>> supertypes) {
        Set<AnnotationMirror> possibleTops = AnnotationUtils.createAnnotationSet();
        for (AnnotationMirror anno : supertypes.keySet()) {
            if (!supertypes.get(anno).isEmpty()) continue;
            possibleTops.add(anno);
        }
        return possibleTops;
    }

    protected Set<AnnotationMirror> findBottoms(Map<AnnotationMirror, Set<AnnotationMirror>> supertypes) {
        Set<AnnotationMirror> possibleBottoms = AnnotationUtils.createAnnotationSet();
        possibleBottoms.addAll(supertypes.keySet());
        for (Set<AnnotationMirror> supers : supertypes.values()) {
            possibleBottoms.removeAll(supers);
        }
        return possibleBottoms;
    }

    protected Map<AnnotationMirror, Set<AnnotationMirror>> buildFullMap(Map<AnnotationMirror, Set<AnnotationMirror>> supertypes) {
        Map<AnnotationMirror, Set<AnnotationMirror>> fullMap = AnnotationUtils.createAnnotationMap();
        for (AnnotationMirror anno : supertypes.keySet()) {
            MultiGraphQualifierHierarchy.findAllSupers(anno, supertypes, fullMap);
        }
        return fullMap;
    }

    /*
     * WARNING - void declaration
     */
    protected void addPolyRelations(QualifierHierarchy qualHierarchy, Map<AnnotationMirror, Set<AnnotationMirror>> fullMap, Map<AnnotationMirror, AnnotationMirror> polyQualifiers, Set<AnnotationMirror> tops, Set<AnnotationMirror> bottoms) {
        if (polyQualifiers.isEmpty()) {
            return;
        }
        for (Map.Entry<AnnotationMirror, AnnotationMirror> kv : polyQualifiers.entrySet()) {
            void var11_18;
            boolean found;
            AnnotationMirror declTop = kv.getKey();
            AnnotationMirror polyQualifier = kv.getValue();
            if (declTop == null || AnnotationUtils.areSame(declTop, this.polymorphicQualifier)) {
                if (declTop == null || tops.size() == 1) {
                    AnnotationUtils.updateMappingToImmutableSet(fullMap, polyQualifier, tops);
                    for (AnnotationMirror annotationMirror : bottoms) {
                        AnnotationUtils.updateMappingToImmutableSet(fullMap, annotationMirror, Collections.singleton(polyQualifier));
                    }
                    if (declTop != null) continue;
                    for (Map.Entry entry : polyQualifiers.entrySet()) {
                        AnnotationMirror otherTop = (AnnotationMirror)entry.getKey();
                        AnnotationMirror otherPoly = (AnnotationMirror)entry.getValue();
                        if (otherTop == null) continue;
                        AnnotationUtils.updateMappingToImmutableSet(fullMap, otherPoly, Collections.singleton(polyQualifier));
                    }
                    continue;
                }
                throw new BugInCF("MultiGraphQualifierHierarchy.addPolyRelations: incorrect or missing top qualifier given in polymorphic qualifier " + polyQualifier + "; declTop = " + declTop + "; possible top qualifiers: " + tops);
            }
            Set<AnnotationMirror> declSupers = fullMap.get(declTop);
            Object var11_14 = null;
            if (declSupers.isEmpty()) {
                AnnotationMirror annotationMirror = declTop;
            } else {
                for (AnnotationMirror ds : declSupers) {
                    if (!AnnotationUtils.containsSameByName(tops, ds)) continue;
                    AnnotationMirror annotationMirror = ds;
                }
            }
            boolean bl = found = var11_18 != null;
            if (!found) {
                throw new BugInCF("MultiGraphQualifierHierarchy.addPolyRelations: incorrect top qualifier given in polymorphic qualifier: " + polyQualifier + " could not find: " + var11_18);
            }
            AnnotationUtils.updateMappingToImmutableSet(fullMap, polyQualifier, Collections.singleton(var11_18));
            found = false;
            AnnotationMirror bottom = null;
            block4: for (AnnotationMirror btm : bottoms) {
                for (AnnotationMirror btmsuper : fullMap.get(btm)) {
                    if (!AnnotationUtils.areSameByName(btmsuper, (AnnotationMirror)var11_18)) continue;
                    found = true;
                    bottom = btm;
                    break block4;
                }
            }
            if (!found) continue;
            AnnotationUtils.updateMappingToImmutableSet(fullMap, bottom, Collections.singleton(polyQualifier));
        }
    }

    private Map<AnnotationPair, AnnotationMirror> calculateLubs() {
        HashMap<AnnotationPair, AnnotationMirror> newlubs = new HashMap<AnnotationPair, AnnotationMirror>();
        for (AnnotationMirror a1 : this.typeQualifiers) {
            for (AnnotationMirror a2 : this.typeQualifiers) {
                AnnotationPair pair;
                if (AnnotationUtils.areSameByName(a1, a2) || !AnnotationUtils.areSame(this.getTopAnnotation(a1), this.getTopAnnotation(a2)) || newlubs.containsKey(pair = new AnnotationPair(a1, a2))) continue;
                AnnotationMirror lub = this.findLub(a1, a2);
                newlubs.put(pair, lub);
            }
        }
        return newlubs;
    }

    protected AnnotationMirror findLub(AnnotationMirror a1, AnnotationMirror a2) {
        if (this.isSubtype(a1, a2)) {
            return a2;
        }
        if (this.isSubtype(a2, a1)) {
            return a1;
        }
        assert (this.getTopAnnotation(a1) == this.getTopAnnotation(a2)) : "MultiGraphQualifierHierarchy.findLub: this method may only be called with qualifiers from the same hierarchy. Found a1: " + a1 + " [top: " + this.getTopAnnotation(a1) + "], a2: " + a2 + " [top: " + this.getTopAnnotation(a2) + "]";
        if (this.isPolymorphicQualifier(a1)) {
            return this.findLubWithPoly(a1, a2);
        }
        if (this.isPolymorphicQualifier(a2)) {
            return this.findLubWithPoly(a2, a1);
        }
        Set<AnnotationMirror> outset = AnnotationUtils.createAnnotationSet();
        for (AnnotationMirror a1Super : this.supertypesGraph.get(a1)) {
            AnnotationMirror a1Lub = this.findLub(a1Super, a2);
            if (a1Lub != null) {
                outset.add(a1Lub);
                continue;
            }
            throw new BugInCF("GraphQualifierHierarchy could not determine LUB for " + a1 + " and " + a2 + ". Please ensure that the checker knows about all type qualifiers.");
        }
        return this.requireSingleton(outset, a1, a2, true);
    }

    private AnnotationMirror findLubWithPoly(AnnotationMirror poly, AnnotationMirror other) {
        AnnotationMirror bottom = this.getBottomAnnotation(other);
        if (AnnotationUtils.areSame(bottom, other)) {
            return poly;
        }
        return this.getTopAnnotation(poly);
    }

    private boolean isPolymorphicQualifier(AnnotationMirror qual) {
        return AnnotationUtils.containsSame(this.polyQualifiers.values(), qual);
    }

    private Set<AnnotationMirror> findSmallestTypes(Set<AnnotationMirror> inset) {
        Set<AnnotationMirror> outset = AnnotationUtils.createAnnotationSet();
        outset.addAll(inset);
        for (AnnotationMirror a1 : inset) {
            Iterator<AnnotationMirror> outit = outset.iterator();
            while (outit.hasNext()) {
                AnnotationMirror a2 = outit.next();
                if (a1 == a2 || !this.isSubtype(a1, a2)) continue;
                outit.remove();
            }
        }
        return outset;
    }

    private static Set<AnnotationMirror> findAllSupers(AnnotationMirror anno, Map<AnnotationMirror, Set<AnnotationMirror>> supertypes, Map<AnnotationMirror, Set<AnnotationMirror>> allSupersSoFar) {
        Set<AnnotationMirror> supers = AnnotationUtils.createAnnotationSet();
        for (AnnotationMirror superAnno : supertypes.get(anno)) {
            supers.add(superAnno);
            supers.addAll(MultiGraphQualifierHierarchy.findAllSupers(superAnno, supertypes, allSupersSoFar));
        }
        allSupersSoFar.put(anno, Collections.unmodifiableSet(supers));
        return supers;
    }

    private Map<AnnotationPair, AnnotationMirror> calculateGlbs() {
        HashMap<AnnotationPair, AnnotationMirror> newglbs = new HashMap<AnnotationPair, AnnotationMirror>();
        for (AnnotationMirror a1 : this.typeQualifiers) {
            for (AnnotationMirror a2 : this.typeQualifiers) {
                AnnotationPair pair;
                if (AnnotationUtils.areSameByName(a1, a2) || !AnnotationUtils.areSame(this.getTopAnnotation(a1), this.getTopAnnotation(a2)) || newglbs.containsKey(pair = new AnnotationPair(a1, a2))) continue;
                AnnotationMirror glb = this.findGlb(a1, a2);
                newglbs.put(pair, glb);
            }
        }
        return newglbs;
    }

    private AnnotationMirror findGlb(AnnotationMirror a1, AnnotationMirror a2) {
        if (this.isSubtype(a1, a2)) {
            return a1;
        }
        if (this.isSubtype(a2, a1)) {
            return a2;
        }
        assert (this.getTopAnnotation(a1) == this.getTopAnnotation(a2)) : "MultiGraphQualifierHierarchy.findGlb: this method may only be called with qualifiers from the same hierarchy. Found a1: " + a1 + " [top: " + this.getTopAnnotation(a1) + "], a2: " + a2 + " [top: " + this.getTopAnnotation(a2) + "]";
        if (this.isPolymorphicQualifier(a1)) {
            return this.findGlbWithPoly(a1, a2);
        }
        if (this.isPolymorphicQualifier(a2)) {
            return this.findGlbWithPoly(a2, a1);
        }
        Set<AnnotationMirror> outset = AnnotationUtils.createAnnotationSet();
        for (AnnotationMirror a1Sub : this.supertypesGraph.keySet()) {
            AnnotationMirror a1lb;
            if (!this.isSubtype(a1Sub, a1) || a1Sub.equals(a1) || (a1lb = this.findGlb(a1Sub, a2)) == null) continue;
            outset.add(a1lb);
        }
        return this.requireSingleton(outset, a1, a2, false);
    }

    private AnnotationMirror findGlbWithPoly(AnnotationMirror poly, AnnotationMirror other) {
        AnnotationMirror top = this.getTopAnnotation(other);
        if (AnnotationUtils.areSame(top, other)) {
            return poly;
        }
        return this.getBottomAnnotation(poly);
    }

    private Set<AnnotationMirror> findGreatestTypes(Set<AnnotationMirror> inset) {
        Set<AnnotationMirror> outset = AnnotationUtils.createAnnotationSet();
        outset.addAll(inset);
        for (AnnotationMirror a1 : inset) {
            Iterator<AnnotationMirror> outit = outset.iterator();
            while (outit.hasNext()) {
                AnnotationMirror a2 = outit.next();
                if (a1 == a2 || !this.isSubtype(a2, a1)) continue;
                outit.remove();
            }
        }
        return outset;
    }

    private AnnotationMirror requireSingleton(Set<AnnotationMirror> outset, AnnotationMirror a1, AnnotationMirror a2, boolean lub) {
        if (outset.size() == 0) {
            throw new BugInCF("MultiGraphQualifierHierarchy could not determine " + (lub ? "LUB" : "GLB") + " for " + a1 + " and " + a2 + ". Please ensure that the checker knows about all type qualifiers.");
        }
        if (outset.size() == 1) {
            return outset.iterator().next();
        }
        outset = lub ? this.findSmallestTypes(outset) : this.findGreatestTypes(outset);
        AnnotationMirror result = null;
        for (AnnotationMirror anno : outset) {
            if (this.isPolymorphicQualifier(anno)) continue;
            if (result == null) {
                result = anno;
                continue;
            }
            throw new BugInCF(String.format("Bug in checker implementation:  type hierarchy is not a lattice.%nThere is no unique " + (lub ? "lub" : "glb") + "(%s, %s).%nTwo incompatible candidates are: %s %s", a1, a2, result, anno));
        }
        return result;
    }

    private static class AnnotationPair {
        public final AnnotationMirror a1;
        public final AnnotationMirror a2;
        private int hashCode = -1;

        public AnnotationPair(AnnotationMirror a1, AnnotationMirror a2) {
            this.a1 = a1;
            this.a2 = a2;
        }

        @Pure
        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = 31;
                if (this.a1 != null) {
                    this.hashCode += 17 * AnnotationUtils.annotationName(this.a1).hashCode();
                }
                if (this.a2 != null) {
                    this.hashCode += 17 * AnnotationUtils.annotationName(this.a2).hashCode();
                }
            }
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AnnotationPair)) {
                return false;
            }
            AnnotationPair other = (AnnotationPair)o;
            if (AnnotationUtils.areSameByName(this.a1, other.a1) && AnnotationUtils.areSameByName(this.a2, other.a2)) {
                return true;
            }
            return AnnotationUtils.areSameByName(this.a2, other.a1) && AnnotationUtils.areSameByName(this.a1, other.a2);
        }

        @SideEffectFree
        public String toString() {
            return "AnnotationPair(" + this.a1 + ", " + this.a2 + ")";
        }
    }

    public static class MultiGraphFactory {
        protected final Map<AnnotationMirror, Set<AnnotationMirror>> supertypes = AnnotationUtils.createAnnotationMap();
        protected final Map<AnnotationMirror, AnnotationMirror> polyQualifiers = new HashMap<AnnotationMirror, AnnotationMirror>();
        protected final AnnotatedTypeFactory atypeFactory;
        private boolean wasBuilt = false;

        public MultiGraphFactory(AnnotatedTypeFactory atypeFactory) {
            this.atypeFactory = atypeFactory;
        }

        public void addQualifier(AnnotationMirror qual) {
            this.assertNotBuilt();
            if (AnnotationUtils.containsSame(this.supertypes.keySet(), qual)) {
                return;
            }
            Class<? extends Annotation> pqtopclass = QualifierPolymorphism.getPolymorphicQualifierTop(qual);
            if (pqtopclass != null) {
                AnnotationMirror pqtop = AnnotationBuilder.fromClass(this.atypeFactory.getElementUtils(), pqtopclass);
                if (QualifierPolymorphism.isPolyAll(qual)) {
                    this.polyQualifiers.put(null, qual);
                } else {
                    this.polyQualifiers.put(pqtop, qual);
                }
            } else {
                this.supertypes.put(qual, AnnotationUtils.createAnnotationSet());
            }
        }

        public void addSubtype(AnnotationMirror sub, AnnotationMirror sup) {
            this.assertNotBuilt();
            this.addQualifier(sub);
            this.addQualifier(sup);
            this.supertypes.get(sub).add(sup);
        }

        public QualifierHierarchy build() {
            this.assertNotBuilt();
            QualifierHierarchy result = this.createQualifierHierarchy();
            this.wasBuilt = true;
            return result;
        }

        protected QualifierHierarchy createQualifierHierarchy() {
            return this.atypeFactory.createQualifierHierarchy(this);
        }

        protected void assertNotBuilt() {
            if (this.wasBuilt) {
                throw new BugInCF("MultiGraphQualifierHierarchy.Factory was already built. Method build can only be called once.");
            }
        }
    }
}

