/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.dependenttypes;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.javacutil.BugInCF;

public class DependentTypesError {
    private static final String FORMAT_STRING = "[error for expression: %s; error: %s]";
    private static final Pattern ERROR_PATTERN = Pattern.compile("\\[error for expression: (.*); error: (.*)\\]");
    public static final String FORMAL_PARAM_NAME_STRING = "Use \"#%d\" rather than \"%s\"";
    private static final Pattern FORMAL_PARAM_NAME_PATTERN = Pattern.compile("^'([a-zA-Z_$][a-zA-Z0-9_$]*)' because (Use \"#\\d+\" rather than \"\\1\")$");
    public final String expression;
    public final String error;

    public static boolean isExpressionError(String expression) {
        return expression.startsWith("[error");
    }

    public DependentTypesError(String expression, String error) {
        this.expression = expression;
        this.error = error;
    }

    public DependentTypesError(String expression, FlowExpressionParseUtil.FlowExpressionParseException e) {
        this.expression = expression;
        StringBuilder buf = new StringBuilder();
        List<Result.DiagMessage> msgs = e.getResult().getDiagMessages();
        for (Result.DiagMessage msg : msgs) {
            buf.append(msg.getArgs()[0]);
        }
        this.error = buf.toString();
    }

    public static DependentTypesError unparse(String formattedError) {
        Matcher matcher = ERROR_PATTERN.matcher(formattedError);
        if (matcher.matches()) {
            assert (matcher.groupCount() == 2);
            return new DependentTypesError(matcher.group(1), matcher.group(2));
        }
        throw new BugInCF("Cannot unparse: " + formattedError);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependentTypesError that = (DependentTypesError)o;
        return this.expression.equals(that.expression) && this.error.equals(that.error);
    }

    public int hashCode() {
        int result = this.expression.hashCode();
        result = 31 * result + this.error.hashCode();
        return result;
    }

    public String toString() {
        return String.format(FORMAT_STRING, this.expression, this.error);
    }

    public String format() {
        Matcher m3 = FORMAL_PARAM_NAME_PATTERN.matcher(this.error);
        if (m3.matches()) {
            return m3.group(2);
        }
        return this.toString();
    }
}

