/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.objectweb.asmx.attrs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.org.objectweb.asmx.Attribute;
import org.checkerframework.org.objectweb.asmx.ByteVector;
import org.checkerframework.org.objectweb.asmx.ClassReader;
import org.checkerframework.org.objectweb.asmx.ClassWriter;
import org.checkerframework.org.objectweb.asmx.Label;
import org.checkerframework.org.objectweb.asmx.Type;
import org.checkerframework.org.objectweb.asmx.attrs.StackMapFrame;
import org.checkerframework.org.objectweb.asmx.attrs.StackMapType;

public class StackMapTableAttribute
extends Attribute {
    public static final int SAME_FRAME = 0;
    public static final int SAME_LOCALS_1_STACK_ITEM_FRAME = 64;
    public static final int RESERVED = 128;
    public static final int SAME_LOCALS_1_STACK_ITEM_FRAME_EXTENDED = 247;
    public static final int CHOP_FRAME = 248;
    public static final int SAME_FRAME_EXTENDED = 251;
    public static final int APPEND_FRAME = 252;
    public static final int FULL_FRAME = 255;
    private static final int MAX_SHORT = 65535;
    private List frames;

    public StackMapTableAttribute() {
        super("StackMapTable");
    }

    public StackMapTableAttribute(List frames) {
        this();
        this.frames = frames;
    }

    public List getFrames() {
        return this.frames;
    }

    public StackMapFrame getFrame(Label label) {
        for (int i = 0; i < this.frames.size(); ++i) {
            StackMapFrame frame = (StackMapFrame)this.frames.get(i);
            if (frame.label != label) continue;
            return frame;
        }
        return null;
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    @Override
    public boolean isCodeAttribute() {
        return true;
    }

    @Override
    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        int size;
        ArrayList<StackMapFrame> frames = new ArrayList<StackMapFrame>();
        boolean isExtCodeSize = cr.readInt(codeOff + 4) > 65535;
        boolean isExtLocals = cr.readUnsignedShort(codeOff + 2) > 65535;
        boolean isExtStack = cr.readUnsignedShort(codeOff) > 65535;
        int offset = 0;
        int methodOff = StackMapTableAttribute.getMethodOff(cr, codeOff, buf);
        StackMapFrame frame = new StackMapFrame(this.getLabel(offset, labels), StackMapTableAttribute.calculateLocals(cr.readClass(cr.header + 2, buf), cr.readUnsignedShort(methodOff), cr.readUTF8(methodOff + 2, buf), cr.readUTF8(methodOff + 4, buf)), Collections.EMPTY_LIST);
        frames.add(frame);
        if (isExtCodeSize) {
            size = cr.readInt(off);
            off += 4;
        } else {
            size = cr.readUnsignedShort(off);
            off += 2;
        }
        while (size > 0) {
            List stack;
            ArrayList locals;
            int offsetDelta;
            int tag = cr.readByte(off);
            ++off;
            if (tag < 64) {
                offsetDelta = tag;
                locals = new ArrayList(frame.locals);
                stack = Collections.EMPTY_LIST;
            } else if (tag < 128) {
                offsetDelta = tag - 64;
                locals = new ArrayList(frame.locals);
                stack = new ArrayList();
                off = this.readType(stack, isExtCodeSize, cr, off, labels, buf);
            } else {
                if (isExtCodeSize) {
                    offsetDelta = cr.readInt(off);
                    off += 4;
                } else {
                    offsetDelta = cr.readUnsignedShort(off);
                    off += 2;
                }
                if (tag == 247) {
                    locals = new ArrayList(frame.locals);
                    stack = new ArrayList();
                    off = this.readType(stack, isExtCodeSize, cr, off, labels, buf);
                } else if (tag >= 248 && tag < 251) {
                    stack = Collections.EMPTY_LIST;
                    int k = 251 - tag;
                    locals = new ArrayList(frame.locals.subList(0, frame.locals.size() - k));
                } else if (tag == 251) {
                    stack = Collections.EMPTY_LIST;
                    locals = new ArrayList(frame.locals);
                } else if (tag < 255) {
                    stack = Collections.EMPTY_LIST;
                    locals = new ArrayList(frame.locals);
                    for (int k = tag - 251; k > 0; --k) {
                        off = this.readType(locals, isExtCodeSize, cr, off, labels, buf);
                    }
                } else if (tag == 255) {
                    locals = new ArrayList();
                    off = this.readTypes(locals, isExtLocals, isExtCodeSize, cr, off, labels, buf);
                    stack = new ArrayList();
                    off = this.readTypes(stack, isExtStack, isExtCodeSize, cr, off, labels, buf);
                } else {
                    throw new RuntimeException("Unknown frame type " + tag + " after offset " + offset);
                }
            }
            Label offsetLabel = this.getLabel(offset += offsetDelta, labels);
            frame = new StackMapFrame(offsetLabel, locals, stack);
            frames.add(frame);
            ++offset;
            --size;
        }
        return new StackMapTableAttribute(frames);
    }

    @Override
    protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        ByteVector bv = new ByteVector();
        boolean isExtCodeSize = code != null && code.length > 65535;
        this.writeSize(this.frames.size() - 1, bv, isExtCodeSize);
        if (this.frames.size() < 2) {
            return bv;
        }
        boolean isExtLocals = maxLocals > 65535;
        boolean isExtStack = maxStack > 65535;
        StackMapFrame frame = (StackMapFrame)this.frames.get(0);
        List locals = frame.locals;
        int offset = frame.label.getOffset();
        for (int i = 1; i < this.frames.size(); ++i) {
            frame = (StackMapFrame)this.frames.get(i);
            List clocals = frame.locals;
            List cstack = frame.stack;
            int coffset = frame.label.getOffset();
            int clocalsSize = clocals.size();
            int cstackSize = cstack.size();
            int localsSize = locals.size();
            int delta = coffset - offset;
            int type = 255;
            int k = 0;
            if (cstackSize == 0) {
                k = clocalsSize - localsSize;
                switch (k) {
                    case -3: 
                    case -2: 
                    case -1: {
                        type = 248;
                        localsSize = clocalsSize;
                        break;
                    }
                    case 0: {
                        type = delta < 64 ? 0 : 251;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        type = 252;
                    }
                }
            } else if (localsSize == clocalsSize && cstackSize == 1) {
                int n = type = delta < 63 ? 64 : 247;
            }
            if (type != 255) {
                for (int j = 0; j < localsSize && type != 255; ++j) {
                    if (locals.get(j).equals(clocals.get(j))) continue;
                    type = 255;
                }
            }
            switch (type) {
                case 0: {
                    bv.putByte(delta);
                    break;
                }
                case 64: {
                    bv.putByte(64 + delta);
                    this.writeTypeInfos(bv, cw, cstack, 0, 1);
                    break;
                }
                case 247: {
                    bv.putByte(247);
                    this.writeSize(delta, bv, isExtCodeSize);
                    this.writeTypeInfos(bv, cw, cstack, 0, 1);
                    break;
                }
                case 251: {
                    bv.putByte(251);
                    this.writeSize(delta, bv, isExtCodeSize);
                    break;
                }
                case 248: {
                    bv.putByte(251 + k);
                    this.writeSize(delta, bv, isExtCodeSize);
                    break;
                }
                case 252: {
                    bv.putByte(251 + k);
                    this.writeSize(delta, bv, isExtCodeSize);
                    this.writeTypeInfos(bv, cw, clocals, clocalsSize - 1, clocalsSize);
                    break;
                }
                case 255: {
                    bv.putByte(255);
                    this.writeSize(delta, bv, isExtCodeSize);
                    this.writeSize(clocalsSize, bv, isExtLocals);
                    this.writeTypeInfos(bv, cw, clocals, 0, clocalsSize);
                    this.writeSize(cstackSize, bv, isExtStack);
                    this.writeTypeInfos(bv, cw, cstack, 0, cstackSize);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            offset = coffset + 1;
            locals = clocals;
        }
        return bv;
    }

    private void writeSize(int delta, ByteVector bv, boolean isExt) {
        if (isExt) {
            bv.putInt(delta);
        } else {
            bv.putShort(delta);
        }
    }

    private void writeTypeInfos(ByteVector bv, ClassWriter cw, List info, int start, int end) {
        block4: for (int j = start; j < end; ++j) {
            StackMapType typeInfo = (StackMapType)info.get(j);
            bv.putByte(typeInfo.getType());
            switch (typeInfo.getType()) {
                case 7: {
                    bv.putShort(cw.newClass(typeInfo.getObject()));
                    continue block4;
                }
                case 8: {
                    bv.putShort(typeInfo.getLabel().getOffset());
                }
            }
        }
    }

    public static int getMethodOff(ClassReader cr, int codeOff, char[] buf) {
        int off = cr.header + 6;
        int interfacesCount = cr.readUnsignedShort(off);
        off += 2;
        for (int fieldsCount = cr.readUnsignedShort(off += 2 + interfacesCount * 2); fieldsCount > 0; --fieldsCount) {
            int attrCount = cr.readUnsignedShort(off + 6);
            off += 8;
            while (attrCount > 0) {
                off += 6 + cr.readInt(off + 2);
                --attrCount;
            }
        }
        int methodsCount = cr.readUnsignedShort(off);
        off += 2;
        while (methodsCount > 0) {
            int methodOff = off;
            int attrCount = cr.readUnsignedShort(off + 6);
            off += 8;
            while (attrCount > 0) {
                String attrName = cr.readUTF8(off, buf);
                if (attrName.equals("Code") && codeOff == (off += 6)) {
                    return methodOff;
                }
                off += cr.readInt(off - 4);
                --attrCount;
            }
            --methodsCount;
        }
        return -1;
    }

    public static List calculateLocals(String className, int access, String methodName, String methodDesc) {
        StackMapType typeInfo;
        ArrayList<StackMapType> locals = new ArrayList<StackMapType>();
        if ("<init>".equals(methodName) && !className.equals("java/lang/Object")) {
            typeInfo = StackMapType.getTypeInfo(6);
            typeInfo.setObject(className);
            locals.add(typeInfo);
        } else if ((access & 8) == 0) {
            typeInfo = StackMapType.getTypeInfo(7);
            typeInfo.setObject(className);
            locals.add(typeInfo);
        }
        Type[] types = Type.getArgumentTypes(methodDesc);
        block6: for (int i = 0; i < types.length; ++i) {
            Type t = types[i];
            switch (t.getSort()) {
                case 7: {
                    StackMapType smt = StackMapType.getTypeInfo(4);
                    continue block6;
                }
                case 8: {
                    StackMapType smt = StackMapType.getTypeInfo(3);
                    continue block6;
                }
                case 6: {
                    StackMapType smt = StackMapType.getTypeInfo(2);
                    continue block6;
                }
                case 9: 
                case 10: {
                    StackMapType smt = StackMapType.getTypeInfo(7);
                    smt.setObject(t.getDescriptor());
                    continue block6;
                }
                default: {
                    StackMapType stackMapType = StackMapType.getTypeInfo(1);
                }
            }
        }
        return locals;
    }

    private int readTypes(List info, boolean isExt, boolean isExtCodeSize, ClassReader cr, int off, Label[] labels, char[] buf) {
        int n = 0;
        if (isExt) {
            n = cr.readInt(off);
            off += 4;
        } else {
            n = cr.readUnsignedShort(off);
            off += 2;
        }
        while (n > 0) {
            off = this.readType(info, isExtCodeSize, cr, off, labels, buf);
            --n;
        }
        return off;
    }

    private int readType(List info, boolean isExtCodeSize, ClassReader cr, int off, Label[] labels, char[] buf) {
        int itemType = cr.readByte(off++);
        StackMapType typeInfo = StackMapType.getTypeInfo(itemType);
        info.add(typeInfo);
        switch (itemType) {
            case 7: {
                typeInfo.setObject(cr.readClass(off, buf));
                off += 2;
                break;
            }
            case 8: {
                int offset;
                if (isExtCodeSize) {
                    offset = cr.readInt(off);
                    off += 4;
                } else {
                    offset = cr.readUnsignedShort(off);
                    off += 2;
                }
                typeInfo.setLabel(this.getLabel(offset, labels));
            }
        }
        return off;
    }

    private Label getLabel(int offset, Label[] labels) {
        Label l = labels[offset];
        if (l != null) {
            return l;
        }
        labels[offset] = new Label();
        return labels[offset];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StackMapTable[");
        for (int i = 0; i < this.frames.size(); ++i) {
            sb.append('\n').append('[').append(this.frames.get(i)).append(']');
        }
        sb.append("\n]");
        return sb.toString();
    }
}

