/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.objectweb.asmx.util;

import java.util.HashMap;
import org.checkerframework.org.objectweb.asmx.AnnotationVisitor;
import org.checkerframework.org.objectweb.asmx.Attribute;
import org.checkerframework.org.objectweb.asmx.Handle;
import org.checkerframework.org.objectweb.asmx.Label;
import org.checkerframework.org.objectweb.asmx.MethodVisitor;
import org.checkerframework.org.objectweb.asmx.Type;
import org.checkerframework.org.objectweb.asmx.TypeAnnotationVisitor;
import org.checkerframework.org.objectweb.asmx.TypePath;
import org.checkerframework.org.objectweb.asmx.signature.SignatureReader;
import org.checkerframework.org.objectweb.asmx.util.AbstractVisitor;
import org.checkerframework.org.objectweb.asmx.util.TraceAbstractVisitor;
import org.checkerframework.org.objectweb.asmx.util.TraceAnnotationVisitor;
import org.checkerframework.org.objectweb.asmx.util.TraceSignatureVisitor;
import org.checkerframework.org.objectweb.asmx.util.TraceTypeAnnotationVisitor;
import org.checkerframework.org.objectweb.asmx.util.attrs.Traceable;

public class TraceMethodVisitor
extends TraceAbstractVisitor
implements MethodVisitor {
    protected MethodVisitor mv;
    protected String tab2 = "    ";
    protected String tab3 = "      ";
    protected String ltab = "   ";
    protected final HashMap labelNames = new HashMap();

    public TraceMethodVisitor() {
        this(null);
    }

    public TraceMethodVisitor(MethodVisitor mv) {
        this.mv = mv;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(desc, visible);
        if (this.mv != null) {
            ((TraceAnnotationVisitor)av).av = this.mv.visitAnnotation(desc, visible);
        }
        return av;
    }

    @Override
    public TypeAnnotationVisitor visitTypeAnnotation(String desc, boolean visible, boolean inCode) {
        TypeAnnotationVisitor xav = super.visitTypeAnnotation(desc, visible);
        if (this.mv != null) {
            ((TraceTypeAnnotationVisitor)xav).xav = this.mv.visitTypeAnnotation(desc, visible, inCode);
        }
        return xav;
    }

    @Override
    public void visitAttribute(Attribute attr) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append("ATTRIBUTE ");
        this.appendDescriptor(-1, attr.type);
        if (attr instanceof Traceable) {
            ((Traceable)((Object)attr)).trace(this.buf, this.labelNames);
        } else {
            this.buf.append(" : ").append(attr.toString()).append("\n");
        }
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitAttribute(attr);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        this.text.add(this.tab2 + "default=");
        TraceAnnotationVisitor tav = new TraceAnnotationVisitor();
        this.text.add(tav.getText());
        this.text.add("\n");
        if (this.mv != null) {
            tav.av = this.mv.visitAnnotationDefault();
        }
        return tav;
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append('@');
        this.appendDescriptor(1, desc);
        this.buf.append('(');
        this.text.add(this.buf.toString());
        TraceAnnotationVisitor tav = new TraceAnnotationVisitor();
        this.text.add(tav.getText());
        this.text.add(visible ? ") // parameter " : ") // invisible, parameter ");
        this.text.add(new Integer(parameter));
        this.text.add("\n");
        if (this.mv != null) {
            tav.av = this.mv.visitParameterAnnotation(parameter, desc, visible);
        }
        return tav;
    }

    @Override
    public void visitCode() {
        if (this.mv != null) {
            this.mv.visitCode();
        }
    }

    @Override
    public void visitInsn(int opcode) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[opcode]).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitInsn(opcode);
        }
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[opcode]).append(' ').append(opcode == 188 ? TYPES[operand] : Integer.toString(operand)).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitIntInsn(opcode, operand);
        }
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[opcode]).append(' ').append(var).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitVarInsn(opcode, var);
        }
    }

    @Override
    public void visitTypeInsn(int opcode, String desc) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[opcode]).append(' ');
        if (desc.startsWith("[")) {
            this.appendDescriptor(1, desc);
        } else {
            this.appendDescriptor(0, desc);
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitTypeInsn(opcode, desc);
        }
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[opcode]).append(' ');
        this.appendDescriptor(0, owner);
        this.buf.append('.').append(name).append(" : ");
        this.appendDescriptor(1, desc);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[opcode]).append(' ');
        this.appendDescriptor(0, owner);
        this.buf.append('.').append(name).append(' ');
        this.appendDescriptor(3, desc);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
    }

    @Override
    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return null;
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[opcode]).append(' ');
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitJumpInsn(opcode, label);
        }
    }

    @Override
    public void visitLabel(Label label) {
        this.buf.setLength(0);
        this.buf.append(this.ltab);
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLabel(label);
        }
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LDC ");
        if (cst instanceof String) {
            AbstractVisitor.appendString(this.buf, (String)cst);
        } else if (cst instanceof Type) {
            this.buf.append(((Type)cst).getDescriptor() + ".class");
        } else {
            this.buf.append(cst);
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLdcInsn(cst);
        }
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("IINC ").append(var).append(' ').append(increment).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitIincInsn(var, increment);
        }
    }

    @Override
    public void visitTableSwitchInsn(int min2, int max, Label dflt, Label[] labels) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("TABLESWITCH\n");
        for (int i = 0; i < labels.length; ++i) {
            this.buf.append(this.tab3).append(min2 + i).append(": ");
            this.appendLabel(labels[i]);
            this.buf.append('\n');
        }
        this.buf.append(this.tab3).append("default: ");
        this.appendLabel(dflt);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitTableSwitchInsn(min2, max, dflt, labels);
        }
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LOOKUPSWITCH\n");
        for (int i = 0; i < labels.length; ++i) {
            this.buf.append(this.tab3).append(keys[i]).append(": ");
            this.appendLabel(labels[i]);
            this.buf.append('\n');
        }
        this.buf.append(this.tab3).append("default: ");
        this.appendLabel(dflt);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLookupSwitchInsn(dflt, keys, labels);
        }
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MULTIANEWARRAY ");
        this.appendDescriptor(1, desc);
        this.buf.append(' ').append(dims).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitMultiANewArrayInsn(desc, dims);
        }
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("TRYCATCHBLOCK ");
        this.appendLabel(start);
        this.buf.append(' ');
        this.appendLabel(end);
        this.buf.append(' ');
        this.appendLabel(handler);
        this.buf.append(' ');
        this.appendDescriptor(0, type);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitTryCatchBlock(start, end, handler, type);
        }
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LOCALVARIABLE ").append(name).append(' ');
        this.appendDescriptor(1, desc);
        this.buf.append(' ');
        this.appendLabel(start);
        this.buf.append(' ');
        this.appendLabel(end);
        this.buf.append(' ').append(index).append('\n');
        if (signature != null) {
            this.buf.append(this.tab2);
            this.appendDescriptor(2, signature);
            TraceSignatureVisitor sv = new TraceSignatureVisitor(0);
            SignatureReader r = new SignatureReader(signature);
            r.acceptType(sv);
            this.buf.append(this.tab2).append("// declaration: ").append(sv.getDeclaration()).append('\n');
        }
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLocalVariable(name, desc, signature, start, end, index);
        }
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LINENUMBER ").append(line).append(' ');
        this.appendLabel(start);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLineNumber(line, start);
        }
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MAXSTACK = ").append(maxStack).append('\n');
        this.text.add(this.buf.toString());
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MAXLOCALS = ").append(maxLocals).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitMaxs(maxStack, maxLocals);
        }
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        if (this.mv != null) {
            this.mv.visitEnd();
        }
    }

    public void appendLabel(Label l) {
        String name = (String)this.labelNames.get(l);
        if (name == null) {
            name = "L" + this.labelNames.size();
            this.labelNames.put(l, name);
        }
        this.buf.append(name);
    }
}

