/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.plumelib.bcelutil;

import org.checkerframework.checker.formatter.qual.FormatMethod;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public final class SimpleLog {
    public @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown boolean enabled;
    private @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String indent_str = "";
    private final @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String INDENT_STR_ONE_LEVEL = "  ";

    public SimpleLog() {
        this(true);
    }

    public SimpleLog(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown boolean enabled) {
        this.enabled = enabled;
    }

    public @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown boolean enabled() {
        return this.enabled;
    }

    @FormatMethod
    public void log(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String format, Object ... args) {
        if (this.enabled) {
            System.out.print(this.indent_str);
            System.out.printf(format, args);
        }
    }

    public void logStackTrace() {
        if (this.enabled) {
            Throwable t = new Throwable();
            t.fillInStackTrace();
            StackTraceElement[] ste_arr = t.getStackTrace();
            for (int ii = 2; ii < ste_arr.length; ++ii) {
                StackTraceElement ste = ste_arr[ii];
                System.out.printf("%s  %s%n", this.indent_str, ste);
            }
        }
    }

    public void indent() {
        if (this.enabled) {
            this.indent_str = this.indent_str + "  ";
        }
    }

    public void exdent() {
        if (this.enabled) {
            if (this.indent_str.isEmpty()) {
                this.log("Called exdent when indentation was 0.", new Object[0]);
                this.logStackTrace();
            } else {
                this.indent_str = this.indent_str.substring(0, this.indent_str.length() - "  ".length());
            }
        }
    }

    public void resetIndent() {
        if (this.enabled) {
            this.indent_str = "";
        }
    }
}

