/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.guieffect;

import java.lang.annotation.Annotation;
import org.checkerframework.checker.guieffect.qual.PolyUIEffect;
import org.checkerframework.checker.guieffect.qual.SafeEffect;
import org.checkerframework.checker.guieffect.qual.UIEffect;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class Effect {
    private final Class<? extends Annotation> annotClass;

    public Effect(Class<? extends Annotation> cls) {
        assert (cls.equals(UIEffect.class) || cls.equals(PolyUIEffect.class) || cls.equals(SafeEffect.class));
        this.annotClass = cls;
    }

    public static boolean lessThanOrEqualTo(Effect left, Effect right) {
        assert (left != null && right != null);
        boolean leftBottom = left.annotClass.equals(SafeEffect.class);
        boolean rightTop = right.annotClass.equals(UIEffect.class);
        return leftBottom || rightTop || left.annotClass.equals(right.annotClass);
    }

    public static Effect min(Effect l, Effect r) {
        if (Effect.lessThanOrEqualTo(l, r)) {
            return l;
        }
        return r;
    }

    public boolean isSafe() {
        return this.annotClass.equals(SafeEffect.class);
    }

    public boolean isUI() {
        return this.annotClass.equals(UIEffect.class);
    }

    public boolean isPoly() {
        return this.annotClass.equals(PolyUIEffect.class);
    }

    public Class<? extends Annotation> getAnnot() {
        return this.annotClass;
    }

    @SideEffectFree
    public String toString() {
        return this.annotClass.getSimpleName();
    }

    public boolean equals(Effect e) {
        return this.annotClass.equals(e.annotClass);
    }

    public boolean equals(Object o) {
        if (o instanceof Effect) {
            return this.equals((Effect)o);
        }
        return super.equals(o);
    }

    @Pure
    public int hashCode() {
        return 31 + this.annotClass.hashCode();
    }

    public static final class EffectRange {
        public final Effect min;
        public final Effect max;

        public EffectRange(Effect min2, Effect max) {
            assert (min2 != null || max != null);
            this.min = min2 != null ? min2 : max;
            this.max = max != null ? max : min2;
        }
    }
}

