/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.inequality;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.index.IndexAbstractTransfer;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.index.inequality.LessThanAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NumericalSubtractionNode;
import org.checkerframework.framework.flow.CFAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.javacutil.AnnotationProvider;

public class LessThanTransfer
extends IndexAbstractTransfer {
    public LessThanTransfer(CFAnalysis analysis) {
        super(analysis);
    }

    @Override
    protected void refineGT(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store, TransferInput<CFValue, CFStore> in) {
        LessThanAnnotatedTypeFactory factory = (LessThanAnnotatedTypeFactory)this.analysis.getTypeFactory();
        FlowExpressions.Receiver leftRec = FlowExpressions.internalReprOf((AnnotationProvider)factory, left);
        if (leftRec != null && leftRec.isUnmodifiableByOtherCode()) {
            List<String> lessThanExpressions = LessThanAnnotatedTypeFactory.getLessThanExpressions(rightAnno);
            if (lessThanExpressions == null) {
                return;
            }
            lessThanExpressions.add(leftRec.toString());
            FlowExpressions.Receiver rightRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), right);
            store.insertValue(rightRec, factory.createLessThanQualifier(lessThanExpressions));
        }
    }

    @Override
    protected void refineGTE(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store, TransferInput<CFValue, CFStore> in) {
        LessThanAnnotatedTypeFactory factory = (LessThanAnnotatedTypeFactory)this.analysis.getTypeFactory();
        FlowExpressions.Receiver leftRec = FlowExpressions.internalReprOf((AnnotationProvider)factory, left);
        if (leftRec != null && leftRec.isUnmodifiableByOtherCode()) {
            List<String> lessThanExpressions = LessThanAnnotatedTypeFactory.getLessThanExpressions(rightAnno);
            if (lessThanExpressions == null) {
                return;
            }
            lessThanExpressions.add(leftRec.toString() + " + 1");
            FlowExpressions.Receiver rightRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), right);
            store.insertValue(rightRec, factory.createLessThanQualifier(lessThanExpressions));
        }
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalSubtraction(NumericalSubtractionNode n, TransferInput<CFValue, CFStore> in) {
        LessThanAnnotatedTypeFactory factory = (LessThanAnnotatedTypeFactory)this.analysis.getTypeFactory();
        FlowExpressions.Receiver leftRec = FlowExpressions.internalReprOf((AnnotationProvider)factory, n.getLeftOperand());
        if (leftRec != null && leftRec.isUnmodifiableByOtherCode()) {
            ValueAnnotatedTypeFactory valueFactory = factory.getValueAnnotatedTypeFactory();
            Long right = IndexUtil.getMinValue(n.getRightOperand().getTree(), valueFactory);
            if (right != null && 0L < right) {
                List<String> expressions = this.getLessThanExpressions(n.getLeftOperand());
                if (expressions == null) {
                    expressions = new ArrayList<String>();
                }
                expressions.add(leftRec.toString());
                AnnotationMirror refine = factory.createLessThanQualifier(expressions);
                CFValue value = (CFValue)this.analysis.createSingleAnnotationValue(refine, n.getType());
                CFStore info = in.getRegularStore();
                return new RegularTransferResult<CFValue, CFStore>(this.finishValue(value, info), info);
            }
        }
        return (TransferResult)super.visitNumericalSubtraction(n, in);
    }

    private List<String> getLessThanExpressions(Node node) {
        Set<AnnotationMirror> s2 = ((CFValue)this.analysis.getValue(node)).getAnnotations();
        LessThanAnnotatedTypeFactory factory = (LessThanAnnotatedTypeFactory)this.analysis.getTypeFactory();
        if (s2 != null && !s2.isEmpty()) {
            return LessThanAnnotatedTypeFactory.getLessThanExpressions(factory.getQualifierHierarchy().findAnnotationInHierarchy(s2, factory.UNKNOWN));
        }
        return Collections.emptyList();
    }
}

