/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.com.github.javaparser.ast.stmt;

import java.util.Optional;
import java.util.function.Consumer;
import org.checkerframework.com.github.javaparser.TokenRange;
import org.checkerframework.com.github.javaparser.ast.AllFieldsConstructor;
import org.checkerframework.com.github.javaparser.ast.Node;
import org.checkerframework.com.github.javaparser.ast.expr.Expression;
import org.checkerframework.com.github.javaparser.ast.expr.NameExpr;
import org.checkerframework.com.github.javaparser.ast.observer.ObservableProperty;
import org.checkerframework.com.github.javaparser.ast.stmt.Statement;
import org.checkerframework.com.github.javaparser.ast.visitor.CloneVisitor;
import org.checkerframework.com.github.javaparser.ast.visitor.GenericVisitor;
import org.checkerframework.com.github.javaparser.ast.visitor.VoidVisitor;
import org.checkerframework.com.github.javaparser.metamodel.BreakStmtMetaModel;
import org.checkerframework.com.github.javaparser.metamodel.JavaParserMetaModel;
import org.checkerframework.com.github.javaparser.metamodel.OptionalProperty;

public final class BreakStmt
extends Statement {
    @OptionalProperty
    private Expression value;

    public BreakStmt() {
        this(null, new NameExpr());
    }

    public BreakStmt(String label) {
        this(null, new NameExpr(label));
    }

    @AllFieldsConstructor
    public BreakStmt(Expression value) {
        this(null, value);
    }

    public BreakStmt(TokenRange tokenRange, Expression value) {
        super(tokenRange);
        this.setValue(value);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Optional<Expression> getValue() {
        return Optional.ofNullable(this.value);
    }

    public BreakStmt setValue(Expression value) {
        if (value == this.value) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.VALUE, this.value, value);
        if (this.value != null) {
            this.value.setParentNode(null);
        }
        this.value = value;
        this.setAsParentNodeOf(value);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        if (this.value != null && node == this.value) {
            this.removeValue();
            return true;
        }
        return super.remove(node);
    }

    public BreakStmt removeValue() {
        return this.setValue(null);
    }

    @Override
    public BreakStmt clone() {
        return (BreakStmt)this.accept(new CloneVisitor(), null);
    }

    @Override
    public BreakStmtMetaModel getMetaModel() {
        return JavaParserMetaModel.breakStmtMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (this.value != null && node == this.value) {
            this.setValue((Expression)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isBreakStmt() {
        return true;
    }

    @Override
    public BreakStmt asBreakStmt() {
        return this;
    }

    @Override
    public void ifBreakStmt(Consumer<BreakStmt> action) {
        action.accept(this);
    }

    @Override
    public Optional<BreakStmt> toBreakStmt() {
        return Optional.of(this);
    }
}

