/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.value.util;

import org.checkerframework.common.value.util.ByteMath;
import org.checkerframework.common.value.util.DoubleMath;
import org.checkerframework.common.value.util.FloatMath;
import org.checkerframework.common.value.util.IntegerMath;
import org.checkerframework.common.value.util.LongMath;
import org.checkerframework.common.value.util.ShortMath;

public abstract class NumberMath<T extends Number> {
    public static NumberMath<?> getNumberMath(Number number) {
        if (number instanceof Byte) {
            return new ByteMath(number.byteValue());
        }
        if (number instanceof Double) {
            return new DoubleMath(number.doubleValue());
        }
        if (number instanceof Float) {
            return new FloatMath(number.floatValue());
        }
        if (number instanceof Integer) {
            return new IntegerMath(number.intValue());
        }
        if (number instanceof Long) {
            return new LongMath(number.longValue());
        }
        if (number instanceof Short) {
            return new ShortMath(number.shortValue());
        }
        return null;
    }

    public abstract Number plus(Number var1);

    public abstract Number minus(Number var1);

    public abstract Number times(Number var1);

    public abstract Number divide(Number var1);

    public abstract Number remainder(Number var1);

    public abstract Number shiftLeft(Number var1);

    public abstract Number signedShiftRight(Number var1);

    public abstract Number unsignedShiftRight(Number var1);

    public abstract Number bitwiseAnd(Number var1);

    public abstract Number bitwiseOr(Number var1);

    public abstract Number bitwiseXor(Number var1);

    public abstract Number unaryPlus();

    public abstract Number unaryMinus();

    public abstract Number bitwiseComplement();

    public abstract Boolean equalTo(Number var1);

    public abstract Boolean notEqualTo(Number var1);

    public abstract Boolean greaterThan(Number var1);

    public abstract Boolean greaterThanEq(Number var1);

    public abstract Boolean lessThan(Number var1);

    public abstract Boolean lessThanEq(Number var1);

    public static boolean isIntegralZero(Number number) {
        if (number instanceof Byte) {
            return number.byteValue() == 0;
        }
        if (number instanceof Integer) {
            return number.intValue() == 0;
        }
        if (number instanceof Long) {
            return number.longValue() == 0L;
        }
        if (number instanceof Short) {
            return number.shortValue() == 0;
        }
        return false;
    }
}

