/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import java.util.ArrayDeque;
import java.util.Arrays;
import org.checkerframework.javacutil.TreeUtils;

public class Heuristics {
    public static boolean matchParents(TreePath path, Tree.Kind ... kinds) {
        Tree tree;
        TreePath parentPath = path.getParentPath();
        boolean result = true;
        ArrayDeque<Tree.Kind> queue = new ArrayDeque<Tree.Kind>(Arrays.asList(kinds));
        while ((tree = parentPath.getLeaf()) != null && !queue.isEmpty()) {
            if (tree.getKind() == Tree.Kind.BLOCK || tree.getKind() == Tree.Kind.PARENTHESIZED) {
                parentPath = parentPath.getParentPath();
                continue;
            }
            result &= queue.removeFirst() == parentPath.getLeaf().getKind();
            parentPath = parentPath.getParentPath();
        }
        return result;
    }

    public static class Matchers {
        public static Matcher preceededBy(Matcher matcher) {
            return new PreceededBy(matcher);
        }

        public static Matcher withIn(Matcher matcher) {
            return new WithIn(matcher);
        }

        public static Matcher whenTrue(Matcher conditionMatcher) {
            return new WithinTrueBranch(conditionMatcher);
        }

        public static Matcher ofKind(Tree.Kind kind, Matcher matcher) {
            return new OfKind(kind, matcher);
        }

        public static Matcher or(Matcher ... matchers) {
            return new OrMatcher(matchers);
        }
    }

    public static class OrMatcher
    extends Matcher {
        private final Matcher[] matchers;

        public OrMatcher(Matcher ... matchers) {
            this.matchers = matchers;
        }

        @Override
        public boolean match(TreePath path) {
            for (Matcher matcher : this.matchers) {
                if (!matcher.match(path)) continue;
                return true;
            }
            return false;
        }
    }

    public static class OfKind
    extends Matcher {
        private final Tree.Kind kind;
        private final Matcher matcher;

        public OfKind(Tree.Kind kind, Matcher matcher) {
            this.kind = kind;
            this.matcher = matcher;
        }

        @Override
        public boolean match(TreePath path) {
            if (path.getLeaf().getKind() == this.kind) {
                return this.matcher.match(path);
            }
            return false;
        }
    }

    public static class WithinTrueBranch
    extends Matcher {
        private final Matcher matcher;

        public WithinTrueBranch(Matcher conditionMatcher) {
            this.matcher = conditionMatcher;
        }

        @Override
        public boolean match(TreePath path) {
            TreePath prev = path;
            for (TreePath p = path.getParentPath(); p != null; p = p.getParentPath()) {
                if (p.getLeaf().getKind() == Tree.Kind.IF) {
                    IfTree ifTree = (IfTree)p.getLeaf();
                    ExpressionTree cond = TreeUtils.skipParens(ifTree.getCondition());
                    if (ifTree.getThenStatement() == prev.getLeaf() && this.matcher.match(new TreePath(p, cond))) {
                        return true;
                    }
                    if (cond.getKind() == Tree.Kind.LOGICAL_COMPLEMENT && this.matcher.match(new TreePath(p, ((UnaryTree)cond).getExpression()))) {
                        return true;
                    }
                }
                prev = p;
            }
            return false;
        }
    }

    public static class WithIn
    extends Matcher {
        private final Matcher matcher;

        public WithIn(Matcher matcher) {
            this.matcher = matcher;
        }

        @Override
        public boolean match(TreePath path) {
            for (TreePath p = path; p != null; p = p.getParentPath()) {
                if (!this.matcher.match(p)) continue;
                return true;
            }
            return false;
        }
    }

    public static class PreceededBy
    extends Matcher {
        private final Matcher matcher;

        public PreceededBy(Matcher matcher) {
            this.matcher = matcher;
        }

        @Override
        public boolean match(TreePath path) {
            StatementTree stmt = TreeUtils.enclosingOfClass(path, StatementTree.class);
            if (stmt == null) {
                return false;
            }
            TreePath p = path;
            while (p.getLeaf() != stmt) {
                p = p.getParentPath();
            }
            assert (p.getLeaf() == stmt);
            while (p != null && p.getLeaf() instanceof StatementTree) {
                if (p.getParentPath().getLeaf() instanceof BlockTree) {
                    BlockTree block = (BlockTree)p.getParentPath().getLeaf();
                    for (StatementTree statementTree : block.getStatements()) {
                        if (statementTree == p.getLeaf()) break;
                        if (!this.matcher.match(new TreePath(p, statementTree))) continue;
                        return true;
                    }
                }
                p = p.getParentPath();
            }
            return false;
        }
    }

    public static class Matcher
    extends SimpleTreeVisitor<Boolean, Void> {
        @Override
        protected Boolean defaultAction(Tree node, Void p) {
            return false;
        }

        @Override
        public Boolean visitParenthesized(ParenthesizedTree node, Void p) {
            return (Boolean)this.visit(node.getExpression(), p);
        }

        public boolean match(TreePath path) {
            return (Boolean)this.visit(path.getLeaf(), null);
        }
    }
}

