/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.dependenttypes;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.dependenttypes.DependentTypesHelper;
import org.checkerframework.javacutil.TreeUtils;

public class DependentTypesTreeAnnotator
extends TreeAnnotator {
    private final DependentTypesHelper helper;

    public DependentTypesTreeAnnotator(AnnotatedTypeFactory atypeFactory, DependentTypesHelper helper) {
        super(atypeFactory);
        this.helper = helper;
    }

    @Override
    public Void visitClass(ClassTree node, AnnotatedTypeMirror annotatedTypeMirror) {
        TypeElement ele = TreeUtils.elementFromDeclaration(node);
        this.helper.standardizeClass(node, annotatedTypeMirror, ele);
        return (Void)super.visitClass(node, annotatedTypeMirror);
    }

    @Override
    public Void visitNewArray(NewArrayTree node, AnnotatedTypeMirror annotatedType) {
        this.helper.standardizeExpression(node, annotatedType);
        return (Void)super.visitNewArray(node, annotatedType);
    }

    @Override
    public Void visitNewClass(NewClassTree node, AnnotatedTypeMirror annotatedType) {
        this.helper.standardizeExpression(node, annotatedType);
        return (Void)super.visitNewClass(node, annotatedType);
    }

    @Override
    public Void visitTypeCast(TypeCastTree node, AnnotatedTypeMirror annotatedType) {
        this.helper.standardizeExpression(node, annotatedType);
        return (Void)super.visitTypeCast(node, annotatedType);
    }

    @Override
    public Void visitVariable(VariableTree node, AnnotatedTypeMirror annotatedTypeMirror) {
        VariableElement ele = TreeUtils.elementFromDeclaration(node);
        this.helper.standardizeVariable(node, annotatedTypeMirror, ele);
        return (Void)super.visitVariable(node, annotatedTypeMirror);
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, AnnotatedTypeMirror annotatedTypeMirror) {
        Element ele = TreeUtils.elementFromUse(node);
        if (ele.getKind() == ElementKind.FIELD) {
            this.helper.standardizeVariable(node, annotatedTypeMirror, ele);
        }
        return (Void)super.visitIdentifier(node, annotatedTypeMirror);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, AnnotatedTypeMirror type) {
        this.helper.standardizeFieldAccess(node, type);
        return (Void)super.visitMemberSelect(node, type);
    }
}

