/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.Main;
import annotator.find.Criteria;
import annotator.find.Criterion;
import annotator.scanner.CommonScanner;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

public class ReturnTypeCriterion
implements Criterion {
    private final String methodName;
    private final Criterion inClassCriterion;
    private final Criterion sigMethodCriterion;

    public ReturnTypeCriterion(String string, String string2) {
        this.methodName = string2;
        this.inClassCriterion = Criteria.inClass(string, false);
        this.sigMethodCriterion = string2.isEmpty() ? null : Criteria.isSigMethod(string2);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Criteria.dbug.debug("ReturnTypeCriterion.isSatisfiedBy(%s); this=%n", Main.leafString(treePath), this.toString());
        block0: do {
            if (treePath.getLeaf().getKind() != Tree.Kind.METHOD) continue;
            if (this.sigMethodCriterion != null && !this.sigMethodCriterion.isSatisfiedBy(treePath)) break;
            for (treePath = treePath.getParentPath(); treePath != null && treePath.getLeaf() != null; treePath = treePath.getParentPath()) {
                if (!CommonScanner.hasClassKind(treePath.getLeaf())) continue;
                if (!this.inClassCriterion.isSatisfiedBy(treePath)) break block0;
                Criteria.dbug.debug("ReturnTypeCriterion.isSatisfiedBy => true%n", new Object[0]);
                return true;
            }
            break;
        } while ((treePath = treePath.getParentPath()) != null && treePath.getLeaf() != null);
        Criteria.dbug.debug("ReturnTypeCriterion.isSatisfiedBy => false%n", new Object[0]);
        return false;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.RETURN_TYPE;
    }

    public String toString() {
        return "ReturnTypeCriterion for method: " + this.methodName;
    }
}

