/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.aliasing;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.common.aliasing.AliasingAnnotatedTypeFactory;
import org.checkerframework.common.aliasing.qual.LeakedToResult;
import org.checkerframework.common.aliasing.qual.NonLeaked;
import org.checkerframework.common.aliasing.qual.Unique;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.TreeUtils;

public class AliasingVisitor
extends BaseTypeVisitor<AliasingAnnotatedTypeFactory> {
    public AliasingVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        if (this.isInUniqueConstructor()) {
            if (TreeUtils.isSuperCall(node)) {
                AnnotatedTypeMirror superResult = ((AliasingAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node);
                if (!superResult.hasAnnotation(Unique.class)) {
                    this.checker.report(Result.failure("unique.leaked", new Object[0]), node);
                }
            } else {
                boolean hasLeakedToResult;
                boolean hasNonLeaked;
                Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                boolean parentIsStatement = parent.getKind() == Tree.Kind.EXPRESSION_STATEMENT;
                ExecutableElement methodElement = TreeUtils.elementFromUse(node);
                List<? extends VariableElement> params = methodElement.getParameters();
                List<? extends ExpressionTree> args = node.getArguments();
                assert (args.size() == params.size()) : "Number of arguments in the method call " + node + " is different from the number of parameters for the method declaration: " + methodElement.getSimpleName();
                for (int i = 0; i < args.size(); ++i) {
                    if (!TreeUtils.isExplicitThisDereference(args.get(i))) continue;
                    VariableElement param = params.get(i);
                    hasNonLeaked = ((AliasingAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(param).hasAnnotation(NonLeaked.class);
                    hasLeakedToResult = ((AliasingAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(param).hasAnnotation(LeakedToResult.class);
                    this.isUniqueCheck(node, parentIsStatement, hasNonLeaked, hasLeakedToResult);
                }
                AnnotatedTypeMirror.AnnotatedExecutableType annotatedType = ((AliasingAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(methodElement);
                AnnotatedTypeMirror.AnnotatedDeclaredType receiverType = annotatedType.getReceiverType();
                if (receiverType != null) {
                    hasNonLeaked = receiverType.hasAnnotation(NonLeaked.class);
                    hasLeakedToResult = receiverType.hasAnnotation(LeakedToResult.class);
                    this.isUniqueCheck(node, parentIsStatement, hasNonLeaked, hasLeakedToResult);
                }
            }
        }
        return super.visitMethodInvocation(node, p);
    }

    private void isUniqueCheck(MethodInvocationTree node, boolean parentIsStatement, boolean hasNonLeaked, boolean hasLeakedToResult) {
        if (!(hasNonLeaked || hasLeakedToResult && parentIsStatement)) {
            this.checker.report(Result.failure("unique.leaked", new Object[0]), node);
        }
    }

    @Override
    protected void commonAssignmentCheck(Tree varTree, ExpressionTree valueExp, @CompilerMessageKey String errorKey) {
        super.commonAssignmentCheck(varTree, valueExp, errorKey);
        if (this.isInUniqueConstructor() && TreeUtils.isExplicitThisDereference(valueExp)) {
            this.checker.report(Result.failure("unique.leaked", new Object[0]), valueExp);
        } else if (this.canBeLeaked(valueExp)) {
            this.checker.report(Result.failure("unique.leaked", new Object[0]), valueExp);
        }
    }

    @Override
    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, Tree valueTree, @CompilerMessageKey String errorKey) {
        super.commonAssignmentCheck(varType, valueType, valueTree, errorKey);
        TreePath path = this.visitorState.getPath();
        if (path == null) {
            return;
        }
        Tree.Kind visitorLeafKind = path.getLeaf().getKind();
        if ((visitorLeafKind == Tree.Kind.NEW_CLASS || visitorLeafKind == Tree.Kind.METHOD_INVOCATION) && this.canBeLeaked(valueTree)) {
            Tree.Kind parentKind = this.visitorState.getPath().getParentPath().getLeaf().getKind();
            if (!(varType.hasAnnotation(NonLeaked.class) || varType.hasAnnotation(LeakedToResult.class) && parentKind == Tree.Kind.EXPRESSION_STATEMENT)) {
                this.checker.report(Result.failure("unique.leaked", new Object[0]), valueTree);
            }
        }
    }

    @Override
    public Void visitThrow(ThrowTree node, Void p) {
        ExpressionTree exp = node.getExpression();
        if (this.canBeLeaked(exp)) {
            this.checker.report(Result.failure("unique.leaked", new Object[0]), exp);
        }
        return super.visitThrow(node, p);
    }

    @Override
    public Void visitVariable(VariableTree node, Void p) {
        AnnotatedTypeMirror varType = ((AliasingAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node);
        VariableElement elt = TreeUtils.elementFromDeclaration(node);
        if (elt.getKind().isField() && varType.hasExplicitAnnotation(Unique.class)) {
            this.checker.report(Result.failure("unique.location.forbidden", new Object[0]), node);
        } else if (node.getType().getKind() == Tree.Kind.ARRAY_TYPE) {
            AnnotatedTypeMirror.AnnotatedArrayType arrayType = (AnnotatedTypeMirror.AnnotatedArrayType)varType;
            if (arrayType.getComponentType().hasAnnotation(Unique.class)) {
                this.checker.report(Result.failure("unique.location.forbidden", new Object[0]), node);
            }
        } else if (node.getType().getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
            AnnotatedTypeMirror.AnnotatedDeclaredType declaredType = (AnnotatedTypeMirror.AnnotatedDeclaredType)varType;
            for (AnnotatedTypeMirror atm : declaredType.getTypeArguments()) {
                if (!atm.hasAnnotation(Unique.class)) continue;
                this.checker.report(Result.failure("unique.location.forbidden", new Object[0]), node);
            }
        }
        return super.visitVariable(node, p);
    }

    @Override
    public Void visitNewArray(NewArrayTree node, Void p) {
        List<? extends ExpressionTree> initializers = node.getInitializers();
        if (initializers != null && !initializers.isEmpty()) {
            for (ExpressionTree expressionTree : initializers) {
                if (!this.canBeLeaked(expressionTree)) continue;
                this.checker.report(Result.failure("unique.leaked", new Object[0]), expressionTree);
            }
        }
        return super.visitNewArray(node, p);
    }

    @Override
    protected void checkConstructorResult(AnnotatedTypeMirror.AnnotatedExecutableType constructorType, ExecutableElement constructorElement) {
        if (!constructorType.getReturnType().hasAnnotation(((AliasingAnnotatedTypeFactory)this.atypeFactory).UNIQUE)) {
            super.checkConstructorResult(constructorType, constructorElement);
        }
    }

    @Override
    protected void checkThisOrSuperConstructorCall(MethodInvocationTree superCall, @CompilerMessageKey String errorKey) {
        AnnotatedTypeMirror superResult;
        if (this.isInUniqueConstructor() && !(superResult = ((AliasingAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(superCall)).hasAnnotation(Unique.class)) {
            this.checker.report(Result.failure("unique.leaked", new Object[0]), superCall);
        }
    }

    private boolean canBeLeaked(Tree exp) {
        AnnotatedTypeMirror type = ((AliasingAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(exp);
        boolean isMethodInvocation = exp.getKind() == Tree.Kind.METHOD_INVOCATION;
        boolean isNewClass = exp.getKind() == Tree.Kind.NEW_CLASS;
        return type.hasExplicitAnnotation(Unique.class) && !isMethodInvocation && !isNewClass;
    }

    private boolean isInUniqueConstructor() {
        MethodTree enclosingMethod = TreeUtils.enclosingMethod(this.getCurrentPath());
        if (enclosingMethod == null) {
            return false;
        }
        return TreeUtils.isConstructor(enclosingMethod) && ((AliasingAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(enclosingMethod).getReturnType().hasAnnotation(Unique.class);
    }
}

