/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.AnalysisResult;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.CFGVisualizer;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.dataflow.cfg.DOTCFGVisualizer;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.dataflow.cfg.node.ReturnNode;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFAbstractStore;
import org.checkerframework.framework.flow.CFAbstractTransfer;
import org.checkerframework.framework.flow.CFAbstractValue;
import org.checkerframework.framework.flow.CFAnalysis;
import org.checkerframework.framework.flow.CFCFGBuilder;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.qual.DefaultFor;
import org.checkerframework.framework.qual.DefaultInUncheckedCodeFor;
import org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import org.checkerframework.framework.qual.DefaultQualifierInHierarchyInUncheckedCode;
import org.checkerframework.framework.qual.MonotonicQualifier;
import org.checkerframework.framework.qual.RelevantJavaTypes;
import org.checkerframework.framework.qual.TypeUseLocation;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.AnnotatedTypeParameterBounds;
import org.checkerframework.framework.type.DefaultInferredTypesApplier;
import org.checkerframework.framework.type.VisitorState;
import org.checkerframework.framework.type.poly.DefaultQualifierPolymorphism;
import org.checkerframework.framework.type.poly.QualifierPolymorphism;
import org.checkerframework.framework.type.treeannotator.ImplicitsTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.PropagationTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.type.typeannotator.ImplicitsTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.IrrelevantTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.ListTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.PropagationTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.TypeAnnotator;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.framework.util.defaults.QualifierDefaults;
import org.checkerframework.framework.util.dependenttypes.DependentTypesHelper;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.CollectionUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.UserError;

public abstract class GenericAnnotatedTypeFactory<Value extends CFAbstractValue<Value>, Store extends CFAbstractStore<Value, Store>, TransferFunction extends CFAbstractTransfer<Value, Store, TransferFunction>, FlowAnalysis extends CFAbstractAnalysis<Value, Store, TransferFunction>>
extends AnnotatedTypeFactory {
    protected static boolean flowByDefault = true;
    private Set<Class<? extends Annotation>> supportedMonotonicQuals;
    protected TypeAnnotator typeAnnotator;
    private ImplicitsTypeAnnotator implicitsTypeAnnotator;
    protected TreeAnnotator treeAnnotator;
    protected QualifierPolymorphism poly;
    protected QualifierDefaults defaults;
    protected DependentTypesHelper dependentTypesHelper;
    private boolean useFlow;
    private final boolean everUseFlow;
    private boolean shouldDefaultTypeVarLocals;
    protected Store emptyStore;
    protected FlowAnalysis analysis;
    protected TransferFunction transfer;
    protected Store initializationStore;
    protected Store initializationStaticStore;
    protected final Map<TransferInput<Value, Store>, IdentityHashMap<Node, TransferResult<Value, Store>>> flowResultAnalysisCaches;
    private static final Comparator<Class<? extends Annotation>> QUALIFIER_SORT_ORDERING = new Comparator<Class<? extends Annotation>>(){

        @Override
        public int compare(Class<? extends Annotation> a1, Class<? extends Annotation> a2) {
            return a1.getCanonicalName().compareTo(a2.getCanonicalName());
        }
    };
    protected final Map<ClassTree, ScanState> scannedClasses;
    protected AnalysisResult<Value, Store> flowResult;
    protected IdentityHashMap<Tree, Store> regularExitStores;
    protected IdentityHashMap<MethodTree, List<Pair<ReturnNode, TransferResult<Value, Store>>>> returnStatementStores;
    protected IdentityHashMap<MethodInvocationTree, Store> methodInvocationStores;
    protected final CFGVisualizer<Value, Store, TransferFunction> cfgVisualizer;

    public GenericAnnotatedTypeFactory(BaseTypeChecker checker, boolean useFlow) {
        super(checker);
        this.everUseFlow = useFlow;
        this.shouldDefaultTypeVarLocals = useFlow;
        this.useFlow = useFlow;
        this.scannedClasses = new HashMap<ClassTree, ScanState>();
        this.flowResult = null;
        this.regularExitStores = null;
        this.methodInvocationStores = null;
        this.returnStatementStores = null;
        this.initializationStore = null;
        this.initializationStaticStore = null;
        this.cfgVisualizer = this.createCFGVisualizer();
        if (this.shouldCache) {
            int cacheSize = this.getCacheSize();
            this.flowResultAnalysisCaches = CollectionUtils.createLRUCache(cacheSize);
        } else {
            this.flowResultAnalysisCaches = null;
        }
    }

    @Override
    protected void postInit() {
        super.postInit();
        this.dependentTypesHelper = this.createDependentTypesHelper();
        this.defaults = this.createAndInitQualifierDefaults();
        this.treeAnnotator = this.createTreeAnnotator();
        this.typeAnnotator = this.createTypeAnnotator();
        this.poly = this.createQualifierPolymorphism();
        this.analysis = this.createFlowAnalysis(new ArrayList<Pair<VariableElement, Value>>());
        this.transfer = (CFAbstractTransfer)((Analysis)this.analysis).getTransferFunction();
        this.emptyStore = ((CFAbstractAnalysis)this.analysis).createEmptyStore(((CFAbstractTransfer)this.transfer).usesSequentialSemantics());
        this.parseStubFiles();
    }

    @Override
    public void preProcessClassTree(ClassTree classTree) {
        if (this.everUseFlow) {
            this.checkAndPerformFlowAnalysis(classTree);
        }
    }

    public GenericAnnotatedTypeFactory(BaseTypeChecker checker) {
        this(checker, flowByDefault);
    }

    @Override
    public void setRoot(@Nullable CompilationUnitTree root) {
        super.setRoot(root);
        this.scannedClasses.clear();
        this.flowResult = null;
        this.regularExitStores = null;
        this.methodInvocationStores = null;
        this.returnStatementStores = null;
        this.initializationStore = null;
        this.initializationStaticStore = null;
        if (this.shouldCache) {
            this.flowResultAnalysisCaches.clear();
        }
    }

    public final Set<Class<? extends Annotation>> getSupportedMonotonicTypeQualifiers() {
        if (this.supportedMonotonicQuals == null) {
            this.supportedMonotonicQuals = new HashSet<Class<? extends Annotation>>();
            for (Class<? extends Annotation> anno : this.getSupportedTypeQualifiers()) {
                MonotonicQualifier mono = anno.getAnnotation(MonotonicQualifier.class);
                if (mono == null) continue;
                this.supportedMonotonicQuals.add(anno);
            }
        }
        return this.supportedMonotonicQuals;
    }

    protected TreeAnnotator createTreeAnnotator() {
        ArrayList<TreeAnnotator> treeAnnotators = new ArrayList<TreeAnnotator>();
        treeAnnotators.add(new PropagationTreeAnnotator(this));
        treeAnnotators.add(new ImplicitsTreeAnnotator(this));
        if (this.dependentTypesHelper != null) {
            treeAnnotators.add(this.dependentTypesHelper.createDependentTypesTreeAnnotator(this));
        }
        return new ListTreeAnnotator((List<TreeAnnotator>)treeAnnotators);
    }

    protected TypeAnnotator createTypeAnnotator() {
        ArrayList<TypeAnnotator> typeAnnotators = new ArrayList<TypeAnnotator>();
        RelevantJavaTypes relevantJavaTypes = this.checker.getClass().getAnnotation(RelevantJavaTypes.class);
        if (relevantJavaTypes != null) {
            Class<?>[] relevantClasses = relevantJavaTypes.value();
            typeAnnotators.add(new IrrelevantTypeAnnotator(this, this.getQualifierHierarchy().getTopAnnotations(), relevantClasses));
        }
        typeAnnotators.add(new PropagationTypeAnnotator(this));
        this.implicitsTypeAnnotator = new ImplicitsTypeAnnotator(this);
        typeAnnotators.add(this.implicitsTypeAnnotator);
        return new ListTypeAnnotator(typeAnnotators);
    }

    protected void addTypeNameImplicit(Class<?> clazz, AnnotationMirror implicitAnno) {
        this.implicitsTypeAnnotator.addTypeName(clazz, implicitAnno);
    }

    protected FlowAnalysis createFlowAnalysis(List<Pair<VariableElement, Value>> fieldValues) {
        for (Class<?> checkerClass = this.checker.getClass(); checkerClass != BaseTypeChecker.class; checkerClass = checkerClass.getSuperclass()) {
            String classToLoad = checkerClass.getName().replace("Checker", "Analysis").replace("Subchecker", "Analysis");
            CFAbstractAnalysis result = (CFAbstractAnalysis)BaseTypeChecker.invokeConstructorFor(classToLoad, new Class[]{BaseTypeChecker.class, this.getClass(), List.class}, new Object[]{this.checker, this, fieldValues});
            if (result == null) continue;
            return (FlowAnalysis)result;
        }
        ArrayList<Pair<VariableElement, CFValue>> tmp = new ArrayList<Pair<VariableElement, CFValue>>();
        for (Pair<VariableElement, Value> fieldVal : fieldValues) {
            assert (fieldVal.second instanceof CFValue);
            tmp.add(Pair.of(fieldVal.first, (CFValue)fieldVal.second));
        }
        return (FlowAnalysis)new CFAnalysis(this.checker, this, (List<Pair<VariableElement, CFValue>>)tmp);
    }

    public TransferFunction createFlowTransferFunction(CFAbstractAnalysis<Value, Store, TransferFunction> analysis) {
        for (Class<?> checkerClass = this.checker.getClass(); checkerClass != BaseTypeChecker.class; checkerClass = checkerClass.getSuperclass()) {
            String classToLoad = checkerClass.getName().replace("Checker", "Transfer").replace("Subchecker", "Transfer");
            CFAbstractTransfer result = (CFAbstractTransfer)BaseTypeChecker.invokeConstructorFor(classToLoad, new Class[]{analysis.getClass()}, new Object[]{analysis});
            if (result == null) continue;
            return (TransferFunction)result;
        }
        CFTransfer ret = new CFTransfer(analysis);
        return (TransferFunction)ret;
    }

    protected DependentTypesHelper createDependentTypesHelper() {
        DependentTypesHelper helper = new DependentTypesHelper(this);
        if (helper.hasDependentAnnotations()) {
            return helper;
        }
        return null;
    }

    public DependentTypesHelper getDependentTypesHelper() {
        return this.dependentTypesHelper;
    }

    @Override
    public AnnotatedTypeMirror.AnnotatedDeclaredType fromNewClass(NewClassTree newClassTree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType superResult = super.fromNewClass(newClassTree);
        if (this.dependentTypesHelper != null) {
            this.dependentTypesHelper.standardizeNewClassTree(newClassTree, superResult);
        }
        return superResult;
    }

    protected final QualifierDefaults createAndInitQualifierDefaults() {
        QualifierDefaults defs = this.createQualifierDefaults();
        this.addCheckedCodeDefaults(defs);
        this.addCheckedStandardDefaults(defs);
        this.addUncheckedCodeDefaults(defs);
        this.addUncheckedStandardDefaults(defs);
        this.checkForDefaultQualifierInHierarchy(defs);
        return defs;
    }

    protected QualifierDefaults createQualifierDefaults() {
        return new QualifierDefaults(this.elements, this);
    }

    protected final String getSortedQualifierNames() {
        Set<Class<? extends Annotation>> stq = this.getSupportedTypeQualifiers();
        if (stq.isEmpty()) {
            return "No qualifiers examined";
        }
        if (stq.size() == 1) {
            return "1 qualifier examined: " + stq.iterator().next().getCanonicalName();
        }
        ArrayList<Class<? extends Annotation>> sortedSupportedQuals = new ArrayList<Class<? extends Annotation>>();
        sortedSupportedQuals.addAll(stq);
        Collections.sort(sortedSupportedQuals, QUALIFIER_SORT_ORDERING);
        StringBuilder sb = new StringBuilder();
        sb.append(sortedSupportedQuals.size());
        sb.append(" qualifiers examined");
        sb.append(": ");
        for (Class clazz : sortedSupportedQuals) {
            sb.append(clazz.getCanonicalName());
            sb.append(", ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    protected void addCheckedCodeDefaults(QualifierDefaults defs) {
        for (Class<? extends Annotation> qual : this.getSupportedTypeQualifiers()) {
            DefaultFor defaultFor = qual.getAnnotation(DefaultFor.class);
            if (defaultFor != null) {
                TypeUseLocation[] locations = defaultFor.value();
                defs.addCheckedCodeDefaults(AnnotationBuilder.fromClass(this.elements, qual), locations);
            }
            if (qual.getAnnotation(DefaultQualifierInHierarchy.class) == null) continue;
            defs.addCheckedCodeDefault(AnnotationBuilder.fromClass(this.elements, qual), TypeUseLocation.OTHERWISE);
        }
    }

    protected void addCheckedStandardDefaults(QualifierDefaults defs) {
        if (this.everUseFlow) {
            defs.addClimbStandardDefaults();
        }
    }

    protected void addUncheckedCodeDefaults(QualifierDefaults defs) {
        for (Class<? extends Annotation> annotation : this.getSupportedTypeQualifiers()) {
            DefaultInUncheckedCodeFor defaultInUncheckedCodeFor = annotation.getAnnotation(DefaultInUncheckedCodeFor.class);
            if (defaultInUncheckedCodeFor != null) {
                TypeUseLocation[] locations = defaultInUncheckedCodeFor.value();
                defs.addUncheckedCodeDefaults(AnnotationBuilder.fromClass(this.elements, annotation), locations);
            }
            if (annotation.getAnnotation(DefaultQualifierInHierarchyInUncheckedCode.class) == null) continue;
            defs.addUncheckedCodeDefault(AnnotationBuilder.fromClass(this.elements, annotation), TypeUseLocation.OTHERWISE);
        }
    }

    protected void addUncheckedStandardDefaults(QualifierDefaults defs) {
        defs.addUncheckedStandardDefaults();
    }

    protected void checkForDefaultQualifierInHierarchy(QualifierDefaults defs) {
        if (!defs.hasDefaultsForCheckedCode()) {
            throw new BugInCF("GenericAnnotatedTypeFactory.createQualifierDefaults: @DefaultQualifierInHierarchy or @DefaultFor(TypeUseLocation.OTHERWISE) not found. Every checker must specify a default qualifier. " + this.getSortedQualifierNames());
        }
    }

    protected QualifierPolymorphism createQualifierPolymorphism() {
        return new DefaultQualifierPolymorphism(this.processingEnv, this);
    }

    public QualifierPolymorphism getQualifierPolymorphism() {
        return this.poly;
    }

    @Override
    protected void postDirectSuperTypes(AnnotatedTypeMirror type, List<? extends AnnotatedTypeMirror> supertypes) {
        super.postDirectSuperTypes(type, supertypes);
        if (type.getKind() == TypeKind.DECLARED) {
            for (AnnotatedTypeMirror annotatedTypeMirror : supertypes) {
                Element elt = ((DeclaredType)annotatedTypeMirror.getUnderlyingType()).asElement();
                this.addComputedTypeAnnotations(elt, annotatedTypeMirror);
            }
        }
    }

    public AnnotatedTypeMirror getResultingTypeOfConstructorMemberReference(MemberReferenceTree memberReferenceTree, AnnotatedTypeMirror.AnnotatedExecutableType constructorType) {
        assert (memberReferenceTree.getMode() == MemberReferenceTree.ReferenceMode.NEW);
        AnnotatedTypeMirror.AnnotatedDeclaredType constructorReturnType = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.fromTypeTree(memberReferenceTree.getQualifierExpression());
        AnnotatedTypes.copyOnlyExplicitConstructorAnnotations(this, constructorReturnType, constructorType);
        this.addComputedTypeAnnotations(memberReferenceTree.getQualifierExpression(), (AnnotatedTypeMirror)constructorReturnType);
        return constructorReturnType;
    }

    public AnnotationMirror getAnnotationFromJavaExpressionString(String expression, Tree tree, TreePath path, Class<? extends Annotation> clazz) throws FlowExpressionParseUtil.FlowExpressionParseException {
        FlowExpressions.Receiver expressionObj = this.getReceiverFromJavaExpressionString(expression, path);
        return this.getAnnotationFromReceiver(expressionObj, tree, clazz);
    }

    public AnnotationMirror getAnnotationFromReceiver(FlowExpressions.Receiver receiver, Tree tree, Class<? extends Annotation> clazz) {
        Store store;
        Object value;
        AnnotationMirror annotationMirror = null;
        if (CFAbstractStore.canInsertReceiver(receiver) && (value = ((CFAbstractStore)(store = this.getStoreBefore(tree))).getValue(receiver)) != null) {
            annotationMirror = AnnotationUtils.getAnnotationByClass(((CFAbstractValue)value).getAnnotations(), clazz);
        }
        if (annotationMirror == null) {
            Element ele;
            if (receiver instanceof FlowExpressions.LocalVariable) {
                ele = ((FlowExpressions.LocalVariable)receiver).getElement();
                annotationMirror = this.getAnnotatedType(ele).getAnnotation(clazz);
            } else if (receiver instanceof FlowExpressions.FieldAccess) {
                ele = ((FlowExpressions.FieldAccess)receiver).getField();
                annotationMirror = this.getAnnotatedType(ele).getAnnotation(clazz);
            }
        }
        return annotationMirror;
    }

    public FlowExpressions.Receiver getReceiverFromJavaExpressionString(String expression, TreePath currentPath) throws FlowExpressionParseUtil.FlowExpressionParseException {
        TypeMirror enclosingClass = TreeUtils.typeOf(TreeUtils.enclosingClass(currentPath));
        FlowExpressions.Receiver r = FlowExpressions.internalReprOfPseudoReceiver(currentPath, enclosingClass);
        FlowExpressionParseUtil.FlowExpressionContext context = new FlowExpressionParseUtil.FlowExpressionContext(r, FlowExpressions.getParametersOfEnclosingMethod(this, currentPath), this.getContext());
        return FlowExpressionParseUtil.parse(expression, context, currentPath, true);
    }

    public AnnotationMirror getAnnotationMirrorFromJavaExpressionString(String expression, Tree tree, TreePath currentPath) throws FlowExpressionParseUtil.FlowExpressionParseException {
        FlowExpressions.Receiver rec = this.getReceiverFromJavaExpressionString(expression, currentPath);
        if (rec == null || !CFAbstractStore.canInsertReceiver(rec)) {
            return null;
        }
        Store store = this.getStoreBefore(tree);
        Object value = ((CFAbstractStore)store).getValue(rec);
        return value != null ? ((CFAbstractValue)value).getAnnotations().iterator().next() : null;
    }

    public @Nullable Store getRegularExitStore(Tree t) {
        return (Store)((CFAbstractStore)this.regularExitStores.get(t));
    }

    public List<Pair<ReturnNode, TransferResult<Value, Store>>> getReturnStatementStores(MethodTree methodTree) {
        assert (this.returnStatementStores.containsKey(methodTree));
        return this.returnStatementStores.get(methodTree);
    }

    public Store getStoreBefore(Tree tree) {
        if (!((Analysis)this.analysis).isRunning()) {
            return (Store)((CFAbstractStore)this.flowResult.getStoreBefore(tree));
        }
        Set<Node> nodes = ((Analysis)this.analysis).getNodesForTree(tree);
        if (nodes != null) {
            return this.getStoreBefore(nodes);
        }
        return (Store)((CFAbstractStore)this.flowResult.getStoreBefore(tree));
    }

    public Store getStoreBefore(Set<Node> nodes) {
        CFAbstractStore merge = null;
        for (Node aNode : nodes) {
            Store s2 = this.getStoreBefore(aNode);
            if (merge == null) {
                merge = (CFAbstractStore)s2;
                continue;
            }
            if (s2 == null) continue;
            merge = merge.leastUpperBound(s2);
        }
        return (Store)merge;
    }

    public Store getStoreBefore(Node node) {
        if (!((Analysis)this.analysis).isRunning()) {
            return (Store)((CFAbstractStore)this.flowResult.getStoreBefore(node));
        }
        TransferInput prevStore = ((Analysis)this.analysis).getInput(node.getBlock());
        if (prevStore == null) {
            return null;
        }
        CFAbstractStore store = (CFAbstractStore)AnalysisResult.runAnalysisFor(node, true, prevStore, ((Analysis)this.analysis).getNodeValues(), this.flowResultAnalysisCaches);
        return (Store)store;
    }

    public Store getStoreAfter(Tree tree) {
        if (!((Analysis)this.analysis).isRunning()) {
            return (Store)((CFAbstractStore)this.flowResult.getStoreAfter(tree));
        }
        Set<Node> nodes = ((Analysis)this.analysis).getNodesForTree(tree);
        return this.getStoreAfter(nodes);
    }

    public Store getStoreAfter(Set<Node> nodes) {
        CFAbstractStore merge = null;
        for (Node node : nodes) {
            Store s2 = this.getStoreAfter(node);
            if (merge == null) {
                merge = (CFAbstractStore)s2;
                continue;
            }
            if (s2 == null) continue;
            merge = merge.leastUpperBound(s2);
        }
        return (Store)merge;
    }

    public Store getStoreAfter(Node node) {
        CFAbstractStore res = (CFAbstractStore)AnalysisResult.runAnalysisFor(node, false, ((Analysis)this.analysis).getInput(node.getBlock()), ((Analysis)this.analysis).getNodeValues(), this.flowResultAnalysisCaches);
        return (Store)res;
    }

    public Set<Node> getNodesForTree(Tree tree) {
        return this.flowResult.getNodesForTree(tree);
    }

    public <T extends Node> T getFirstNodeOfKindForTree(Tree tree, Class<T> kind) {
        Set<Node> nodes = this.getNodesForTree(tree);
        for (Node node : nodes) {
            if (!node.getClass().equals(kind)) continue;
            return (T)((Node)kind.cast(node));
        }
        return null;
    }

    public HashMap<Element, Value> getFinalLocalValues() {
        return this.flowResult.getFinalLocalValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performFlowAnalysis(ClassTree classTree) {
        if (this.flowResult == null) {
            this.regularExitStores = new IdentityHashMap();
            this.returnStatementStores = new IdentityHashMap();
            this.flowResult = new AnalysisResult(this.flowResultAnalysisCaches);
        }
        if (classTree.getKind() == Tree.Kind.ANNOTATION_TYPE) {
            this.scannedClasses.put(classTree, ScanState.FINISHED);
            return;
        }
        ArrayDeque<Pair<ClassTree, Store>> queue = new ArrayDeque<Pair<ClassTree, Store>>();
        ArrayList<Pair<VariableElement, Value>> fieldValues = new ArrayList<Pair<VariableElement, Value>>();
        queue.add(Pair.of(classTree, null));
        while (!queue.isEmpty()) {
            Pair qel = (Pair)queue.remove();
            ClassTree ct = (ClassTree)qel.first;
            CFAbstractStore capturedStore = (CFAbstractStore)qel.second;
            this.scannedClasses.put(ct, ScanState.IN_PROGRESS);
            TreePath preTreePath = this.visitorState.getPath();
            AnnotatedTypeMirror.AnnotatedDeclaredType preClassType = this.visitorState.getClassType();
            ClassTree preClassTree = this.visitorState.getClassTree();
            AnnotatedTypeMirror.AnnotatedDeclaredType preAMT = this.visitorState.getMethodReceiver();
            MethodTree preMT = this.visitorState.getMethodTree();
            this.visitorState.setPath(TreePath.getPath(this.root, (Tree)ct));
            this.visitorState.setClassType(this.getAnnotatedType(TreeUtils.elementFromDeclaration(ct)));
            this.visitorState.setClassTree(ct);
            this.visitorState.setMethodReceiver(null);
            this.visitorState.setMethodTree(null);
            this.initializationStaticStore = capturedStore;
            this.initializationStore = capturedStore;
            ArrayDeque<Pair<LambdaExpressionTree, Store>> lambdaQueue = new ArrayDeque<Pair<LambdaExpressionTree, Store>>();
            try {
                ArrayList<UnderlyingAST.CFGMethod> methods = new ArrayList<UnderlyingAST.CFGMethod>();
                block10: for (Tree tree : ct.getMembers()) {
                    switch (tree.getKind()) {
                        case METHOD: {
                            MethodTree mt = (MethodTree)tree;
                            Set<Modifier> flags = mt.getModifiers().getFlags();
                            if (flags.contains((Object)Modifier.ABSTRACT)) continue block10;
                            if (flags.contains((Object)Modifier.NATIVE) || mt.getBody() == null) break;
                            UnderlyingAST.CFGMethod met = new UnderlyingAST.CFGMethod(mt, ct);
                            methods.add(met);
                            break;
                        }
                        case VARIABLE: {
                            VariableTree vt = (VariableTree)tree;
                            ExpressionTree initializer = vt.getInitializer();
                            if (initializer == null) continue block10;
                            boolean isStatic = vt.getModifiers().getFlags().contains((Object)Modifier.STATIC);
                            this.analyze(queue, lambdaQueue, new UnderlyingAST.CFGStatement(vt, ct), fieldValues, classTree, true, true, isStatic, capturedStore);
                            CFAbstractValue value = (CFAbstractValue)this.flowResult.getValue(initializer);
                            if (!vt.getModifiers().getFlags().contains((Object)Modifier.FINAL) || value == null) continue block10;
                            VariableElement element = TreeUtils.elementFromDeclaration(vt);
                            fieldValues.add(Pair.of(element, value));
                            break;
                        }
                        case CLASS: 
                        case ANNOTATION_TYPE: 
                        case INTERFACE: 
                        case ENUM: {
                            queue.add(Pair.of((ClassTree)tree, capturedStore));
                            break;
                        }
                        case BLOCK: {
                            BlockTree b = (BlockTree)tree;
                            this.analyze(queue, lambdaQueue, new UnderlyingAST.CFGStatement(b, ct), fieldValues, ct, true, true, b.isStatic(), capturedStore);
                            break;
                        }
                        default: {
                            assert (false) : "Unexpected member: " + (Object)((Object)tree.getKind());
                            continue block10;
                        }
                    }
                }
                for (UnderlyingAST.CFGMethod cFGMethod : methods) {
                    this.analyze(queue, lambdaQueue, cFGMethod, fieldValues, classTree, TreeUtils.isConstructor(cFGMethod.getMethod()), false, false, capturedStore);
                }
                while (!lambdaQueue.isEmpty()) {
                    Pair lambdaPair = (Pair)lambdaQueue.poll();
                    this.analyze(queue, lambdaQueue, new UnderlyingAST.CFGLambda((LambdaExpressionTree)lambdaPair.first), fieldValues, classTree, false, false, false, (CFAbstractStore)lambdaPair.second);
                }
                if (this.initializationStaticStore == null) {
                    this.regularExitStores.put(ct, this.emptyStore);
                } else {
                    this.regularExitStores.put(ct, this.initializationStaticStore);
                }
            }
            finally {
                this.visitorState.setPath(preTreePath);
                this.visitorState.setClassType(preClassType);
                this.visitorState.setClassTree(preClassTree);
                this.visitorState.setMethodReceiver(preAMT);
                this.visitorState.setMethodTree(preMT);
            }
            this.scannedClasses.put(ct, ScanState.FINISHED);
        }
    }

    protected void analyze(Queue<Pair<ClassTree, Store>> queue, Queue<Pair<LambdaExpressionTree, Store>> lambdaQueue, UnderlyingAST ast, List<Pair<VariableElement, Value>> fieldValues, ClassTree currentClass, boolean isInitializationCode, boolean updateInitializationStore, boolean isStatic, Store capturedStore) {
        CFAbstractStore regularExitStore;
        UnderlyingAST block;
        ControlFlowGraph cfg = CFCFGBuilder.build(this.root, ast, this.checker, this, this.processingEnv);
        if (isInitializationCode) {
            Store initStore;
            Store Store2 = initStore = !isStatic ? this.initializationStore : this.initializationStaticStore;
            if (initStore != null) {
                ((CFAbstractTransfer)this.transfer).setFixedInitialStore(initStore);
            } else {
                ((CFAbstractTransfer)this.transfer).setFixedInitialStore(capturedStore);
            }
        } else {
            ((CFAbstractTransfer)this.transfer).setFixedInitialStore(capturedStore);
        }
        ((CFAbstractAnalysis)this.analysis).performAnalysis(cfg, fieldValues);
        AnalysisResult result = ((Analysis)this.analysis).getResult();
        this.flowResult.combine(result);
        if (ast.getKind() == UnderlyingAST.Kind.METHOD) {
            UnderlyingAST.CFGMethod mast = (UnderlyingAST.CFGMethod)ast;
            MethodTree method = mast.getMethod();
            CFAbstractStore regularExitStore2 = (CFAbstractStore)((Analysis)this.analysis).getRegularExitStore();
            if (regularExitStore2 != null) {
                this.regularExitStores.put(method, regularExitStore2);
            }
            this.returnStatementStores.put(method, ((Analysis)this.analysis).getReturnStatementStores());
        } else if (ast.getKind() == UnderlyingAST.Kind.ARBITRARY_CODE) {
            block = (UnderlyingAST.CFGStatement)ast;
            regularExitStore = (CFAbstractStore)((Analysis)this.analysis).getRegularExitStore();
            if (regularExitStore != null) {
                this.regularExitStores.put(((UnderlyingAST.CFGStatement)block).getCode(), regularExitStore);
            }
        } else if (ast.getKind() == UnderlyingAST.Kind.LAMBDA) {
            block = (UnderlyingAST.CFGLambda)ast;
            regularExitStore = (CFAbstractStore)((Analysis)this.analysis).getRegularExitStore();
            if (regularExitStore != null) {
                this.regularExitStores.put(((UnderlyingAST.CFGLambda)block).getCode(), regularExitStore);
            }
        } else assert (false) : "Unexpected AST kind: " + (Object)((Object)ast.getKind());
        if (isInitializationCode && updateInitializationStore) {
            CFAbstractStore newInitStore = (CFAbstractStore)((Analysis)this.analysis).getRegularExitStore();
            if (!isStatic) {
                this.initializationStore = newInitStore;
            } else {
                this.initializationStaticStore = newInitStore;
            }
        }
        if (this.checker.hasOption("flowdotdir") || this.checker.hasOption("cfgviz")) {
            this.handleCFGViz();
        }
        for (ClassTree cls : cfg.getDeclaredClasses()) {
            queue.add(Pair.of(cls, this.getStoreBefore(cls)));
        }
        for (LambdaExpressionTree lambda : cfg.getDeclaredLambdas()) {
            lambdaQueue.add(Pair.of(lambda, this.getStoreBefore(lambda)));
        }
    }

    protected void handleCFGViz() {
        ((CFAbstractAnalysis)this.analysis).visualizeCFG();
    }

    public AnnotatedTypeMirror getAnnotatedTypeLhsNoTypeVarDefault(Tree lhsTree) {
        boolean old = this.shouldDefaultTypeVarLocals;
        this.shouldDefaultTypeVarLocals = false;
        AnnotatedTypeMirror type = this.getAnnotatedTypeLhs(lhsTree);
        this.shouldDefaultTypeVarLocals = old;
        return type;
    }

    public AnnotatedTypeMirror getAnnotatedTypeLhs(Tree lhsTree) {
        AnnotatedTypeMirror res = null;
        boolean oldUseFlow = this.useFlow;
        boolean oldShouldCache = this.shouldCache;
        this.useFlow = false;
        this.shouldCache = false;
        switch (lhsTree.getKind()) {
            case VARIABLE: 
            case IDENTIFIER: 
            case MEMBER_SELECT: 
            case ARRAY_ACCESS: {
                res = this.getAnnotatedType(lhsTree);
                break;
            }
            default: {
                if (TreeUtils.isTypeTree(lhsTree)) {
                    res = this.getAnnotatedType(lhsTree);
                    break;
                }
                throw new BugInCF("GenericAnnotatedTypeFactory: Unexpected tree passed to getAnnotatedTypeLhs. lhsTree: " + lhsTree + " Tree.Kind: " + (Object)((Object)lhsTree.getKind()));
            }
        }
        this.useFlow = oldUseFlow;
        this.shouldCache = oldShouldCache;
        return res;
    }

    public AnnotatedTypeMirror getAnnotatedTypeVarargsArray(Tree tree) {
        List<Node> args;
        if (!this.useFlow) {
            return null;
        }
        switch (tree.getKind()) {
            case METHOD_INVOCATION: {
                args = this.getFirstNodeOfKindForTree(tree, MethodInvocationNode.class).getArguments();
                break;
            }
            case NEW_CLASS: {
                args = this.getFirstNodeOfKindForTree(tree, ObjectCreationNode.class).getArguments();
                break;
            }
            default: {
                throw new BugInCF("Unexpected kind of tree: " + tree);
            }
        }
        assert (!args.isEmpty()) : "Arguments are empty";
        Node varargsArray = args.get(args.size() - 1);
        AnnotatedTypeMirror varargtype = this.getAnnotatedType(varargsArray.getTree());
        return varargtype;
    }

    public AnnotatedTypeMirror getAnnotatedTypeRhsUnaryAssign(UnaryTree tree) {
        if (!this.useFlow) {
            return this.getAnnotatedType(tree);
        }
        AssignmentNode n = this.flowResult.getAssignForUnaryTree(tree);
        return this.getAnnotatedType(n.getExpression().getTree());
    }

    @Override
    public AnnotatedTypeFactory.ParameterizedExecutableType constructorFromUse(NewClassTree tree) {
        AnnotatedTypeFactory.ParameterizedExecutableType mType = super.constructorFromUse(tree);
        AnnotatedTypeMirror.AnnotatedExecutableType method = mType.executableType;
        if (this.dependentTypesHelper != null) {
            this.dependentTypesHelper.viewpointAdaptConstructor(tree, method);
        }
        this.poly.annotate(tree, method);
        return mType;
    }

    @Override
    public AnnotatedTypeMirror getMethodReturnType(MethodTree m3) {
        AnnotatedTypeMirror returnType = super.getMethodReturnType(m3);
        if (this.dependentTypesHelper != null) {
            this.dependentTypesHelper.standardizeReturnType(m3, returnType);
        }
        return returnType;
    }

    @Override
    public AnnotatedTypeMirror getMethodReturnType(MethodTree m3, ReturnTree r) {
        AnnotatedTypeMirror returnType = super.getMethodReturnType(m3, r);
        if (this.dependentTypesHelper != null) {
            this.dependentTypesHelper.standardizeReturnType(m3, returnType);
        }
        return returnType;
    }

    @Override
    public void addDefaultAnnotations(AnnotatedTypeMirror type) {
        this.typeAnnotator.visit(type, null);
        this.defaults.annotate((Element)null, type);
    }

    @Override
    protected final void addComputedTypeAnnotations(Tree tree, AnnotatedTypeMirror type) {
        this.addComputedTypeAnnotations(tree, type, this.useFlow);
    }

    protected void addComputedTypeAnnotations(Tree tree, AnnotatedTypeMirror type, boolean iUseFlow) {
        Value as;
        assert (this.root != null) : "GenericAnnotatedTypeFactory.addComputedTypeAnnotations:  root needs to be set when used on trees; factory: " + this.getClass();
        this.treeAnnotator.visit(tree, type);
        this.typeAnnotator.visit(type, null);
        this.defaults.annotate(tree, type);
        if (iUseFlow && (as = this.getInferredValueFor(tree)) != null) {
            this.applyInferredAnnotations(type, as);
        }
    }

    protected void checkAndPerformFlowAnalysis(Tree tree) {
        ClassTree classTree;
        if (tree instanceof ClassTree && !this.scannedClasses.containsKey(classTree = (ClassTree)tree)) {
            this.performFlowAnalysis(classTree);
        }
    }

    public Value getInferredValueFor(Tree tree) {
        if (tree == null) {
            throw new BugInCF("GenericAnnotatedTypeFactory.getInferredValueFor called with null tree");
        }
        CFAbstractValue as = null;
        if (((Analysis)this.analysis).isRunning()) {
            as = (CFAbstractValue)((Analysis)this.analysis).getValue(tree);
        }
        if (as == null && this.flowResult != null) {
            as = (CFAbstractValue)this.flowResult.getValue(tree);
        }
        return (Value)as;
    }

    protected void applyInferredAnnotations(AnnotatedTypeMirror type, Value as) {
        DefaultInferredTypesApplier applier = new DefaultInferredTypesApplier(this.getQualifierHierarchy(), this);
        applier.applyInferredType(type, ((CFAbstractValue)as).getAnnotations(), ((CFAbstractValue)as).getUnderlyingType());
    }

    @Override
    public void addComputedTypeAnnotations(Element elt, AnnotatedTypeMirror type) {
        this.typeAnnotator.visit(type, null);
        this.defaults.annotate(elt, type);
        if (this.dependentTypesHelper != null) {
            this.dependentTypesHelper.standardizeVariable(type, elt);
        }
    }

    @Override
    public AnnotatedTypeFactory.ParameterizedExecutableType methodFromUse(MethodInvocationTree tree) {
        AnnotatedTypeFactory.ParameterizedExecutableType mType = super.methodFromUse(tree);
        AnnotatedTypeMirror.AnnotatedExecutableType method = mType.executableType;
        if (this.dependentTypesHelper != null) {
            this.dependentTypesHelper.viewpointAdaptMethod(tree, method);
        }
        this.poly.annotate(tree, method);
        return mType;
    }

    @Override
    public List<AnnotatedTypeParameterBounds> typeVariablesFromUse(AnnotatedTypeMirror.AnnotatedDeclaredType type, TypeElement element) {
        List<AnnotatedTypeParameterBounds> f = super.typeVariablesFromUse(type, element);
        if (this.dependentTypesHelper != null) {
            this.dependentTypesHelper.viewpointAdaptTypeVariableBounds(element, f, this.visitorState.getPath());
        }
        return f;
    }

    public Store getEmptyStore() {
        return this.emptyStore;
    }

    public <T extends GenericAnnotatedTypeFactory<?, ?, ?, ?>, U extends BaseTypeChecker> T getTypeFactoryOfSubchecker(Class<U> checkerClass) {
        Object subFactory = this.checker.getTypeFactoryOfSubchecker(checkerClass);
        if (subFactory != null && ((AnnotatedTypeFactory)subFactory).getVisitorState() != null) {
            VisitorState subFactoryVisitorState = ((AnnotatedTypeFactory)subFactory).getVisitorState();
            subFactoryVisitorState.setPath(this.visitorState.getPath());
            subFactoryVisitorState.setClassTree(this.visitorState.getClassTree());
            subFactoryVisitorState.setClassType(this.visitorState.getClassType());
            subFactoryVisitorState.setMethodTree(this.visitorState.getMethodTree());
            subFactoryVisitorState.setMethodReceiver(this.visitorState.getMethodReceiver());
        }
        return subFactory;
    }

    public boolean getShouldDefaultTypeVarLocals() {
        return this.shouldDefaultTypeVarLocals;
    }

    protected CFGVisualizer<Value, Store, TransferFunction> createCFGVisualizer() {
        if (this.checker.hasOption("flowdotdir")) {
            String flowdotdir = this.checker.getOption("flowdotdir");
            boolean verbose = this.checker.hasOption("verbosecfg");
            HashMap<String, Object> args = new HashMap<String, Object>(2);
            args.put("outdir", flowdotdir);
            args.put("verbose", verbose);
            args.put("checkerName", this.getCheckerName());
            DOTCFGVisualizer res = new DOTCFGVisualizer();
            res.init(args);
            return res;
        }
        if (this.checker.hasOption("cfgviz")) {
            String cfgviz = this.checker.getOption("cfgviz");
            if (cfgviz == null) {
                throw new UserError("-Acfgviz specified without arguments, should be -Acfgviz=VizClassName[,opts,...]");
            }
            String[] opts = cfgviz.split(",");
            Map<String, Object> args = this.processCFGVisualizerOption(opts);
            if (!args.containsKey("verbose")) {
                boolean verbose = this.checker.hasOption("verbosecfg");
                args.put("verbose", verbose);
            }
            args.put("checkerName", this.getCheckerName());
            CFGVisualizer res = (CFGVisualizer)BaseTypeChecker.invokeConstructorFor(opts[0], null, null);
            res.init(args);
            return res;
        }
        return null;
    }

    private String getCheckerName() {
        String checkerName = this.checker.getClass().getSimpleName();
        if (checkerName.endsWith("Checker") || checkerName.endsWith("checker")) {
            checkerName = checkerName.substring(0, checkerName.length() - "checker".length());
        }
        return checkerName;
    }

    private Map<String, Object> processCFGVisualizerOption(String[] opts) {
        HashMap<String, Object> res = new HashMap<String, Object>(opts.length - 1);
        block4: for (int i = 1; i < opts.length; ++i) {
            String opt = opts[i];
            String[] split = opt.split("=");
            switch (split.length) {
                case 1: {
                    res.put(split[0], true);
                    continue block4;
                }
                case 2: {
                    res.put(split[0], split[1]);
                    continue block4;
                }
                default: {
                    throw new UserError("Too many `=` in cfgviz option: " + opt);
                }
            }
        }
        return res;
    }

    public CFGVisualizer<Value, Store, TransferFunction> getCFGVisualizer() {
        return this.cfgVisualizer;
    }

    protected static enum ScanState {
        IN_PROGRESS,
        FINISHED;

    }
}

