/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.ElementAnnotationApplier;
import org.checkerframework.framework.type.visitor.AnnotatedTypeScanner;
import org.checkerframework.framework.type.visitor.SimpleAnnotatedTypeVisitor;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TreeUtils;

class SupertypeFinder {
    SupertypeFinder() {
    }

    public static List<AnnotatedTypeMirror.AnnotatedDeclaredType> directSuperTypes(AnnotatedTypeMirror.AnnotatedDeclaredType type) {
        SupertypeFindingVisitor supertypeFindingVisitor = new SupertypeFindingVisitor(type.atypeFactory);
        List<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes = supertypeFindingVisitor.visitDeclared(type, null);
        type.atypeFactory.postDirectSuperTypes(type, supertypes);
        return supertypes;
    }

    public static final List<? extends AnnotatedTypeMirror> directSuperTypes(AnnotatedTypeMirror type) {
        SupertypeFindingVisitor supertypeFindingVisitor = new SupertypeFindingVisitor(type.atypeFactory);
        List supertypes = (List)supertypeFindingVisitor.visit(type, null);
        type.atypeFactory.postDirectSuperTypes(type, supertypes);
        return supertypes;
    }

    private static class SupertypeFindingVisitor
    extends SimpleAnnotatedTypeVisitor<List<? extends AnnotatedTypeMirror>, Void> {
        private final Types types;
        private final AnnotatedTypeFactory atypeFactory;
        private final TypeParamReplacer typeParamReplacer;

        SupertypeFindingVisitor(AnnotatedTypeFactory atypeFactory) {
            this.atypeFactory = atypeFactory;
            this.types = atypeFactory.types;
            this.typeParamReplacer = new TypeParamReplacer(this.types);
        }

        @Override
        public List<AnnotatedTypeMirror> defaultAction(AnnotatedTypeMirror t, Void p) {
            return new ArrayList<AnnotatedTypeMirror>();
        }

        @Override
        public List<AnnotatedTypeMirror> visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type, Void p) {
            ArrayList<AnnotatedTypeMirror> superTypes = new ArrayList<AnnotatedTypeMirror>();
            Set<AnnotationMirror> annotations = type.getAnnotations();
            TypeElement boxed = this.types.boxedClass(type.getUnderlyingType());
            AnnotatedTypeMirror.AnnotatedDeclaredType boxedType = this.atypeFactory.getAnnotatedType(boxed);
            boxedType.replaceAnnotations(annotations);
            superTypes.add(boxedType);
            TypeKind superPrimitiveType = null;
            if (type.getKind() != TypeKind.BOOLEAN) {
                if (type.getKind() == TypeKind.BYTE) {
                    superPrimitiveType = TypeKind.SHORT;
                } else if (type.getKind() == TypeKind.CHAR) {
                    superPrimitiveType = TypeKind.INT;
                } else if (type.getKind() != TypeKind.DOUBLE) {
                    if (type.getKind() == TypeKind.FLOAT) {
                        superPrimitiveType = TypeKind.DOUBLE;
                    } else if (type.getKind() == TypeKind.INT) {
                        superPrimitiveType = TypeKind.LONG;
                    } else if (type.getKind() == TypeKind.LONG) {
                        superPrimitiveType = TypeKind.FLOAT;
                    } else if (type.getKind() == TypeKind.SHORT) {
                        superPrimitiveType = TypeKind.INT;
                    } else assert (false) : "Forgot the primitive " + type;
                }
            }
            if (superPrimitiveType != null) {
                AnnotatedTypeMirror.AnnotatedPrimitiveType superPrimitive = (AnnotatedTypeMirror.AnnotatedPrimitiveType)this.atypeFactory.toAnnotatedType(this.types.getPrimitiveType(superPrimitiveType), false);
                superPrimitive.addAnnotations(annotations);
                superTypes.add(superPrimitive);
            }
            return superTypes;
        }

        @Override
        public List<AnnotatedTypeMirror.AnnotatedDeclaredType> visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Void p) {
            ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes = new ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType>();
            TypeElement typeElement = (TypeElement)type.getUnderlyingType().asElement();
            HashMap<TypeParameterElement, AnnotatedTypeMirror> mapping = new HashMap<TypeParameterElement, AnnotatedTypeMirror>();
            if (type.getTypeArguments().size() != typeElement.getTypeParameters().size() && !type.wasRaw()) {
                throw new BugInCF("AnnotatedDeclaredType's element has a different number of type parameters than type.\ntype=" + type + "\nelement=" + typeElement);
            }
            for (AnnotatedTypeMirror.AnnotatedDeclaredType enclosing = type; enclosing != null; enclosing = enclosing.getEnclosingType()) {
                TypeElement enclosingTypeElement = (TypeElement)enclosing.getUnderlyingType().asElement();
                List<AnnotatedTypeMirror> typeArgs = enclosing.getTypeArguments();
                List<? extends TypeParameterElement> typeParams = enclosingTypeElement.getTypeParameters();
                for (int i = 0; i < enclosing.getTypeArguments().size(); ++i) {
                    AnnotatedTypeMirror typArg = typeArgs.get(i);
                    TypeParameterElement ele = typeParams.get(i);
                    mapping.put(ele, typArg);
                }
            }
            ClassTree classTree = this.atypeFactory.trees.getTree(typeElement);
            if (classTree != null) {
                supertypes.addAll(this.supertypesFromTree(type, classTree));
            } else {
                supertypes.addAll(this.supertypesFromElement(type, typeElement));
            }
            if (typeElement.getKind() == ElementKind.ANNOTATION_TYPE) {
                TypeElement jlaElement = this.atypeFactory.elements.getTypeElement(Annotation.class.getCanonicalName());
                AnnotatedTypeMirror.AnnotatedDeclaredType jlaAnnotation = this.atypeFactory.fromElement(jlaElement);
                jlaAnnotation.addAnnotations(type.getAnnotations());
                supertypes.add(jlaAnnotation);
            }
            for (AnnotatedTypeMirror.AnnotatedDeclaredType dt : supertypes) {
                this.typeParamReplacer.visit(dt, mapping);
            }
            return supertypes;
        }

        /*
         * WARNING - void declaration
         */
        private List<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypesFromElement(AnnotatedTypeMirror.AnnotatedDeclaredType type, TypeElement typeElement) {
            ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes = new ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType>();
            if (typeElement.getKind() == ElementKind.ENUM) {
                DeclaredType dt = (DeclaredType)typeElement.getSuperclass();
                AnnotatedTypeMirror.AnnotatedDeclaredType annotatedDeclaredType = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.atypeFactory.toAnnotatedType(dt, false);
                List<AnnotatedTypeMirror> tas = annotatedDeclaredType.getTypeArguments();
                ArrayList<AnnotatedTypeMirror> newtas = new ArrayList<AnnotatedTypeMirror>();
                for (AnnotatedTypeMirror t : tas) {
                    if (!this.atypeFactory.types.isSameType(t.getUnderlyingType(), type.getUnderlyingType())) continue;
                    t.addAnnotations(type.getAnnotations());
                    newtas.add(t);
                }
                annotatedDeclaredType.setTypeArguments(newtas);
                supertypes.add(annotatedDeclaredType);
            } else if (typeElement.getSuperclass().getKind() != TypeKind.NONE) {
                DeclaredType superClass = (DeclaredType)typeElement.getSuperclass();
                AnnotatedTypeMirror.AnnotatedDeclaredType annotatedDeclaredType = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.atypeFactory.toAnnotatedType(superClass, false);
                supertypes.add(annotatedDeclaredType);
            } else if (!ElementUtils.isObject(typeElement)) {
                supertypes.add(AnnotatedTypeMirror.createTypeOfObject(this.atypeFactory));
            }
            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                void var5_11;
                if (type.wasRaw()) {
                    TypeMirror typeMirror2 = this.types.erasure(typeMirror);
                }
                AnnotatedTypeMirror.AnnotatedDeclaredType ast = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.atypeFactory.toAnnotatedType((TypeMirror)var5_11, false);
                supertypes.add(ast);
                if (!type.wasRaw() || var5_11.getKind() != TypeKind.DECLARED) continue;
                List<? extends TypeMirror> typeArgs = ((DeclaredType)var5_11).getTypeArguments();
                List<AnnotatedTypeMirror> annotatedTypeArgs = ast.getTypeArguments();
                for (int i = 0; i < typeArgs.size(); ++i) {
                    this.atypeFactory.addComputedTypeAnnotations(this.types.asElement(typeArgs.get(i)), annotatedTypeArgs.get(i));
                }
            }
            ElementAnnotationApplier.annotateSupers(supertypes, typeElement);
            if (type.wasRaw()) {
                for (AnnotatedTypeMirror.AnnotatedDeclaredType annotatedDeclaredType : supertypes) {
                    annotatedDeclaredType.setWasRaw();
                }
            }
            return supertypes;
        }

        private List<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypesFromTree(AnnotatedTypeMirror.AnnotatedDeclaredType type, ClassTree classTree) {
            ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes = new ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType>();
            if (classTree.getExtendsClause() != null) {
                AnnotatedTypeMirror.AnnotatedDeclaredType adt2 = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.atypeFactory.getAnnotatedTypeFromTypeTree(classTree.getExtendsClause());
                supertypes.add(adt2);
            } else if (!ElementUtils.isObject(TreeUtils.elementFromDeclaration(classTree))) {
                supertypes.add(AnnotatedTypeMirror.createTypeOfObject(this.atypeFactory));
            }
            for (Tree tree : classTree.getImplementsClause()) {
                AnnotatedTypeMirror.AnnotatedDeclaredType adt3 = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.atypeFactory.getAnnotatedTypeFromTypeTree(tree);
                supertypes.add(adt3);
            }
            TypeElement elem = TreeUtils.elementFromDeclaration(classTree);
            if (elem.getKind() == ElementKind.ENUM) {
                DeclaredType declaredType = (DeclaredType)elem.getSuperclass();
                AnnotatedTypeMirror.AnnotatedDeclaredType adt = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.atypeFactory.toAnnotatedType(declaredType, false);
                List<AnnotatedTypeMirror> tas = adt.getTypeArguments();
                ArrayList<AnnotatedTypeMirror> newtas = new ArrayList<AnnotatedTypeMirror>();
                for (AnnotatedTypeMirror t : tas) {
                    if (!this.atypeFactory.types.isSameType(t.getUnderlyingType(), type.getUnderlyingType())) continue;
                    t.addAnnotations(type.getAnnotations());
                    newtas.add(t);
                }
                adt.setTypeArguments(newtas);
                supertypes.add(adt);
            }
            if (type.wasRaw()) {
                for (AnnotatedTypeMirror.AnnotatedDeclaredType adt : supertypes) {
                    adt.setWasRaw();
                }
            }
            return supertypes;
        }

        @Override
        public List<AnnotatedTypeMirror> visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, Void p) {
            ArrayList<AnnotatedTypeMirror> superTypes = new ArrayList<AnnotatedTypeMirror>();
            Set<AnnotationMirror> annotations = type.getAnnotations();
            Elements elements = this.atypeFactory.elements;
            AnnotatedTypeMirror.AnnotatedDeclaredType objectType = this.atypeFactory.getAnnotatedType(elements.getTypeElement("java.lang.Object"));
            objectType.addAnnotations(annotations);
            superTypes.add(objectType);
            AnnotatedTypeMirror.AnnotatedDeclaredType cloneableType = this.atypeFactory.getAnnotatedType(elements.getTypeElement("java.lang.Cloneable"));
            cloneableType.addAnnotations(annotations);
            superTypes.add(cloneableType);
            AnnotatedTypeMirror.AnnotatedDeclaredType serializableType = this.atypeFactory.getAnnotatedType(elements.getTypeElement("java.io.Serializable"));
            serializableType.addAnnotations(annotations);
            superTypes.add(serializableType);
            for (AnnotatedTypeMirror annotatedTypeMirror : type.getComponentType().directSuperTypes()) {
                ArrayType arrType = this.atypeFactory.types.getArrayType(annotatedTypeMirror.getUnderlyingType());
                AnnotatedTypeMirror.AnnotatedArrayType aarrType = (AnnotatedTypeMirror.AnnotatedArrayType)this.atypeFactory.toAnnotatedType(arrType, false);
                aarrType.setComponentType(annotatedTypeMirror);
                aarrType.addAnnotations(annotations);
                superTypes.add(aarrType);
            }
            return superTypes;
        }

        @Override
        public List<AnnotatedTypeMirror> visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, Void p) {
            ArrayList<AnnotatedTypeMirror> superTypes = new ArrayList<AnnotatedTypeMirror>();
            superTypes.add(type.getUpperBound().deepCopy());
            return superTypes;
        }

        @Override
        public List<AnnotatedTypeMirror> visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, Void p) {
            ArrayList<AnnotatedTypeMirror> superTypes = new ArrayList<AnnotatedTypeMirror>();
            superTypes.add(type.getExtendsBound().deepCopy());
            return superTypes;
        }

        private static class TypeParamReplacer
        extends AnnotatedTypeScanner<Void, Map<TypeParameterElement, AnnotatedTypeMirror>> {
            private final Types types;

            public TypeParamReplacer(Types types) {
                this.types = types;
            }

            @Override
            public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Map<TypeParameterElement, AnnotatedTypeMirror> mapping) {
                if (this.visitedNodes.containsKey(type)) {
                    return (Void)this.visitedNodes.get(type);
                }
                this.visitedNodes.put(type, null);
                if (type.getEnclosingType() != null) {
                    this.scan(type.getEnclosingType(), mapping);
                }
                ArrayList<AnnotatedTypeMirror> args = new ArrayList<AnnotatedTypeMirror>();
                for (AnnotatedTypeMirror arg : type.getTypeArguments()) {
                    Element elem = this.types.asElement(arg.getUnderlyingType());
                    if (elem != null && elem.getKind() == ElementKind.TYPE_PARAMETER && mapping.containsKey(elem)) {
                        AnnotatedTypeMirror other = mapping.get(elem).deepCopy();
                        other.replaceAnnotations(arg.getAnnotationsField());
                        args.add(other);
                        continue;
                    }
                    args.add(arg);
                    this.scan(arg, mapping);
                }
                type.setTypeArguments(args);
                return null;
            }

            @Override
            public Void visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, Map<TypeParameterElement, AnnotatedTypeMirror> mapping) {
                AnnotatedTypeMirror comptype = type.getComponentType();
                Element elem = this.types.asElement(comptype.getUnderlyingType());
                if (elem != null && elem.getKind() == ElementKind.TYPE_PARAMETER && mapping.containsKey(elem)) {
                    AnnotatedTypeMirror other = mapping.get(elem);
                    other.replaceAnnotations(comptype.getAnnotationsField());
                    type.setComponentType(other);
                } else {
                    this.scan(type.getComponentType(), mapping);
                }
                return null;
            }
        }
    }
}

