/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Criterion;
import annotator.scanner.CommonScanner;
import annotator.scanner.InitBlockScanner;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

public class InInitBlockCriterion
implements Criterion {
    public final int blockID;
    public final boolean isStatic;
    public final Criterion notInMethodCriterion;

    public InInitBlockCriterion(int n, boolean bl) {
        this.blockID = n;
        this.isStatic = bl;
        this.notInMethodCriterion = Criteria.notInMethod();
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        while (treePath != null) {
            if (CommonScanner.isInitBlock(treePath, this.isStatic)) {
                int n = InitBlockScanner.indexOfInitTree(treePath, this.isStatic);
                return n == this.blockID;
            }
            treePath = treePath.getParentPath();
        }
        return false;
    }

    @Override
    public Criterion.Kind getKind() {
        return this.isStatic ? Criterion.Kind.IN_STATIC_INIT : Criterion.Kind.IN_INSTANCE_INIT;
    }

    public String toString() {
        return "In " + (this.isStatic ? "static" : "instance") + " initializer with index " + this.blockID;
    }
}

