/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Criterion;
import annotator.scanner.NewScanner;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import scenelib.annotations.el.RelativeLocation;

public class NewCriterion
implements Criterion {
    private final String methodName;
    private final Criterion inMethodCriterion;
    private final RelativeLocation loc;

    public NewCriterion(String string, RelativeLocation relativeLocation) {
        this.methodName = string.substring(0, string.lastIndexOf(")") + 1);
        this.inMethodCriterion = !string.startsWith("init for field") && !string.startsWith("static init number") && !string.startsWith("instance init number") ? Criteria.inMethod(string) : null;
        this.loc = relativeLocation;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Tree tree = treePath.getLeaf();
        if (this.inMethodCriterion != null && !this.inMethodCriterion.isSatisfiedBy(treePath)) {
            return this.isSatisfiedBy(treePath.getParentPath());
        }
        if (tree.getKind() == Tree.Kind.NEW_CLASS || tree.getKind() == Tree.Kind.NEW_ARRAY) {
            int n;
            int n2 = NewScanner.indexOfNewTree(treePath, tree);
            boolean bl = this.loc.isBytecodeOffset() ? n2 == (n = NewScanner.getMethodNewIndex(this.methodName, this.loc.offset).intValue()) : n2 == this.loc.index;
            return bl;
        }
        return this.isSatisfiedBy(treePath.getParentPath());
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.NEW;
    }

    public String toString() {
        return "NewCriterion in method: " + this.methodName + " at location " + this.loc;
    }
}

