/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.SubtypeVisitHistory;
import org.checkerframework.framework.type.visitor.AbstractAtmComboVisitor;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.AtmCombo;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.PluginUtil;
import org.checkerframework.javacutil.TypesUtils;

public class StructuralEqualityComparer
extends AbstractAtmComboVisitor<Boolean, Void> {
    protected final SubtypeVisitHistory visitHistory;
    private AnnotationMirror currentTop = null;

    public StructuralEqualityComparer(SubtypeVisitHistory typeargVisitHistory) {
        this.visitHistory = typeargVisitHistory;
    }

    @Override
    protected Boolean defaultAction(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, Void p) {
        if (type1.atypeFactory.ignoreUninferredTypeArguments) {
            if (type1.getKind() == TypeKind.WILDCARD && ((AnnotatedTypeMirror.AnnotatedWildcardType)type1).isUninferredTypeArgument()) {
                return true;
            }
            if (type2.getKind() == TypeKind.WILDCARD && ((AnnotatedTypeMirror.AnnotatedWildcardType)type2).isUninferredTypeArgument()) {
                return true;
            }
        }
        if (type1.getKind() == TypeKind.TYPEVAR || type2.getKind() == TypeKind.TYPEVAR) {
            return true;
        }
        if (type1.getKind() == TypeKind.NULL || type2.getKind() == TypeKind.NULL) {
            return this.arePrimeAnnosEqual(type1, type2);
        }
        return (Boolean)super.defaultAction(type1, type2, p);
    }

    @Override
    protected String defaultErrorMessage(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, Void p) {
        return "AnnotatedTypeMirrors aren't structurally equal.\n  type1 = " + type1.getClass().getSimpleName() + "( " + type1 + " )\n  type2 = " + type2.getClass().getSimpleName() + "( " + type2 + " )\n  visitHistory = " + this.visitHistory;
    }

    private boolean areEqual(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
        assert (this.currentTop != null);
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        return AtmCombo.accept(type1, type2, null, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areEqualInHierarchy(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, AnnotationMirror top) {
        boolean areEqual;
        assert (top != null);
        AnnotationMirror prevTop = this.currentTop;
        this.currentTop = top;
        try {
            areEqual = this.areEqual(type1, type2);
        }
        finally {
            this.currentTop = prevTop;
        }
        return areEqual;
    }

    protected boolean arePrimeAnnosEqual(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
        if (this.currentTop != null) {
            return AnnotationUtils.areSame(type1.getAnnotationInHierarchy(this.currentTop), type2.getAnnotationInHierarchy(this.currentTop));
        }
        throw new BugInCF("currentTop null");
    }

    protected boolean areAllEqual(Collection<? extends AnnotatedTypeMirror> types1, Collection<? extends AnnotatedTypeMirror> types2) {
        if (types1.size() != types2.size()) {
            throw new BugInCF("Mismatching collection sizes:\n    types 1: " + PluginUtil.join("; ", types1) + " (" + types1.size() + ")\n    types 2: " + PluginUtil.join("; ", types2) + " (" + types2.size() + ")");
        }
        Iterator<? extends AnnotatedTypeMirror> types1Iter = types1.iterator();
        Iterator<? extends AnnotatedTypeMirror> types2Iter = types2.iterator();
        while (types1Iter.hasNext()) {
            AnnotatedTypeMirror type2;
            AnnotatedTypeMirror type1 = types1Iter.next();
            if (this.checkOrAreEqual(type1, type2 = types2Iter.next())) continue;
            return false;
        }
        return true;
    }

    protected boolean checkOrAreEqual(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
        if (this.visitHistory.contains(type1, type2, this.currentTop)) {
            return true;
        }
        Boolean result = this.areEqual(type1, type2);
        this.visitHistory.add(type1, type2, this.currentTop, result);
        return result;
    }

    @Override
    public Boolean visitArray_Array(AnnotatedTypeMirror.AnnotatedArrayType type1, AnnotatedTypeMirror.AnnotatedArrayType type2, Void p) {
        if (!this.arePrimeAnnosEqual(type1, type2)) {
            return false;
        }
        return this.areEqual(type1.getComponentType(), type2.getComponentType());
    }

    @Override
    public Boolean visitDeclared_Declared(AnnotatedTypeMirror.AnnotatedDeclaredType type1, AnnotatedTypeMirror.AnnotatedDeclaredType type2, Void p) {
        if (this.visitHistory.contains(type1, type2, this.currentTop)) {
            return true;
        }
        if (!this.arePrimeAnnosEqual(type1, type2)) {
            return false;
        }
        this.visitHistory.add(type1, type2, this.currentTop, true);
        Boolean result = this.visitTypeArgs(type1, type2);
        this.visitHistory.add(type1, type2, this.currentTop, result);
        return result;
    }

    protected Boolean visitTypeArgs(AnnotatedTypeMirror.AnnotatedDeclaredType type1, AnnotatedTypeMirror.AnnotatedDeclaredType type2) {
        List<AnnotatedTypeMirror> type1Args = type1.getTypeArguments();
        List<AnnotatedTypeMirror> type2Args = type2.getTypeArguments();
        if (type1Args.isEmpty() && type2Args.isEmpty()) {
            return true;
        }
        if (type1Args.size() == type2Args.size()) {
            return this.areAllEqual(type1Args, type2Args);
        }
        return true;
    }

    @Override
    public Boolean visitIntersection_Intersection(AnnotatedTypeMirror.AnnotatedIntersectionType type1, AnnotatedTypeMirror.AnnotatedIntersectionType type2, Void p) {
        if (!this.arePrimeAnnosEqual(type1, type2)) {
            return false;
        }
        Boolean result = this.areAllEqual(type1.directSuperTypes(), type2.directSuperTypes());
        this.visitHistory.add(type1, type2, this.currentTop, result);
        return result;
    }

    @Override
    public Boolean visitPrimitive_Primitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type1, AnnotatedTypeMirror.AnnotatedPrimitiveType type2, Void p) {
        return this.arePrimeAnnosEqual(type1, type2);
    }

    @Override
    public Boolean visitTypevar_Typevar(AnnotatedTypeMirror.AnnotatedTypeVariable type1, AnnotatedTypeMirror.AnnotatedTypeVariable type2, Void p) {
        if (this.visitHistory.contains(type1, type2, this.currentTop)) {
            return true;
        }
        if ((TypesUtils.isCaptured(type1.getUnderlyingType()) || TypesUtils.isCaptured(type2.getUnderlyingType())) && !this.boundsMatch(type1, type2)) {
            Boolean result = this.subtypeAndCompare(type1.getUpperBound(), type2.getUpperBound()) && this.subtypeAndCompare(type1.getLowerBound(), type2.getLowerBound());
            this.visitHistory.add(type1, type2, this.currentTop, result);
            return result;
        }
        Boolean result = this.areEqual(type1.getUpperBound(), type2.getUpperBound()) && this.areEqual(type1.getLowerBound(), type2.getLowerBound());
        this.visitHistory.add(type1, type2, this.currentTop, result);
        return result;
    }

    boolean subtypeAndCompare(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
        AnnotatedTypeMirror t2;
        AnnotatedTypeMirror t1;
        Types types = type1.atypeFactory.types;
        if (type1.getKind() == TypeKind.NULL && type2.getKind() == TypeKind.NULL) {
            return this.areEqual(type1, type2);
        }
        if (type1.getKind() == TypeKind.NULL || type2.getKind() == TypeKind.NULL) {
            t1 = type1;
            t2 = type2;
        } else if (types.isSubtype(type2.getUnderlyingType(), type1.getUnderlyingType())) {
            t1 = type1;
            t2 = AnnotatedTypes.asSuper(type1.atypeFactory, type2, type1);
        } else if (types.isSubtype(type1.getUnderlyingType(), type2.getUnderlyingType())) {
            t1 = AnnotatedTypes.asSuper(type1.atypeFactory, type1, type2);
            t2 = type2;
        } else {
            t1 = null;
            t2 = null;
        }
        if (t1 == null || t2 == null) {
            QualifierHierarchy qualifierHierarchy = type1.atypeFactory.getQualifierHierarchy();
            if (this.currentTop != null) {
                return AnnotationUtils.areSame(AnnotatedTypes.findEffectiveAnnotationInHierarchy(qualifierHierarchy, type1, this.currentTop), AnnotatedTypes.findEffectiveAnnotationInHierarchy(qualifierHierarchy, type2, this.currentTop));
            }
            throw new BugInCF("currentTop null");
        }
        return this.areEqual(t1, t2);
    }

    public boolean boundsMatch(AnnotatedTypeMirror.AnnotatedTypeVariable type1, AnnotatedTypeMirror.AnnotatedTypeVariable type2) {
        Types types = type1.atypeFactory.types;
        return types.isSameType(type1.getUpperBound().getUnderlyingType(), type2.getUpperBound().getUnderlyingType()) && types.isSameType(type1.getLowerBound().getUnderlyingType(), type2.getLowerBound().getUnderlyingType());
    }

    @Override
    public Boolean visitWildcard_Wildcard(AnnotatedTypeMirror.AnnotatedWildcardType type1, AnnotatedTypeMirror.AnnotatedWildcardType type2, Void p) {
        if (this.visitHistory.contains(type1, type2, this.currentTop)) {
            return true;
        }
        if (type1.atypeFactory.ignoreUninferredTypeArguments && (type1.isUninferredTypeArgument() || type2.isUninferredTypeArgument())) {
            return true;
        }
        Boolean result = this.areEqual(type1.getExtendsBound(), type2.getExtendsBound()) && this.areEqual(type1.getSuperBound(), type2.getSuperBound());
        this.visitHistory.add(type1, type2, this.currentTop, result);
        return result;
    }

    @Override
    public Boolean visitDeclared_Primitive(AnnotatedTypeMirror.AnnotatedDeclaredType type1, AnnotatedTypeMirror.AnnotatedPrimitiveType type2, Void p) {
        if (!TypesUtils.isBoxOf(type1.getUnderlyingType(), type2.getUnderlyingType())) {
            this.defaultErrorMessage((AnnotatedTypeMirror)type1, (AnnotatedTypeMirror)type2, p);
        }
        return this.arePrimeAnnosEqual(type1, type2);
    }

    @Override
    public Boolean visitPrimitive_Declared(AnnotatedTypeMirror.AnnotatedPrimitiveType type1, AnnotatedTypeMirror.AnnotatedDeclaredType type2, Void p) {
        if (!TypesUtils.isBoxOf(type2.getUnderlyingType(), type1.getUnderlyingType())) {
            this.defaultErrorMessage((AnnotatedTypeMirror)type1, (AnnotatedTypeMirror)type2, p);
        }
        return this.arePrimeAnnosEqual(type1, type2);
    }

    @Override
    public Boolean visitWildcard_Typevar(AnnotatedTypeMirror.AnnotatedWildcardType type1, AnnotatedTypeMirror.AnnotatedTypeVariable type2, Void p) {
        if (this.visitHistory.contains(type1, type2, this.currentTop)) {
            return true;
        }
        if (type1.atypeFactory.ignoreUninferredTypeArguments && type1.isUninferredTypeArgument()) {
            return true;
        }
        Boolean result = this.areEqual(type1.getExtendsBound(), type2.getUpperBound()) && this.areEqual(type1.getSuperBound(), type2.getLowerBound());
        this.visitHistory.add(type1, type2, this.currentTop, result);
        return result;
    }

    @Override
    public Boolean visitWildcard_Declared(AnnotatedTypeMirror.AnnotatedWildcardType type1, AnnotatedTypeMirror.AnnotatedDeclaredType type2, Void p) {
        if (type1.atypeFactory.ignoreUninferredTypeArguments && type1.isUninferredTypeArgument()) {
            return true;
        }
        return this.arePrimeAnnosEqual(type1.getExtendsBound(), type2);
    }

    @Override
    public Boolean visitDeclared_Wildcard(AnnotatedTypeMirror.AnnotatedDeclaredType type1, AnnotatedTypeMirror.AnnotatedWildcardType type2, Void p) {
        if (type2.atypeFactory.ignoreUninferredTypeArguments && type2.isUninferredTypeArgument()) {
            return true;
        }
        QualifierHierarchy qualifierHierarchy = type1.atypeFactory.getQualifierHierarchy();
        AnnotationMirror q1 = AnnotatedTypes.findEffectiveAnnotationInHierarchy(qualifierHierarchy, type1, this.currentTop);
        AnnotationMirror q2 = AnnotatedTypes.findEffectiveAnnotationInHierarchy(qualifierHierarchy, type2, this.currentTop);
        Boolean result = qualifierHierarchy.isSubtype(q1, q2);
        this.visitHistory.add(type1, type2, this.currentTop, result);
        return result;
    }
}

