/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type.poly;

import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.qual.PolymorphicQualifier;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AnnotationUtils;

public interface QualifierPolymorphism {
    public static boolean isPolyAll(AnnotationMirror qual) {
        return AnnotationUtils.areSameByClass(qual, PolyAll.class);
    }

    public static AnnotationMirror getPolymorphicQualifier(AnnotationMirror qual) {
        if (qual == null) {
            return null;
        }
        Element qualElt = qual.getAnnotationType().asElement();
        for (AnnotationMirror annotationMirror : qualElt.getAnnotationMirrors()) {
            if (!AnnotationUtils.areSameByClass(annotationMirror, PolymorphicQualifier.class)) continue;
            return annotationMirror;
        }
        return null;
    }

    @Deprecated
    public static boolean isPolymorphicQualified(AnnotationMirror qual) {
        return QualifierPolymorphism.getPolymorphicQualifier(qual) != null;
    }

    public static boolean hasPolymorphicQualifier(AnnotationMirror qual) {
        return QualifierPolymorphism.getPolymorphicQualifier(qual) != null;
    }

    @Deprecated
    public static Name getPolymorphicQualifierTop(AnnotationMirror qual) {
        AnnotationMirror poly = QualifierPolymorphism.getPolymorphicQualifier(qual);
        if (poly == null) {
            return null;
        }
        Name ret = AnnotationUtils.getElementValueClassName(poly, "value", true);
        return ret;
    }

    public static Name getPolymorphicQualifierElement(AnnotationMirror qual) {
        AnnotationMirror poly = QualifierPolymorphism.getPolymorphicQualifier(qual);
        if (poly == null) {
            return null;
        }
        Name ret = AnnotationUtils.getElementValueClassName(poly, "value", true);
        return ret;
    }

    public void annotate(MethodInvocationTree var1, AnnotatedTypeMirror.AnnotatedExecutableType var2);

    public void annotate(NewClassTree var1, AnnotatedTypeMirror.AnnotatedExecutableType var2);

    public void annotate(AnnotatedTypeMirror.AnnotatedExecutableType var1, AnnotatedTypeMirror.AnnotatedExecutableType var2);
}

