/*
 * Decompiled with CFR 0.152.
 */
package annotator;

import annotator.Source;
import annotator.find.AnnotationInsertion;
import annotator.find.CastInsertion;
import annotator.find.ConstructorInsertion;
import annotator.find.Criteria;
import annotator.find.GenericArrayLocationCriterion;
import annotator.find.Insertion;
import annotator.find.Insertions;
import annotator.find.NewInsertion;
import annotator.find.ReceiverInsertion;
import annotator.find.TreeFinder;
import annotator.find.TypedInsertion;
import annotator.scanner.LocalVariableScanner;
import annotator.specification.IndexFileSpecification;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javac.tree.JCTree;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.com.google.common.collect.LinkedHashMultimap;
import org.checkerframework.com.google.common.collect.Multimap;
import org.checkerframework.org.plumelib.options.Option;
import org.checkerframework.org.plumelib.options.OptionGroup;
import org.checkerframework.org.plumelib.options.Options;
import org.checkerframework.org.plumelib.util.FileIOException;
import org.checkerframework.org.plumelib.util.Pair;
import org.checkerframework.org.plumelib.util.UtilPlume;
import scenelib.annotations.Annotation;
import scenelib.annotations.el.ABlock;
import scenelib.annotations.el.AClass;
import scenelib.annotations.el.ADeclaration;
import scenelib.annotations.el.AElement;
import scenelib.annotations.el.AExpression;
import scenelib.annotations.el.AField;
import scenelib.annotations.el.AMethod;
import scenelib.annotations.el.AScene;
import scenelib.annotations.el.ATypeElement;
import scenelib.annotations.el.ATypeElementWithType;
import scenelib.annotations.el.AnnotationDef;
import scenelib.annotations.el.DefException;
import scenelib.annotations.el.ElementVisitor;
import scenelib.annotations.el.LocalLocation;
import scenelib.annotations.io.ASTIndex;
import scenelib.annotations.io.ASTPath;
import scenelib.annotations.io.ASTRecord;
import scenelib.annotations.io.DebugWriter;
import scenelib.annotations.io.IndexFileParser;
import scenelib.annotations.io.IndexFileWriter;
import scenelib.annotations.util.coll.VivifyingMap;
import scenelib.type.DeclaredType;
import scenelib.type.Type;

public class Main {
    @OptionGroup(value="General options")
    @Option(value="-d <directory> Directory in which output files are written")
    public static String outdir = "annotated/";
    @Option(value="-i Overwrite original source files")
    public static boolean in_place = false;
    @Option(value="-a Abbreviate annotation names")
    public static boolean abbreviate = true;
    @Option(value="-c Insert annotations in comments")
    public static boolean comments = false;
    @Option(value="-o Omit given annotation")
    public static String omit_annotation;
    @Option(value="Suppress warnings about disallowed insertions")
    public static boolean nowarn;
    @Option(value="Convert JAIFs to AST Path format")
    public static boolean convert_jaifs;
    @Option(value="-h Print usage information and exit")
    public static boolean help;
    @OptionGroup(value="Debugging options")
    @Option(value="-v Verbose (print progress information)")
    public static boolean verbose;
    @Option(value="Debug (print debug information)")
    public static boolean debug;
    @Option(value="Print error stack")
    public static boolean print_error_stack;
    public static boolean temporaryDebug;
    private static ElementVisitor<Void, AElement> classFilter;
    private static Pattern javaLangClassPattern;

    private static AScene filteredScene(AScene aScene) {
        AScene aScene2 = new AScene();
        aScene2.packages.putAll(aScene.packages);
        aScene2.imports.putAll(aScene.imports);
        for (Map.Entry entry : aScene.classes.entrySet()) {
            String string = (String)entry.getKey();
            AClass aClass = (AClass)entry.getValue();
            AClass aClass2 = aScene2.classes.getVivify(string);
            aClass.accept(classFilter, aClass2);
        }
        aScene2.prune();
        return aScene2;
    }

    private static ATypeElement findInnerTypeElement(Tree tree, ASTRecord aSTRecord, ADeclaration aDeclaration, Type type, Insertion insertion) {
        ASTPath aSTPath = aSTRecord.astPath;
        GenericArrayLocationCriterion genericArrayLocationCriterion = insertion.getCriteria().getGenericArrayLocation();
        assert (aSTPath != null && genericArrayLocationCriterion != null);
        List<TypeAnnotationPosition.TypePathEntry> list = genericArrayLocationCriterion.getLocation();
        for (TypeAnnotationPosition.TypePathEntry typePathEntry : list) {
            ASTPath.ASTEntry aSTEntry;
            switch (typePathEntry.tag) {
                case ARRAY: {
                    if (!aSTPath.isEmpty() && (aSTEntry = aSTPath.getLast()).getTreeKind() == Tree.Kind.NEW_ARRAY && aSTEntry.childSelectorIs("type")) {
                        aSTEntry = new ASTPath.ASTEntry(Tree.Kind.NEW_ARRAY, "type", aSTEntry.getArgument() + 1);
                        break;
                    }
                    aSTEntry = new ASTPath.ASTEntry(Tree.Kind.ARRAY_TYPE, "type");
                    break;
                }
                case INNER_TYPE: {
                    aSTEntry = new ASTPath.ASTEntry(Tree.Kind.MEMBER_SELECT, "expression");
                    break;
                }
                case TYPE_ARGUMENT: {
                    aSTEntry = new ASTPath.ASTEntry(Tree.Kind.PARAMETERIZED_TYPE, "typeArgument", typePathEntry.arg);
                    break;
                }
                case WILDCARD: {
                    aSTEntry = new ASTPath.ASTEntry(Tree.Kind.UNBOUNDED_WILDCARD, "bound");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown type tag " + (Object)((Object)typePathEntry.tag));
                }
            }
            aSTPath = aSTPath.extend(aSTEntry);
        }
        return aDeclaration.insertAnnotations.getVivify(aSTPath);
    }

    /*
     * WARNING - void declaration
     */
    private static void convertInsertion(String string, JCTree.JCCompilationUnit jCCompilationUnit, ASTRecord aSTRecord, Insertion insertion, AScene aScene, Multimap<Insertion, Annotation> multimap) {
        block30: {
            Collection<Annotation> collection;
            block29: {
                collection = multimap.get(insertion);
                if (aSTRecord != null) break block29;
                if (!insertion.getCriteria().isOnPackage()) break block30;
                for (Annotation annotation : collection) {
                    ((AElement)aScene.packages.get((Object)string)).tlAnnotationsHere.add(annotation);
                }
                break block30;
            }
            if (aScene != null && aSTRecord.className != null) {
                Cloneable cloneable;
                Tree tree;
                int n;
                AClass aClass = aScene.classes.getVivify(aSTRecord.className);
                ADeclaration aDeclaration = null;
                if (insertion.getCriteria().onBoundZero() && !((ASTPath.ASTEntry)aSTRecord.astPath.get((n = aSTRecord.astPath.size()) - 1)).childSelectorIs("bound")) {
                    ASTPath aSTPath = ASTPath.empty();
                    for (int i = 0; i < n; ++i) {
                        aSTPath = aSTPath.extend((ASTPath.ASTEntry)aSTRecord.astPath.get(i));
                    }
                    aSTPath = aSTPath.extend(new ASTPath.ASTEntry(Tree.Kind.TYPE_PARAMETER, "bound", 0));
                    aSTRecord = aSTRecord.replacePath(aSTPath);
                }
                if (aSTRecord.methodName == null) {
                    aDeclaration = aSTRecord.varName == null ? aClass : (ADeclaration)aClass.fields.getVivify(aSTRecord.varName);
                } else {
                    AMethod aMethod = aClass.methods.getVivify(aSTRecord.methodName);
                    if (aSTRecord.varName == null) {
                        aDeclaration = aMethod;
                    } else {
                        try {
                            int n2 = Integer.parseInt(aSTRecord.varName);
                            aDeclaration = n2 < 0 ? aMethod.receiver : (ADeclaration)aMethod.parameters.getVivify(n2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            Object object;
                            TreePath treePath = ASTIndex.getTreePath(jCCompilationUnit, aSTRecord);
                            Object object2 = null;
                            tree = null;
                            cloneable = null;
                            block9: while (treePath != null) {
                                object = treePath.getLeaf();
                                switch (object.getKind()) {
                                    case VARIABLE: {
                                        JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)object;
                                        continue block9;
                                    }
                                    case METHOD: {
                                        tree = (JCTree.JCMethodDecl)object;
                                        continue block9;
                                    }
                                    case ANNOTATION: 
                                    case CLASS: 
                                    case ENUM: 
                                    case INTERFACE: {
                                        break block9;
                                    }
                                    default: {
                                        treePath = treePath.getParentPath();
                                        continue block9;
                                    }
                                }
                            }
                            while (treePath != null) {
                                object = treePath.getLeaf();
                                Tree.Kind kind = object.getKind();
                                if (kind == Tree.Kind.METHOD) {
                                    void var12_24;
                                    tree = (JCTree.JCMethodDecl)object;
                                    int n2 = LocalVariableScanner.indexOfVarTree(treePath, (Tree)var12_24, aSTRecord.varName);
                                    int n3 = tree.getStartPosition();
                                    int n4 = var12_24.getStartPosition();
                                    int n5 = var12_24.getEndPosition(jCCompilationUnit.endPositions);
                                    LocalLocation localLocation = new LocalLocation(n2, n4 - n3, n5 - n4);
                                    aDeclaration = aMethod.body.locals.getVivify(localLocation);
                                    break;
                                }
                                if (ASTPath.isClassEquiv(kind)) {
                                    cloneable = (JCTree.JCClassDecl)object;
                                    break;
                                }
                                treePath = treePath.getParentPath();
                            }
                        }
                    }
                }
                if (aDeclaration != null) {
                    AElement aElement;
                    if (aSTRecord.astPath.isEmpty()) {
                        aElement = aDeclaration;
                    } else if (insertion.getKind() == Insertion.Kind.CAST) {
                        ATypeElementWithType aTypeElementWithType = aDeclaration.insertTypecasts.getVivify(aSTRecord.astPath);
                        aTypeElementWithType.setType(((CastInsertion)insertion).getType());
                        aElement = aTypeElementWithType;
                    } else {
                        aElement = aDeclaration.insertAnnotations.getVivify(aSTRecord.astPath);
                    }
                    for (Annotation annotation : collection) {
                        aElement.tlAnnotationsHere.add(annotation);
                    }
                    if (insertion instanceof TypedInsertion) {
                        TypedInsertion typedInsertion = (TypedInsertion)insertion;
                        if (!aSTRecord.astPath.isEmpty()) {
                            // empty if block
                        }
                        for (Insertion insertion2 : typedInsertion.getInnerTypeInsertions()) {
                            tree = ASTIndex.getNode(jCCompilationUnit, aSTRecord);
                            if (tree == null) continue;
                            cloneable = Main.findInnerTypeElement(tree, aSTRecord, aDeclaration, typedInsertion.getType(), insertion2);
                            for (Annotation annotation : multimap.get(insertion2)) {
                                ((ATypeElement)cloneable).tlAnnotationsHere.add(annotation);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
        Object object;
        AbstractCollection iOException3;
        ArrayList fileIOException;
        Object object2;
        String[] stringArray2;
        Object object3;
        if (verbose) {
            System.out.printf("insert-annotations-to-source (%s)", "Annotation File Utilities v3.6.47");
        }
        Options options = new Options("Main [options] { jaif-file | java-file | @arg-file } ...\n(Contents of argfiles are expanded into the argument list.)", Main.class);
        try {
            object3 = CommandLine.parse(stringArray);
            stringArray2 = options.parse(true, (String[])object3);
        }
        catch (IOException iOException2) {
            System.err.println(iOException2);
            System.err.println("(For non-argfile beginning with \"@\", use \"@@\" for initial \"@\".");
            System.err.println("Alternative for filenames: indicate directory, e.g. as './@file'.");
            System.err.println("Alternative for flags: use '=', as in '-o=@Deprecated'.)");
            stringArray2 = null;
            System.exit(1);
        }
        object3 = new DebugWriter();
        DebugWriter debugWriter = new DebugWriter();
        DebugWriter debugWriter2 = ((DebugWriter)object3).or(debugWriter);
        ((DebugWriter)object3).setEnabled(debug);
        debugWriter.setEnabled(verbose);
        TreeFinder.warn.setEnabled(!nowarn);
        TreeFinder.stak.setEnabled(print_error_stack);
        TreeFinder.dbug.setEnabled(debug);
        Criteria.dbug.setEnabled(debug);
        if (help) {
            options.printUsage();
            System.exit(0);
        }
        if (in_place && outdir != "annotated/") {
            System.out.println("The --outdir and --in-place options are mutually exclusive.");
            options.printUsage();
            System.exit(1);
        }
        if (stringArray2.length < 2) {
            System.out.printf("Supplied %d arguments, at least 2 needed%n", stringArray2.length);
            options.printUsage();
            System.exit(1);
        }
        Insertions insertions = new Insertions();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        HashMap hashMap = new HashMap();
        HashMap<Insertion, String> hashMap2 = new HashMap<Insertion, String>();
        HashMap<String, AScene> hashMap3 = new HashMap<String, AScene>();
        HashMap<String, Set<String>> hashMap4 = new HashMap<String, Set<String>>();
        IndexFileParser.setAbbreviate(abbreviate);
        for (String object4 : stringArray2) {
            if (object4.endsWith(".java")) {
                arrayList2.add(object4);
                continue;
            }
            if (object4.endsWith(".jaif") || object4.endsWith(".jann")) {
                object2 = new IndexFileSpecification(object4);
                try {
                    fileIOException = ((IndexFileSpecification)object2).parse();
                    if (temporaryDebug) {
                        System.out.printf("parsedSpec (size %d):%n", fileIOException.size());
                        for (AbstractCollection iOException3 : fileIOException) {
                            System.out.printf("  %s, isInserted=%s%n", iOException3, ((Insertion)((Object)iOException3)).isInserted());
                        }
                    }
                    object = ((IndexFileSpecification)object2).getScene();
                    Collections.sort(fileIOException, new Comparator<Insertion>(){

                        @Override
                        public int compare(Insertion insertion, Insertion insertion2) {
                            ASTPath aSTPath = insertion.getCriteria().getASTPath();
                            ASTPath aSTPath2 = insertion2.getCriteria().getASTPath();
                            return aSTPath == null ? (aSTPath2 == null ? 0 : -1) : (aSTPath2 == null ? 1 : aSTPath.compareTo(aSTPath2));
                        }
                    });
                    if (convert_jaifs) {
                        hashMap3.put(object4, Main.filteredScene((AScene)object));
                        iOException3 = fileIOException.iterator();
                        while (iOException3.hasNext()) {
                            Insertion n = (Insertion)iOException3.next();
                            hashMap2.put(n, object4);
                        }
                        if (!hashMap.containsKey(object4)) {
                            hashMap.put(object4, LinkedHashMultimap.create());
                        }
                        ((Multimap)hashMap.get(object4)).putAll(((IndexFileSpecification)object2).insertionSources());
                    }
                    debugWriter2.debug("Read %d annotations from %s%n", fileIOException.size(), object4);
                    if (omit_annotation != null) {
                        iOException3 = new ArrayList(fileIOException.size());
                        for (Object object5 : fileIOException) {
                            if (omit_annotation.equals(((Insertion)object5).getText())) continue;
                            iOException3.add(object5);
                        }
                        fileIOException = iOException3;
                        debugWriter2.debug("After filtering: %d annotations from %s%n", fileIOException.size(), object4);
                    }
                    insertions.addAll(fileIOException);
                    hashMap4.putAll(((IndexFileSpecification)object2).annotationImports());
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    if (runtimeException.getCause() != null && runtimeException.getCause() instanceof FileNotFoundException) {
                        System.err.println("File not found: " + object4);
                        System.exit(1);
                        continue;
                    }
                    throw runtimeException;
                }
                catch (FileIOException fileIOException2) {
                    System.err.println("Error while parsing annotation file " + object4 + " at line " + (fileIOException2.lineNumber + 1) + ":");
                    if (fileIOException2.getMessage() != null) {
                        System.err.println('\t' + fileIOException2.getMessage());
                    }
                    if (fileIOException2.getCause() != null && fileIOException2.getCause().getMessage() != null) {
                        System.err.println('\t' + fileIOException2.getCause().getMessage());
                    }
                    if (print_error_stack) {
                        fileIOException2.printStackTrace();
                    }
                    System.exit(1);
                    continue;
                }
            }
            throw new Error("Unrecognized file extension: " + object4);
        }
        if (((DebugWriter)object3).isEnabled()) {
            ((DebugWriter)object3).debug("In annotator.Main:%n", new Object[0]);
            ((DebugWriter)object3).debug("%d insertions, %d .java files%n", insertions.size(), arrayList2.size());
            ((DebugWriter)object3).debug("Insertions:%n", new Object[0]);
            for (Insertion insertion : insertions) {
                ((DebugWriter)object3).debug("  %s, isInserted=%s%n", insertion, insertion.isInserted());
            }
        }
        for (String string : arrayList2) {
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            Object object5;
            debugWriter.debug("Processing %s%n", string);
            File file = new File(string);
            File file2 = new File(string + ".unannotated");
            if (in_place && file2.exists()) {
                debugWriter.debug("Renaming %s to %s%n", file2, file);
                boolean bl = file2.renameTo(file);
                if (!bl) {
                    throw new Error(String.format("Failed renaming %s to %s", file2, file));
                }
            }
            object2 = System.getProperty("file.separator");
            fileIOException = System.getProperty("line.separator");
            try {
                fileIOException = UtilPlume.inferLineSeparator(string);
                object = new Source(string);
                debugWriter.debug("Parsed %s%n", string);
            }
            catch (Source.CompilerException compilerException) {
                compilerException.printStackTrace();
                return;
            }
            catch (IOException iOException4) {
                iOException4.printStackTrace();
                return;
            }
            iOException3 = new LinkedHashSet();
            int n = 0;
            object5 = "";
            for (CompilationUnitTree compilationUnitTree : ((Source)object).parse()) {
                Object object10;
                Cloneable cloneable;
                Object object11;
                Iterator iterator;
                object9 = (JCTree.JCCompilationUnit)compilationUnitTree;
                object8 = compilationUnitTree.getPackageName();
                object5 = object8 == null ? "" : object8.toString();
                object7 = new TreeFinder((JCTree.JCCompilationUnit)object9);
                object6 = ((TreeFinder)object7).getPositions((JCTree.JCCompilationUnit)object9, insertions);
                if (((DebugWriter)object3).isEnabled()) {
                    ((DebugWriter)object3).debug("In annotator.Main:%n", new Object[0]);
                    ((DebugWriter)object3).debug("positions (for %d insertions) = %s%n", insertions.size(), object6);
                }
                if (convert_jaifs) {
                    iterator = ((TreeFinder)object7).getPaths();
                    for (Map.Entry entry : iterator.asMap().entrySet()) {
                        object11 = (ASTRecord)entry.getKey();
                        for (Insertion insertion : entry.getValue()) {
                            if (insertion.getCriteria().getASTPath() != null) continue;
                            String string2 = (String)hashMap2.get(insertion);
                            cloneable = (AScene)hashMap3.get(string2);
                            object10 = (Multimap)hashMap.get(string2);
                            if (!object10.containsKey(insertion)) continue;
                            Main.convertInsertion((String)object5, (JCTree.JCCompilationUnit)object9, (ASTRecord)object11, insertion, cloneable, (Multimap<Insertion, Annotation>)object10);
                        }
                    }
                    continue;
                }
                if (debugWriter2.isEnabled()) {
                    System.err.printf("getPositions returned %d positions in tree for %s%n", object6.size(), string);
                }
                iterator = object6.keySet();
                TreeSet<Pair<Integer, ASTPath>> treeSet = new TreeSet<Pair<Integer, ASTPath>>(new Comparator<Pair<Integer, ASTPath>>(){

                    @Override
                    public int compare(Pair<Integer, ASTPath> pair, Pair<Integer, ASTPath> pair2) {
                        int n = Integer.compare((Integer)pair2.a, (Integer)pair.a);
                        if (n != 0) {
                            return n;
                        }
                        return pair2.b == null ? (pair.b == null ? 0 : -1) : (pair.b == null ? 1 : ((ASTPath)pair2.b).compareTo((ASTPath)pair.b));
                    }
                });
                treeSet.addAll((Collection<Pair<Integer, ASTPath>>)((Object)iterator));
                Iterator iterator2 = treeSet.iterator();
                while (iterator2.hasNext()) {
                    object11 = (Pair)iterator2.next();
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    cloneable = new TreeSet();
                    object10 = new ArrayList(object6.get(object11));
                    Collections.reverse(object10);
                    ((DebugWriter)object3).debug("insertion pos: %d%n", ((Pair)object11).a);
                    assert ((Integer)((Pair)object11).a >= 0) : "pos is negative: " + ((Pair)object11).a + " " + object10.get(0) + " " + string;
                    Iterator iterator3 = object10.iterator();
                    while (iterator3.hasNext()) {
                        AnnotationInsertion annotationInsertion;
                        Object object12;
                        Object object13;
                        int n2;
                        Insertion insertion = (Insertion)iterator3.next();
                        String string3 = "";
                        boolean bl4 = false;
                        int n3 = (Integer)((Pair)object11).a;
                        if (insertion.isSeparateLine()) {
                            n2 = 0;
                            while (n3 - n2 != 0 && (((Source)object).charAt(n3 - n2 - 1) == ' ' || ((Source)object).charAt(n3 - n2 - 1) == '\t')) {
                                ++n2;
                            }
                            if (n3 - n2 == 0 || ((Source)object).charAt(n3 - n2 - 1) == '\f' || ((Source)object).charAt(n3 - n2 - 1) == '\n' || ((Source)object).charAt(n3 - n2 - 1) == '\r') {
                                string3 = fileIOException + ((Source)object).substring(n3 - n2, n3);
                                bl4 = true;
                            }
                        }
                        n2 = n3 != 0 ? (int)((Source)object).charAt(n3 - 1) : 0;
                        if (insertion.getKind() == Insertion.Kind.ANNOTATION) {
                            String string4;
                            object13 = (AnnotationInsertion)insertion;
                            if (((AnnotationInsertion)object13).isGenerateBound()) {
                                try {
                                    string4 = ((Source)object).substring(n3, n3 + 9);
                                    if ("Object & ".equals(string4)) {
                                        ((AnnotationInsertion)object13).setGenerateBound(false);
                                        n2 = 46;
                                    }
                                }
                                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                                    // empty catch block
                                }
                            }
                            if (((AnnotationInsertion)object13).isGenerateExtends()) {
                                try {
                                    string4 = ((Source)object).substring(n3, n3 + 9);
                                    if (" extends ".equals(string4)) {
                                        ((AnnotationInsertion)object13).setGenerateExtends(false);
                                        n3 += 8;
                                    }
                                }
                                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                            }
                        } else if (insertion.getKind() == Insertion.Kind.CAST) {
                            ((CastInsertion)insertion).setOnArrayLiteral(((Source)object).charAt(n3) == '{');
                        } else if (insertion.getKind() == Insertion.Kind.RECEIVER) {
                            object13 = (ReceiverInsertion)insertion;
                            ((TypedInsertion)object13).setAnnotationsOnly(bl);
                            bl = true;
                        } else if (insertion.getKind() == Insertion.Kind.NEW) {
                            object13 = (NewInsertion)insertion;
                            ((TypedInsertion)object13).setAnnotationsOnly(bl2);
                            bl2 = true;
                        } else if (insertion.getKind() == Insertion.Kind.CONSTRUCTOR) {
                            object13 = (ConstructorInsertion)insertion;
                            if (bl3) {
                                ((TypedInsertion)object13).setAnnotationsOnly(true);
                            }
                            bl3 = true;
                        }
                        object13 = insertion.getText(comments, abbreviate, bl4, n3, (char)n2) + string3;
                        if (cloneable.contains(object13)) continue;
                        cloneable.add(object13);
                        if (((String)object13).startsWith("@")) {
                            String string5;
                            int n4 = n3 - ((String)object13).length() - 1;
                            if (n4 >= 0 && (((String)object13).equals((string5 = ((Source)object).getString().substring(n4, n3)).substring(0, ((String)object13).length())) || ((String)object13).equals(string5.substring(1)))) {
                                ((DebugWriter)object3).debug("Inserting '%s' at %d in code of length %d with preceding text '%s'%n", object13, n3, ((Source)object).getString().length(), string5);
                                ((DebugWriter)object3).debug("Already present, skipping%n", new Object[0]);
                                continue;
                            }
                            int n5 = n3 + ((String)object13).length();
                            if (n5 < ((Source)object).getString().length()) {
                                object12 = ((Source)object).getString().substring(n3, n5);
                                ((DebugWriter)object3).debug("followingText=\"%s\"%n", object12);
                                ((DebugWriter)object3).debug("toInsert=\"%s\"%n", object13);
                                String string6 = ((String)object13).substring(0, ((String)object13).length() - 1);
                                if (((String)object12).equals(object13) || ((String)object12).substring(0, ((String)object12).length() - 1).equals(string6) && Character.isWhitespace(((Source)object).getString().charAt(n5))) {
                                    ((DebugWriter)object3).debug("Already present, skipping %s%n", string6);
                                    continue;
                                }
                            }
                        }
                        if (insertion.isInserted()) continue;
                        ((Source)object).insert(n3, (String)object13);
                        if (verbose && !debug) {
                            System.out.print(".");
                            if (++n % 50 == 0) {
                                System.out.println();
                            }
                        }
                        ((DebugWriter)object3).debug("Post-insertion source: %n" + ((Source)object).getString(), new Object[0]);
                        Collection<String> collection = Main.nonJavaLangClasses(insertion.getPackageNames());
                        if (!collection.isEmpty()) {
                            ((DebugWriter)object3).debug("Need import %s%n  due to insertion %s%n", collection, object13);
                            iOException3.addAll(collection);
                        }
                        if (!(insertion instanceof AnnotationInsertion) || (object12 = (Set)hashMap4.get((annotationInsertion = (AnnotationInsertion)insertion).getAnnotationFullyQualifiedName())) == null) continue;
                        iOException3.addAll(object12);
                    }
                }
            }
            if (convert_jaifs) {
                for (Map.Entry entry : hashMap3.entrySet()) {
                    object9 = (String)entry.getKey();
                    object8 = (AScene)entry.getValue();
                    try {
                        IndexFileWriter.write((AScene)object8, (String)object9 + ".converted");
                    }
                    catch (DefException defException) {
                        System.err.println((String)object9 + ":  format error in conversion");
                        if (!print_error_stack) continue;
                        defException.printStackTrace();
                    }
                }
                return;
            }
            if (((DebugWriter)object3).isEnabled()) {
                ((DebugWriter)object3).debug("%d imports to insert%n", ((HashSet)iOException3).size());
                for (String string7 : iOException3) {
                    ((DebugWriter)object3).debug("  %s%n", string7);
                }
            }
            Object object14 = Pattern.compile("(?m)^import\\b");
            Pattern pattern = Pattern.compile("(?m)^package\\b.*;(\\n|\\r\\n?)");
            int n6 = 0;
            object8 = ((Source)object).getString();
            object7 = ((Pattern)object14).matcher((CharSequence)object8);
            object6 = new TreeSet();
            if (((Matcher)object7).find()) {
                n6 = ((Matcher)object7).start();
                do {
                    int n7 = ((Matcher)object7).start();
                    int n8 = ((String)object8).indexOf(System.lineSeparator(), n7) + 1;
                    if (n8 <= 0) {
                        n8 = ((String)object8).length();
                    }
                    String string8 = ((String)object8).substring(n7, n8);
                    object6.add(string8);
                } while (((Matcher)object7).find());
            } else {
                object7 = pattern.matcher((CharSequence)object8);
                if (((Matcher)object7).find()) {
                    n6 = ((Matcher)object7).end();
                }
            }
            for (String string9 : iOException3) {
                String string10 = "import " + string9 + ";" + fileIOException;
                if (object6.contains(string10)) continue;
                object6.add(string10);
                ((Source)object).insert(n6, string10);
                n6 += string10.length();
            }
            object14 = null;
            try {
                if (in_place) {
                    boolean bl;
                    object14 = file;
                    if (verbose) {
                        System.out.printf("Renaming %s to %s%n", file, file2);
                    }
                    if (!(bl = file.renameTo(file2))) {
                        throw new Error(String.format("Failed renaming %s to %s", file, file2));
                    }
                } else {
                    if (((String)object5).isEmpty()) {
                        object14 = new File(outdir, file.getName());
                    } else {
                        String[] stringArray3 = ((String)object5).split("\\.");
                        StringBuilder stringBuilder = new StringBuilder(outdir);
                        for (int i = 0; i < stringArray3.length; ++i) {
                            stringBuilder.append((String)object2).append(stringArray3[i]);
                        }
                        object14 = new File(stringBuilder.toString(), file.getName());
                    }
                    ((File)object14).getParentFile().mkdirs();
                }
                FileOutputStream fileOutputStream = new FileOutputStream((File)object14);
                if (verbose) {
                    System.out.printf("Writing %s%n", object14);
                }
                ((Source)object).write(fileOutputStream);
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException5) {
                System.err.println("Problem while writing file " + object14);
                iOException5.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static boolean isJavaLangClass(String string) {
        Matcher matcher = javaLangClassPattern.matcher(string);
        return matcher.matches();
    }

    private static Collection<String> nonJavaLangClasses(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : collection) {
            if (Main.isJavaLangClass(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static String leafString(TreePath treePath) {
        if (treePath == null) {
            return "null";
        }
        return Main.treeToString(treePath.getLeaf());
    }

    public static String treeToString(Tree tree) {
        String string = tree.toString();
        String string2 = Main.firstLine(string);
        return "\"" + string2 + "\"";
    }

    public static String firstLine(String string) {
        while (string.startsWith("\n")) {
            string = string.substring(1);
        }
        int n = string.indexOf(10);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + "...";
    }

    public static Pair<String, String> removeArgs(String string) {
        int n = string.indexOf("(");
        return n == -1 ? Pair.of(string, null) : Pair.of(string.substring(0, n), string.substring(n));
    }

    static {
        convert_jaifs = false;
        help = false;
        debug = false;
        print_error_stack = false;
        temporaryDebug = false;
        classFilter = new ElementVisitor<Void, AElement>(){

            <K, V extends AElement> Void filter(VivifyingMap<K, V> vivifyingMap, VivifyingMap<K, V> vivifyingMap2) {
                for (Map.Entry entry : vivifyingMap.entrySet()) {
                    ((AElement)entry.getValue()).accept(this, vivifyingMap2.getVivify(entry.getKey()));
                }
                return null;
            }

            @Override
            public Void visitAnnotationDef(AnnotationDef annotationDef, AElement aElement) {
                return null;
            }

            @Override
            public Void visitBlock(ABlock aBlock, AElement aElement) {
                ABlock aBlock2 = (ABlock)aElement;
                this.filter(aBlock.locals, aBlock2.locals);
                return this.visitExpression((AExpression)aBlock, aElement);
            }

            @Override
            public Void visitClass(AClass aClass, AElement aElement) {
                AClass aClass2 = (AClass)aElement;
                this.filter(aClass.methods, aClass2.methods);
                this.filter(aClass.fields, aClass2.fields);
                this.filter(aClass.fieldInits, aClass2.fieldInits);
                this.filter(aClass.staticInits, aClass2.staticInits);
                this.filter(aClass.instanceInits, aClass2.instanceInits);
                return this.visitDeclaration((ADeclaration)aClass, aElement);
            }

            @Override
            public Void visitDeclaration(ADeclaration aDeclaration, AElement aElement) {
                ATypeElement aTypeElement;
                ASTPath aSTPath;
                ADeclaration aDeclaration2 = (ADeclaration)aElement;
                VivifyingMap<ASTPath, ATypeElement> vivifyingMap = aDeclaration2.insertAnnotations;
                VivifyingMap<ASTPath, ATypeElementWithType> vivifyingMap2 = aDeclaration2.insertTypecasts;
                for (Map.Entry entry : aDeclaration.insertAnnotations.entrySet()) {
                    aSTPath = (ASTPath)entry.getKey();
                    aTypeElement = (ATypeElement)entry.getValue();
                    vivifyingMap.put(aSTPath, aTypeElement);
                }
                for (Map.Entry entry : aDeclaration.insertTypecasts.entrySet()) {
                    aSTPath = (ASTPath)entry.getKey();
                    aTypeElement = (ATypeElementWithType)entry.getValue();
                    Type type = ((ATypeElementWithType)aTypeElement).getType();
                    if (type instanceof DeclaredType && ((DeclaredType)type).getName().isEmpty()) {
                        vivifyingMap.put(aSTPath, aTypeElement);
                        continue;
                    }
                    vivifyingMap2.put(aSTPath, (ATypeElementWithType)aTypeElement);
                }
                return null;
            }

            @Override
            public Void visitExpression(AExpression aExpression, AElement aElement) {
                AExpression aExpression2 = (AExpression)aElement;
                this.filter(aExpression.typecasts, aExpression2.typecasts);
                this.filter(aExpression.instanceofs, aExpression2.instanceofs);
                this.filter(aExpression.news, aExpression2.news);
                return null;
            }

            @Override
            public Void visitField(AField aField, AElement aElement) {
                return this.visitDeclaration((ADeclaration)aField, aElement);
            }

            @Override
            public Void visitMethod(AMethod aMethod, AElement aElement) {
                AMethod aMethod2 = (AMethod)aElement;
                this.filter(aMethod.bounds, aMethod2.bounds);
                this.filter(aMethod.parameters, aMethod2.parameters);
                this.filter(aMethod.throwsException, aMethod2.throwsException);
                aMethod.returnType.accept(this, aMethod2.returnType);
                aMethod.receiver.accept(this, aMethod2.receiver);
                aMethod.body.accept(this, aMethod2.body);
                return this.visitDeclaration((ADeclaration)aMethod, aElement);
            }

            @Override
            public Void visitTypeElement(ATypeElement aTypeElement, AElement aElement) {
                ATypeElement aTypeElement2 = (ATypeElement)aElement;
                this.filter(aTypeElement.innerTypes, aTypeElement2.innerTypes);
                return null;
            }

            @Override
            public Void visitTypeElementWithType(ATypeElementWithType aTypeElementWithType, AElement aElement) {
                ATypeElementWithType aTypeElementWithType2 = (ATypeElementWithType)aElement;
                aTypeElementWithType2.setType(aTypeElementWithType.getType());
                return this.visitTypeElement((ATypeElement)aTypeElementWithType, aElement);
            }

            @Override
            public Void visitElement(AElement aElement, AElement aElement2) {
                return null;
            }
        };
        javaLangClassPattern = Pattern.compile("^java.lang.[A-Za-z0-9_]+$");
    }
}

