/*
 * Decompiled with CFR 0.152.
 */
package annotator.scanner;

import annotator.scanner.CommonScanner;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;

public class AnonymousClassScanner
extends TreePathScanner<Void, Integer> {
    private int index = 1;
    private boolean found = false;
    private Tree anonclass;

    public static int indexOfClassTree(TreePath treePath, Tree tree) {
        int n = 0;
        boolean bl = false;
        while (treePath.getParentPath() != null && n < 1) {
            if (treePath.getLeaf() == tree) {
                bl = true;
            }
            treePath = treePath.getParentPath();
            if (!bl || !CommonScanner.hasClassKind(treePath.getLeaf())) continue;
            ++n;
        }
        AnonymousClassScanner anonymousClassScanner = new AnonymousClassScanner(tree);
        anonymousClassScanner.scan(treePath, Integer.valueOf(0));
        if (anonymousClassScanner.found) {
            return anonymousClassScanner.index;
        }
        return -1;
    }

    private AnonymousClassScanner(Tree tree) {
        this.anonclass = tree;
    }

    @Override
    public Void visitClass(ClassTree classTree, Integer n) {
        if (n < 2) {
            if (!this.found && CommonScanner.hasClassKind(this.anonclass)) {
                if (this.anonclass == classTree) {
                    this.found = true;
                } else if (classTree.getSimpleName().toString().trim().isEmpty()) {
                    ++this.index;
                }
            }
            super.visitClass(classTree, n + 1);
        }
        return null;
    }

    @Override
    public Void visitNewClass(NewClassTree newClassTree, Integer n) {
        if (!this.found && this.anonclass.getKind() == Tree.Kind.NEW_CLASS) {
            if (this.anonclass == newClassTree) {
                this.found = true;
            } else if (newClassTree.getClassBody() != null) {
                ++this.index;
            } else {
                return null;
            }
        }
        super.visitNewClass(newClassTree, n + 1);
        return null;
    }
}

