/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.inequality;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.index.Subsequence;
import org.checkerframework.checker.index.inequality.LessThanAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.FlowExpressionParseUtil;

public class LessThanVisitor
extends BaseTypeVisitor<LessThanAnnotatedTypeFactory> {
    private static final @CompilerMessageKey String FROM_GT_TO = "from.gt.to";

    public LessThanVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    protected void commonAssignmentCheck(Tree varTree, ExpressionTree valueTree, @CompilerMessageKey String errorKey) {
        Subsequence subSeq = Subsequence.getSubsequenceFromTree(varTree, this.atypeFactory);
        if (subSeq != null) {
            AnnotationMirror anm;
            try {
                anm = ((LessThanAnnotatedTypeFactory)this.atypeFactory).getAnnotationMirrorFromJavaExpressionString(subSeq.from, varTree, this.getCurrentPath());
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                anm = null;
            }
            if (anm == null || !LessThanAnnotatedTypeFactory.isLessThanOrEqual(anm, subSeq.to)) {
                this.checker.report(Result.failure(FROM_GT_TO, subSeq.from, subSeq.to, anm == null ? "@LessThanUnknown" : anm, subSeq.to, subSeq.to), valueTree);
            }
        }
        super.commonAssignmentCheck(varTree, valueTree, errorKey);
    }

    @Override
    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, Tree valueTree, @CompilerMessageKey String errorKey) {
        List<String> expressions = LessThanAnnotatedTypeFactory.getLessThanExpressions(varType.getEffectiveAnnotationInHierarchy(((LessThanAnnotatedTypeFactory)this.atypeFactory).UNKNOWN));
        if (expressions != null) {
            boolean isLessThan = true;
            for (String expression : expressions) {
                if (((LessThanAnnotatedTypeFactory)this.atypeFactory).isLessThanByValue(valueTree, expression, this.getCurrentPath())) continue;
                isLessThan = false;
            }
            if (isLessThan) {
                this.commonAssignmentCheckStartDiagnostic(varType, valueType, valueTree);
                this.commonAssignmentCheckEndDiagnostic(true, "isLessThan", varType, valueType, valueTree);
                return;
            }
        }
        super.commonAssignmentCheck(varType, valueType, valueTree, errorKey);
    }
}

