/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.com.github.javaparser;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.checkerframework.com.github.javaparser.CommentsInserter;
import org.checkerframework.com.github.javaparser.ParseResult;
import org.checkerframework.com.github.javaparser.Problem;
import org.checkerframework.com.github.javaparser.Providers;
import org.checkerframework.com.github.javaparser.UnicodeEscapeProcessingProvider;
import org.checkerframework.com.github.javaparser.ast.CompilationUnit;
import org.checkerframework.com.github.javaparser.ast.Node;
import org.checkerframework.com.github.javaparser.ast.validator.Java10Validator;
import org.checkerframework.com.github.javaparser.ast.validator.Java11Validator;
import org.checkerframework.com.github.javaparser.ast.validator.Java12Validator;
import org.checkerframework.com.github.javaparser.ast.validator.Java1_0Validator;
import org.checkerframework.com.github.javaparser.ast.validator.Java1_1Validator;
import org.checkerframework.com.github.javaparser.ast.validator.Java1_2Validator;
import org.checkerframework.com.github.javaparser.ast.validator.Java1_3Validator;
import org.checkerframework.com.github.javaparser.ast.validator.Java1_4Validator;
import org.checkerframework.com.github.javaparser.ast.validator.Java5Validator;
import org.checkerframework.com.github.javaparser.ast.validator.Java6Validator;
import org.checkerframework.com.github.javaparser.ast.validator.Java7Validator;
import org.checkerframework.com.github.javaparser.ast.validator.Java8Validator;
import org.checkerframework.com.github.javaparser.ast.validator.Java9Validator;
import org.checkerframework.com.github.javaparser.ast.validator.ProblemReporter;
import org.checkerframework.com.github.javaparser.ast.validator.Validator;
import org.checkerframework.com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import org.checkerframework.com.github.javaparser.resolution.SymbolResolver;
import org.checkerframework.com.github.javaparser.utils.Utils;
import org.checkerframework.com.github.javaparser.version.Java10PostProcessor;
import org.checkerframework.com.github.javaparser.version.Java11PostProcessor;
import org.checkerframework.com.github.javaparser.version.Java12PostProcessor;

public class ParserConfiguration {
    private boolean storeTokens = true;
    private boolean attributeComments = true;
    private boolean doNotAssignCommentsPrecedingEmptyLines = true;
    private boolean ignoreAnnotationsWhenAttributingComments = false;
    private boolean lexicalPreservationEnabled = false;
    private boolean preprocessUnicodeEscapes = false;
    private SymbolResolver symbolResolver = null;
    private int tabSize = 1;
    private LanguageLevel languageLevel = LanguageLevel.CURRENT;
    private Charset characterEncoding = Providers.UTF8;
    private final List<Providers.PreProcessor> preProcessors = new ArrayList<Providers.PreProcessor>();
    private final List<ParseResult.PostProcessor> postProcessors = new ArrayList<ParseResult.PostProcessor>();

    public ParserConfiguration() {
        this.preProcessors.add(innerProvider -> {
            if (this.preprocessUnicodeEscapes) {
                return new UnicodeEscapeProcessingProvider(innerProvider);
            }
            return innerProvider;
        });
        this.postProcessors.add((result, configuration) -> {
            if (configuration.isLexicalPreservationEnabled()) {
                result.ifSuccessful(LexicalPreservingPrinter::setup);
            }
        });
        this.postProcessors.add((result, configuration) -> {
            if (configuration.isAttributeComments()) {
                result.ifSuccessful(resultNode -> result.getCommentsCollection().ifPresent(comments -> new CommentsInserter(configuration).insertComments((Node)resultNode, comments.copy().getComments())));
            }
        });
        this.postProcessors.add((result, configuration) -> {
            LanguageLevel languageLevel = this.getLanguageLevel();
            if (languageLevel.postProcessor != null) {
                languageLevel.postProcessor.process(result, configuration);
            }
            if (languageLevel.validator != null) {
                languageLevel.validator.accept((Node)result.getResult().get(), new ProblemReporter(newProblem -> result.getProblems().add((Problem)newProblem)));
            }
        });
        this.postProcessors.add((result, configuration) -> configuration.getSymbolResolver().ifPresent(symbolResolver -> result.ifSuccessful(resultNode -> {
            if (resultNode instanceof CompilationUnit) {
                resultNode.setData(Node.SYMBOL_RESOLVER_KEY, symbolResolver);
            }
        })));
    }

    public boolean isAttributeComments() {
        return this.attributeComments;
    }

    public ParserConfiguration setAttributeComments(boolean attributeComments) {
        this.attributeComments = attributeComments;
        return this;
    }

    public boolean isDoNotAssignCommentsPrecedingEmptyLines() {
        return this.doNotAssignCommentsPrecedingEmptyLines;
    }

    public ParserConfiguration setDoNotAssignCommentsPrecedingEmptyLines(boolean doNotAssignCommentsPrecedingEmptyLines) {
        this.doNotAssignCommentsPrecedingEmptyLines = doNotAssignCommentsPrecedingEmptyLines;
        return this;
    }

    public boolean isIgnoreAnnotationsWhenAttributingComments() {
        return this.ignoreAnnotationsWhenAttributingComments;
    }

    public ParserConfiguration setIgnoreAnnotationsWhenAttributingComments(boolean ignoreAnnotationsWhenAttributingComments) {
        this.ignoreAnnotationsWhenAttributingComments = ignoreAnnotationsWhenAttributingComments;
        return this;
    }

    public ParserConfiguration setStoreTokens(boolean storeTokens) {
        this.storeTokens = storeTokens;
        if (!storeTokens) {
            this.setAttributeComments(false);
        }
        return this;
    }

    public boolean isStoreTokens() {
        return this.storeTokens;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public ParserConfiguration setTabSize(int tabSize) {
        this.tabSize = tabSize;
        return this;
    }

    public ParserConfiguration setLexicalPreservationEnabled(boolean lexicalPreservationEnabled) {
        this.lexicalPreservationEnabled = lexicalPreservationEnabled;
        return this;
    }

    public boolean isLexicalPreservationEnabled() {
        return this.lexicalPreservationEnabled;
    }

    public Optional<SymbolResolver> getSymbolResolver() {
        return Optional.ofNullable(this.symbolResolver);
    }

    public ParserConfiguration setSymbolResolver(SymbolResolver symbolResolver) {
        this.symbolResolver = symbolResolver;
        return this;
    }

    public List<Providers.PreProcessor> getPreProcessors() {
        return this.preProcessors;
    }

    public List<ParseResult.PostProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    public ParserConfiguration setLanguageLevel(LanguageLevel languageLevel) {
        this.languageLevel = Utils.assertNotNull(languageLevel);
        return this;
    }

    public LanguageLevel getLanguageLevel() {
        return this.languageLevel;
    }

    public ParserConfiguration setPreprocessUnicodeEscapes(boolean preprocessUnicodeEscapes) {
        this.preprocessUnicodeEscapes = preprocessUnicodeEscapes;
        return this;
    }

    public boolean isPreprocessUnicodeEscapes() {
        return this.preprocessUnicodeEscapes;
    }

    public Charset getCharacterEncoding() {
        return this.characterEncoding;
    }

    public ParserConfiguration setCharacterEncoding(Charset characterEncoding) {
        this.characterEncoding = characterEncoding;
        return this;
    }

    public static enum LanguageLevel {
        RAW(null, null),
        POPULAR(new Java8Validator(), null),
        CURRENT(new Java8Validator(), null),
        BLEEDING_EDGE(new Java12Validator(), new Java12PostProcessor()),
        JAVA_1_0(new Java1_0Validator(), null),
        JAVA_1_1(new Java1_1Validator(), null),
        JAVA_1_2(new Java1_2Validator(), null),
        JAVA_1_3(new Java1_3Validator(), null),
        JAVA_1_4(new Java1_4Validator(), null),
        JAVA_5(new Java5Validator(), null),
        JAVA_6(new Java6Validator(), null),
        JAVA_7(new Java7Validator(), null),
        JAVA_8(new Java8Validator(), null),
        JAVA_9(new Java9Validator(), null),
        JAVA_10(new Java10Validator(), new Java10PostProcessor()),
        JAVA_11(new Java11Validator(), new Java11PostProcessor()),
        JAVA_12(new Java12Validator(), new Java12PostProcessor());

        final Validator validator;
        final ParseResult.PostProcessor postProcessor;

        private LanguageLevel(Validator validator, ParseResult.PostProcessor postProcessor) {
            this.validator = validator;
            this.postProcessor = postProcessor;
        }
    }
}

