/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.defaults;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Elements;
import org.checkerframework.framework.qual.AnnotatedFor;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.checkerframework.framework.qual.DefaultQualifiers;
import org.checkerframework.framework.qual.TypeUseLocation;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.visitor.AnnotatedTypeScanner;
import org.checkerframework.framework.util.CheckerMain;
import org.checkerframework.framework.util.defaults.Default;
import org.checkerframework.framework.util.defaults.DefaultSet;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.CollectionUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.PluginUtil;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class QualifierDefaults {
    private boolean applyToTypeVar = false;
    private final Elements elements;
    private final AnnotatedTypeFactory atypeFactory;
    private final List<String> upstreamCheckerNames;
    private final DefaultSet checkedCodeDefaults = new DefaultSet();
    private final DefaultSet uncheckedCodeDefaults = new DefaultSet();
    private static final int CACHE_SIZE = 300;
    protected static final Map<Element, BoundType> elementToBoundType = CollectionUtils.createLRUCache(300);
    private final Map<Element, DefaultSet> elementDefaults = new IdentityHashMap<Element, DefaultSet>();
    private final Map<Element, Boolean> elementAnnotatedFors = new IdentityHashMap<Element, Boolean>();
    public static final TypeUseLocation[] STANDARD_CLIMB_DEFAULTS_TOP = new TypeUseLocation[]{TypeUseLocation.LOCAL_VARIABLE, TypeUseLocation.RESOURCE_VARIABLE, TypeUseLocation.EXCEPTION_PARAMETER, TypeUseLocation.IMPLICIT_UPPER_BOUND};
    public static final TypeUseLocation[] STANDARD_CLIMB_DEFAULTS_BOTTOM = new TypeUseLocation[]{TypeUseLocation.IMPLICIT_LOWER_BOUND};
    private static final TypeUseLocation[] validUncheckedCodeDefaultLocations = new TypeUseLocation[]{TypeUseLocation.FIELD, TypeUseLocation.PARAMETER, TypeUseLocation.RETURN, TypeUseLocation.RECEIVER, TypeUseLocation.UPPER_BOUND, TypeUseLocation.LOWER_BOUND, TypeUseLocation.OTHERWISE, TypeUseLocation.ALL};
    public static final TypeUseLocation[] STANDARD_UNCHECKED_DEFAULTS_TOP = new TypeUseLocation[]{TypeUseLocation.RETURN, TypeUseLocation.FIELD, TypeUseLocation.UPPER_BOUND};
    public static final TypeUseLocation[] STANDARD_UNCHECKED_DEFAULTS_BOTTOM = new TypeUseLocation[]{TypeUseLocation.PARAMETER, TypeUseLocation.LOWER_BOUND};
    private final boolean useUncheckedCodeDefaultsSource;
    private final boolean useUncheckedCodeDefaultsBytecode;

    public static TypeUseLocation[] validLocationsForUncheckedCodeDefaults() {
        return validUncheckedCodeDefaultLocations;
    }

    public QualifierDefaults(Elements elements, AnnotatedTypeFactory atypeFactory) {
        this.elements = elements;
        this.atypeFactory = atypeFactory;
        this.upstreamCheckerNames = atypeFactory.getContext().getChecker().getUpstreamCheckerNames();
        this.useUncheckedCodeDefaultsBytecode = atypeFactory.getContext().getChecker().useUncheckedCodeDefault("bytecode");
        this.useUncheckedCodeDefaultsSource = atypeFactory.getContext().getChecker().useUncheckedCodeDefault("source");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Checked code defaults: ");
        sb.append(System.lineSeparator());
        sb.append(PluginUtil.join(System.lineSeparator(), this.checkedCodeDefaults));
        sb.append(System.lineSeparator());
        sb.append("Unchecked code defaults: ");
        sb.append(System.lineSeparator());
        sb.append(PluginUtil.join(System.lineSeparator(), this.uncheckedCodeDefaults));
        sb.append(System.lineSeparator());
        sb.append("useUncheckedCodeDefaultsSource: ");
        sb.append(this.useUncheckedCodeDefaultsSource);
        sb.append(System.lineSeparator());
        sb.append("useUncheckedCodeDefaultsBytecode: ");
        sb.append(this.useUncheckedCodeDefaultsBytecode);
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    public boolean hasDefaultsForCheckedCode() {
        for (Default def : this.checkedCodeDefaults) {
            if (def.location != TypeUseLocation.OTHERWISE && def.location != TypeUseLocation.ALL) continue;
            return true;
        }
        return false;
    }

    public void addUncheckedStandardDefaults() {
        QualifierHierarchy qualHierarchy = this.atypeFactory.getQualifierHierarchy();
        Set<? extends AnnotationMirror> tops = qualHierarchy.getTopAnnotations();
        Set<? extends AnnotationMirror> bottoms = qualHierarchy.getBottomAnnotations();
        for (TypeUseLocation loc : STANDARD_UNCHECKED_DEFAULTS_TOP) {
            for (AnnotationMirror annotationMirror : tops) {
                if (this.conflictsWithExistingDefaults(this.uncheckedCodeDefaults, annotationMirror, loc)) continue;
                this.addUncheckedCodeDefault(annotationMirror, loc);
            }
        }
        for (TypeUseLocation loc : STANDARD_UNCHECKED_DEFAULTS_BOTTOM) {
            for (AnnotationMirror annotationMirror : bottoms) {
                if (this.conflictsWithExistingDefaults(this.uncheckedCodeDefaults, annotationMirror, loc)) continue;
                this.addUncheckedCodeDefault(annotationMirror, loc);
            }
        }
    }

    public void addClimbStandardDefaults() {
        QualifierHierarchy qualHierarchy = this.atypeFactory.getQualifierHierarchy();
        Set<? extends AnnotationMirror> tops = qualHierarchy.getTopAnnotations();
        Set<? extends AnnotationMirror> bottoms = qualHierarchy.getBottomAnnotations();
        for (TypeUseLocation loc : STANDARD_CLIMB_DEFAULTS_TOP) {
            for (AnnotationMirror annotationMirror : tops) {
                if (this.conflictsWithExistingDefaults(this.checkedCodeDefaults, annotationMirror, loc)) continue;
                this.addCheckedCodeDefault(annotationMirror, loc);
            }
        }
        for (TypeUseLocation loc : STANDARD_CLIMB_DEFAULTS_BOTTOM) {
            for (AnnotationMirror annotationMirror : bottoms) {
                if (this.conflictsWithExistingDefaults(this.checkedCodeDefaults, annotationMirror, loc)) continue;
                this.addCheckedCodeDefault(annotationMirror, loc);
            }
        }
    }

    public void addCheckedCodeDefault(AnnotationMirror absoluteDefaultAnno, TypeUseLocation location) {
        this.checkDuplicates(this.checkedCodeDefaults, absoluteDefaultAnno, location);
        this.checkedCodeDefaults.add(new Default(absoluteDefaultAnno, location));
    }

    public void addUncheckedCodeDefault(AnnotationMirror uncheckedDefaultAnno, TypeUseLocation location) {
        this.checkDuplicates(this.uncheckedCodeDefaults, uncheckedDefaultAnno, location);
        this.checkIsValidUncheckedCodeLocation(uncheckedDefaultAnno, location);
        this.uncheckedCodeDefaults.add(new Default(uncheckedDefaultAnno, location));
    }

    public void addUncheckedCodeDefaults(AnnotationMirror absoluteDefaultAnno, TypeUseLocation[] locations) {
        for (TypeUseLocation location : locations) {
            this.addUncheckedCodeDefault(absoluteDefaultAnno, location);
        }
    }

    public void addCheckedCodeDefaults(AnnotationMirror absoluteDefaultAnno, TypeUseLocation[] locations) {
        for (TypeUseLocation location : locations) {
            this.addCheckedCodeDefault(absoluteDefaultAnno, location);
        }
    }

    public void addElementDefault(Element elem, AnnotationMirror elementDefaultAnno, TypeUseLocation location) {
        DefaultSet prevset = this.elementDefaults.get(elem);
        if (prevset != null) {
            this.checkDuplicates(prevset, elementDefaultAnno, location);
        } else {
            prevset = new DefaultSet();
        }
        prevset.add(new Default(elementDefaultAnno, location));
        this.elementDefaults.put(elem, prevset);
    }

    private void checkIsValidUncheckedCodeLocation(AnnotationMirror uncheckedDefaultAnno, TypeUseLocation location) {
        boolean isValidUntypeLocation = false;
        for (TypeUseLocation validLoc : QualifierDefaults.validLocationsForUncheckedCodeDefaults()) {
            if (location != validLoc) continue;
            isValidUntypeLocation = true;
            break;
        }
        if (!isValidUntypeLocation) {
            throw new BugInCF("Invalid unchecked code default location: " + (Object)((Object)location) + " -> " + uncheckedDefaultAnno);
        }
    }

    private void checkDuplicates(DefaultSet previousDefaults, AnnotationMirror newAnno, TypeUseLocation newLoc) {
        if (this.conflictsWithExistingDefaults(previousDefaults, newAnno, newLoc)) {
            throw new BugInCF("Only one qualifier from a hierarchy can be the default. Existing: " + previousDefaults + " and new: " + new Default(newAnno, newLoc));
        }
    }

    private boolean conflictsWithExistingDefaults(DefaultSet previousDefaults, AnnotationMirror newAnno, TypeUseLocation newLoc) {
        QualifierHierarchy qualHierarchy = this.atypeFactory.getQualifierHierarchy();
        for (Default previous : previousDefaults) {
            AnnotationMirror previousTop;
            if (AnnotationUtils.areSame(newAnno, previous.anno) || previous.location != newLoc || !qualHierarchy.isSubtype(newAnno, previousTop = qualHierarchy.getTopAnnotation(previous.anno))) continue;
            return true;
        }
        return false;
    }

    public void annotate(Element elt, AnnotatedTypeMirror type) {
        this.applyDefaultsElement(elt, type);
    }

    public void annotate(Tree tree, AnnotatedTypeMirror type) {
        this.applyDefaults(tree, type);
    }

    private Element nearestEnclosingExceptLocal(Tree tree) {
        TreePath path = this.atypeFactory.getPath(tree);
        if (path == null) {
            Element element = this.atypeFactory.getEnclosingElementForArtificialTree(tree);
            if (element != null) {
                return element;
            }
            return TreeUtils.elementFromTree(tree);
        }
        Tree prev = null;
        for (Tree t : path) {
            switch (t.getKind()) {
                case VARIABLE: {
                    VariableTree vtree = (VariableTree)t;
                    ExpressionTree vtreeInit = vtree.getInitializer();
                    if (vtreeInit != null && prev == vtreeInit) {
                        VariableElement elt = TreeUtils.elementFromDeclaration((VariableTree)t);
                        AnnotationMirror d = this.atypeFactory.getDeclAnnotation(elt, DefaultQualifier.class);
                        AnnotationMirror ds = this.atypeFactory.getDeclAnnotation(elt, DefaultQualifiers.class);
                        if (d == null && ds == null) break;
                    }
                    if (prev != null && prev.getKind() == Tree.Kind.MODIFIERS) break;
                    return TreeUtils.elementFromDeclaration((VariableTree)t);
                }
                case METHOD: {
                    return TreeUtils.elementFromDeclaration((MethodTree)t);
                }
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case ANNOTATION_TYPE: {
                    return TreeUtils.elementFromDeclaration((ClassTree)t);
                }
            }
            prev = t;
        }
        return null;
    }

    private void applyDefaults(Tree tree, AnnotatedTypeMirror type) {
        Element elt;
        switch (tree.getKind()) {
            case MEMBER_SELECT: {
                elt = TreeUtils.elementFromUse((MemberSelectTree)tree);
                break;
            }
            case IDENTIFIER: {
                elt = TreeUtils.elementFromUse((IdentifierTree)tree);
                if (!ElementUtils.isTypeDeclaration(elt)) break;
                elt = this.nearestEnclosingExceptLocal(tree);
                break;
            }
            case METHOD_INVOCATION: {
                elt = TreeUtils.elementFromUse((MethodInvocationTree)tree);
                break;
            }
            case CLASS: {
                if (((ClassTree)tree).getExtendsClause() != null) {
                    Element extendsElt = TreeUtils.elementFromTree(((ClassTree)tree).getExtendsClause());
                    this.applyDefaultsToElement(extendsElt, type);
                }
                for (Tree tree2 : ((ClassTree)tree).getImplementsClause()) {
                    Element implementsElt = TreeUtils.elementFromTree(tree2);
                    this.applyDefaultsToElement(implementsElt, type);
                }
                elt = this.nearestEnclosingExceptLocal(tree);
                break;
            }
            default: {
                elt = this.nearestEnclosingExceptLocal(tree);
            }
        }
        this.applyDefaultsToElement(elt, type);
    }

    void applyDefaultsToElement(Element elt, AnnotatedTypeMirror type) {
        boolean defaultTypeVarLocals = this.atypeFactory instanceof GenericAnnotatedTypeFactory && ((GenericAnnotatedTypeFactory)this.atypeFactory).getShouldDefaultTypeVarLocals();
        this.applyToTypeVar = defaultTypeVarLocals && elt != null && elt.getKind() == ElementKind.LOCAL_VARIABLE && type.getKind() == TypeKind.TYPEVAR;
        this.applyDefaultsElement(elt, type);
        this.applyToTypeVar = false;
    }

    private DefaultSet fromDefaultQualifier(AnnotationMirror dq) {
        Name cls = AnnotationUtils.getElementValueClassName(dq, "value", false);
        AnnotationMirror anno = AnnotationBuilder.fromName(this.elements, cls);
        if (anno == null) {
            return null;
        }
        if (!this.atypeFactory.isSupportedQualifier(anno)) {
            anno = this.atypeFactory.canonicalAnnotation(anno);
        }
        if (this.atypeFactory.isSupportedQualifier(anno)) {
            List<TypeUseLocation> locations = AnnotationUtils.getElementValueEnumArray(dq, "locations", TypeUseLocation.class, true);
            DefaultSet ret = new DefaultSet();
            for (TypeUseLocation loc : locations) {
                ret.add(new Default(anno, loc));
            }
            return ret;
        }
        return null;
    }

    private boolean isElementAnnotatedForThisChecker(Element elt) {
        Element parent;
        List<String> checkers;
        boolean elementAnnotatedForThisChecker = false;
        if (elt == null) {
            throw new BugInCF("Call of QualifierDefaults.isElementAnnotatedForThisChecker with null");
        }
        if (this.elementAnnotatedFors.containsKey(elt)) {
            return this.elementAnnotatedFors.get(elt);
        }
        AnnotationMirror af = this.atypeFactory.getDeclAnnotation(elt, AnnotatedFor.class);
        if (af != null && (checkers = AnnotationUtils.getElementValueArray(af, "value", String.class, false)) != null) {
            for (String checker : checkers) {
                if (!CheckerMain.matchesFullyQualifiedProcessor(checker, this.upstreamCheckerNames, true)) continue;
                elementAnnotatedForThisChecker = true;
                break;
            }
        }
        if (!elementAnnotatedForThisChecker && (parent = elt.getKind() == ElementKind.PACKAGE ? ElementUtils.parentPackage((PackageElement)elt, this.elements) : elt.getEnclosingElement()) != null && this.isElementAnnotatedForThisChecker(parent)) {
            elementAnnotatedForThisChecker = true;
        }
        this.elementAnnotatedFors.put(elt, elementAnnotatedForThisChecker);
        return elementAnnotatedForThisChecker;
    }

    private DefaultSet defaultsAt(Element elt) {
        AnnotationMirror ds;
        if (elt == null) {
            return DefaultSet.EMPTY;
        }
        if (this.elementDefaults.containsKey(elt)) {
            return this.elementDefaults.get(elt);
        }
        DefaultSet qualifiers = null;
        AnnotationMirror d = this.atypeFactory.getDeclAnnotation(elt, DefaultQualifier.class);
        if (d != null) {
            qualifiers = new DefaultSet();
            DefaultSet p = this.fromDefaultQualifier(d);
            if (p != null) {
                qualifiers.addAll(p);
            }
        }
        if ((ds = this.atypeFactory.getDeclAnnotation(elt, DefaultQualifiers.class)) != null) {
            if (qualifiers == null) {
                qualifiers = new DefaultSet();
            }
            List values = AnnotationUtils.getElementValue(ds, "value", List.class, false);
            for (AnnotationMirror d2 : values) {
                DefaultSet p = this.fromDefaultQualifier(d2);
                if (p == null) continue;
                qualifiers.addAll(p);
            }
        }
        Element parent = elt.getKind() == ElementKind.PACKAGE ? ElementUtils.parentPackage((PackageElement)elt, this.elements) : elt.getEnclosingElement();
        DefaultSet parentDefaults = this.defaultsAt(parent);
        if (qualifiers == null || qualifiers.isEmpty()) {
            qualifiers = parentDefaults;
        } else {
            qualifiers.addAll(parentDefaults);
        }
        if (qualifiers != null && !qualifiers.isEmpty()) {
            this.elementDefaults.put(elt, qualifiers);
            return qualifiers;
        }
        return DefaultSet.EMPTY;
    }

    public boolean applyUncheckedCodeDefaults(Element annotationScope) {
        boolean isBytecode;
        if (annotationScope == null) {
            return false;
        }
        if (this.uncheckedCodeDefaults.isEmpty()) {
            return false;
        }
        boolean isFromStubFile = this.atypeFactory.isFromStubFile(annotationScope);
        boolean bl = isBytecode = ElementUtils.isElementFromByteCode(annotationScope) && this.atypeFactory.declarationFromElement(annotationScope) == null && !isFromStubFile;
        if (isBytecode) {
            return this.useUncheckedCodeDefaultsBytecode;
        }
        if (isFromStubFile) {
            return false;
        }
        if (this.useUncheckedCodeDefaultsSource) {
            return !this.isElementAnnotatedForThisChecker(annotationScope);
        }
        return false;
    }

    private void applyDefaultsElement(Element annotationScope, AnnotatedTypeMirror type) {
        DefaultSet defaults = this.defaultsAt(annotationScope);
        DefaultApplierElement applier = this.createDefaultApplierElement(this.atypeFactory, annotationScope, type, this.applyToTypeVar);
        for (Default def : defaults) {
            applier.applyDefault(def);
        }
        if (this.applyUncheckedCodeDefaults(annotationScope)) {
            for (Default def : this.uncheckedCodeDefaults) {
                applier.applyDefault(def);
            }
        }
        for (Default def : this.checkedCodeDefaults) {
            applier.applyDefault(def);
        }
    }

    protected DefaultApplierElement createDefaultApplierElement(AnnotatedTypeFactory atypeFactory, Element annotationScope, AnnotatedTypeMirror type, boolean applyToTypeVar) {
        return new DefaultApplierElement(atypeFactory, annotationScope, type, applyToTypeVar);
    }

    private static BoundType getBoundType(AnnotatedTypeMirror type, AnnotatedTypeFactory typeFactory) {
        if (type instanceof AnnotatedTypeMirror.AnnotatedTypeVariable) {
            return QualifierDefaults.getTypeVarBoundType((AnnotatedTypeMirror.AnnotatedTypeVariable)type, typeFactory);
        }
        if (type instanceof AnnotatedTypeMirror.AnnotatedWildcardType) {
            return QualifierDefaults.getWildcardBoundType((AnnotatedTypeMirror.AnnotatedWildcardType)type, typeFactory);
        }
        throw new BugInCF("Unexpected type kind: type=" + type);
    }

    private static BoundType getTypeVarBoundType(AnnotatedTypeMirror.AnnotatedTypeVariable typeVar, AnnotatedTypeFactory typeFactory) {
        return QualifierDefaults.getTypeVarBoundType((TypeParameterElement)typeVar.getUnderlyingType().asElement(), typeFactory);
    }

    private static BoundType getTypeVarBoundType(TypeParameterElement typeParamElem, AnnotatedTypeFactory typeFactory) {
        BoundType boundType;
        Tree typeParamDecl;
        BoundType prev = elementToBoundType.get(typeParamElem);
        if (prev != null) {
            return prev;
        }
        TreePath declaredTypeVarEle = typeFactory.getTreeUtils().getPath(typeParamElem);
        Tree tree = typeParamDecl = declaredTypeVarEle == null ? null : declaredTypeVarEle.getLeaf();
        if (typeParamDecl == null) {
            boundType = typeParamElem.getBounds().size() == 1 && TypesUtils.isObject(typeParamElem.getBounds().get(0)) ? BoundType.UNBOUNDED : BoundType.UPPER;
        } else if (typeParamDecl.getKind() == Tree.Kind.TYPE_PARAMETER) {
            TypeParameterTree tptree = (TypeParameterTree)typeParamDecl;
            List<? extends Tree> bnds = tptree.getBounds();
            boundType = bnds != null && !bnds.isEmpty() ? BoundType.UPPER : BoundType.UNBOUNDED;
        } else {
            throw new BugInCF("Unexpected tree type for typeVar Element:\ntypeParamElem=" + typeParamElem + "\n" + typeParamDecl);
        }
        elementToBoundType.put(typeParamElem, boundType);
        return boundType;
    }

    public static BoundType getWildcardBoundType(AnnotatedTypeMirror.AnnotatedWildcardType annotatedWildcard, AnnotatedTypeFactory typeFactory) {
        Type.WildcardType wildcard = (Type.WildcardType)annotatedWildcard.getUnderlyingType();
        BoundType boundType = wildcard.isUnbound() && wildcard.bound != null ? QualifierDefaults.getTypeVarBoundType((TypeParameterElement)wildcard.bound.asElement(), typeFactory) : (wildcard.isSuperBound() ? BoundType.LOWER : BoundType.UPPER);
        return boundType;
    }

    static enum BoundType {
        UPPER,
        LOWER,
        UNBOUNDED;


        public boolean isOneOf(BoundType ... choices) {
            for (BoundType choice : choices) {
                if (this != choice) continue;
                return true;
            }
            return false;
        }
    }

    public static class DefaultApplierElement {
        protected final AnnotatedTypeFactory atypeFactory;
        protected final Element scope;
        protected final AnnotatedTypeMirror type;
        protected TypeUseLocation location;
        protected final DefaultApplierElementImpl impl;
        private final AnnotatedTypeMirror.AnnotatedTypeVariable defaultableTypeVar;

        public DefaultApplierElement(AnnotatedTypeFactory atypeFactory, Element scope, AnnotatedTypeMirror type, boolean applyToTypeVar) {
            this.atypeFactory = atypeFactory;
            this.scope = scope;
            this.type = type;
            this.impl = new DefaultApplierElementImpl();
            this.defaultableTypeVar = applyToTypeVar ? (AnnotatedTypeMirror.AnnotatedTypeVariable)type : null;
        }

        public void applyDefault(Default def) {
            this.location = def.location;
            this.impl.visit(this.type, def.anno);
        }

        protected boolean shouldBeAnnotated(AnnotatedTypeMirror type, boolean applyToTypeVar) {
            return type != null && type.getKind() != TypeKind.NONE && type.getKind() != TypeKind.WILDCARD && (type.getKind() != TypeKind.TYPEVAR || applyToTypeVar) && !(type instanceof AnnotatedTypeMirror.AnnotatedNoType);
        }

        protected void addAnnotation(AnnotatedTypeMirror type, AnnotationMirror qual) {
            List<AnnotatedTypeMirror.AnnotatedDeclaredType> sups;
            if (!type.isAnnotatedInHierarchy(qual) && type.getKind() != TypeKind.EXECUTABLE) {
                type.addAnnotation(qual);
            }
            if (type.getKind() == TypeKind.INTERSECTION && (sups = ((AnnotatedTypeMirror.AnnotatedIntersectionType)type).directSuperTypesField()) != null) {
                for (AnnotatedTypeMirror annotatedTypeMirror : sups) {
                    if (annotatedTypeMirror.isAnnotatedInHierarchy(qual)) continue;
                    annotatedTypeMirror.addAnnotation(qual);
                }
            }
        }

        protected class DefaultApplierElementImpl
        extends AnnotatedTypeScanner<Void, AnnotationMirror> {
            private boolean isLowerBound = false;
            private boolean isUpperBound = false;
            private BoundType boundType = BoundType.UNBOUNDED;

            protected DefaultApplierElementImpl() {
            }

            @Override
            public Void scan(AnnotatedTypeMirror t, AnnotationMirror qual) {
                if (!DefaultApplierElement.this.shouldBeAnnotated(t, t == DefaultApplierElement.this.defaultableTypeVar)) {
                    return (Void)super.scan(t, qual);
                }
                switch (DefaultApplierElement.this.location) {
                    case TYPE_DECLARATION: {
                        if (DefaultApplierElement.this.scope == null || DefaultApplierElement.this.scope.getKind() != ElementKind.CLASS && DefaultApplierElement.this.scope.getKind() != ElementKind.INTERFACE && DefaultApplierElement.this.scope.getKind() != ElementKind.ENUM || t != DefaultApplierElement.this.type) break;
                        DefaultApplierElement.this.addAnnotation(t, qual);
                        break;
                    }
                    case FIELD: {
                        if (DefaultApplierElement.this.scope == null || DefaultApplierElement.this.scope.getKind() != ElementKind.FIELD || t != DefaultApplierElement.this.type) break;
                        DefaultApplierElement.this.addAnnotation(t, qual);
                        break;
                    }
                    case LOCAL_VARIABLE: {
                        if (DefaultApplierElement.this.scope == null || DefaultApplierElement.this.scope.getKind() != ElementKind.LOCAL_VARIABLE || t != DefaultApplierElement.this.type) break;
                        DefaultApplierElement.this.addAnnotation(t, qual);
                        break;
                    }
                    case RESOURCE_VARIABLE: {
                        if (DefaultApplierElement.this.scope == null || DefaultApplierElement.this.scope.getKind() != ElementKind.RESOURCE_VARIABLE || t != DefaultApplierElement.this.type) break;
                        DefaultApplierElement.this.addAnnotation(t, qual);
                        break;
                    }
                    case EXCEPTION_PARAMETER: {
                        if (DefaultApplierElement.this.scope == null || DefaultApplierElement.this.scope.getKind() != ElementKind.EXCEPTION_PARAMETER || t != DefaultApplierElement.this.type) break;
                        DefaultApplierElement.this.addAnnotation(t, qual);
                        if (t.getKind() != TypeKind.UNION) break;
                        AnnotatedTypeMirror.AnnotatedUnionType aut = (AnnotatedTypeMirror.AnnotatedUnionType)t;
                        for (AnnotatedTypeMirror.AnnotatedDeclaredType anno : aut.getAlternatives()) {
                            DefaultApplierElement.this.addAnnotation(anno, qual);
                        }
                        break;
                    }
                    case PARAMETER: {
                        if (DefaultApplierElement.this.scope != null && DefaultApplierElement.this.scope.getKind() == ElementKind.PARAMETER && t == DefaultApplierElement.this.type) {
                            DefaultApplierElement.this.addAnnotation(t, qual);
                            break;
                        }
                        if (DefaultApplierElement.this.scope == null || DefaultApplierElement.this.scope.getKind() != ElementKind.METHOD && DefaultApplierElement.this.scope.getKind() != ElementKind.CONSTRUCTOR || t.getKind() != TypeKind.EXECUTABLE || t != DefaultApplierElement.this.type) break;
                        for (AnnotatedTypeMirror atm : ((AnnotatedTypeMirror.AnnotatedExecutableType)t).getParameterTypes()) {
                            if (!DefaultApplierElement.this.shouldBeAnnotated(atm, false)) continue;
                            DefaultApplierElement.this.addAnnotation(atm, qual);
                        }
                        break;
                    }
                    case RECEIVER: {
                        AnnotatedTypeMirror.AnnotatedDeclaredType receiver;
                        if (DefaultApplierElement.this.scope != null && DefaultApplierElement.this.scope.getKind() == ElementKind.PARAMETER && t == DefaultApplierElement.this.type && DefaultApplierElement.this.scope.getSimpleName().contentEquals("this")) {
                            DefaultApplierElement.this.addAnnotation(t, qual);
                            break;
                        }
                        if (DefaultApplierElement.this.scope == null || DefaultApplierElement.this.scope.getKind() != ElementKind.METHOD || t.getKind() != TypeKind.EXECUTABLE || t != DefaultApplierElement.this.type || !DefaultApplierElement.this.shouldBeAnnotated(receiver = ((AnnotatedTypeMirror.AnnotatedExecutableType)t).getReceiverType(), false)) break;
                        DefaultApplierElement.this.addAnnotation(receiver, qual);
                        break;
                    }
                    case RETURN: {
                        AnnotatedTypeMirror returnType;
                        if (DefaultApplierElement.this.scope == null || DefaultApplierElement.this.scope.getKind() != ElementKind.METHOD || t.getKind() != TypeKind.EXECUTABLE || t != DefaultApplierElement.this.type || !DefaultApplierElement.this.shouldBeAnnotated(returnType = ((AnnotatedTypeMirror.AnnotatedExecutableType)t).getReturnType(), false)) break;
                        DefaultApplierElement.this.addAnnotation(returnType, qual);
                        break;
                    }
                    case CONSTRUCTOR_RESULT: {
                        AnnotatedTypeMirror returnType;
                        if (DefaultApplierElement.this.scope == null || DefaultApplierElement.this.scope.getKind() != ElementKind.CONSTRUCTOR || t.getKind() != TypeKind.EXECUTABLE || t != DefaultApplierElement.this.type || !DefaultApplierElement.this.shouldBeAnnotated(returnType = ((AnnotatedTypeMirror.AnnotatedExecutableType)t).getReturnType(), false)) break;
                        DefaultApplierElement.this.addAnnotation(returnType, qual);
                        break;
                    }
                    case IMPLICIT_LOWER_BOUND: {
                        if (!this.isLowerBound || !this.boundType.isOneOf(BoundType.UNBOUNDED, BoundType.UPPER)) break;
                        DefaultApplierElement.this.addAnnotation(t, qual);
                        break;
                    }
                    case EXPLICIT_LOWER_BOUND: {
                        if (!this.isLowerBound || !this.boundType.isOneOf(BoundType.LOWER)) break;
                        DefaultApplierElement.this.addAnnotation(t, qual);
                        break;
                    }
                    case LOWER_BOUND: {
                        if (!this.isLowerBound) break;
                        DefaultApplierElement.this.addAnnotation(t, qual);
                        break;
                    }
                    case IMPLICIT_UPPER_BOUND: {
                        if (!this.isUpperBound || !this.boundType.isOneOf(BoundType.UNBOUNDED, BoundType.LOWER)) break;
                        DefaultApplierElement.this.addAnnotation(t, qual);
                        break;
                    }
                    case EXPLICIT_UPPER_BOUND: {
                        if (!this.isUpperBound || !this.boundType.isOneOf(BoundType.UPPER)) break;
                        DefaultApplierElement.this.addAnnotation(t, qual);
                        break;
                    }
                    case UPPER_BOUND: {
                        if (!this.isUpperBound) break;
                        DefaultApplierElement.this.addAnnotation(t, qual);
                        break;
                    }
                    case OTHERWISE: 
                    case ALL: {
                        DefaultApplierElement.this.addAnnotation(t, qual);
                        break;
                    }
                    default: {
                        throw new BugInCF("QualifierDefaults.DefaultApplierElement: unhandled location: " + (Object)((Object)DefaultApplierElement.this.location));
                    }
                }
                return (Void)super.scan(t, qual);
            }

            @Override
            public void reset() {
                super.reset();
                DefaultApplierElement.this.impl.isLowerBound = false;
                DefaultApplierElement.this.impl.isUpperBound = false;
                DefaultApplierElement.this.impl.boundType = BoundType.UNBOUNDED;
            }

            @Override
            public Void visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotationMirror qual) {
                if (this.visitedNodes.containsKey(type)) {
                    return (Void)this.visitedNodes.get(type);
                }
                this.visitBounds(type, type.getUpperBound(), type.getLowerBound(), qual);
                return null;
            }

            @Override
            public Void visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotationMirror qual) {
                if (this.visitedNodes.containsKey(type)) {
                    return (Void)this.visitedNodes.get(type);
                }
                this.visitBounds(type, type.getExtendsBound(), type.getSuperBound(), qual);
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void visitBounds(AnnotatedTypeMirror boundedType, AnnotatedTypeMirror upperBound, AnnotatedTypeMirror lowerBound, AnnotationMirror qual) {
                boolean prevIsUpperBound = this.isUpperBound;
                boolean prevIsLowerBound = this.isLowerBound;
                BoundType prevBoundType = this.boundType;
                this.boundType = QualifierDefaults.getBoundType(boundedType, DefaultApplierElement.this.atypeFactory);
                try {
                    this.isLowerBound = true;
                    this.isUpperBound = false;
                    this.scanAndReduce(lowerBound, qual, null);
                    this.visitedNodes.put(DefaultApplierElement.this.type, null);
                    this.isLowerBound = false;
                    this.isUpperBound = true;
                    this.scanAndReduce(upperBound, qual, null);
                    this.visitedNodes.put(DefaultApplierElement.this.type, null);
                }
                finally {
                    this.isUpperBound = prevIsUpperBound;
                    this.isLowerBound = prevIsLowerBound;
                    this.boundType = prevBoundType;
                }
            }
        }
    }
}

