/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.fenum;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.fenum.FenumAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.javacutil.TreeUtils;

public class FenumVisitor
extends BaseTypeVisitor<FenumAnnotatedTypeFactory> {
    public FenumVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    public Void visitBinary(BinaryTree node, Void p) {
        if (!TreeUtils.isStringConcatenation(node)) {
            AnnotatedTypeMirror lhsAtm = ((FenumAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getLeftOperand());
            AnnotatedTypeMirror rhsAtm = ((FenumAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getRightOperand());
            Set<AnnotationMirror> lhs = lhsAtm.getEffectiveAnnotations();
            Set<AnnotationMirror> rhs = rhsAtm.getEffectiveAnnotations();
            QualifierHierarchy qualHierarchy = ((FenumAnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy();
            if (!qualHierarchy.isSubtype(lhs, rhs) && !qualHierarchy.isSubtype(rhs, lhs)) {
                this.checker.report(Result.failure("binary.type.incompatible", lhsAtm, rhsAtm), node);
            }
        }
        return (Void)super.visitBinary(node, p);
    }

    @Override
    public Void visitSwitch(SwitchTree node, Void p) {
        ExpressionTree expr = node.getExpression();
        AnnotatedTypeMirror exprType = ((FenumAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(expr);
        for (CaseTree caseTree : node.getCases()) {
            ExpressionTree realCaseExpr = caseTree.getExpression();
            if (realCaseExpr == null) continue;
            AnnotatedTypeMirror caseType = ((FenumAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(realCaseExpr);
            this.commonAssignmentCheck(exprType, caseType, caseTree, "switch.type.incompatible");
        }
        return (Void)super.visitSwitch(node, p);
    }

    @Override
    protected void checkConstructorInvocation(AnnotatedTypeMirror.AnnotatedDeclaredType dt, AnnotatedTypeMirror.AnnotatedExecutableType constructor, NewClassTree src) {
    }

    @Override
    protected void checkConstructorResult(AnnotatedTypeMirror.AnnotatedExecutableType constructorType, ExecutableElement constructorElement) {
    }

    @Override
    protected Set<? extends AnnotationMirror> getExceptionParameterLowerBoundAnnotations() {
        return Collections.singleton(((FenumAnnotatedTypeFactory)this.atypeFactory).FENUM_UNQUALIFIED);
    }

    @Override
    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedDeclaredType declarationType, AnnotatedTypeMirror.AnnotatedDeclaredType useType, Tree tree) {
        return true;
    }
}

