/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.index.IndexMethodIdentifier;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.qual.IntRange;
import org.checkerframework.common.value.qual.IntVal;
import org.checkerframework.common.value.util.Range;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class IndexUtil {
    public static List<String> getValueOfAnnotationWithStringArgument(AnnotationMirror anno) {
        if (!AnnotationUtils.hasElementValue(anno, "value")) {
            return null;
        }
        return AnnotationUtils.getElementValueArray(anno, "value", String.class, true);
    }

    public static Range getPossibleValues(AnnotatedTypeMirror valueType, ValueAnnotatedTypeFactory valueAnnotatedTypeFactory) {
        if (valueAnnotatedTypeFactory.isIntRange(valueType.getAnnotations())) {
            return ValueAnnotatedTypeFactory.getRange(valueType.getAnnotation(IntRange.class));
        }
        List<Long> values = ValueAnnotatedTypeFactory.getIntValues(valueType.getAnnotation(IntVal.class));
        if (values != null) {
            return new Range(Collections.min(values), Collections.max(values));
        }
        return null;
    }

    public static Long getExactValue(Tree tree, ValueAnnotatedTypeFactory factory) {
        AnnotatedTypeMirror valueType = factory.getAnnotatedType(tree);
        Range possibleValues = IndexUtil.getPossibleValues(valueType, factory);
        if (possibleValues != null && possibleValues.from == possibleValues.to) {
            return possibleValues.from;
        }
        return null;
    }

    public static Long getExactValue(Element element, ValueAnnotatedTypeFactory factory) {
        AnnotatedTypeMirror valueType = factory.getAnnotatedType(element);
        Range possibleValues = IndexUtil.getPossibleValues(valueType, factory);
        if (possibleValues != null && possibleValues.from == possibleValues.to) {
            return possibleValues.from;
        }
        return null;
    }

    public static Long getMinValue(Tree tree, ValueAnnotatedTypeFactory factory) {
        AnnotatedTypeMirror valueType = factory.getAnnotatedType(tree);
        Range possibleValues = IndexUtil.getPossibleValues(valueType, factory);
        if (possibleValues != null) {
            return possibleValues.from;
        }
        return null;
    }

    public static Long getMaxValue(Tree tree, ValueAnnotatedTypeFactory factory) {
        AnnotatedTypeMirror valueType = factory.getAnnotatedType(tree);
        Range possibleValues = IndexUtil.getPossibleValues(valueType, factory);
        if (possibleValues != null) {
            return possibleValues.to;
        }
        return null;
    }

    public static int getMinLen(Tree tree, ValueAnnotatedTypeFactory valueAnnotatedTypeFactory) {
        AnnotatedTypeMirror minLenType = valueAnnotatedTypeFactory.getAnnotatedType(tree);
        return valueAnnotatedTypeFactory.getMinLenValue(minLenType);
    }

    public static boolean isSequenceType(TypeMirror type) {
        return type.getKind() == TypeKind.ARRAY || TypesUtils.isString(type);
    }

    public static ExpressionTree getLengthSequenceTree(Tree lengthTree, IndexMethodIdentifier imf, ProcessingEnvironment processingEnv) {
        if (TreeUtils.isArrayLengthAccess(lengthTree)) {
            return ((MemberSelectTree)lengthTree).getExpression();
        }
        if (imf.isLengthOfMethodInvocation(lengthTree)) {
            return TreeUtils.getReceiverTree((MethodInvocationTree)lengthTree);
        }
        return null;
    }

    public static Integer getMinLenFromTree(Tree tree, ValueAnnotatedTypeFactory valueATF) {
        AnnotatedTypeMirror minLenType = valueATF.getAnnotatedType(tree);
        Long min2 = valueATF.getMinimumIntegralValue(minLenType);
        if (min2 == null) {
            return null;
        }
        if (min2 < 0L || min2 > Integer.MAX_VALUE) {
            min2 = 0L;
        }
        return min2.intValue();
    }
}

