/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.lowerbound;

import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import org.checkerframework.checker.index.IndexAbstractTransfer;
import org.checkerframework.checker.index.IndexRefinementInfo;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.index.lowerbound.LowerBoundAnnotatedTypeFactory;
import org.checkerframework.checker.index.qual.GTENegativeOne;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.index.upperbound.OffsetEquation;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.dataflow.cfg.node.BitwiseAndNode;
import org.checkerframework.dataflow.cfg.node.IntegerDivisionNode;
import org.checkerframework.dataflow.cfg.node.IntegerRemainderNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NumericalAdditionNode;
import org.checkerframework.dataflow.cfg.node.NumericalMultiplicationNode;
import org.checkerframework.dataflow.cfg.node.NumericalSubtractionNode;
import org.checkerframework.dataflow.cfg.node.SignedRightShiftNode;
import org.checkerframework.dataflow.cfg.node.UnsignedRightShiftNode;
import org.checkerframework.framework.flow.CFAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;

public class LowerBoundTransfer
extends IndexAbstractTransfer {
    public final AnnotationMirror GTEN1;
    public final AnnotationMirror NN;
    public final AnnotationMirror POS;
    public final AnnotationMirror UNKNOWN;
    private LowerBoundAnnotatedTypeFactory aTypeFactory;

    public LowerBoundTransfer(CFAnalysis analysis) {
        super(analysis);
        this.aTypeFactory = (LowerBoundAnnotatedTypeFactory)analysis.getTypeFactory();
        this.GTEN1 = this.aTypeFactory.GTEN1;
        this.NN = this.aTypeFactory.NN;
        this.POS = this.aTypeFactory.POS;
        this.UNKNOWN = this.aTypeFactory.UNKNOWN;
    }

    private void notEqualToValue(Node mLiteral, Node otherNode, AnnotationMirror otherAnno, CFStore store) {
        block5: {
            long intLiteral;
            block4: {
                Long integerLiteral = IndexUtil.getExactValue(mLiteral.getTree(), this.aTypeFactory.getValueAnnotatedTypeFactory());
                if (integerLiteral == null) {
                    return;
                }
                intLiteral = integerLiteral;
                if (intLiteral != 0L) break block4;
                if (!AnnotationUtils.areSameByClass(otherAnno, NonNegative.class)) break block5;
                List<Node> internals = this.splitAssignments(otherNode);
                for (Node internal : internals) {
                    FlowExpressions.Receiver rec = FlowExpressions.internalReprOf((AnnotationProvider)this.aTypeFactory, internal);
                    store.insertValue(rec, this.POS);
                }
                break block5;
            }
            if (intLiteral == -1L && AnnotationUtils.areSameByClass(otherAnno, GTENegativeOne.class)) {
                List<Node> internals = this.splitAssignments(otherNode);
                for (Node internal : internals) {
                    FlowExpressions.Receiver rec = FlowExpressions.internalReprOf((AnnotationProvider)this.aTypeFactory, internal);
                    store.insertValue(rec, this.NN);
                }
            }
        }
    }

    @Override
    protected TransferResult<CFValue, CFStore> strengthenAnnotationOfEqualTo(TransferResult<CFValue, CFStore> result, Node firstNode, Node secondNode, CFValue firstValue, CFValue secondValue, boolean notEqualTo) {
        result = super.strengthenAnnotationOfEqualTo(result, firstNode, secondNode, firstValue, secondValue, notEqualTo);
        IndexRefinementInfo rfi = new IndexRefinementInfo(result, this.analysis, secondNode, firstNode);
        if (rfi.leftAnno == null || rfi.rightAnno == null) {
            return result;
        }
        CFStore notEqualsStore = notEqualTo ? rfi.thenStore : rfi.elseStore;
        this.notEqualToValue(rfi.left, rfi.right, rfi.rightAnno, notEqualsStore);
        this.notEqualToValue(rfi.right, rfi.left, rfi.leftAnno, notEqualsStore);
        this.notEqualsLessThan(rfi.left, rfi.leftAnno, rfi.right, rfi.rightAnno, notEqualsStore);
        this.notEqualsLessThan(rfi.right, rfi.rightAnno, rfi.left, rfi.leftAnno, notEqualsStore);
        return rfi.newResult;
    }

    private void notEqualsLessThan(Node leftNode, AnnotationMirror leftAnno, Node otherNode, AnnotationMirror otherAnno, CFStore store) {
        if (!this.isNonNegative(leftAnno) || !this.isNonNegative(otherAnno)) {
            return;
        }
        FlowExpressions.Receiver otherRec = FlowExpressions.internalReprOf((AnnotationProvider)this.aTypeFactory, otherNode);
        if (this.aTypeFactory.getLessThanAnnotatedTypeFactory().isLessThanOrEqual(leftNode.getTree(), otherRec.toString())) {
            store.insertValue(otherRec, this.POS);
        }
    }

    @Override
    protected void refineGT(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store, TransferInput<CFValue, CFStore> in) {
        if (rightAnno == null || leftAnno == null) {
            return;
        }
        FlowExpressions.Receiver leftRec = FlowExpressions.internalReprOf((AnnotationProvider)this.aTypeFactory, left);
        if (AnnotationUtils.areSame(rightAnno, this.GTEN1)) {
            store.insertValue(leftRec, this.NN);
            return;
        }
        if (AnnotationUtils.areSame(rightAnno, this.NN)) {
            store.insertValue(leftRec, this.POS);
            return;
        }
        if (AnnotationUtils.areSame(rightAnno, this.POS)) {
            store.insertValue(leftRec, this.POS);
            return;
        }
    }

    @Override
    protected void refineGTE(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store, TransferInput<CFValue, CFStore> in) {
        if (rightAnno == null || leftAnno == null) {
            return;
        }
        FlowExpressions.Receiver leftRec = FlowExpressions.internalReprOf((AnnotationProvider)this.aTypeFactory, left);
        AnnotationMirror newLBType = this.aTypeFactory.getQualifierHierarchy().greatestLowerBound(rightAnno, leftAnno);
        store.insertValue(leftRec, newLBType);
    }

    private AnnotationMirror anmAfterSubtractingOne(AnnotationMirror oldAnm) {
        if (this.isPositive(oldAnm)) {
            return this.NN;
        }
        if (this.isNonNegative(oldAnm)) {
            return this.GTEN1;
        }
        return this.UNKNOWN;
    }

    private AnnotationMirror anmAfterAddingOne(AnnotationMirror oldAnm) {
        if (this.isNonNegative(oldAnm)) {
            return this.POS;
        }
        if (this.isGTEN1(oldAnm)) {
            return this.NN;
        }
        return this.UNKNOWN;
    }

    private AnnotationMirror getAnnotationForLiteralPlus(int val, AnnotationMirror nonLiteralType) {
        if (val == -2) {
            if (this.isPositive(nonLiteralType)) {
                return this.GTEN1;
            }
        } else {
            if (val == -1) {
                return this.anmAfterSubtractingOne(nonLiteralType);
            }
            if (val == 0) {
                return nonLiteralType;
            }
            if (val == 1) {
                return this.anmAfterAddingOne(nonLiteralType);
            }
            if (val >= 2 && this.isGTEN1(nonLiteralType)) {
                return this.POS;
            }
        }
        return this.UNKNOWN;
    }

    private AnnotationMirror getAnnotationForPlus(BinaryOperationNode binaryOpNode, TransferInput<CFValue, CFStore> p) {
        Node leftExprNode = binaryOpNode.getLeftOperand();
        Node rightExprNode = binaryOpNode.getRightOperand();
        AnnotationMirror leftAnno = this.getLowerBoundAnnotation(leftExprNode, p);
        Long valRight = IndexUtil.getExactValue(rightExprNode.getTree(), this.aTypeFactory.getValueAnnotatedTypeFactory());
        if (valRight != null) {
            return this.getAnnotationForLiteralPlus(valRight.intValue(), leftAnno);
        }
        AnnotationMirror rightAnno = this.getLowerBoundAnnotation(rightExprNode, p);
        Long valLeft = IndexUtil.getExactValue(leftExprNode.getTree(), this.aTypeFactory.getValueAnnotatedTypeFactory());
        if (valLeft != null) {
            return this.getAnnotationForLiteralPlus(valLeft.intValue(), rightAnno);
        }
        if (AnnotationUtils.areSameByClass(leftAnno, Positive.class) && AnnotationUtils.areSameByClass(rightAnno, Positive.class)) {
            return this.POS;
        }
        if (AnnotationUtils.areSameByClass(leftAnno, NonNegative.class)) {
            return rightAnno;
        }
        if (AnnotationUtils.areSameByClass(rightAnno, NonNegative.class)) {
            return leftAnno;
        }
        if (this.isPositive(leftAnno) && this.isGTEN1(rightAnno) || this.isGTEN1(leftAnno) && this.isPositive(rightAnno)) {
            return this.NN;
        }
        return this.UNKNOWN;
    }

    private AnnotationMirror getAnnotationForMinus(BinaryOperationNode minusNode, TransferInput<CFValue, CFStore> p) {
        Long valRight = IndexUtil.getExactValue(minusNode.getRightOperand().getTree(), this.aTypeFactory.getValueAnnotatedTypeFactory());
        if (valRight != null) {
            AnnotationMirror leftAnno = this.getLowerBoundAnnotation(minusNode.getLeftOperand(), p);
            AnnotationMirror result = this.getAnnotationForLiteralPlus(-1 * valRight.intValue(), leftAnno);
            Tree leftExpr = minusNode.getLeftOperand().getTree();
            Integer minLen = null;
            if (leftExpr.getKind() == Tree.Kind.MEMBER_SELECT) {
                MemberSelectTree mstree = (MemberSelectTree)leftExpr;
                minLen = this.aTypeFactory.getMinLenFromMemberSelectTree(mstree);
            } else if (leftExpr.getKind() == Tree.Kind.METHOD_INVOCATION) {
                MethodInvocationTree mitree = (MethodInvocationTree)leftExpr;
                minLen = this.aTypeFactory.getMinLenFromMethodInvocationTree(mitree);
            }
            if (minLen != null) {
                result = this.aTypeFactory.anmFromVal((long)minLen.intValue() - valRight);
            }
            return result;
        }
        OffsetEquation leftExpression = OffsetEquation.createOffsetFromNode(minusNode.getLeftOperand(), this.aTypeFactory, '+');
        if (leftExpression != null) {
            if (this.aTypeFactory.getLessThanAnnotatedTypeFactory().isLessThan(minusNode.getRightOperand().getTree(), leftExpression.toString())) {
                return this.POS;
            }
            if (this.aTypeFactory.getLessThanAnnotatedTypeFactory().isLessThanOrEqual(minusNode.getRightOperand().getTree(), leftExpression.toString())) {
                return this.NN;
            }
        }
        return this.UNKNOWN;
    }

    private AnnotationMirror getAnnotationForLiteralMultiply(int val, AnnotationMirror nonLiteralType) {
        if (val == 0) {
            return this.NN;
        }
        if (val == 1) {
            return nonLiteralType;
        }
        if (val > 1 && this.isNonNegative(nonLiteralType)) {
            return nonLiteralType;
        }
        return this.UNKNOWN;
    }

    private AnnotationMirror getAnnotationForMultiply(NumericalMultiplicationNode node, TransferInput<CFValue, CFStore> p) {
        AnnotationMirror randomSpecialCaseResult = this.aTypeFactory.checkForMathRandomSpecialCase(node);
        if (randomSpecialCaseResult != null) {
            return randomSpecialCaseResult;
        }
        AnnotationMirror leftAnno = this.getLowerBoundAnnotation(node.getLeftOperand(), p);
        Long valRight = IndexUtil.getExactValue(node.getRightOperand().getTree(), this.aTypeFactory.getValueAnnotatedTypeFactory());
        if (valRight != null) {
            return this.getAnnotationForLiteralMultiply(valRight.intValue(), leftAnno);
        }
        AnnotationMirror rightAnno = this.getLowerBoundAnnotation(node.getRightOperand(), p);
        Long valLeft = IndexUtil.getExactValue(node.getLeftOperand().getTree(), this.aTypeFactory.getValueAnnotatedTypeFactory());
        if (valLeft != null) {
            return this.getAnnotationForLiteralMultiply(valLeft.intValue(), rightAnno);
        }
        if (this.isPositive(leftAnno) && this.isPositive(rightAnno)) {
            return this.POS;
        }
        if (this.isNonNegative(leftAnno) && this.isNonNegative(rightAnno)) {
            return this.NN;
        }
        return this.UNKNOWN;
    }

    private AnnotationMirror addAnnotationForLiteralDivideLeft(int val, AnnotationMirror rightAnno) {
        if (val == 0) {
            return this.NN;
        }
        if (val == 1) {
            if (this.isNonNegative(rightAnno)) {
                return this.NN;
            }
            return this.GTEN1;
        }
        return this.UNKNOWN;
    }

    private AnnotationMirror addAnnotationForLiteralDivideRight(int val, AnnotationMirror leftAnno) {
        if (val == 0) {
            return this.aTypeFactory.BOTTOM;
        }
        if (val == 1) {
            return leftAnno;
        }
        if (val >= 2 && this.isNonNegative(leftAnno)) {
            return this.NN;
        }
        return this.UNKNOWN;
    }

    private AnnotationMirror getAnnotationForDivide(IntegerDivisionNode node, TransferInput<CFValue, CFStore> p) {
        AnnotationMirror leftAnno = this.getLowerBoundAnnotation(node.getLeftOperand(), p);
        Long valRight = IndexUtil.getExactValue(node.getRightOperand().getTree(), this.aTypeFactory.getValueAnnotatedTypeFactory());
        if (valRight != null) {
            return this.addAnnotationForLiteralDivideRight(valRight.intValue(), leftAnno);
        }
        AnnotationMirror rightAnno = this.getLowerBoundAnnotation(node.getRightOperand(), p);
        Long valLeft = IndexUtil.getExactValue(node.getLeftOperand().getTree(), this.aTypeFactory.getValueAnnotatedTypeFactory());
        if (valLeft != null) {
            return this.addAnnotationForLiteralDivideLeft(valLeft.intValue(), leftAnno);
        }
        if (this.isPositive(leftAnno) && this.isNonNegative(rightAnno)) {
            return this.NN;
        }
        if (this.isNonNegative(rightAnno)) {
            return leftAnno;
        }
        return this.UNKNOWN;
    }

    private AnnotationMirror addAnnotationForLiteralRemainder(int val) {
        if (val == 1 || val == -1) {
            return this.NN;
        }
        return this.UNKNOWN;
    }

    @Override
    protected void addInformationFromPreconditions(CFStore info, AnnotatedTypeFactory factory, UnderlyingAST.CFGMethod method, MethodTree methodTree, ExecutableElement methodElement) {
        super.addInformationFromPreconditions(info, factory, method, methodTree, methodElement);
        List<? extends VariableTree> paramTrees = methodTree.getParameters();
        for (VariableTree variableTree : paramTrees) {
            if (!TreeUtils.typeOf(variableTree).getKind().equals((Object)TypeKind.CHAR)) continue;
            FlowExpressions.Receiver rec = null;
            try {
                rec = FlowExpressionParseUtil.internalReprOfVariable(this.aTypeFactory, variableTree);
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException flowExpressionParseException) {
                // empty catch block
            }
            if (rec == null) continue;
            info.insertValue(rec, this.aTypeFactory.NN);
        }
    }

    public AnnotationMirror getAnnotationForRemainder(IntegerRemainderNode node, TransferInput<CFValue, CFStore> p) {
        AnnotationMirror leftAnno = this.getLowerBoundAnnotation(node.getLeftOperand(), p);
        Long valRight = IndexUtil.getExactValue(node.getRightOperand().getTree(), this.aTypeFactory.getValueAnnotatedTypeFactory());
        if (valRight != null) {
            return this.addAnnotationForLiteralRemainder(valRight.intValue());
        }
        if (this.isNonNegative(leftAnno)) {
            return this.NN;
        }
        if (this.isGTEN1(leftAnno)) {
            return this.GTEN1;
        }
        return this.UNKNOWN;
    }

    private AnnotationMirror getAnnotationForRightShift(BinaryOperationNode node, TransferInput<CFValue, CFStore> p) {
        AnnotationMirror leftAnno = this.getLowerBoundAnnotation(node.getLeftOperand(), p);
        AnnotationMirror rightAnno = this.getLowerBoundAnnotation(node.getRightOperand(), p);
        if (this.isNonNegative(leftAnno) && this.isNonNegative(rightAnno)) {
            return this.NN;
        }
        return this.UNKNOWN;
    }

    private AnnotationMirror getAnnotationForAnd(BitwiseAndNode node, TransferInput<CFValue, CFStore> p) {
        AnnotationMirror rightAnno = this.getLowerBoundAnnotation(node.getRightOperand(), p);
        if (this.isNonNegative(rightAnno)) {
            return this.NN;
        }
        AnnotationMirror leftAnno = this.getLowerBoundAnnotation(node.getLeftOperand(), p);
        if (this.isNonNegative(leftAnno)) {
            return this.NN;
        }
        return this.UNKNOWN;
    }

    private boolean isPositive(AnnotationMirror anm) {
        return AnnotationUtils.areSameByClass(anm, Positive.class);
    }

    private boolean isNonNegative(AnnotationMirror anm) {
        return AnnotationUtils.areSameByClass(anm, NonNegative.class) || this.isPositive(anm);
    }

    private boolean isGTEN1(AnnotationMirror anm) {
        return AnnotationUtils.areSameByClass(anm, GTENegativeOne.class) || this.isNonNegative(anm);
    }

    private AnnotationMirror getLowerBoundAnnotation(Node subNode, TransferInput<CFValue, CFStore> p) {
        CFValue value = p.getValueOfSubNode(subNode);
        return this.getLowerBoundAnnotation(value);
    }

    private AnnotationMirror getLowerBoundAnnotation(CFValue cfValue) {
        return this.aTypeFactory.getQualifierHierarchy().findAnnotationInHierarchy(cfValue.getAnnotations(), this.aTypeFactory.UNKNOWN);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalAddition(NumericalAdditionNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult result = (TransferResult)super.visitNumericalAddition(n, p);
        AnnotationMirror newAnno = this.getAnnotationForPlus(n, p);
        return this.createNewResult(result, newAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalSubtraction(NumericalSubtractionNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult result = (TransferResult)super.visitNumericalSubtraction(n, p);
        AnnotationMirror newAnno = this.getAnnotationForMinus(n, p);
        return this.createNewResult(result, newAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalMultiplication(NumericalMultiplicationNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult result = (TransferResult)super.visitNumericalMultiplication(n, p);
        AnnotationMirror newAnno = this.getAnnotationForMultiply(n, p);
        return this.createNewResult(result, newAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitIntegerDivision(IntegerDivisionNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult result = (TransferResult)super.visitIntegerDivision(n, p);
        AnnotationMirror newAnno = this.getAnnotationForDivide(n, p);
        return this.createNewResult(result, newAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitIntegerRemainder(IntegerRemainderNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitIntegerRemainder(n, p);
        AnnotationMirror resultAnno = this.getAnnotationForRemainder(n, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitSignedRightShift(SignedRightShiftNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitSignedRightShift(n, p);
        AnnotationMirror resultAnno = this.getAnnotationForRightShift(n, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitUnsignedRightShift(UnsignedRightShiftNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitUnsignedRightShift(n, p);
        AnnotationMirror resultAnno = this.getAnnotationForRightShift(n, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitBitwiseAnd(BitwiseAndNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitBitwiseAnd(n, p);
        AnnotationMirror resultAnno = this.getAnnotationForAnd(n, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    private TransferResult<CFValue, CFStore> createNewResult(TransferResult<CFValue, CFStore> result, AnnotationMirror resultAnno) {
        CFValue newResultValue = (CFValue)this.analysis.createSingleAnnotationValue(resultAnno, result.getResultValue().getUnderlyingType());
        return new RegularTransferResult<CFValue, CFStore>(newResultValue, result.getRegularStore());
    }
}

