/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.interning;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.checkerframework.checker.interning.InterningAnnotatedTypeFactory;
import org.checkerframework.checker.interning.qual.InternMethod;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.InternedDistinct;
import org.checkerframework.checker.interning.qual.UsesObjectEquals;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.Heuristics;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public final class InterningVisitor
extends BaseTypeVisitor<InterningAnnotatedTypeFactory> {
    private final AnnotationMirror INTERNED;
    private final AnnotationMirror INTERNED_DISTINCT;
    private final DeclaredType typeToCheck;
    private final ExecutableElement comparableCompareTo;

    public InterningVisitor(BaseTypeChecker checker) {
        super(checker);
        this.INTERNED = AnnotationBuilder.fromClass(this.elements, Interned.class);
        this.INTERNED_DISTINCT = AnnotationBuilder.fromClass(this.elements, InternedDistinct.class);
        this.typeToCheck = this.typeToCheck();
        this.comparableCompareTo = TreeUtils.getMethod("java.lang.Comparable", "compareTo", 1, this.checker.getProcessingEnvironment());
    }

    private boolean shouldCheckExpression(ExpressionTree tree) {
        if (this.typeToCheck == null) {
            return true;
        }
        TypeMirror type = TreeUtils.typeOf(tree);
        return this.types.isSubtype(type, this.typeToCheck) || this.types.isSubtype(this.typeToCheck, type);
    }

    @Override
    public Void visitBinary(BinaryTree node, Void p) {
        if (node.getKind() != Tree.Kind.EQUAL_TO && node.getKind() != Tree.Kind.NOT_EQUAL_TO) {
            return (Void)super.visitBinary(node, p);
        }
        ExpressionTree leftOp = node.getLeftOperand();
        ExpressionTree rightOp = node.getRightOperand();
        if (leftOp.getKind() == Tree.Kind.NULL_LITERAL || rightOp.getKind() == Tree.Kind.NULL_LITERAL) {
            return (Void)super.visitBinary(node, p);
        }
        AnnotatedTypeMirror left = ((InterningAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(leftOp);
        AnnotatedTypeMirror right = ((InterningAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(rightOp);
        if (left.getKind().isPrimitive() || right.getKind().isPrimitive()) {
            return (Void)super.visitBinary(node, p);
        }
        if (left.hasEffectiveAnnotation(this.INTERNED_DISTINCT) || right.hasEffectiveAnnotation(this.INTERNED_DISTINCT)) {
            return (Void)super.visitBinary(node, p);
        }
        if (!this.shouldCheckExpression(leftOp) && !this.shouldCheckExpression(rightOp)) {
            return (Void)super.visitBinary(node, p);
        }
        if (this.suppressInsideComparison(node)) {
            return (Void)super.visitBinary(node, p);
        }
        if (this.suppressEarlyEquals(node)) {
            return (Void)super.visitBinary(node, p);
        }
        if (this.suppressEarlyCompareTo(node)) {
            return (Void)super.visitBinary(node, p);
        }
        if (this.suppressEqualsIfClassIsAnnotated(left, right)) {
            return (Void)super.visitBinary(node, p);
        }
        Element leftElt = null;
        Element rightElt = null;
        if (left instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) {
            leftElt = ((DeclaredType)left.getUnderlyingType()).asElement();
        }
        if (right instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) {
            rightElt = ((DeclaredType)right.getUnderlyingType()).asElement();
        }
        if (!(left.hasEffectiveAnnotation(this.INTERNED) || leftElt != null && leftElt.getAnnotation(UsesObjectEquals.class) != null)) {
            this.checker.report(Result.failure("not.interned", left), leftOp);
        }
        if (!(right.hasEffectiveAnnotation(this.INTERNED) || rightElt != null && rightElt.getAnnotation(UsesObjectEquals.class) != null)) {
            this.checker.report(Result.failure("not.interned", right), rightOp);
        }
        return (Void)super.visitBinary(node, p);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        if (this.isInvocationOfEquals(node)) {
            AnnotatedTypeMirror recv = ((InterningAnnotatedTypeFactory)this.atypeFactory).getReceiverType(node);
            AnnotatedTypeMirror comp = ((InterningAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getArguments().get(0));
            if (this.checker.getLintOption("dotequals", true) && recv.hasEffectiveAnnotation(this.INTERNED) && comp.hasEffectiveAnnotation(this.INTERNED)) {
                this.checker.report(Result.warning("unnecessary.equals", new Object[0]), node);
            }
        }
        return super.visitMethodInvocation(node, p);
    }

    @Override
    public void processClassTree(ClassTree node) {
        TypeElement elt = TreeUtils.elementFromDeclaration(node);
        UsesObjectEquals annotation = elt.getAnnotation(UsesObjectEquals.class);
        Tree superClass = node.getExtendsClause();
        Element elmt = null;
        if (superClass != null && (superClass instanceof IdentifierTree || superClass instanceof MemberSelectTree)) {
            elmt = TreeUtils.elementFromUse((ExpressionTree)superClass);
        }
        if (annotation != null) {
            if (this.overridesEquals(node)) {
                this.checker.report(Result.failure("overrides.equals", new Object[0]), node);
            }
            if (superClass != null && (elmt == null || elmt.getAnnotation(UsesObjectEquals.class) == null)) {
                this.checker.report(Result.failure("superclass.notannotated", new Object[0]), node);
            }
        } else if (superClass != null && elmt != null && elmt.getAnnotation(UsesObjectEquals.class) != null) {
            this.checker.report(Result.failure("superclass.annotated", new Object[0]), node);
        }
        super.processClassTree(node);
    }

    @Override
    protected void checkConstructorResult(AnnotatedTypeMirror.AnnotatedExecutableType constructorType, ExecutableElement constructorElement) {
        if (constructorElement.getEnclosingElement().getKind() == ElementKind.ENUM) {
            return;
        }
        super.checkConstructorResult(constructorType, constructorElement);
    }

    @Override
    public boolean validateTypeOf(Tree tree) {
        NewClassTree newClassTree;
        TypeMirror typeMirror;
        Set<AnnotationMirror> bounds;
        if (tree.getKind() == Tree.Kind.METHOD && TreeUtils.isConstructor((MethodTree)tree)) {
            return true;
        }
        if (tree.getKind() == Tree.Kind.NEW_CLASS && AnnotationUtils.containsSameByClass(bounds = ((InterningAnnotatedTypeFactory)this.atypeFactory).getTypeDeclarationBounds(typeMirror = TreeUtils.typeOf(newClassTree = (NewClassTree)tree)), Interned.class)) {
            AnnotatedTypeFactory.ParameterizedExecutableType fromUse = ((InterningAnnotatedTypeFactory)this.atypeFactory).constructorFromUse(newClassTree);
            AnnotatedTypeMirror.AnnotatedExecutableType constructor = fromUse.executableType;
            if (!this.checkCreationOfInternedObject(newClassTree, constructor)) {
                return false;
            }
        }
        return super.validateTypeOf(tree);
    }

    private boolean checkCreationOfInternedObject(NewClassTree newInternedObject, AnnotatedTypeMirror.AnnotatedExecutableType constructor) {
        if (constructor.getReturnType().hasAnnotation(Interned.class)) {
            return true;
        }
        TreePath path = this.getCurrentPath();
        if (path != null) {
            ExecutableElement elt;
            Tree parent;
            TreePath parentPath;
            for (parentPath = path.getParentPath(); parentPath != null && parentPath.getLeaf().getKind() == Tree.Kind.PARENTHESIZED; parentPath = parentPath.getParentPath()) {
            }
            if (parentPath != null && parentPath.getParentPath() != null && (parent = parentPath.getParentPath().getLeaf()).getKind() == Tree.Kind.METHOD_INVOCATION && ((InterningAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(elt = TreeUtils.elementFromUse((MethodInvocationTree)parent), InternMethod.class) != null) {
                return true;
            }
        }
        this.checker.report(Result.failure("interned.object.creation", new Object[0]), newInternedObject);
        return false;
    }

    private boolean overridesEquals(ClassTree node) {
        List<? extends Tree> members = node.getMembers();
        for (Tree tree : members) {
            MethodTree mTree;
            ExecutableElement enclosing;
            if (!(tree instanceof MethodTree) || !this.overrides(enclosing = TreeUtils.elementFromDeclaration(mTree = (MethodTree)tree), Object.class, "equals")) continue;
            return true;
        }
        return false;
    }

    private boolean isInvocationOfEquals(MethodInvocationTree node) {
        ExecutableElement method = TreeUtils.elementFromUse(node);
        return method.getParameters().size() == 1 && method.getReturnType().getKind() == TypeKind.BOOLEAN && method.getSimpleName().contentEquals("equals");
    }

    private boolean suppressInsideComparison(BinaryTree node) {
        Tree tree;
        if (node.getKind() != Tree.Kind.EQUAL_TO) {
            return false;
        }
        ExpressionTree left = node.getLeftOperand();
        ExpressionTree right = node.getRightOperand();
        if (left.getKind() != Tree.Kind.IDENTIFIER || right.getKind() != Tree.Kind.IDENTIFIER) {
            return false;
        }
        if (!Heuristics.matchParents(this.getCurrentPath(), Tree.Kind.IF, Tree.Kind.METHOD)) {
            return false;
        }
        TreePath parentPath = this.getCurrentPath().getParentPath();
        Tree ifStatementTree = null;
        MethodTree methodTree = null;
        while ((tree = parentPath.getLeaf()) != null) {
            if (tree.getKind() == Tree.Kind.IF) {
                ifStatementTree = tree;
            } else if (tree.getKind() == Tree.Kind.METHOD) {
                methodTree = (MethodTree)tree;
                break;
            }
            parentPath = parentPath.getParentPath();
        }
        assert (ifStatementTree != null);
        assert (methodTree != null);
        StatementTree stmnt = methodTree.getBody().getStatements().get(0);
        assert (stmnt != null);
        if (stmnt != ifStatementTree) {
            return false;
        }
        ExecutableElement enclosing = TreeUtils.elementFromDeclaration(this.visitorState.getMethodTree());
        assert (enclosing != null);
        Element lhs = TreeUtils.elementFromUse((IdentifierTree)left);
        Element rhs = TreeUtils.elementFromUse((IdentifierTree)right);
        Heuristics.Matcher matcherIfReturnsZero = new Heuristics.Matcher(){

            @Override
            public Boolean visitIf(IfTree tree, Void p) {
                return (Boolean)this.visit(tree.getThenStatement(), p);
            }

            @Override
            public Boolean visitBlock(BlockTree tree, Void p) {
                if (tree.getStatements().isEmpty()) {
                    return false;
                }
                return (Boolean)this.visit(tree.getStatements().get(0), p);
            }

            @Override
            public Boolean visitReturn(ReturnTree tree, Void p) {
                ExpressionTree expr = tree.getExpression();
                return expr != null && expr.getKind() == Tree.Kind.INT_LITERAL && ((LiteralTree)expr).getValue().equals(0);
            }
        };
        if (this.overrides(enclosing, Comparator.class, "compare")) {
            boolean returnsZero = Heuristics.Matchers.withIn(Heuristics.Matchers.ofKind(Tree.Kind.IF, matcherIfReturnsZero)).match(this.getCurrentPath());
            if (!returnsZero) {
                return false;
            }
            assert (enclosing.getParameters().size() == 2);
            Element p1 = enclosing.getParameters().get(0);
            Element p2 = enclosing.getParameters().get(1);
            return p1.equals(lhs) && p2.equals(rhs) || p2.equals(lhs) && p1.equals(rhs);
        }
        if (this.overrides(enclosing, Object.class, "equals")) {
            assert (enclosing.getParameters().size() == 1);
            Element param = enclosing.getParameters().get(0);
            Element thisElt = this.getThis(this.trees.getScope(this.getCurrentPath()));
            assert (thisElt != null);
            return thisElt.equals(lhs) && param.equals(rhs) || param.equals(lhs) && thisElt.equals(rhs);
        }
        if (this.overrides(enclosing, Comparable.class, "compareTo")) {
            boolean returnsZero = Heuristics.Matchers.withIn(Heuristics.Matchers.ofKind(Tree.Kind.IF, matcherIfReturnsZero)).match(this.getCurrentPath());
            if (!returnsZero) {
                return false;
            }
            assert (enclosing.getParameters().size() == 1);
            Element param = enclosing.getParameters().get(0);
            Element thisElt = this.getThis(this.trees.getScope(this.getCurrentPath()));
            assert (thisElt != null);
            return thisElt.equals(lhs) && param.equals(rhs) || param.equals(lhs) && thisElt.equals(rhs);
        }
        return false;
    }

    private static boolean sameTree(ExpressionTree expr1, ExpressionTree expr2) {
        return TreeUtils.withoutParens(expr1).toString().equals(TreeUtils.withoutParens(expr2).toString());
    }

    private boolean suppressEarlyEquals(final BinaryTree node) {
        if (node.getKind() != Tree.Kind.EQUAL_TO) {
            return false;
        }
        final ExpressionTree left = TreeUtils.withoutParens(node.getLeftOperand());
        final ExpressionTree right = TreeUtils.withoutParens(node.getRightOperand());
        Heuristics.Matcher matcherEqOrEquals = new Heuristics.Matcher(){

            private boolean isNeqNull(ExpressionTree e, ExpressionTree e1, ExpressionTree e2) {
                if ((e = TreeUtils.withoutParens(e)).getKind() != Tree.Kind.NOT_EQUAL_TO) {
                    return false;
                }
                ExpressionTree neqLeft = ((BinaryTree)e).getLeftOperand();
                ExpressionTree neqRight = ((BinaryTree)e).getRightOperand();
                return (InterningVisitor.sameTree(neqLeft, e1) || InterningVisitor.sameTree(neqLeft, e2)) && neqRight.getKind() == Tree.Kind.NULL_LITERAL || (InterningVisitor.sameTree(neqRight, e1) || InterningVisitor.sameTree(neqRight, e2)) && neqLeft.getKind() == Tree.Kind.NULL_LITERAL;
            }

            @Override
            public Boolean visitBinary(BinaryTree tree, Void p) {
                ExpressionTree leftTree = tree.getLeftOperand();
                ExpressionTree rightTree = tree.getRightOperand();
                if (tree.getKind() == Tree.Kind.CONDITIONAL_OR) {
                    if (InterningVisitor.sameTree(leftTree, node)) {
                        return (Boolean)this.visit(rightTree, p);
                    }
                    return false;
                }
                if (tree.getKind() == Tree.Kind.CONDITIONAL_AND) {
                    if (this.isNeqNull(leftTree, left, right)) {
                        return (Boolean)this.visit(rightTree, p);
                    }
                    return false;
                }
                return false;
            }

            @Override
            public Boolean visitConditionalExpression(ConditionalExpressionTree tree, Void p) {
                ExpressionTree cond = tree.getCondition();
                ExpressionTree trueExp = tree.getTrueExpression();
                ExpressionTree falseExp = tree.getFalseExpression();
                if (this.isNeqNull(cond, left, right) && falseExp.getKind() == Tree.Kind.BOOLEAN_LITERAL && ((LiteralTree)falseExp).getValue().equals(false)) {
                    return (Boolean)this.visit(trueExp, p);
                }
                return false;
            }

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree tree, Void p) {
                if (!InterningVisitor.this.isInvocationOfEquals(tree)) {
                    return false;
                }
                List<? extends ExpressionTree> args = tree.getArguments();
                if (args.size() != 1) {
                    return false;
                }
                ExpressionTree arg = args.get(0);
                ExpressionTree exp = tree.getMethodSelect();
                if (exp.getKind() != Tree.Kind.MEMBER_SELECT) {
                    return false;
                }
                MemberSelectTree member = (MemberSelectTree)exp;
                ExpressionTree receiver = member.getExpression();
                if (InterningVisitor.sameTree(receiver, left) && InterningVisitor.sameTree(arg, right)) {
                    return true;
                }
                if (InterningVisitor.sameTree(receiver, right) && InterningVisitor.sameTree(arg, left)) {
                    return true;
                }
                return false;
            }
        };
        boolean okay = Heuristics.Matchers.withIn(Heuristics.Matchers.ofKind(Tree.Kind.CONDITIONAL_OR, matcherEqOrEquals)).match(this.getCurrentPath());
        return okay;
    }

    private boolean suppressEarlyCompareTo(final BinaryTree node) {
        if (node.getKind() != Tree.Kind.EQUAL_TO) {
            return false;
        }
        ExpressionTree left = TreeUtils.withoutParens(node.getLeftOperand());
        ExpressionTree right = TreeUtils.withoutParens(node.getRightOperand());
        if (left.getKind() != Tree.Kind.IDENTIFIER || right.getKind() != Tree.Kind.IDENTIFIER) {
            return false;
        }
        final Element lhs = TreeUtils.elementFromUse((IdentifierTree)left);
        final Element rhs = TreeUtils.elementFromUse((IdentifierTree)right);
        Heuristics.Matcher matcherEqOrCompareTo = new Heuristics.Matcher(){

            @Override
            public Boolean visitBinary(BinaryTree tree, Void p) {
                if (tree.getKind() == Tree.Kind.EQUAL_TO) {
                    ExpressionTree leftTree = tree.getLeftOperand();
                    ExpressionTree rightTree = tree.getRightOperand();
                    if (rightTree.getKind() != Tree.Kind.INT_LITERAL) {
                        return false;
                    }
                    LiteralTree rightLiteral = (LiteralTree)rightTree;
                    if (!rightLiteral.getValue().equals(0)) {
                        return false;
                    }
                    return (Boolean)this.visit(leftTree, p);
                }
                ExpressionTree leftTree = tree.getLeftOperand();
                ExpressionTree rightTree = tree.getRightOperand();
                if (leftTree != node) {
                    return false;
                }
                if (rightTree.getKind() != Tree.Kind.EQUAL_TO) {
                    return false;
                }
                return (Boolean)this.visit(rightTree, p);
            }

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree tree, Void p) {
                if (!TreeUtils.isMethodInvocation((Tree)tree, InterningVisitor.this.comparableCompareTo, InterningVisitor.this.checker.getProcessingEnvironment())) {
                    return false;
                }
                List<? extends ExpressionTree> args = tree.getArguments();
                if (args.size() != 1) {
                    return false;
                }
                ExpressionTree arg = args.get(0);
                if (arg.getKind() != Tree.Kind.IDENTIFIER) {
                    return false;
                }
                Element argElt = TreeUtils.elementFromUse(arg);
                ExpressionTree exp = tree.getMethodSelect();
                if (exp.getKind() != Tree.Kind.MEMBER_SELECT) {
                    return false;
                }
                MemberSelectTree member = (MemberSelectTree)exp;
                if (member.getExpression().getKind() != Tree.Kind.IDENTIFIER) {
                    return false;
                }
                Element refElt = TreeUtils.elementFromUse(member.getExpression());
                if (!(refElt.equals(lhs) && argElt.equals(rhs) || refElt.equals(rhs) && argElt.equals(lhs))) {
                    return false;
                }
                return true;
            }
        };
        boolean okay = Heuristics.Matchers.withIn(Heuristics.Matchers.ofKind(Tree.Kind.CONDITIONAL_OR, matcherEqOrCompareTo)).match(this.getCurrentPath());
        return okay;
    }

    private boolean suppressEqualsIfClassIsAnnotated(AnnotatedTypeMirror left, AnnotatedTypeMirror right) {
        return this.classIsAnnotated(left) || this.classIsAnnotated(right);
    }

    private boolean classIsAnnotated(AnnotatedTypeMirror type) {
        Element classElt;
        TypeMirror tm = type.getUnderlyingType();
        if (tm == null) {
            return false;
        }
        if ((tm = TypesUtils.findConcreteUpperBound(tm)) == null || tm.getKind() == TypeKind.ARRAY) {
            return false;
        }
        if (tm.getKind() != TypeKind.DECLARED) {
            this.checker.message(Diagnostic.Kind.WARNING, "InterningVisitor.classIsAnnotated: tm = %s (%s)%n", tm, tm.getClass());
        }
        if ((classElt = ((DeclaredType)tm).asElement()) == null) {
            this.checker.message(Diagnostic.Kind.WARNING, "InterningVisitor.classIsAnnotated: classElt = null for tm = %s (%s)%n", tm, tm.getClass());
        }
        if (classElt != null) {
            Set<AnnotationMirror> bound = ((InterningAnnotatedTypeFactory)this.atypeFactory).getTypeDeclarationBounds(tm);
            return AnnotationUtils.containsSameByClass(bound, Interned.class);
        }
        return false;
    }

    private Element getThis(Scope scope) {
        for (Element element : scope.getLocalElements()) {
            if (!element.getSimpleName().contentEquals("this")) continue;
            return element;
        }
        return null;
    }

    private boolean overrides(ExecutableElement e, Class<?> clazz, String method) {
        TypeElement clazzElt = this.elements.getTypeElement(clazz.getCanonicalName());
        assert (clazzElt != null);
        for (ExecutableElement elt : ElementFilter.methodsIn(clazzElt.getEnclosedElements())) {
            if (!elt.getSimpleName().contentEquals(method) || !this.elements.overrides(e, elt, clazzElt)) continue;
            return true;
        }
        return false;
    }

    DeclaredType typeToCheck() {
        String className = this.checker.getOption("checkclass");
        if (className == null) {
            return null;
        }
        TypeElement classElt = this.elements.getTypeElement(className);
        if (classElt == null) {
            return null;
        }
        return this.types.getDeclaredType(classElt, new TypeMirror[0]);
    }
}

