/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.regex;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.regex.RegexTransfer;
import org.checkerframework.checker.regex.qual.PartialRegex;
import org.checkerframework.checker.regex.qual.PolyRegex;
import org.checkerframework.checker.regex.qual.Regex;
import org.checkerframework.checker.regex.qual.RegexBottom;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.LiteralTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.PropagationTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.GraphQualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;

public class RegexAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    protected final AnnotationMirror REGEX;
    protected final AnnotationMirror REGEXBOTTOM;
    protected final AnnotationMirror PARTIALREGEX;
    protected final AnnotationMirror POLYREGEX;
    protected final ExecutableElement regexValueElement;
    private final ExecutableElement partialRegexValue;
    private final ExecutableElement patternCompile;

    public RegexAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.REGEX = AnnotationBuilder.fromClass(this.elements, Regex.class);
        this.REGEXBOTTOM = AnnotationBuilder.fromClass(this.elements, RegexBottom.class);
        this.PARTIALREGEX = AnnotationBuilder.fromClass(this.elements, PartialRegex.class);
        this.POLYREGEX = AnnotationBuilder.fromClass(this.elements, PolyRegex.class);
        this.regexValueElement = TreeUtils.getMethod(Regex.class.getName(), "value", 0, this.processingEnv);
        this.partialRegexValue = TreeUtils.getMethod(PartialRegex.class.getName(), "value", 0, this.processingEnv);
        this.patternCompile = TreeUtils.getMethod(Pattern.class.getName(), "compile", 1, this.processingEnv);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return this.getBundledTypeQualifiersWithPolyAll(Regex.class, PartialRegex.class, RegexBottom.class, UnknownRegex.class);
    }

    @Override
    public CFTransfer createFlowTransferFunction(CFAbstractAnalysis<CFValue, CFStore, CFTransfer> analysis) {
        return new RegexTransfer((CFAnalysis)analysis);
    }

    AnnotationMirror createRegexAnnotation(int groupCount) {
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, Regex.class);
        if (groupCount > 0) {
            builder.setValue((CharSequence)"value", groupCount);
        }
        return builder.build();
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new RegexQualifierHierarchy(factory, this.REGEXBOTTOM);
    }

    public int getGroupCount(AnnotationMirror anno) {
        AnnotationValue groupCountValue = AnnotationUtils.getElementValuesWithDefaults(anno).get(this.regexValueElement);
        return groupCountValue == null ? 0 : (Integer)groupCountValue.getValue();
    }

    public static int getGroupCount(@Regex String regexp) {
        return Pattern.compile(regexp).matcher("").groupCount();
    }

    @Pure
    private static boolean isRegex(String s2) {
        try {
            Pattern.compile(s2);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return true;
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new LiteralTreeAnnotator(this).addStandardLiteralQualifiers(), new RegexTreeAnnotator(this), new RegexPropagationTreeAnnotator(this));
    }

    private class RegexTreeAnnotator
    extends TreeAnnotator {
        public RegexTreeAnnotator(AnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type) {
            if (!type.isAnnotatedInHierarchy(RegexAnnotatedTypeFactory.this.REGEX)) {
                String regex = null;
                if (tree.getKind() == Tree.Kind.STRING_LITERAL) {
                    regex = (String)tree.getValue();
                } else if (tree.getKind() == Tree.Kind.CHAR_LITERAL) {
                    regex = Character.toString(((Character)tree.getValue()).charValue());
                }
                if (regex != null) {
                    if (RegexAnnotatedTypeFactory.isRegex(regex)) {
                        int groupCount = RegexAnnotatedTypeFactory.getGroupCount(regex);
                        type.addAnnotation(RegexAnnotatedTypeFactory.this.createRegexAnnotation(groupCount));
                    } else {
                        type.addAnnotation(this.createPartialRegexAnnotation(regex));
                    }
                }
            }
            return (Void)super.visitLiteral(tree, type);
        }

        @Override
        public Void visitBinary(BinaryTree tree, AnnotatedTypeMirror type) {
            if (!type.isAnnotatedInHierarchy(RegexAnnotatedTypeFactory.this.REGEX) && TreeUtils.isStringConcatenation(tree)) {
                AnnotatedTypeMirror lExpr = RegexAnnotatedTypeFactory.this.getAnnotatedType(tree.getLeftOperand());
                AnnotatedTypeMirror rExpr = RegexAnnotatedTypeFactory.this.getAnnotatedType(tree.getRightOperand());
                Integer lGroupCount = this.getMinimumRegexCount(lExpr);
                Integer rGroupCount = this.getMinimumRegexCount(rExpr);
                boolean lExprRE = lGroupCount != null;
                boolean rExprRE = rGroupCount != null;
                boolean lExprPart = lExpr.hasAnnotation(PartialRegex.class);
                boolean rExprPart = rExpr.hasAnnotation(PartialRegex.class);
                boolean lExprPoly = lExpr.hasAnnotation(PolyRegex.class);
                boolean rExprPoly = rExpr.hasAnnotation(PolyRegex.class);
                if (lExprRE && rExprRE) {
                    type.removeAnnotationInHierarchy(RegexAnnotatedTypeFactory.this.REGEX);
                    type.addAnnotation(RegexAnnotatedTypeFactory.this.createRegexAnnotation(lGroupCount + rGroupCount));
                } else if (lExprPoly && rExprPoly || lExprPoly && rExprRE || lExprRE && rExprPoly) {
                    type.addAnnotation(PolyRegex.class);
                } else if (lExprPart && rExprPart) {
                    String lRegex = this.getPartialRegexValue(lExpr);
                    String rRegex = this.getPartialRegexValue(rExpr);
                    String concat = lRegex + rRegex;
                    if (RegexAnnotatedTypeFactory.isRegex(concat)) {
                        int groupCount = RegexAnnotatedTypeFactory.getGroupCount(concat);
                        type.addAnnotation(RegexAnnotatedTypeFactory.this.createRegexAnnotation(groupCount));
                    } else {
                        type.addAnnotation(this.createPartialRegexAnnotation(concat));
                    }
                } else if (lExprRE && rExprPart) {
                    String rRegex = this.getPartialRegexValue(rExpr);
                    String concat = "e" + rRegex;
                    type.addAnnotation(this.createPartialRegexAnnotation(concat));
                } else if (lExprPart && rExprRE) {
                    String lRegex = this.getPartialRegexValue(lExpr);
                    String concat = lRegex + "e";
                    type.addAnnotation(this.createPartialRegexAnnotation(concat));
                }
            }
            return null;
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type) {
            if (TreeUtils.isStringCompoundConcatenation(node)) {
                AnnotatedTypeMirror rhs = RegexAnnotatedTypeFactory.this.getAnnotatedType(node.getExpression());
                AnnotatedTypeMirror lhs = RegexAnnotatedTypeFactory.this.getAnnotatedType(node.getVariable());
                Integer lhsRegexCount = this.getMinimumRegexCount(lhs);
                Integer rhsRegexCount = this.getMinimumRegexCount(rhs);
                if (lhsRegexCount != null && rhsRegexCount != null) {
                    int lCount = RegexAnnotatedTypeFactory.this.getGroupCount(lhs.getAnnotation(Regex.class));
                    int rCount = RegexAnnotatedTypeFactory.this.getGroupCount(rhs.getAnnotation(Regex.class));
                    type.removeAnnotationInHierarchy(RegexAnnotatedTypeFactory.this.REGEX);
                    type.addAnnotation(RegexAnnotatedTypeFactory.this.createRegexAnnotation(lCount + rCount));
                }
            }
            return null;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, AnnotatedTypeMirror type) {
            if (TreeUtils.isMethodInvocation((Tree)tree, RegexAnnotatedTypeFactory.this.patternCompile, RegexAnnotatedTypeFactory.this.processingEnv)) {
                ExpressionTree arg0 = tree.getArguments().get(0);
                AnnotatedTypeMirror argType = RegexAnnotatedTypeFactory.this.getAnnotatedType(arg0);
                Integer regexCount = this.getMinimumRegexCount(argType);
                AnnotationMirror bottomAnno = RegexAnnotatedTypeFactory.this.getAnnotatedType(arg0).getAnnotation(RegexBottom.class);
                if (regexCount != null) {
                    type.replaceAnnotation(RegexAnnotatedTypeFactory.this.createRegexAnnotation(regexCount));
                } else if (bottomAnno != null) {
                    type.replaceAnnotation(AnnotationBuilder.fromClass(RegexAnnotatedTypeFactory.this.elements, RegexBottom.class));
                }
            }
            return (Void)super.visitMethodInvocation(tree, type);
        }

        private AnnotationMirror createPartialRegexAnnotation(String partial) {
            AnnotationBuilder builder = new AnnotationBuilder(RegexAnnotatedTypeFactory.this.processingEnv, PartialRegex.class);
            builder.setValue((CharSequence)"value", partial);
            return builder.build();
        }

        private String getPartialRegexValue(AnnotatedTypeMirror type) {
            return (String)AnnotationUtils.getElementValuesWithDefaults(type.getAnnotation(PartialRegex.class)).get(RegexAnnotatedTypeFactory.this.partialRegexValue).getValue();
        }

        private Integer getMinimumRegexCount(AnnotatedTypeMirror type) {
            AnnotationMirror primaryRegexAnno = type.getAnnotation(Regex.class);
            if (primaryRegexAnno == null) {
                switch (type.getKind()) {
                    case TYPEVAR: {
                        return this.getMinimumRegexCount(((AnnotatedTypeMirror.AnnotatedTypeVariable)type).getUpperBound());
                    }
                    case WILDCARD: {
                        return this.getMinimumRegexCount(((AnnotatedTypeMirror.AnnotatedWildcardType)type).getExtendsBound());
                    }
                    case INTERSECTION: {
                        Integer maxBound = null;
                        for (AnnotatedTypeMirror annotatedTypeMirror : ((AnnotatedTypeMirror.AnnotatedIntersectionType)type).directSuperTypes()) {
                            Integer boundRegexNum = this.getMinimumRegexCount(annotatedTypeMirror);
                            if (boundRegexNum == null || maxBound != null && boundRegexNum <= maxBound) continue;
                            maxBound = boundRegexNum;
                        }
                        return maxBound;
                    }
                }
                return null;
            }
            return RegexAnnotatedTypeFactory.this.getGroupCount(primaryRegexAnno);
        }
    }

    private static class RegexPropagationTreeAnnotator
    extends PropagationTreeAnnotator {
        public RegexPropagationTreeAnnotator(AnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type) {
            return null;
        }
    }

    private final class RegexQualifierHierarchy
    extends GraphQualifierHierarchy {
        public RegexQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory f, AnnotationMirror bottom) {
            super(f, bottom);
        }

        @Override
        public boolean isSubtype(AnnotationMirror subAnno, AnnotationMirror superAnno) {
            if (AnnotationUtils.areSameByName(subAnno, RegexAnnotatedTypeFactory.this.REGEX) && AnnotationUtils.areSameByName(superAnno, RegexAnnotatedTypeFactory.this.REGEX)) {
                int rhsValue = this.getRegexValue(subAnno);
                int lhsValue = this.getRegexValue(superAnno);
                return lhsValue <= rhsValue;
            }
            if (AnnotationUtils.areSameByName(superAnno, RegexAnnotatedTypeFactory.this.REGEX)) {
                superAnno = RegexAnnotatedTypeFactory.this.REGEX;
            }
            if (AnnotationUtils.areSameByName(subAnno, RegexAnnotatedTypeFactory.this.REGEX)) {
                subAnno = RegexAnnotatedTypeFactory.this.REGEX;
            }
            if (AnnotationUtils.areSameByName(superAnno, RegexAnnotatedTypeFactory.this.PARTIALREGEX)) {
                superAnno = RegexAnnotatedTypeFactory.this.PARTIALREGEX;
            }
            if (AnnotationUtils.areSameByName(subAnno, RegexAnnotatedTypeFactory.this.PARTIALREGEX)) {
                subAnno = RegexAnnotatedTypeFactory.this.PARTIALREGEX;
            }
            return super.isSubtype(subAnno, superAnno);
        }

        private int getRegexValue(AnnotationMirror anno) {
            return (Integer)AnnotationUtils.getElementValuesWithDefaults(anno).get(RegexAnnotatedTypeFactory.this.regexValueElement).getValue();
        }
    }
}

