/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.signature;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.signature.qual.BinaryName;
import org.checkerframework.checker.signature.qual.DotSeparatedIdentifiers;
import org.checkerframework.checker.signature.qual.InternalForm;
import org.checkerframework.checker.signature.qual.SignatureBottom;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.TreeUtils;

public class SignatureAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    protected final AnnotationMirror SIGNATURE_UNKNOWN;
    protected final AnnotationMirror BINARY_NAME;
    protected final AnnotationMirror INTERNAL_FORM;
    protected final AnnotationMirror DOT_SEPARATED_IDENTIFIERS;
    private final ExecutableElement replaceCharChar;
    private final ExecutableElement replaceCharSequenceCharSequence;

    public SignatureAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.SIGNATURE_UNKNOWN = AnnotationBuilder.fromClass(this.elements, SignatureUnknown.class);
        this.BINARY_NAME = AnnotationBuilder.fromClass(this.elements, BinaryName.class);
        this.INTERNAL_FORM = AnnotationBuilder.fromClass(this.elements, InternalForm.class);
        this.DOT_SEPARATED_IDENTIFIERS = AnnotationBuilder.fromClass(this.elements, DotSeparatedIdentifiers.class);
        this.replaceCharChar = TreeUtils.getMethod(String.class.getName(), "replace", this.processingEnv, "char", "char");
        this.replaceCharSequenceCharSequence = TreeUtils.getMethod(String.class.getName(), "replace", this.processingEnv, "java.lang.CharSequence", "java.lang.CharSequence");
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return this.getBundledTypeQualifiersWithPolyAll(SignatureUnknown.class, SignatureBottom.class);
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new SignatureTreeAnnotator(this), super.createTreeAnnotator());
    }

    private class SignatureTreeAnnotator
    extends TreeAnnotator {
        public SignatureTreeAnnotator(AnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitBinary(BinaryTree tree, AnnotatedTypeMirror type) {
            if (TreeUtils.isStringConcatenation(tree)) {
                type.removeAnnotationInHierarchy(SignatureAnnotatedTypeFactory.this.SIGNATURE_UNKNOWN);
                type.addAnnotation(SignatureUnknown.class);
            }
            return null;
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type) {
            if (TreeUtils.isStringCompoundConcatenation(node)) {
                type.removeAnnotationInHierarchy(SignatureAnnotatedTypeFactory.this.SIGNATURE_UNKNOWN);
                type.addAnnotation(SignatureUnknown.class);
            }
            return null;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, AnnotatedTypeMirror type) {
            if (TreeUtils.isMethodInvocation((Tree)tree, SignatureAnnotatedTypeFactory.this.replaceCharChar, SignatureAnnotatedTypeFactory.this.processingEnv) || TreeUtils.isMethodInvocation((Tree)tree, SignatureAnnotatedTypeFactory.this.replaceCharSequenceCharSequence, SignatureAnnotatedTypeFactory.this.processingEnv)) {
                ExpressionTree arg1;
                ExpressionTree arg0;
                int oldChar = 32;
                int newChar = 32;
                if (TreeUtils.isMethodInvocation((Tree)tree, SignatureAnnotatedTypeFactory.this.replaceCharChar, SignatureAnnotatedTypeFactory.this.processingEnv)) {
                    arg0 = tree.getArguments().get(0);
                    arg1 = tree.getArguments().get(1);
                    if (arg0.getKind() == Tree.Kind.CHAR_LITERAL && arg1.getKind() == Tree.Kind.CHAR_LITERAL) {
                        oldChar = ((Character)((LiteralTree)arg0).getValue()).charValue();
                        newChar = ((Character)((LiteralTree)arg1).getValue()).charValue();
                    }
                } else {
                    arg0 = tree.getArguments().get(0);
                    arg1 = tree.getArguments().get(1);
                    if (arg0.getKind() == Tree.Kind.STRING_LITERAL && arg1.getKind() == Tree.Kind.STRING_LITERAL) {
                        String const0 = (String)((LiteralTree)arg0).getValue();
                        String const1 = (String)((LiteralTree)arg1).getValue();
                        if (const0.length() == 1 && const1.length() == 1) {
                            oldChar = const0.charAt(0);
                            newChar = const1.charAt(0);
                        }
                    }
                }
                ExpressionTree receiver = TreeUtils.getReceiverTree(tree);
                AnnotatedTypeMirror receiverType = SignatureAnnotatedTypeFactory.this.getAnnotatedType(receiver);
                if (oldChar == 46 && newChar == 47 && receiverType.getAnnotation(BinaryName.class) != null) {
                    type.replaceAnnotation(SignatureAnnotatedTypeFactory.this.INTERNAL_FORM);
                } else if (oldChar == 47 && newChar == 46 && receiverType.getAnnotation(InternalForm.class) != null) {
                    type.replaceAnnotation(SignatureAnnotatedTypeFactory.this.BINARY_NAME);
                }
            }
            return (Void)super.visitMethodInvocation(tree, type);
        }
    }
}

