/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.com.github.javaparser.ast.nodeTypes;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.com.github.javaparser.ast.Modifier;
import org.checkerframework.com.github.javaparser.ast.Node;
import org.checkerframework.com.github.javaparser.ast.NodeList;
import org.checkerframework.com.github.javaparser.ast.body.ConstructorDeclaration;
import org.checkerframework.com.github.javaparser.ast.nodeTypes.NodeWithMembers;
import org.checkerframework.com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;

public interface NodeWithConstructors<N extends Node>
extends NodeWithSimpleName<N>,
NodeWithMembers<N> {
    default public Optional<ConstructorDeclaration> getDefaultConstructor() {
        return this.getMembers().stream().filter(bd -> bd instanceof ConstructorDeclaration).map(bd -> (ConstructorDeclaration)bd).filter(cd2 -> cd2.getParameters().isEmpty()).findFirst();
    }

    default public ConstructorDeclaration addConstructor(Modifier.Keyword ... modifiers) {
        ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration();
        constructorDeclaration.setModifiers((NodeList)Modifier.createModifierList(modifiers));
        constructorDeclaration.setName(this.getName());
        this.getMembers().add(constructorDeclaration);
        return constructorDeclaration;
    }

    default public List<ConstructorDeclaration> getConstructors() {
        return Collections.unmodifiableList(this.getMembers().stream().filter(m3 -> m3 instanceof ConstructorDeclaration).map(m3 -> (ConstructorDeclaration)m3).collect(Collectors.toList()));
    }

    default public Optional<ConstructorDeclaration> getConstructorByParameterTypes(String ... paramTypes) {
        return this.getConstructors().stream().filter(m3 -> m3.hasParametersOfType(paramTypes)).findFirst();
    }

    default public Optional<ConstructorDeclaration> getConstructorByParameterTypes(Class<?> ... paramTypes) {
        return this.getConstructors().stream().filter(m3 -> m3.hasParametersOfType(paramTypes)).findFirst();
    }
}

