/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.basetype;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.checkerframework.common.basetype.BaseTypeContext;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.common.reflection.MethodValChecker;
import org.checkerframework.dataflow.cfg.CFGVisualizer;
import org.checkerframework.framework.source.SourceChecker;
import org.checkerframework.framework.source.SourceVisitor;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.util.TreePathCacher;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.UserError;

public abstract class BaseTypeChecker
extends SourceChecker
implements BaseTypeContext {
    private List<BaseTypeChecker> subcheckers = null;
    private List<BaseTypeChecker> immediateSubcheckers;
    private Set<String> supportedOptions;
    private TreePathCacher treePathCacher;
    private final Comparator<CheckerMessage> checkerMessageComparator = new Comparator<CheckerMessage>(){

        @Override
        public int compare(CheckerMessage o1, CheckerMessage o2) {
            int o2Index;
            int byPos = InternalUtils.compareDiagnosticPosition(o1.source, o2.source);
            if (byPos != 0) {
                return byPos;
            }
            int o1Index = BaseTypeChecker.this.getSubcheckers().indexOf(o1.checker);
            if (o1Index != (o2Index = BaseTypeChecker.this.getSubcheckers().indexOf(o2.checker))) {
                if (o1Index == -1) {
                    o1Index = BaseTypeChecker.this.getSubcheckers().size();
                }
                if (o2Index == -1) {
                    o2Index = BaseTypeChecker.this.getSubcheckers().size();
                }
                return Integer.compare(o1Index, o2Index);
            }
            int kind = o1.kind.compareTo(o2.kind);
            if (kind != 0) {
                return kind;
            }
            return o1.message.compareTo(o2.message);
        }
    };
    private TreeSet<CheckerMessage> messageStore = null;

    @Override
    public void initChecker() {
        for (BaseTypeChecker checker : this.getSubcheckers()) {
            checker.initChecker();
            checker.addOptions(super.getOptions());
            checker.setSupportedLintOptions(this.getSupportedLintOptions());
        }
        super.initChecker();
    }

    @Override
    protected void setRoot(CompilationUnitTree newRoot) {
        super.setRoot(newRoot);
        if (this.parentChecker == null) {
            this.treePathCacher.clear();
        }
    }

    protected LinkedHashSet<Class<? extends BaseTypeChecker>> getImmediateSubcheckerClasses() {
        if (this.shouldResolveReflection()) {
            return new LinkedHashSet<Class<? extends BaseTypeChecker>>(Collections.singleton(MethodValChecker.class));
        }
        return new LinkedHashSet<Class<? extends BaseTypeChecker>>();
    }

    public boolean shouldResolveReflection() {
        return super.getOptions().containsKey("resolveReflection");
    }

    protected BaseTypeVisitor<?> createSourceVisitor() {
        for (Class<?> checkerClass = this.getClass(); checkerClass != BaseTypeChecker.class; checkerClass = checkerClass.getSuperclass()) {
            String classToLoad = checkerClass.getName().replace("Checker", "Visitor").replace("Subchecker", "Visitor");
            BaseTypeVisitor result = (BaseTypeVisitor)BaseTypeChecker.invokeConstructorFor(classToLoad, new Class[]{BaseTypeChecker.class}, new Object[]{this});
            if (result == null) continue;
            return result;
        }
        return new BaseTypeVisitor(this);
    }

    @Override
    public Set<String> getSupportedLintOptions() {
        HashSet<String> lintSet = new HashSet<String>(super.getSupportedLintOptions());
        lintSet.add("cast");
        lintSet.add("cast:redundant");
        lintSet.add("cast:unsafe");
        for (BaseTypeChecker checker : this.getSubcheckers()) {
            lintSet.addAll(checker.getSupportedLintOptions());
        }
        return Collections.unmodifiableSet(lintSet);
    }

    public static <T> T invokeConstructorFor(String name, Class<?>[] paramTypes, Object[] args) {
        Class<?> cls = null;
        try {
            cls = Class.forName(name);
        }
        catch (Exception e) {
            return null;
        }
        assert (cls != null) : "reflectively loading " + name + " failed";
        try {
            Constructor<?> ctor = cls.getConstructor(paramTypes);
            return (T)ctor.newInstance(args);
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                Throwable err = t.getCause();
                if (err instanceof UserError) {
                    UserError ue = (UserError)err;
                    throw ue;
                }
                throw new BugInCF("InvocationTargetException when invoking constructor for class " + name + "; Underlying cause: " + err, t);
            }
            throw new BugInCF("Unexpected " + t.getClass().getSimpleName() + " for class " + name + " when invoking the constructor; parameter types: " + Arrays.toString(paramTypes), t);
        }
    }

    @Override
    public BaseTypeContext getContext() {
        return this;
    }

    @Override
    public BaseTypeChecker getChecker() {
        return this;
    }

    @Override
    public BaseTypeVisitor<?> getVisitor() {
        return (BaseTypeVisitor)super.getVisitor();
    }

    @Override
    public GenericAnnotatedTypeFactory<?, ?, ?, ?> getTypeFactory() {
        SourceVisitor visitor = this.getVisitor();
        if (visitor == null) {
            return null;
        }
        return ((BaseTypeVisitor)visitor).getTypeFactory();
    }

    @Override
    public AnnotationProvider getAnnotationProvider() {
        return this.getTypeFactory();
    }

    public <T extends BaseTypeChecker> T getSubchecker(Class<T> checkerClass) {
        for (BaseTypeChecker checker : this.immediateSubcheckers) {
            if (!checker.getClass().equals(checkerClass)) continue;
            return (T)checker;
        }
        return null;
    }

    public <T extends GenericAnnotatedTypeFactory<?, ?, ?, ?>, U extends BaseTypeChecker> T getTypeFactoryOfSubchecker(Class<U> checkerClass) {
        U checker = this.getSubchecker(checkerClass);
        if (checker != null) {
            return (T)((BaseTypeChecker)checker).getTypeFactory();
        }
        return null;
    }

    private List<BaseTypeChecker> instantiateSubcheckers(LinkedHashMap<Class<? extends BaseTypeChecker>, BaseTypeChecker> alreadyInitializedSubcheckerMap) {
        LinkedHashSet<Class<? extends BaseTypeChecker>> classesOfImmediateSubcheckers = this.getImmediateSubcheckerClasses();
        if (classesOfImmediateSubcheckers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BaseTypeChecker> immediateSubcheckers = new ArrayList<BaseTypeChecker>(classesOfImmediateSubcheckers.size());
        for (Class clazz : classesOfImmediateSubcheckers) {
            BaseTypeChecker instance;
            BaseTypeChecker subchecker = alreadyInitializedSubcheckerMap.get(clazz);
            if (subchecker != null) {
                immediateSubcheckers.add(subchecker);
                continue;
            }
            try {
                instance = (BaseTypeChecker)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new BugInCF("Could not create an instance of " + clazz);
            }
            instance.setProcessingEnvironment(this.processingEnv);
            instance.treePathCacher = this.getTreePathCacher();
            instance.subcheckers = Collections.emptyList();
            immediateSubcheckers.add(instance);
            instance.immediateSubcheckers = instance.instantiateSubcheckers(alreadyInitializedSubcheckerMap);
            instance.setParentChecker(this);
            alreadyInitializedSubcheckerMap.put(clazz, instance);
        }
        return Collections.unmodifiableList(immediateSubcheckers);
    }

    private List<BaseTypeChecker> getSubcheckers() {
        if (this.subcheckers == null) {
            LinkedHashMap<Class<? extends BaseTypeChecker>, BaseTypeChecker> checkerMap = new LinkedHashMap<Class<? extends BaseTypeChecker>, BaseTypeChecker>();
            this.immediateSubcheckers = this.instantiateSubcheckers(checkerMap);
            this.subcheckers = Collections.unmodifiableList(new ArrayList<BaseTypeChecker>(checkerMap.values()));
        }
        return this.subcheckers;
    }

    public TreePathCacher getTreePathCacher() {
        if (this.treePathCacher == null) {
            this.treePathCacher = new TreePathCacher();
        }
        return this.treePathCacher;
    }

    @Override
    public void typeProcess(TypeElement element, TreePath tree) {
        if (!this.getSubcheckers().isEmpty()) {
            this.messageStore = new TreeSet<CheckerMessage>(this.checkerMessageComparator);
        }
        Context context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        Log log = Log.instance(context);
        int nerrorsOfAllPreviousCheckers = this.errsOnLastExit;
        for (BaseTypeChecker subchecker : this.getSubcheckers()) {
            subchecker.errsOnLastExit = nerrorsOfAllPreviousCheckers;
            subchecker.messageStore = this.messageStore;
            int errorsBeforeTypeChecking = log.nerrors;
            subchecker.typeProcess(element, tree);
            int errorsAfterTypeChecking = log.nerrors;
            nerrorsOfAllPreviousCheckers += errorsAfterTypeChecking - errorsBeforeTypeChecking;
        }
        this.errsOnLastExit = nerrorsOfAllPreviousCheckers;
        super.typeProcess(element, tree);
        if (!this.getSubcheckers().isEmpty()) {
            this.printCollectedMessages(tree.getCompilationUnit());
            this.errsOnLastExit = log.nerrors;
        }
    }

    @Override
    protected void warnUnneededSuppressions() {
        if (this.parentChecker != null || !this.hasOption("warnUnneededSuppressions")) {
            return;
        }
        HashSet<Element> elementsSuppress = new HashSet<Element>(this.elementsWithSuppressedWarnings);
        this.elementsWithSuppressedWarnings.clear();
        HashSet<String> checkerKeys = new HashSet<String>(this.getSuppressWarningsKeys());
        HashSet<String> errorKeys = new HashSet<String>(this.messages.stringPropertyNames());
        for (BaseTypeChecker subChecker : this.subcheckers) {
            elementsSuppress.addAll(subChecker.elementsWithSuppressedWarnings);
            subChecker.elementsWithSuppressedWarnings.clear();
            checkerKeys.addAll(subChecker.getSuppressWarningsKeys());
            errorKeys.addAll(subChecker.messages.stringPropertyNames());
            ((BaseTypeVisitor)subChecker.getVisitor()).treesWithSuppressWarnings.clear();
        }
        this.warnUnneedSuppressions(elementsSuppress, checkerKeys, errorKeys);
        ((BaseTypeVisitor)this.getVisitor()).treesWithSuppressWarnings.clear();
    }

    @Override
    protected void printMessage(Diagnostic.Kind kind, String message, Tree source, CompilationUnitTree root) {
        assert (this.currentRoot == root);
        if (this.messageStore == null) {
            super.printMessage(kind, message, source, root);
        } else {
            CheckerMessage checkerMessage = new CheckerMessage(kind, message, source, this);
            this.messageStore.add(checkerMessage);
        }
    }

    private void printCollectedMessages(CompilationUnitTree unit) {
        if (this.messageStore != null) {
            for (CheckerMessage msg : this.messageStore) {
                super.printMessage(msg.kind, msg.message, msg.source, unit);
            }
        }
    }

    @Override
    public void typeProcessingOver() {
        for (BaseTypeChecker checker : this.getSubcheckers()) {
            checker.typeProcessingOver();
        }
        super.typeProcessingOver();
    }

    @Override
    public Set<String> getSupportedOptions() {
        if (this.supportedOptions == null) {
            HashSet<String> options = new HashSet<String>();
            options.addAll(super.getSupportedOptions());
            for (BaseTypeChecker checker : this.getSubcheckers()) {
                options.addAll(checker.getSupportedOptions());
            }
            options.addAll(this.expandCFOptions(Arrays.asList(this.getClass()), options.toArray(new String[0])));
            this.supportedOptions = Collections.unmodifiableSet(options);
        }
        return this.supportedOptions;
    }

    @Override
    public Map<String, String> getOptions() {
        HashMap<String, String> options = new HashMap<String, String>(super.getOptions());
        for (BaseTypeChecker checker : this.getSubcheckers()) {
            options.putAll(checker.getOptions());
        }
        return options;
    }

    @Override
    protected Object processArg(Object arg) {
        if (arg instanceof Collection) {
            Collection carg = (Collection)arg;
            ArrayList<Object> newList = new ArrayList<Object>(carg.size());
            for (Object o : carg) {
                newList.add(this.processArg(o));
            }
            return newList;
        }
        if (arg instanceof AnnotationMirror && this.getTypeFactory() != null) {
            return this.getTypeFactory().getAnnotationFormatter().formatAnnotationMirror((AnnotationMirror)arg);
        }
        return super.processArg(arg);
    }

    @Override
    protected boolean shouldAddShutdownHook() {
        if (super.shouldAddShutdownHook() || this.getTypeFactory().getCFGVisualizer() != null) {
            return true;
        }
        for (BaseTypeChecker checker : this.getSubcheckers()) {
            if (checker.getTypeFactory().getCFGVisualizer() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void shutdownHook() {
        super.shutdownHook();
        CFGVisualizer<?, ?, ?> viz = this.getTypeFactory().getCFGVisualizer();
        if (viz != null) {
            viz.shutdown();
        }
        for (BaseTypeChecker checker : this.getSubcheckers()) {
            viz = checker.getTypeFactory().getCFGVisualizer();
            if (viz == null) continue;
            viz.shutdown();
        }
    }

    private static class CheckerMessage {
        final Diagnostic.Kind kind;
        final String message;
        final Tree source;
        final BaseTypeChecker checker;

        private CheckerMessage(Diagnostic.Kind kind, String message, Tree source, BaseTypeChecker checker) {
            this.kind = kind;
            this.message = message;
            this.source = source;
            this.checker = checker;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CheckerMessage that = (CheckerMessage)o;
            if (this.kind != that.kind) {
                return false;
            }
            if (!this.message.equals(that.message)) {
                return false;
            }
            if (this.source != that.source) {
                return false;
            }
            return this.checker == that.checker;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.message, this.source, this.checker});
        }

        public String toString() {
            return "CheckerMessage{kind=" + (Object)((Object)this.kind) + ", checker=" + this.checker.getClass().getSimpleName() + ", message='" + this.message + '\'' + ", source=" + this.source + '}';
        }
    }
}

