/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.basetype;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import java.lang.annotation.Annotation;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeValidator;
import org.checkerframework.common.basetype.TypeValidator;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.BooleanLiteralNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.ReturnNode;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.util.PurityChecker;
import org.checkerframework.dataflow.util.PurityUtils;
import org.checkerframework.framework.flow.CFAbstractStore;
import org.checkerframework.framework.flow.CFAbstractValue;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.checkerframework.framework.qual.Unused;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.source.SourceVisitor;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.AnnotatedTypeParameterBounds;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.framework.type.VisitorState;
import org.checkerframework.framework.type.poly.QualifierPolymorphism;
import org.checkerframework.framework.type.visitor.SimpleAnnotatedTypeScanner;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.BaseContext;
import org.checkerframework.framework.util.ContractsUtils;
import org.checkerframework.framework.util.FieldInvariants;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.framework.util.dependenttypes.DependentTypesHelper;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.PluginUtil;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class BaseTypeVisitor<Factory extends GenericAnnotatedTypeFactory<?, ?, ?, ?>>
extends SourceVisitor<Void, Void> {
    protected final BaseTypeChecker checker;
    protected final Factory atypeFactory;
    protected final SourcePositions positions;
    protected final VisitorState visitorState;
    protected final ContractsUtils contractsUtils;
    private final ExecutableElement objectEquals;
    private final ExecutableElement vectorCopyInto;
    private final ExecutableElement functionApply;
    private final AnnotatedTypeMirror.AnnotatedDeclaredType vectorType;
    protected final AnnotationMirror TARGET;
    protected final ExecutableElement targetValueElement;
    private Set<? extends AnnotationMirror> getExceptionParameterLowerBoundAnnotationsCache;
    private static SimpleAnnotatedTypeScanner<Boolean, Void> checkContainsSameToString = new SimpleAnnotatedTypeScanner<Boolean, Void>(){
        Map<String, String> map = new HashMap<String, String>();

        @Override
        protected Boolean reduce(Boolean r1, Boolean r2) {
            r1 = r1 == null ? false : r1;
            r2 = r2 == null ? false : r2;
            return r1 != false || r2 != false;
        }

        @Override
        protected Boolean defaultAction(AnnotatedTypeMirror type, Void avoid) {
            if (type == null) {
                return false;
            }
            String simple = type.toString();
            String verbose = this.map.get(simple);
            if (verbose == null) {
                this.map.put(simple, type.toString(true));
                return false;
            }
            return !verbose.equals(type.toString(true));
        }
    };
    protected final TypeValidator typeValidator;
    private static boolean checkedJDK = false;

    public BaseTypeVisitor(BaseTypeChecker checker) {
        this(checker, null);
    }

    protected BaseTypeVisitor(BaseTypeChecker checker, Factory typeFactory) {
        super(checker);
        this.TARGET = AnnotationBuilder.fromClass(this.elements, Target.class);
        this.getExceptionParameterLowerBoundAnnotationsCache = null;
        this.checker = checker;
        this.atypeFactory = typeFactory == null ? this.createTypeFactory() : typeFactory;
        this.contractsUtils = ContractsUtils.getInstance(this.atypeFactory);
        this.positions = this.trees.getSourcePositions();
        this.visitorState = ((AnnotatedTypeFactory)this.atypeFactory).getVisitorState();
        this.typeValidator = this.createTypeValidator();
        ProcessingEnvironment env = checker.getProcessingEnvironment();
        this.objectEquals = TreeUtils.getMethod("java.lang.Object", "equals", 1, env);
        this.vectorCopyInto = TreeUtils.getMethod("java.util.Vector", "copyInto", 1, env);
        this.functionApply = TreeUtils.getMethod("java.util.function.Function", "apply", 1, env);
        this.vectorType = ((AnnotatedTypeFactory)this.atypeFactory).fromElement(this.elements.getTypeElement("java.util.Vector"));
        this.targetValueElement = TreeUtils.getMethod(Target.class.getName(), "value", 0, env);
        this.checkForAnnotatedJdk();
    }

    protected Factory createTypeFactory() {
        for (Class<?> checkerClass = this.checker.getClass(); checkerClass != BaseTypeChecker.class; checkerClass = checkerClass.getSuperclass()) {
            String classToLoad = checkerClass.getName().replace("Checker", "AnnotatedTypeFactory").replace("Subchecker", "AnnotatedTypeFactory");
            AnnotatedTypeFactory result = (AnnotatedTypeFactory)BaseTypeChecker.invokeConstructorFor(classToLoad, new Class[]{BaseTypeChecker.class}, new Object[]{this.checker});
            if (result == null) continue;
            return (Factory)((GenericAnnotatedTypeFactory)result);
        }
        try {
            return (Factory)new BaseAnnotatedTypeFactory(this.checker);
        }
        catch (Throwable t) {
            throw new BugInCF("Unexpected " + t.getClass().getSimpleName() + " when invoking BaseAnnotatedTypeFactory for checker " + this.checker.getClass().getSimpleName(), t);
        }
    }

    public final Factory getTypeFactory() {
        return this.atypeFactory;
    }

    @Override
    public void setRoot(CompilationUnitTree root) {
        ((GenericAnnotatedTypeFactory)this.atypeFactory).setRoot(root);
        super.setRoot(root);
    }

    @Override
    public Void scan(Tree tree, Void p) {
        if (tree != null && this.getCurrentPath() != null) {
            this.visitorState.setPath(new TreePath(this.getCurrentPath(), tree));
        }
        return (Void)super.scan(tree, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Void visitClass(ClassTree classTree, Void p) {
        if (this.checker.shouldSkipDefs(classTree)) {
            return null;
        }
        ((GenericAnnotatedTypeFactory)this.atypeFactory).preProcessClassTree(classTree);
        TreePath preTreePath = this.visitorState.getPath();
        AnnotatedTypeMirror.AnnotatedDeclaredType preACT = this.visitorState.getClassType();
        ClassTree preCT = this.visitorState.getClassTree();
        AnnotatedTypeMirror.AnnotatedDeclaredType preAMT = this.visitorState.getMethodReceiver();
        MethodTree preMT = this.visitorState.getMethodTree();
        Pair<Tree, AnnotatedTypeMirror> preAssCtxt = this.visitorState.getAssignmentContext();
        this.visitorState.setPath(TreePath.getPath(this.root, (Tree)classTree));
        this.visitorState.setClassType(((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(TreeUtils.elementFromDeclaration(classTree)));
        this.visitorState.setClassTree(classTree);
        this.visitorState.setMethodReceiver(null);
        this.visitorState.setMethodTree(null);
        this.visitorState.setAssignmentContext(null);
        try {
            this.processClassTree(classTree);
            ((AnnotatedTypeFactory)this.atypeFactory).postProcessClassTree(classTree);
        }
        finally {
            this.visitorState.setPath(preTreePath);
            this.visitorState.setClassType(preACT);
            this.visitorState.setClassTree(preCT);
            this.visitorState.setMethodReceiver(preAMT);
            this.visitorState.setMethodTree(preMT);
            this.visitorState.setAssignmentContext(preAssCtxt);
        }
        return null;
    }

    public void processClassTree(ClassTree classTree) {
        List<? extends Tree> impls;
        this.checkFieldInvariantDeclarations(classTree);
        if (!TreeUtils.hasExplicitConstructor(classTree)) {
            this.checkDefaultConstructor(classTree);
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType classType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(classTree);
        if (((GenericAnnotatedTypeFactory)this.atypeFactory).getDependentTypesHelper() != null) {
            ((GenericAnnotatedTypeFactory)this.atypeFactory).getDependentTypesHelper().checkClass(classTree, classType);
        }
        this.validateType(classTree, classType);
        Tree ext = classTree.getExtendsClause();
        if (ext != null) {
            this.validateTypeOf(ext);
        }
        if ((impls = classTree.getImplementsClause()) != null) {
            for (Tree tree : impls) {
                this.validateTypeOf(tree);
            }
        }
        this.checkExtendsImplements(classTree);
        super.visitClass(classTree, null);
    }

    protected void checkExtendsImplements(ClassTree classTree) {
        if (TypesUtils.isAnonymous(TreeUtils.typeOf(classTree))) {
            return;
        }
        Set<AnnotationMirror> classBounds = ((AnnotatedTypeFactory)this.atypeFactory).getTypeDeclarationBounds(TreeUtils.typeOf(classTree));
        QualifierHierarchy qualifierHierarchy = ((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy();
        if (classTree.getExtendsClause() != null) {
            Set<AnnotationMirror> extendsAnnos = ((AnnotatedTypeFactory)this.atypeFactory).getTypeOfExtendsImplements(classTree.getExtendsClause()).getAnnotations();
            for (AnnotationMirror classAnno : classBounds) {
                AnnotationMirror extendsAnno;
                if (qualifierHierarchy.isSubtype(classAnno, extendsAnno = qualifierHierarchy.findAnnotationInSameHierarchy(extendsAnnos, classAnno))) continue;
                this.checker.report(Result.failure("declaration.inconsistent.with.extends.clause", classAnno, extendsAnno), classTree.getExtendsClause());
            }
        }
        for (Tree tree : classTree.getImplementsClause()) {
            Set<AnnotationMirror> implementsClauseAnnos = ((AnnotatedTypeFactory)this.atypeFactory).getTypeOfExtendsImplements(tree).getAnnotations();
            for (AnnotationMirror classAnno : classBounds) {
                AnnotationMirror implementsAnno;
                if (qualifierHierarchy.isSubtype(classAnno, implementsAnno = qualifierHierarchy.findAnnotationInSameHierarchy(implementsClauseAnnos, classAnno))) continue;
                this.checker.report(Result.failure("declaration.inconsistent.with.implements.clause", classAnno, implementsAnno), tree);
            }
        }
    }

    protected void checkFieldInvariantDeclarations(ClassTree classTree) {
        Result superError;
        FieldInvariants superInvar;
        TypeElement elt = TreeUtils.elementFromDeclaration(classTree);
        FieldInvariants invariants = ((AnnotatedTypeFactory)this.atypeFactory).getFieldInvariants(elt);
        if (invariants == null) {
            return;
        }
        Tree errorTree = ((AnnotatedTypeFactory)this.atypeFactory).getFieldInvariantAnnotationTree(classTree.getModifiers().getAnnotations());
        if (errorTree == null) {
            errorTree = classTree;
        }
        if (!invariants.isWellFormed()) {
            this.checker.report(Result.failure("field.invariant.not.wellformed", new Object[0]), errorTree);
            return;
        }
        TypeMirror superClass = elt.getSuperclass();
        ArrayList<String> fieldsNotFound = new ArrayList<String>(invariants.getFields());
        Set<VariableElement> fieldElts = ElementUtils.findFieldsInTypeOrSuperType(superClass, fieldsNotFound);
        if (!fieldsNotFound.isEmpty()) {
            String notFoundString = String.join((CharSequence)", ", fieldsNotFound);
            this.checker.report(Result.failure("field.invariant.not.found", notFoundString), errorTree);
        }
        if ((superInvar = ((AnnotatedTypeFactory)this.atypeFactory).getFieldInvariants(TypesUtils.getTypeElement(superClass))) != null && (superError = invariants.isSuperInvariant(superInvar, (AnnotatedTypeFactory)this.atypeFactory)) != null) {
            this.checker.report(superError, errorTree);
        }
        ArrayList<String> notFinal = new ArrayList<String>();
        for (VariableElement field : fieldElts) {
            String fieldName = field.getSimpleName().toString();
            if (!ElementUtils.isFinal(field)) {
                notFinal.add(fieldName);
            }
            AnnotatedTypeMirror type = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(field);
            List<AnnotationMirror> annos = invariants.getQualifiersFor(field.getSimpleName());
            for (AnnotationMirror invariantAnno : annos) {
                AnnotationMirror declaredAnno = type.getEffectiveAnnotationInHierarchy(invariantAnno);
                if (declaredAnno == null || ((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(invariantAnno, declaredAnno)) continue;
                this.checker.report(Result.failure("field.invariant.not.subtype", fieldName, invariantAnno, declaredAnno), errorTree);
            }
        }
        if (!notFinal.isEmpty()) {
            String notFinalString = String.join((CharSequence)", ", notFinal);
            this.checker.report(Result.failure("field.invariant.not.final", notFinalString), errorTree);
        }
    }

    protected void checkDefaultConstructor(ClassTree node) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitMethod(MethodTree node, Void p) {
        boolean abstractMethod;
        Object object;
        ExecutableElement methodElement;
        MethodTree preMT;
        AnnotatedTypeMirror.AnnotatedDeclaredType preMRT;
        AnnotatedTypeMirror.AnnotatedExecutableType methodType;
        block26: {
            methodType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node).deepCopy();
            preMRT = this.visitorState.getMethodReceiver();
            preMT = this.visitorState.getMethodTree();
            this.visitorState.setMethodReceiver(methodType.getReceiverType());
            this.visitorState.setMethodTree(node);
            methodElement = TreeUtils.elementFromDeclaration(node);
            this.warnAboutTypeAnnotationsTooEarly(node, node.getModifiers());
            if (!TreeUtils.isAnonymousConstructor(node)) break block26;
            Void void_ = null;
            boolean bl = methodElement.getModifiers().contains((Object)Modifier.ABSTRACT) || methodElement.getModifiers().contains((Object)Modifier.NATIVE);
            ArrayList<String> formalParamNames = new ArrayList<String>();
            for (VariableTree variableTree : node.getParameters()) {
                formalParamNames.add(variableTree.getName().toString());
            }
            this.checkContractsAtMethodDeclaration(node, methodElement, formalParamNames, bl);
            this.visitorState.setMethodReceiver(preMRT);
            this.visitorState.setMethodTree(preMT);
            return void_;
        }
        try {
            Map.Entry<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> pair;
            AnnotatedTypeMirror.AnnotatedDeclaredType annotatedDeclaredType;
            AnnotatedTypeMirror.AnnotatedExecutableType overriddenMethod;
            if (TreeUtils.isConstructor(node)) {
                this.checkConstructorResult(methodType, methodElement);
            }
            boolean anyPurityAnnotation = PurityUtils.hasPurityAnnotation(this.atypeFactory, node);
            boolean bl = this.checker.hasOption("suggestPureMethods");
            boolean checkPurityAnnotations = this.checker.hasOption("checkPurityAnnotations");
            if (checkPurityAnnotations && (anyPurityAnnotation || bl)) {
                PurityChecker.PurityResult r;
                List<Pure.Kind> kinds = PurityUtils.getPurityKinds(this.atypeFactory, node);
                boolean bl2 = kinds.contains((Object)Pure.Kind.DETERMINISTIC);
                if (bl2) {
                    if (TreeUtils.isConstructor(node)) {
                        this.checker.report(Result.warning("purity.deterministic.constructor", new Object[0]), node);
                    } else if (TreeUtils.typeOf(node.getReturnType()).getKind() == TypeKind.VOID) {
                        this.checker.report(Result.warning("purity.deterministic.void.method", new Object[0]), node);
                    }
                }
                if (!(r = PurityChecker.checkPurity(((AnnotatedTypeFactory)this.atypeFactory).getPath(node.getBody()), this.atypeFactory, this.checker.hasOption("assumeSideEffectFree"))).isPure(kinds)) {
                    this.reportPurityErrors(r, node, kinds);
                }
                if (bl) {
                    HashSet<Pure.Kind> hashSet = new HashSet<Pure.Kind>(r.getTypes());
                    hashSet.removeAll(kinds);
                    if (TreeUtils.isConstructor(node)) {
                        hashSet.remove((Object)Pure.Kind.DETERMINISTIC);
                    }
                    if (!hashSet.isEmpty()) {
                        if (hashSet.size() == 2) {
                            this.checker.report(Result.warning("purity.more.pure", node.getName()), node);
                        } else if (hashSet.contains((Object)Pure.Kind.SIDE_EFFECT_FREE)) {
                            this.checker.report(Result.warning("purity.more.sideeffectfree", node.getName()), node);
                        } else if (hashSet.contains((Object)Pure.Kind.DETERMINISTIC)) {
                            this.checker.report(Result.warning("purity.more.deterministic", node.getName()), node);
                        } else assert (false) : "BaseTypeVisitor reached undesirable state";
                    }
                }
            }
            this.validateTypeOf(node);
            for (ExpressionTree expressionTree : node.getThrows()) {
                this.validateTypeOf(expressionTree);
            }
            if (((GenericAnnotatedTypeFactory)this.atypeFactory).getDependentTypesHelper() != null) {
                ((GenericAnnotatedTypeFactory)this.atypeFactory).getDependentTypesHelper().checkMethod(node, methodType);
            }
            AnnotatedTypeMirror.AnnotatedDeclaredType enclosingType = (AnnotatedTypeMirror.AnnotatedDeclaredType)((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(methodElement.getEnclosingElement());
            Map<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> map = AnnotatedTypes.overriddenMethods(this.elements, this.atypeFactory, methodElement);
            object = map.entrySet().iterator();
            while (object.hasNext() && this.checkOverride(node, enclosingType, overriddenMethod = AnnotatedTypes.asMemberOf(this.types, this.atypeFactory, (AnnotatedTypeMirror)(annotatedDeclaredType = (pair = object.next()).getKey()), pair.getValue()), annotatedDeclaredType)) {
            }
            object = (Void)super.visitMethod(node, p);
            abstractMethod = methodElement.getModifiers().contains((Object)Modifier.ABSTRACT) || methodElement.getModifiers().contains((Object)Modifier.NATIVE);
        }
        catch (Throwable throwable) {
            boolean abstractMethod3 = methodElement.getModifiers().contains((Object)Modifier.ABSTRACT) || methodElement.getModifiers().contains((Object)Modifier.NATIVE);
            ArrayList<String> formalParamNames = new ArrayList<String>();
            for (VariableTree variableTree : node.getParameters()) {
                formalParamNames.add(variableTree.getName().toString());
            }
            this.checkContractsAtMethodDeclaration(node, methodElement, formalParamNames, abstractMethod3);
            this.visitorState.setMethodReceiver(preMRT);
            this.visitorState.setMethodTree(preMT);
            throw throwable;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (VariableTree variableTree : node.getParameters()) {
            arrayList.add(variableTree.getName().toString());
        }
        this.checkContractsAtMethodDeclaration(node, methodElement, arrayList, abstractMethod);
        this.visitorState.setMethodReceiver(preMRT);
        this.visitorState.setMethodTree(preMT);
        return object;
    }

    protected void checkConstructorResult(AnnotatedTypeMirror.AnnotatedExecutableType constructorType, ExecutableElement constructorElement) {
        QualifierHierarchy qualifierHierarchy = ((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy();
        Set<AnnotationMirror> constructorAnnotations = constructorType.getReturnType().getAnnotations();
        Set<? extends AnnotationMirror> tops = qualifierHierarchy.getTopAnnotations();
        for (AnnotationMirror annotationMirror : tops) {
            AnnotationMirror constructorAnno;
            if (qualifierHierarchy.isSubtype(annotationMirror, constructorAnno = qualifierHierarchy.findAnnotationInHierarchy(constructorAnnotations, annotationMirror))) continue;
            this.checker.report(Result.warning("inconsistent.constructor.type", constructorAnno), constructorElement);
        }
    }

    protected void reportPurityErrors(PurityChecker.PurityResult result, MethodTree node, Collection<Pure.Kind> expectedTypes) {
        assert (!result.isPure(expectedTypes));
        EnumSet<Pure.Kind> t = EnumSet.copyOf(expectedTypes);
        t.removeAll(result.getTypes());
        if (t.contains((Object)Pure.Kind.DETERMINISTIC) || t.contains((Object)Pure.Kind.SIDE_EFFECT_FREE)) {
            String msgPrefix = "purity.not.deterministic.not.sideeffectfree.";
            if (!t.contains((Object)Pure.Kind.SIDE_EFFECT_FREE)) {
                msgPrefix = "purity.not.deterministic.";
            } else if (!t.contains((Object)Pure.Kind.DETERMINISTIC)) {
                msgPrefix = "purity.not.sideeffectfree.";
            }
            for (Pair<Tree, String> r : result.getNotBothReasons()) {
                this.reportPurityError(msgPrefix, r);
            }
            if (t.contains((Object)Pure.Kind.SIDE_EFFECT_FREE)) {
                for (Pair<Tree, String> r : result.getNotSEFreeReasons()) {
                    this.reportPurityError("purity.not.sideeffectfree.", r);
                }
            }
            if (t.contains((Object)Pure.Kind.DETERMINISTIC)) {
                for (Pair<Tree, String> r : result.getNotDetReasons()) {
                    this.reportPurityError("purity.not.deterministic.", r);
                }
            }
        }
    }

    private void reportPurityError(String msgPrefix, Pair<Tree, String> r) {
        String reason = (String)r.second;
        @CompilerMessageKey String msg = msgPrefix + reason;
        if (reason.equals("call")) {
            MethodInvocationTree mitree = (MethodInvocationTree)r.first;
            this.checker.report(Result.failure(msg, mitree.getMethodSelect()), r.first);
        } else {
            this.checker.report(Result.failure(msg, new Object[0]), r.first);
        }
    }

    private void checkContractsAtMethodDeclaration(MethodTree node, ExecutableElement methodElement, List<String> formalParamNames, boolean abstractMethod) {
        FlowExpressionParseUtil.FlowExpressionContext flowExprContext = null;
        List<ContractsUtils.Contract> contracts = this.contractsUtils.getContracts(methodElement);
        for (ContractsUtils.Contract contract : contracts) {
            String expression = contract.expression;
            AnnotationMirror annotation = contract.annotation;
            if (flowExprContext == null) {
                flowExprContext = FlowExpressionParseUtil.FlowExpressionContext.buildContextForMethodDeclaration(node, this.getCurrentPath(), (BaseContext)this.checker.getContext());
            }
            annotation = this.standardizeAnnotationFromContract(annotation, flowExprContext, this.getCurrentPath());
            FlowExpressions.Receiver expr = null;
            try {
                expr = FlowExpressionParseUtil.parse(expression, flowExprContext, this.getCurrentPath(), false);
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                this.checker.report(e.getResult(), node);
            }
            if (expr != null && !CFAbstractStore.canInsertReceiver(expr)) {
                this.checker.report(Result.failure("flowexpr.parse.error", expression), node);
                expr = null;
            }
            if (expr != null && !abstractMethod) {
                switch (contract.kind) {
                    case POSTCONDTION: {
                        this.checkPostcondition(node, annotation, contract.contractAnnotation, expr);
                        break;
                    }
                    case CONDITIONALPOSTCONDTION: {
                        this.checkConditionalPostcondition(node, annotation, contract.contractAnnotation, expr, ((ContractsUtils.ConditionalPostcondition)contract).annoResult);
                        break;
                    }
                }
            }
            if (formalParamNames != null && formalParamNames.contains(expression)) {
                @CompilerMessageKey String key = "contracts." + contract.kind.errorKey + ".expression.parameter.name";
                this.checker.report(Result.warning(key, contract.contractAnnotation.getAnnotationType().asElement().getSimpleName(), node.getName().toString(), expression, formalParamNames.indexOf(expression) + 1, expression), node);
            }
            this.checkParametersAreEffectivelyFinal(node, methodElement, expression);
        }
    }

    private AnnotationMirror standardizeAnnotationFromContract(AnnotationMirror annoFromContract, FlowExpressionParseUtil.FlowExpressionContext flowExprContext, TreePath path) {
        DependentTypesHelper dependentTypesHelper = ((GenericAnnotatedTypeFactory)this.atypeFactory).getDependentTypesHelper();
        if (dependentTypesHelper != null) {
            AnnotationMirror anno = dependentTypesHelper.standardizeAnnotation(flowExprContext, path, annoFromContract, false);
            dependentTypesHelper.checkAnnotation(anno, path.getLeaf());
            return anno;
        }
        return annoFromContract;
    }

    private void checkParametersAreEffectivelyFinal(MethodTree node, ExecutableElement method, String stringExpr) {
        List<Integer> parameterIndices = FlowExpressionParseUtil.parameterIndices(stringExpr);
        for (Integer idx : parameterIndices) {
            VariableElement parameter;
            if (idx > method.getParameters().size() || ElementUtils.isEffectivelyFinal(parameter = method.getParameters().get(idx - 1))) continue;
            this.checker.report(Result.failure("flowexpr.parameter.not.final", "#" + idx, stringExpr), node);
        }
    }

    protected void checkPostcondition(MethodTree methodTree, AnnotationMirror annotation, AnnotationMirror contractAnnotation, FlowExpressions.Receiver expression) {
        Object exitStore = ((GenericAnnotatedTypeFactory)this.atypeFactory).getRegularExitStore(methodTree);
        if (exitStore != null) {
            Object value = ((CFAbstractStore)exitStore).getValue(expression);
            AnnotationMirror inferredAnno = null;
            if (value != null) {
                QualifierHierarchy hierarchy = ((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy();
                Set<AnnotationMirror> annos = ((CFAbstractValue)value).getAnnotations();
                inferredAnno = hierarchy.findAnnotationInSameHierarchy(annos, annotation);
            }
            if (!this.checkContract(expression, annotation, inferredAnno, (CFAbstractStore<?, ?>)exitStore)) {
                this.checker.report(Result.failure("contracts.postcondition.not.satisfied", contractAnnotation.getAnnotationType().asElement().getSimpleName(), expression.toString()), methodTree);
            }
        }
    }

    protected void checkConditionalPostcondition(MethodTree node, AnnotationMirror annotation, AnnotationMirror contractAnnotation, FlowExpressions.Receiver expression, boolean result) {
        boolean booleanReturnType = TypesUtils.isBooleanType(TreeUtils.typeOf(node.getReturnType()));
        if (!booleanReturnType) {
            this.checker.report(Result.failure("contracts.conditional.postcondition.invalid.returntype", new Object[0]), node);
            return;
        }
        for (Pair pair : ((GenericAnnotatedTypeFactory)this.atypeFactory).getReturnStatementStores(node)) {
            Boolean retVal;
            ReturnNode returnStmt = (ReturnNode)pair.first;
            Node retValNode = returnStmt.getResult();
            Boolean bl = retVal = retValNode instanceof BooleanLiteralNode ? ((BooleanLiteralNode)retValNode).getValue() : null;
            TransferResult transferResult = (TransferResult)pair.second;
            if (transferResult == null) continue;
            CFAbstractStore exitStore = (CFAbstractStore)(result ? transferResult.getThenStore() : transferResult.getElseStore());
            Object value = exitStore.getValue(expression);
            if (retVal != null && retVal != result) continue;
            AnnotationMirror inferredAnno = null;
            if (value != null) {
                QualifierHierarchy hierarchy = ((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy();
                Set<AnnotationMirror> annos = ((CFAbstractValue)value).getAnnotations();
                inferredAnno = hierarchy.findAnnotationInSameHierarchy(annos, annotation);
            }
            if (this.checkContract(expression, annotation, inferredAnno, exitStore)) continue;
            this.checker.report(Result.failure("contracts.conditional.postcondition.not.satisfied", contractAnnotation.getAnnotationType().asElement().getSimpleName(), expression.toString()), returnStmt.getTree());
        }
    }

    @Override
    public Void visitTypeParameter(TypeParameterTree node, Void p) {
        this.validateTypeOf(node);
        for (Tree tree : node.getBounds()) {
            this.validateTypeOf(tree);
        }
        return (Void)super.visitTypeParameter(node, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitVariable(VariableTree node, Void p) {
        this.warnAboutTypeAnnotationsTooEarly(node, node.getModifiers());
        Pair<Tree, AnnotatedTypeMirror> preAssCtxt = this.visitorState.getAssignmentContext();
        this.visitorState.setAssignmentContext(Pair.of(node, ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node)));
        try {
            if (((GenericAnnotatedTypeFactory)this.atypeFactory).getDependentTypesHelper() != null) {
                ((GenericAnnotatedTypeFactory)this.atypeFactory).getDependentTypesHelper().checkType((AnnotatedTypeMirror)this.visitorState.getAssignmentContext().second, node);
            }
            if (node.getInitializer() != null) {
                this.commonAssignmentCheck(node, node.getInitializer(), "assignment.type.incompatible");
            } else {
                this.validateTypeOf(node);
            }
            Void void_ = (Void)super.visitVariable(node, p);
            return void_;
        }
        finally {
            this.visitorState.setAssignmentContext(preAssCtxt);
        }
    }

    private void warnAboutTypeAnnotationsTooEarly(Tree node, ModifiersTree modifiersTree) {
        if (node.getKind() == Tree.Kind.VARIABLE && TreeUtils.elementFromDeclaration((VariableTree)node).getKind() == ElementKind.ENUM_CONSTANT) {
            return;
        }
        Set<Modifier> modifierSet = modifiersTree.getFlags();
        List<? extends AnnotationTree> annotations = modifiersTree.getAnnotations();
        if (annotations.isEmpty()) {
            return;
        }
        int lastDeclAnnoIndex = -1;
        for (int i = annotations.size() - 1; i > 0; --i) {
            if (this.isTypeAnnotation(annotations.get(i))) continue;
            lastDeclAnnoIndex = i;
            break;
        }
        if (lastDeclAnnoIndex != -1) {
            ArrayList<Object> badTypeAnnos = new ArrayList<Object>();
            for (int i = 0; i < lastDeclAnnoIndex; ++i) {
                AnnotationTree anno = annotations.get(i);
                if (!this.isTypeAnnotation(anno)) continue;
                badTypeAnnos.add(anno);
            }
            if (!badTypeAnnos.isEmpty()) {
                this.checker.report(Result.warning("type.anno.before.decl.anno", badTypeAnnos, annotations.get(lastDeclAnnoIndex)), node);
            }
        }
        AnnotationTree firstAnno = annotations.get(0);
        if (!modifierSet.isEmpty() && this.isTypeAnnotation(firstAnno)) {
            int varStartPos;
            int precedingTextLength = 0;
            for (Modifier m3 : modifierSet) {
                precedingTextLength += m3.toString().length() + 1;
            }
            int annoStartPos = ((JCTree)((Object)firstAnno)).getStartPosition();
            if (annoStartPos < (varStartPos = ((JCTree)node).getStartPosition()) + precedingTextLength) {
                this.checker.report(Result.warning("type.anno.before.modifier", firstAnno, modifierSet), node);
            }
        }
    }

    private boolean isTypeAnnotation(AnnotationTree anno) {
        Symbol.ClassSymbol annoSymbol;
        Tree annoType = anno.getAnnotationType();
        switch (annoType.getKind()) {
            case IDENTIFIER: {
                annoSymbol = (Symbol.ClassSymbol)((JCTree.JCIdent)annoType).sym;
                break;
            }
            case MEMBER_SELECT: {
                annoSymbol = (Symbol.ClassSymbol)((JCTree.JCFieldAccess)annoType).sym;
                break;
            }
            default: {
                throw new Error("Unhandled kind: " + (Object)((Object)annoType.getKind()) + " for " + anno);
            }
        }
        for (AnnotationMirror metaAnno : annoSymbol.getAnnotationMirrors()) {
            if (!AnnotationUtils.areSameByName(metaAnno, this.TARGET)) continue;
            AnnotationValue valueValue = metaAnno.getElementValues().get(this.targetValueElement);
            List targets = (List)valueValue.getValue();
            for (AnnotationValue target : targets) {
                Symbol.VarSymbol targetSymbol = ((Attribute.Enum)target).value;
                if (!targetSymbol.toString().equals("TYPE_USE")) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitAssignment(AssignmentTree node, Void p) {
        Pair<Tree, AnnotatedTypeMirror> preAssCtxt = this.visitorState.getAssignmentContext();
        this.visitorState.setAssignmentContext(Pair.of(node.getVariable(), ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getVariable())));
        try {
            this.commonAssignmentCheck(node.getVariable(), node.getExpression(), "assignment.type.incompatible");
            Void void_ = (Void)super.visitAssignment(node, p);
            return void_;
        }
        finally {
            this.visitorState.setAssignmentContext(preAssCtxt);
        }
    }

    @Override
    public Void visitEnhancedForLoop(EnhancedForLoopTree node, Void p) {
        AnnotatedTypeMirror var = ((GenericAnnotatedTypeFactory)this.atypeFactory).getAnnotatedTypeLhs(node.getVariable());
        AnnotatedTypeMirror iterableType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getExpression());
        AnnotatedTypeMirror iteratedType = AnnotatedTypes.getIteratedType(this.checker.getProcessingEnvironment(), this.atypeFactory, iterableType);
        boolean valid = this.validateTypeOf(node.getVariable());
        if (valid) {
            this.commonAssignmentCheck(var, iteratedType, node.getExpression(), "enhancedfor.type.incompatible");
        }
        return (Void)super.visitEnhancedForLoop(node, p);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        ExecutableElement invokedMethodElement;
        if (TreeUtils.elementFromUse(node) == null || TreeUtils.isEnumSuper(node)) {
            return (Void)super.visitMethodInvocation(node, p);
        }
        if (this.shouldSkipUses(node)) {
            return (Void)super.visitMethodInvocation(node, p);
        }
        AnnotatedTypeFactory.ParameterizedExecutableType mType = ((GenericAnnotatedTypeFactory)this.atypeFactory).methodFromUse(node);
        AnnotatedTypeMirror.AnnotatedExecutableType invokedMethod = mType.executableType;
        List<AnnotatedTypeMirror> typeargs = mType.typeArgs;
        if (!((GenericAnnotatedTypeFactory)this.atypeFactory).ignoreUninferredTypeArguments) {
            for (AnnotatedTypeMirror annotatedTypeMirror : typeargs) {
                if (annotatedTypeMirror.getKind() != TypeKind.WILDCARD || !((AnnotatedTypeMirror.AnnotatedWildcardType)annotatedTypeMirror).isUninferredTypeArgument()) continue;
                this.checker.report(Result.failure("type.arguments.not.inferred", invokedMethod.getElement().getSimpleName()), node);
                break;
            }
        }
        ArrayList<AnnotatedTypeParameterBounds> paramBounds = new ArrayList<AnnotatedTypeParameterBounds>();
        for (AnnotatedTypeMirror.AnnotatedTypeVariable param : invokedMethod.getTypeVariables()) {
            paramBounds.add(param.getBounds());
        }
        this.checkTypeArguments(node, paramBounds, typeargs, node.getTypeArguments());
        List<AnnotatedTypeMirror> list = AnnotatedTypes.expandVarArgs(this.atypeFactory, invokedMethod, node.getArguments());
        this.checkArguments(list, node.getArguments());
        this.checkVarargs(invokedMethod, node);
        if (ElementUtils.isMethod(invokedMethod.getElement(), this.vectorCopyInto, ((AnnotatedTypeFactory)this.atypeFactory).getProcessingEnv())) {
            this.typeCheckVectorCopyIntoArgument(node, list);
        }
        if (!ElementUtils.isStatic(invokedMethodElement = invokedMethod.getElement()) && !TreeUtils.isSuperConstructorCall(node)) {
            this.checkMethodInvocability(invokedMethod, node);
        }
        this.checkPreconditions(node, this.contractsUtils.getPreconditions(invokedMethodElement));
        if (TreeUtils.isSuperConstructorCall(node)) {
            this.checkSuperConstructorCall(node);
        } else if (TreeUtils.isThisConstructorCall(node)) {
            this.checkThisConstructorCall(node);
        }
        this.scan((Tree)node.getMethodSelect(), p);
        return null;
    }

    protected void checkThisConstructorCall(MethodInvocationTree thisCall) {
        this.checkThisOrSuperConstructorCall(thisCall, "this.invocation.invalid");
    }

    protected void checkSuperConstructorCall(MethodInvocationTree superCall) {
        this.checkThisOrSuperConstructorCall(superCall, "super.invocation.invalid");
    }

    protected void checkThisOrSuperConstructorCall(MethodInvocationTree superCall, @CompilerMessageKey String errorKey) {
        TreePath path = ((AnnotatedTypeFactory)this.atypeFactory).getPath(superCall);
        MethodTree enclosingMethod = TreeUtils.enclosingMethod(path);
        AnnotatedTypeMirror superType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(superCall);
        AnnotatedTypeMirror.AnnotatedExecutableType constructorType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(enclosingMethod);
        Set<? extends AnnotationMirror> topAnnotations = ((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().getTopAnnotations();
        for (AnnotationMirror annotationMirror : topAnnotations) {
            AnnotationMirror superTypeMirror = superType.getAnnotationInHierarchy(annotationMirror);
            AnnotationMirror constructorTypeMirror = constructorType.getReturnType().getAnnotationInHierarchy(annotationMirror);
            if (((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(superTypeMirror, constructorTypeMirror)) continue;
            this.checker.report(Result.failure(errorKey, constructorTypeMirror, superCall, superTypeMirror), superCall);
        }
    }

    protected void checkVarargs(AnnotatedTypeMirror.AnnotatedExecutableType invokedMethod, Tree tree) {
        AnnotatedTypeMirror lastArgType;
        List<? extends ExpressionTree> args;
        if (!invokedMethod.isVarArgs()) {
            return;
        }
        List<AnnotatedTypeMirror> formals = invokedMethod.getParameterTypes();
        int numFormals = formals.size();
        int lastArgIndex = numFormals - 1;
        AnnotatedTypeMirror.AnnotatedArrayType lastParamAnnotatedType = (AnnotatedTypeMirror.AnnotatedArrayType)formals.get(lastArgIndex);
        switch (tree.getKind()) {
            case METHOD_INVOCATION: {
                args = ((MethodInvocationTree)tree).getArguments();
                break;
            }
            case NEW_CLASS: {
                args = ((NewClassTree)tree).getArguments();
                break;
            }
            default: {
                throw new BugInCF("Unexpected kind of tree: " + tree);
            }
        }
        if (numFormals == args.size() && (lastArgType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(args.get(args.size() - 1))).getKind() == TypeKind.ARRAY && AnnotatedTypes.getArrayDepth(lastParamAnnotatedType) == AnnotatedTypes.getArrayDepth((AnnotatedTypeMirror.AnnotatedArrayType)lastArgType)) {
            return;
        }
        AnnotatedTypeMirror wrappedVarargsType = ((GenericAnnotatedTypeFactory)this.atypeFactory).getAnnotatedTypeVarargsArray(tree);
        if (wrappedVarargsType == null) {
            return;
        }
        if (wrappedVarargsType.getKind() == TypeKind.ARRAY) {
            ((AnnotatedTypeMirror.AnnotatedArrayType)wrappedVarargsType).setComponentType(lastParamAnnotatedType.getComponentType());
        }
        this.commonAssignmentCheck(lastParamAnnotatedType, wrappedVarargsType, tree, "varargs.type.incompatible");
    }

    protected void checkPreconditions(MethodInvocationTree tree, Set<ContractsUtils.Precondition> preconditions) {
        if (preconditions.isEmpty()) {
            return;
        }
        FlowExpressionParseUtil.FlowExpressionContext flowExprContext = FlowExpressionParseUtil.FlowExpressionContext.buildContextForMethodUse(tree, (BaseContext)this.checker.getContext());
        if (flowExprContext == null) {
            this.checker.report(Result.failure("flowexpr.parse.context.not.determined", tree), tree);
            return;
        }
        for (ContractsUtils.Precondition p : preconditions) {
            FlowExpressions.Receiver expr;
            String expression = p.expression;
            AnnotationMirror anno = p.annotation;
            anno = this.standardizeAnnotationFromContract(anno, flowExprContext, this.getCurrentPath());
            try {
                expr = FlowExpressionParseUtil.parse(expression, flowExprContext, this.getCurrentPath(), false);
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                this.checker.report(e.getResult(), tree);
                return;
            }
            Object store = ((GenericAnnotatedTypeFactory)this.atypeFactory).getStoreBefore(tree);
            CFAbstractValue value = null;
            if (CFAbstractStore.canInsertReceiver(expr)) {
                value = (CFAbstractValue)((CFAbstractStore)store).getValue(expr);
            }
            AnnotationMirror inferredAnno = null;
            if (value != null) {
                QualifierHierarchy hierarchy = ((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy();
                Set<AnnotationMirror> annos = value.getAnnotations();
                inferredAnno = hierarchy.findAnnotationInSameHierarchy(annos, anno);
            }
            if (this.checkContract(expr, anno, inferredAnno, (CFAbstractStore<?, ?>)store)) continue;
            String expressionString = expr == null || expr.containsUnknown() ? expression : expr.toString();
            this.checker.report(Result.failure("contracts.precondition.not.satisfied", tree.getMethodSelect().toString(), expressionString), tree);
        }
    }

    protected boolean checkContract(FlowExpressions.Receiver expr, AnnotationMirror necessaryAnnotation, AnnotationMirror inferredAnnotation, CFAbstractStore<?, ?> store) {
        return inferredAnnotation != null && ((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(inferredAnnotation, necessaryAnnotation);
    }

    protected void typeCheckVectorCopyIntoArgument(MethodInvocationTree node, List<? extends AnnotatedTypeMirror> params) {
        assert (params.size() == 1) : "invalid no. of parameters " + params + " found for method invocation " + node;
        assert (node.getArguments().size() == 1) : "invalid no. of arguments in method invocation " + node;
        AnnotatedTypeMirror passed = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getArguments().get(0));
        AnnotatedTypeMirror.AnnotatedArrayType passedAsArray = (AnnotatedTypeMirror.AnnotatedArrayType)passed;
        AnnotatedTypeMirror receiver = ((AnnotatedTypeFactory)this.atypeFactory).getReceiverType(node);
        AnnotatedTypeMirror.AnnotatedDeclaredType receiverAsVector = AnnotatedTypes.asSuper(this.atypeFactory, receiver, this.vectorType);
        if (receiverAsVector.getTypeArguments().isEmpty()) {
            return;
        }
        AnnotatedTypeMirror argComponent = passedAsArray.getComponentType();
        AnnotatedTypeMirror vectorTypeArg = receiverAsVector.getTypeArguments().get(0);
        Tree errorLocation = node.getArguments().get(0);
        if (TypesUtils.isErasedSubtype(vectorTypeArg.getUnderlyingType(), argComponent.getUnderlyingType(), this.types)) {
            this.commonAssignmentCheck(argComponent, vectorTypeArg, errorLocation, "vector.copyinto.type.incompatible");
        } else {
            this.checker.report(Result.failure("vector.copyinto.type.incompatible", vectorTypeArg, argComponent), errorLocation);
        }
    }

    @Override
    public Void visitNewClass(NewClassTree node, Void p) {
        if (this.checker.shouldSkipUses(TreeUtils.constructor(node))) {
            return (Void)super.visitNewClass(node, p);
        }
        AnnotatedTypeFactory.ParameterizedExecutableType fromUse = ((GenericAnnotatedTypeFactory)this.atypeFactory).constructorFromUse(node);
        AnnotatedTypeMirror.AnnotatedExecutableType constructor = fromUse.executableType;
        List<AnnotatedTypeMirror> typeargs = fromUse.typeArgs;
        List<? extends ExpressionTree> passedArguments = node.getArguments();
        List<AnnotatedTypeMirror> params = AnnotatedTypes.expandVarArgs(this.atypeFactory, constructor, passedArguments);
        this.checkArguments(params, passedArguments);
        this.checkVarargs(constructor, node);
        ArrayList<AnnotatedTypeParameterBounds> paramBounds = new ArrayList<AnnotatedTypeParameterBounds>();
        for (AnnotatedTypeMirror.AnnotatedTypeVariable param : constructor.getTypeVariables()) {
            paramBounds.add(param.getBounds());
        }
        this.checkTypeArguments(node, paramBounds, typeargs, node.getTypeArguments());
        boolean valid = this.validateTypeOf(node);
        if (valid) {
            AnnotatedTypeMirror.AnnotatedDeclaredType dt = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node);
            if (((GenericAnnotatedTypeFactory)this.atypeFactory).getDependentTypesHelper() != null) {
                ((GenericAnnotatedTypeFactory)this.atypeFactory).getDependentTypesHelper().checkType(dt, node);
            }
            this.checkConstructorInvocation(dt, constructor, node);
        }
        this.scan((Tree)node.getEnclosingExpression(), p);
        this.scan((Tree)node.getIdentifier(), p);
        this.scan((Tree)node.getClassBody(), p);
        return null;
    }

    @Override
    public Void visitLambdaExpression(LambdaExpressionTree node, Void p) {
        AnnotatedTypeMirror ret;
        Pair<AnnotatedTypeMirror.AnnotatedDeclaredType, AnnotatedTypeMirror.AnnotatedExecutableType> result = ((AnnotatedTypeFactory)this.atypeFactory).getFnInterfaceFromTree(node);
        AnnotatedTypeMirror.AnnotatedExecutableType functionType = (AnnotatedTypeMirror.AnnotatedExecutableType)result.second;
        if (node.getBody().getKind() != Tree.Kind.BLOCK && (ret = functionType.getReturnType()).getKind() != TypeKind.VOID) {
            this.visitorState.setAssignmentContext(Pair.of(node, ret));
            this.commonAssignmentCheck(ret, (ExpressionTree)node.getBody(), "return.type.incompatible");
        }
        for (int i = 0; i < functionType.getParameterTypes().size(); ++i) {
            AnnotatedTypeMirror lambdaParameter = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getParameters().get(i));
            this.commonAssignmentCheck(lambdaParameter, functionType.getParameterTypes().get(i), node.getParameters().get(i), "lambda.param.type.incompatible");
        }
        return (Void)super.visitLambdaExpression(node, p);
    }

    @Override
    public Void visitMemberReference(MemberReferenceTree node, Void p) {
        this.checkMethodReferenceAsOverride(node, p);
        return (Void)super.visitMemberReference(node, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitReturn(ReturnTree node, Void p) {
        if (node.getExpression() == null) {
            return (Void)super.visitReturn(node, p);
        }
        Pair<Tree, AnnotatedTypeMirror> preAssCtxt = this.visitorState.getAssignmentContext();
        try {
            Tree enclosing = TreeUtils.enclosingOfKind(this.getCurrentPath(), new HashSet<Tree.Kind>(Arrays.asList(Tree.Kind.METHOD, Tree.Kind.LAMBDA_EXPRESSION)));
            AnnotatedTypeMirror ret = null;
            if (enclosing.getKind() == Tree.Kind.METHOD) {
                MethodTree enclosingMethod = TreeUtils.enclosingMethod(this.getCurrentPath());
                boolean valid = this.validateTypeOf(enclosing);
                if (valid) {
                    ret = ((GenericAnnotatedTypeFactory)this.atypeFactory).getMethodReturnType(enclosingMethod, node);
                }
            } else {
                Pair<AnnotatedTypeMirror.AnnotatedDeclaredType, AnnotatedTypeMirror.AnnotatedExecutableType> result = ((AnnotatedTypeFactory)this.atypeFactory).getFnInterfaceFromTree((LambdaExpressionTree)enclosing);
                ret = ((AnnotatedTypeMirror.AnnotatedExecutableType)result.second).getReturnType();
            }
            if (ret != null) {
                this.visitorState.setAssignmentContext(Pair.of(node, ret));
                this.commonAssignmentCheck(ret, node.getExpression(), "return.type.incompatible");
            }
            Void void_ = (Void)super.visitReturn(node, p);
            return void_;
        }
        finally {
            this.visitorState.setAssignmentContext(preAssCtxt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitAnnotation(AnnotationTree node, Void p) {
        List<? extends ExpressionTree> args = node.getArguments();
        if (args.isEmpty()) {
            return null;
        }
        TypeElement anno = (TypeElement)((Object)TreeInfo.symbol((JCTree)node.getAnnotationType()));
        Name annoName = anno.getQualifiedName();
        if (annoName.contentEquals(DefaultQualifier.class.getName()) || annoName.contentEquals(SuppressWarnings.class.getName())) {
            return null;
        }
        HashMap<String, AnnotatedTypeMirror> annoTypes = new HashMap<String, AnnotatedTypeMirror>();
        for (Element element : ElementFilter.methodsIn(anno.getEnclosedElements())) {
            AnnotatedTypeMirror.AnnotatedExecutableType exeatm = (AnnotatedTypeMirror.AnnotatedExecutableType)((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(element);
            AnnotatedTypeMirror retty = exeatm.getReturnType();
            annoTypes.put(element.getSimpleName().toString(), retty);
        }
        for (ExpressionTree expressionTree : args) {
            if (!(expressionTree instanceof AssignmentTree)) continue;
            AssignmentTree at = (AssignmentTree)expressionTree;
            if (at.getExpression().getKind() == Tree.Kind.ANNOTATION) {
                this.visitAnnotation((AnnotationTree)at.getExpression(), p);
                continue;
            }
            if (at.getExpression().getKind() == Tree.Kind.NEW_ARRAY) {
                NewArrayTree nat = (NewArrayTree)at.getExpression();
                boolean isAnno = false;
                for (ExpressionTree expressionTree2 : nat.getInitializers()) {
                    if (expressionTree2.getKind() != Tree.Kind.ANNOTATION) continue;
                    this.visitAnnotation((AnnotationTree)expressionTree2, p);
                    isAnno = true;
                }
                if (isAnno) continue;
            }
            AnnotatedTypeMirror expected = (AnnotatedTypeMirror)annoTypes.get(at.getVariable().toString());
            Pair<Tree, AnnotatedTypeMirror> preAssCtxt = this.visitorState.getAssignmentContext();
            ExpressionTree var = at.getVariable();
            assert (var instanceof IdentifierTree) : "Expected IdentifierTree as context. Found: " + var;
            AnnotatedTypeMirror annotatedTypeMirror = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(var);
            assert (annotatedTypeMirror instanceof AnnotatedTypeMirror.AnnotatedExecutableType) : "Expected AnnotatedExecutableType as context. Found: " + annotatedTypeMirror;
            AnnotatedTypeMirror newctx = ((AnnotatedTypeMirror.AnnotatedExecutableType)annotatedTypeMirror).getReturnType();
            this.visitorState.setAssignmentContext(Pair.of(null, newctx));
            try {
                AnnotatedTypeMirror actual = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(at.getExpression());
                if (expected.getKind() != TypeKind.ARRAY) {
                    this.commonAssignmentCheck(expected, actual, at.getExpression(), "annotation.type.incompatible");
                    continue;
                }
                if (actual.getKind() == TypeKind.ARRAY) {
                    this.commonAssignmentCheck(expected, actual, at.getExpression(), "annotation.type.incompatible");
                    continue;
                }
                this.commonAssignmentCheck(((AnnotatedTypeMirror.AnnotatedArrayType)expected).getComponentType(), actual, at.getExpression(), "annotation.type.incompatible");
            }
            finally {
                this.visitorState.setAssignmentContext(preAssCtxt);
            }
        }
        return null;
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpressionTree node, Void p) {
        AnnotatedTypeMirror cond = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node);
        this.commonAssignmentCheck(cond, node.getTrueExpression(), "conditional.type.incompatible");
        this.commonAssignmentCheck(cond, node.getFalseExpression(), "conditional.type.incompatible");
        return (Void)super.visitConditionalExpression(node, p);
    }

    @Override
    public Void visitUnary(UnaryTree node, Void p) {
        Tree.Kind nodeKind = node.getKind();
        if (nodeKind == Tree.Kind.PREFIX_DECREMENT || nodeKind == Tree.Kind.PREFIX_INCREMENT || nodeKind == Tree.Kind.POSTFIX_DECREMENT || nodeKind == Tree.Kind.POSTFIX_INCREMENT) {
            AnnotatedTypeMirror varType = ((GenericAnnotatedTypeFactory)this.atypeFactory).getAnnotatedTypeLhs(node.getExpression());
            AnnotatedTypeMirror valueType = ((GenericAnnotatedTypeFactory)this.atypeFactory).getAnnotatedTypeRhsUnaryAssign(node);
            String errorKey = nodeKind == Tree.Kind.PREFIX_INCREMENT || nodeKind == Tree.Kind.POSTFIX_INCREMENT ? "unary.increment.type.incompatible" : "unary.decrement.type.incompatible";
            this.commonAssignmentCheck(varType, valueType, node, errorKey);
        }
        return (Void)super.visitUnary(node, p);
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
        this.commonAssignmentCheck(node.getVariable(), (ExpressionTree)node, "compound.assignment.type.incompatible");
        return (Void)super.visitCompoundAssignment(node, p);
    }

    @Override
    public Void visitNewArray(NewArrayTree node, Void p) {
        boolean valid = this.validateTypeOf(node);
        if (valid && node.getType() != null) {
            AnnotatedTypeMirror.AnnotatedArrayType arrayType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node);
            if (((GenericAnnotatedTypeFactory)this.atypeFactory).getDependentTypesHelper() != null) {
                ((GenericAnnotatedTypeFactory)this.atypeFactory).getDependentTypesHelper().checkType(arrayType, node);
            }
            if (node.getInitializers() != null) {
                this.checkArrayInitialization(arrayType.getComponentType(), node.getInitializers());
            }
        }
        return (Void)super.visitNewArray(node, p);
    }

    protected void checkTypecastRedundancy(TypeCastTree typeCastTree) {
        AnnotatedTypeMirror exprType;
        if (!this.checker.getLintOption("cast:redundant", false)) {
            return;
        }
        AnnotatedTypeMirror castType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(typeCastTree);
        if (castType.equals(exprType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(typeCastTree.getExpression()))) {
            this.checker.report(Result.warning("cast.redundant", castType), typeCastTree);
        }
    }

    protected void checkTypecastSafety(TypeCastTree typeCastTree) {
        AnnotatedTypeMirror exprType;
        if (!this.checker.getLintOption("cast:unsafe", true)) {
            return;
        }
        AnnotatedTypeMirror castType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(typeCastTree);
        if (!this.isTypeCastSafe(castType, exprType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(typeCastTree.getExpression()))) {
            this.checker.report(Result.warning("cast.unsafe", exprType.toString(true), castType.toString(true)), typeCastTree);
        }
    }

    protected boolean isTypeCastSafe(AnnotatedTypeMirror castType, AnnotatedTypeMirror exprType) {
        QualifierHierarchy qualifierHierarchy = ((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy();
        if (castType.getKind() == TypeKind.DECLARED) {
            AnnotatedTypeMirror.AnnotatedDeclaredType castDeclared = (AnnotatedTypeMirror.AnnotatedDeclaredType)castType;
            Set<AnnotationMirror> bounds = ((AnnotatedTypeFactory)this.atypeFactory).getTypeDeclarationBounds(castDeclared.getUnderlyingType());
            if (AnnotationUtils.areSame(castDeclared.getAnnotations(), bounds)) {
                return true;
            }
        }
        if (this.checker.hasOption("checkCastElementType")) {
            AnnotatedTypeMirror newCastType = castType.getKind() == TypeKind.TYPEVAR ? ((AnnotatedTypeMirror.AnnotatedTypeVariable)castType).getUpperBound() : castType;
            AnnotatedTypeMirror newExprType = exprType.getKind() == TypeKind.TYPEVAR ? ((AnnotatedTypeMirror.AnnotatedTypeVariable)exprType).getUpperBound() : exprType;
            if (!((AnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(newExprType, newCastType)) {
                return false;
            }
            if (newCastType.getKind() == TypeKind.ARRAY && newExprType.getKind() != TypeKind.ARRAY) {
                return false;
            }
            if (newCastType.getKind() == TypeKind.DECLARED && newExprType.getKind() == TypeKind.DECLARED) {
                int exprSize;
                int castSize = ((AnnotatedTypeMirror.AnnotatedDeclaredType)newCastType).getTypeArguments().size();
                if (castSize != (exprSize = ((AnnotatedTypeMirror.AnnotatedDeclaredType)newExprType).getTypeArguments().size())) {
                    return false;
                }
            } else if (castType.getKind() == TypeKind.TYPEVAR && exprType.getKind() == TypeKind.TYPEVAR) {
                Set<AnnotationMirror> lowerBoundAnnotationsCast = AnnotatedTypes.findEffectiveLowerBoundAnnotations(qualifierHierarchy, castType);
                Set<AnnotationMirror> lowerBoundAnnotationsExpr = AnnotatedTypes.findEffectiveLowerBoundAnnotations(qualifierHierarchy, exprType);
                return qualifierHierarchy.isSubtype(lowerBoundAnnotationsExpr, lowerBoundAnnotationsCast) && qualifierHierarchy.isSubtype(exprType.getEffectiveAnnotations(), castType.getEffectiveAnnotations());
            }
            Set<AnnotationMirror> castAnnos = castType.getKind() == TypeKind.TYPEVAR ? AnnotatedTypes.findEffectiveLowerBoundAnnotations(qualifierHierarchy, castType) : castType.getAnnotations();
            return qualifierHierarchy.isSubtype(exprType.getEffectiveAnnotations(), castAnnos);
        }
        return qualifierHierarchy.isSubtype(exprType.getEffectiveAnnotations(), castType.getEffectiveAnnotations());
    }

    @Override
    public Void visitTypeCast(TypeCastTree node, Void p) {
        boolean valid;
        boolean bl = valid = this.validateTypeOf(node) && this.validateTypeOf(node.getExpression());
        if (valid) {
            this.checkTypecastSafety(node);
            this.checkTypecastRedundancy(node);
        }
        if (((GenericAnnotatedTypeFactory)this.atypeFactory).getDependentTypesHelper() != null) {
            AnnotatedTypeMirror type = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node);
            ((GenericAnnotatedTypeFactory)this.atypeFactory).getDependentTypesHelper().checkType(type, node.getType());
        }
        return (Void)super.visitTypeCast(node, p);
    }

    @Override
    public Void visitInstanceOf(InstanceOfTree node, Void p) {
        this.validateTypeOf(node.getType());
        return (Void)super.visitInstanceOf(node, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitArrayAccess(ArrayAccessTree node, Void p) {
        Pair<Tree, AnnotatedTypeMirror> preAssCtxt = this.visitorState.getAssignmentContext();
        try {
            this.visitorState.setAssignmentContext(null);
            this.scan((Tree)node.getExpression(), p);
            this.scan((Tree)node.getIndex(), p);
        }
        finally {
            this.visitorState.setAssignmentContext(preAssCtxt);
        }
        return null;
    }

    @Override
    public Void visitCatch(CatchTree node, Void p) {
        this.checkExceptionParameter(node);
        return (Void)super.visitCatch(node, p);
    }

    @Override
    public Void visitThrow(ThrowTree node, Void p) {
        this.checkThrownExpression(node);
        return (Void)super.visitThrow(node, p);
    }

    private Set<? extends AnnotationMirror> getExceptionParameterLowerBoundAnnotationsCached() {
        if (this.getExceptionParameterLowerBoundAnnotationsCache == null) {
            this.getExceptionParameterLowerBoundAnnotationsCache = this.getExceptionParameterLowerBoundAnnotations();
        }
        return this.getExceptionParameterLowerBoundAnnotationsCache;
    }

    protected void checkExceptionParameter(CatchTree node) {
        Set<AnnotationMirror> requiredAnnotations = this.getExceptionParameterLowerBoundAnnotationsCached();
        AnnotatedTypeMirror exPar = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getParameter());
        for (AnnotationMirror required : requiredAnnotations) {
            AnnotationMirror found = exPar.getAnnotationInHierarchy(required);
            assert (found != null);
            if (!((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(required, found)) {
                this.checker.report(Result.failure("exception.parameter.invalid", found, required), node.getParameter());
            }
            if (exPar.getKind() != TypeKind.UNION) continue;
            AnnotatedTypeMirror.AnnotatedUnionType aut = (AnnotatedTypeMirror.AnnotatedUnionType)exPar;
            for (AnnotatedTypeMirror annotatedTypeMirror : aut.getAlternatives()) {
                AnnotationMirror foundAltern = annotatedTypeMirror.getAnnotationInHierarchy(required);
                if (((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(required, foundAltern)) continue;
                this.checker.report(Result.failure("exception.parameter.invalid", foundAltern, required), node.getParameter());
            }
        }
    }

    protected Set<? extends AnnotationMirror> getExceptionParameterLowerBoundAnnotations() {
        return ((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().getTopAnnotations();
    }

    protected void checkThrownExpression(ThrowTree node) {
        AnnotatedTypeMirror throwType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getExpression());
        Set<AnnotationMirror> required = this.getThrowUpperBoundAnnotations();
        switch (throwType.getKind()) {
            case NULL: 
            case DECLARED: {
                Set<AnnotationMirror> found = throwType.getAnnotations();
                if (((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(found, required)) break;
                this.checker.report(Result.failure("throw.type.invalid", found, required), node.getExpression());
                break;
            }
            case TYPEVAR: 
            case WILDCARD: {
                Set<AnnotationMirror> foundEffective = throwType.getEffectiveAnnotations();
                if (((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(foundEffective, required)) break;
                this.checker.report(Result.failure("throw.type.invalid", foundEffective, required), node.getExpression());
                break;
            }
            case UNION: {
                AnnotatedTypeMirror.AnnotatedUnionType unionType = (AnnotatedTypeMirror.AnnotatedUnionType)throwType;
                Set<AnnotationMirror> foundPrimary = unionType.getAnnotations();
                if (!((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(foundPrimary, required)) {
                    this.checker.report(Result.failure("throw.type.invalid", foundPrimary, required), node.getExpression());
                }
                for (AnnotatedTypeMirror annotatedTypeMirror : unionType.getAlternatives()) {
                    if (((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(annotatedTypeMirror.getAnnotations(), required)) continue;
                    this.checker.report(Result.failure("throw.type.invalid", annotatedTypeMirror.getAnnotations(), required), node.getExpression());
                }
                break;
            }
            default: {
                throw new BugInCF("Unexpected throw expression type: " + (Object)((Object)throwType.getKind()));
            }
        }
    }

    protected Set<? extends AnnotationMirror> getThrowUpperBoundAnnotations() {
        return this.getExceptionParameterLowerBoundAnnotations();
    }

    protected void commonAssignmentCheck(Tree varTree, ExpressionTree valueExp, @CompilerMessageKey String errorKey) {
        AnnotatedTypeMirror var = ((GenericAnnotatedTypeFactory)this.atypeFactory).getAnnotatedTypeLhs(varTree);
        assert (var != null) : "no variable found for tree: " + varTree;
        if (!this.validateType(varTree, var)) {
            return;
        }
        this.commonAssignmentCheck(var, valueExp, errorKey);
    }

    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, ExpressionTree valueExp, @CompilerMessageKey String errorKey) {
        if (this.shouldSkipUses(valueExp)) {
            return;
        }
        if (valueExp.getKind() == Tree.Kind.MEMBER_REFERENCE || valueExp.getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
            return;
        }
        if (varType.getKind() == TypeKind.ARRAY && valueExp instanceof NewArrayTree && ((NewArrayTree)valueExp).getType() == null) {
            AnnotatedTypeMirror compType = ((AnnotatedTypeMirror.AnnotatedArrayType)varType).getComponentType();
            NewArrayTree arrayTree = (NewArrayTree)valueExp;
            assert (arrayTree.getInitializers() != null) : "array initializers are not expected to be null in: " + valueExp;
            this.checkArrayInitialization(compType, arrayTree.getInitializers());
        }
        if (!this.validateTypeOf(valueExp)) {
            return;
        }
        AnnotatedTypeMirror valueType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(valueExp);
        assert (valueType != null) : "null type for expression: " + valueExp;
        this.commonAssignmentCheck(varType, valueType, valueExp, errorKey);
    }

    protected final void commonAssignmentCheckStartDiagnostic(AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, Tree valueTree) {
        if (this.checker.hasOption("showchecks")) {
            long valuePos = this.positions.getStartPosition(this.root, valueTree);
            System.out.printf("%s %s (line %3d): %s %s%n     actual: %s %s%n   expected: %s %s%n", new Object[]{this.getClass().getSimpleName(), "about to test whether actual is a subtype of expected", this.root.getLineMap() != null ? this.root.getLineMap().getLineNumber(valuePos) : -1L, valueTree.getKind(), valueTree, valueType.getKind(), valueType.toString(), varType.getKind(), varType.toString()});
        }
    }

    protected final void commonAssignmentCheckEndDiagnostic(boolean success, String extraMessage, AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, Tree valueTree) {
        if (this.checker.hasOption("showchecks")) {
            long valuePos = this.positions.getStartPosition(this.root, valueTree);
            System.out.printf(" %s%s (line %3d): %s %s%n     actual: %s %s%n   expected: %s %s%n", new Object[]{success ? "success: actual is subtype of expected" : "FAILURE: actual is not subtype of expected", extraMessage == null ? "" : " because " + extraMessage, this.root.getLineMap() != null ? this.root.getLineMap().getLineNumber(valuePos) : -1L, valueTree.getKind(), valueTree, valueType.getKind(), valueType.toString(), varType.getKind(), varType.toString()});
        }
    }

    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, Tree valueTree, @CompilerMessageKey String errorKey) {
        this.commonAssignmentCheckStartDiagnostic(varType, valueType, valueTree);
        boolean success = ((AnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(valueType, varType);
        if (success) {
            for (Class<Annotation> mono : ((GenericAnnotatedTypeFactory)this.atypeFactory).getSupportedMonotonicTypeQualifiers()) {
                if (!valueType.hasAnnotation(mono) || !varType.hasAnnotation(mono)) continue;
                this.checker.report(Result.failure("monotonic.type.incompatible", mono.getSimpleName(), mono.getSimpleName(), valueType.toString()), valueTree);
                return;
            }
        }
        this.commonAssignmentCheckEndDiagnostic(success, null, varType, valueType, valueTree);
        if (!success) {
            FoundRequired pair = FoundRequired.of(valueType, varType);
            String valueTypeString = pair.found;
            String varTypeString = pair.required;
            this.checker.report(Result.failure(errorKey, valueTypeString, varTypeString), valueTree);
        }
    }

    private static boolean shouldPrintVerbose(AnnotatedTypeMirror atm1, AnnotatedTypeMirror atm2) {
        if (!atm1.toString().contains("@") && !atm2.toString().contains("@")) {
            return true;
        }
        return BaseTypeVisitor.containsSameToString(atm1, atm2);
    }

    private static boolean shouldPrintVerbose(AnnotatedTypeMirror atm, AnnotatedTypeParameterBounds bounds) {
        if (!atm.toString().contains("@") && !bounds.toString().contains("@")) {
            return true;
        }
        return BaseTypeVisitor.containsSameToString(atm, bounds.getUpperBound(), bounds.getLowerBound());
    }

    private static boolean containsSameToString(AnnotatedTypeMirror ... atms) {
        for (AnnotatedTypeMirror atm : atms) {
            Boolean result = (Boolean)checkContainsSameToString.visit(atm);
            if (result != null && result.booleanValue()) {
                return true;
            }
            checkContainsSameToString.reset();
        }
        return false;
    }

    protected void checkArrayInitialization(AnnotatedTypeMirror type, List<? extends ExpressionTree> initializers) {
        for (ExpressionTree expressionTree : initializers) {
            this.commonAssignmentCheck(type, expressionTree, "array.initializer.type.incompatible");
        }
    }

    protected void checkTypeArguments(Tree toptree, List<? extends AnnotatedTypeParameterBounds> paramBounds, List<? extends AnnotatedTypeMirror> typeargs, List<? extends Tree> typeargTrees) {
        if (paramBounds.isEmpty()) {
            return;
        }
        assert (paramBounds.size() == typeargs.size()) : "BaseTypeVisitor.checkTypeArguments: mismatch between type arguments: " + typeargs + " and type parameter bounds" + paramBounds;
        Iterator<? extends AnnotatedTypeParameterBounds> boundsIter = paramBounds.iterator();
        Iterator<? extends AnnotatedTypeMirror> argIter = typeargs.iterator();
        while (boundsIter.hasNext()) {
            AnnotatedTypeParameterBounds bounds = boundsIter.next();
            AnnotatedTypeMirror typeArg = argIter.next();
            if (this.isIgnoredUninferredWildcard(bounds.getUpperBound()) || this.isIgnoredUninferredWildcard(typeArg) || this.shouldBeCaptureConverted(typeArg, bounds)) continue;
            AnnotatedTypeMirror paramUpperBound = bounds.getUpperBound();
            if (typeArg.getKind() == TypeKind.WILDCARD) {
                paramUpperBound = ((AnnotatedTypeFactory)this.atypeFactory).widenToUpperBound(paramUpperBound, (AnnotatedTypeMirror.AnnotatedWildcardType)typeArg);
            }
            if (typeargTrees == null || typeargTrees.isEmpty()) {
                this.commonAssignmentCheck(paramUpperBound, typeArg, toptree, "type.argument.type.incompatible");
            } else {
                this.commonAssignmentCheck(paramUpperBound, typeArg, typeargTrees.get(typeargs.indexOf(typeArg)), "type.argument.type.incompatible");
            }
            if (((AnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(bounds.getLowerBound(), typeArg)) continue;
            FoundRequired fr = FoundRequired.of(typeArg, bounds);
            if (typeargTrees == null || typeargTrees.isEmpty()) {
                this.checker.report(Result.failure("type.argument.type.incompatible", fr.found, fr.required), toptree);
                continue;
            }
            this.checker.report(Result.failure("type.argument.type.incompatible", fr.found, fr.required), typeargTrees.get(typeargs.indexOf(typeArg)));
        }
    }

    private boolean isIgnoredUninferredWildcard(AnnotatedTypeMirror type) {
        return ((GenericAnnotatedTypeFactory)this.atypeFactory).ignoreUninferredTypeArguments && type.getKind() == TypeKind.WILDCARD && ((AnnotatedTypeMirror.AnnotatedWildcardType)type).isUninferredTypeArgument();
    }

    private boolean shouldBeCaptureConverted(AnnotatedTypeMirror typeArg, AnnotatedTypeParameterBounds bounds) {
        return typeArg.getKind() == TypeKind.WILDCARD && bounds.getUpperBound().getKind() == TypeKind.WILDCARD;
    }

    protected boolean skipReceiverSubtypeCheck(MethodInvocationTree node, AnnotatedTypeMirror methodDefinitionReceiver, AnnotatedTypeMirror methodCallReceiver) {
        return false;
    }

    protected void checkMethodInvocability(AnnotatedTypeMirror.AnnotatedExecutableType method, MethodInvocationTree node) {
        if (method.getReceiverType() == null) {
            return;
        }
        if (method.getElement().getKind() == ElementKind.CONSTRUCTOR) {
            return;
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType methodReceiver = method.getReceiverType().getErased();
        AnnotatedTypeMirror treeReceiver = ((AnnotatedTypeMirror)methodReceiver).shallowCopy(false);
        AnnotatedTypeMirror rcv = ((AnnotatedTypeFactory)this.atypeFactory).getReceiverType(node);
        treeReceiver.addAnnotations(rcv.getEffectiveAnnotations());
        if (!this.skipReceiverSubtypeCheck(node, methodReceiver, rcv) && !((AnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(treeReceiver, methodReceiver)) {
            this.checker.report(Result.failure("method.invocation.invalid", TreeUtils.elementFromUse(node), treeReceiver.toString(), methodReceiver.toString()), node);
        }
    }

    protected void checkConstructorInvocation(AnnotatedTypeMirror.AnnotatedDeclaredType invocation, AnnotatedTypeMirror.AnnotatedExecutableType constructor, NewClassTree newClassTree) {
        Set<AnnotationMirror> explicitAnnos = ((GenericAnnotatedTypeFactory)this.atypeFactory).fromNewClass(newClassTree).getAnnotations();
        if (explicitAnnos.isEmpty()) {
            return;
        }
        Set<AnnotationMirror> resultAnnos = constructor.getReturnType().getAnnotations();
        for (AnnotationMirror explicit : explicitAnnos) {
            AnnotationMirror resultAnno = ((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().findAnnotationInSameHierarchy(resultAnnos, explicit);
            if (!((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(explicit, resultAnno) && !((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(resultAnno, explicit)) {
                this.checker.report(Result.failure("constructor.invocation.invalid", constructor.toString(), explicit, resultAnno), newClassTree);
                return;
            }
            if (((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(resultAnno, explicit)) continue;
            this.checker.report(Result.warning("cast.unsafe.constructor.invocation", resultAnno, explicit), newClassTree);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkArguments(List<? extends AnnotatedTypeMirror> requiredArgs, List<? extends ExpressionTree> passedArgs) {
        assert (requiredArgs.size() == passedArgs.size()) : "mismatch between required args (" + requiredArgs + ") and passed args (" + passedArgs + ")";
        Pair<Tree, AnnotatedTypeMirror> preAssCtxt = this.visitorState.getAssignmentContext();
        try {
            for (int i = 0; i < requiredArgs.size(); ++i) {
                this.visitorState.setAssignmentContext(Pair.of(null, requiredArgs.get(i)));
                this.commonAssignmentCheck(requiredArgs.get(i), passedArgs.get(i), "argument.type.incompatible");
                this.scan((Tree)passedArgs.get(i), null);
            }
        }
        finally {
            this.visitorState.setAssignmentContext(preAssCtxt);
        }
    }

    protected boolean testTypevarContainment(AnnotatedTypeMirror inner, AnnotatedTypeMirror outer) {
        AnnotatedTypeMirror.AnnotatedTypeVariable outerAtv;
        AnnotatedTypeMirror.AnnotatedTypeVariable innerAtv;
        if (inner.getKind() == TypeKind.TYPEVAR && outer.getKind() == TypeKind.TYPEVAR && AnnotatedTypes.areCorrespondingTypeVariables(this.elements, innerAtv = (AnnotatedTypeMirror.AnnotatedTypeVariable)inner, outerAtv = (AnnotatedTypeMirror.AnnotatedTypeVariable)outer)) {
            TypeHierarchy typeHierarchy = ((AnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy();
            return typeHierarchy.isSubtype(innerAtv.getUpperBound(), outerAtv.getUpperBound()) && typeHierarchy.isSubtype(outerAtv.getLowerBound(), innerAtv.getLowerBound());
        }
        return false;
    }

    protected OverrideChecker createOverrideChecker(Tree overriderTree, AnnotatedTypeMirror.AnnotatedExecutableType overrider, AnnotatedTypeMirror overridingType, AnnotatedTypeMirror overridingReturnType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType, AnnotatedTypeMirror overriddenReturnType) {
        return new OverrideChecker(overriderTree, overrider, overridingType, overridingReturnType, overridden, overriddenType, overriddenReturnType);
    }

    protected boolean checkOverride(MethodTree overriderTree, AnnotatedTypeMirror.AnnotatedDeclaredType overridingType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType) {
        AnnotatedTypeMirror.AnnotatedExecutableType overrider = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(overriderTree);
        return this.checkOverride(overriderTree, overrider, overridingType, overridden, overriddenType);
    }

    protected boolean checkOverride(MethodTree overriderTree, AnnotatedTypeMirror.AnnotatedExecutableType overrider, AnnotatedTypeMirror.AnnotatedDeclaredType overridingType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType) {
        if (overrider.getTypeVariables().isEmpty() && !overridden.getTypeVariables().isEmpty()) {
            overridden = overridden.getErased();
        }
        OverrideChecker overrideChecker = this.createOverrideChecker(overriderTree, overrider, overridingType, overrider.getReturnType(), overridden, overriddenType, overridden.getReturnType());
        return overrideChecker.checkOverride();
    }

    protected boolean checkMethodReferenceAsOverride(MemberReferenceTree memberReferenceTree, Void p) {
        AnnotatedTypeMirror.AnnotatedExecutableType invocationType;
        AnnotatedTypeMirror p1;
        TypeMirror asSuper;
        Pair<AnnotatedTypeMirror.AnnotatedDeclaredType, AnnotatedTypeMirror.AnnotatedExecutableType> result = ((AnnotatedTypeFactory)this.atypeFactory).getFnInterfaceFromTree(memberReferenceTree);
        AnnotatedTypeMirror.AnnotatedDeclaredType functionalInterface = (AnnotatedTypeMirror.AnnotatedDeclaredType)result.first;
        AnnotatedTypeMirror.AnnotatedExecutableType functionType = (AnnotatedTypeMirror.AnnotatedExecutableType)result.second;
        ExpressionTree qualifierExpression = memberReferenceTree.getQualifierExpression();
        JCTree.JCMemberReference.ReferenceKind memRefKind = ((JCTree.JCMemberReference)memberReferenceTree).kind;
        AnnotatedTypeMirror enclosingType = memberReferenceTree.getMode() == MemberReferenceTree.ReferenceMode.NEW || memRefKind == JCTree.JCMemberReference.ReferenceKind.UNBOUND || memRefKind == JCTree.JCMemberReference.ReferenceKind.STATIC ? ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedTypeFromTypeTree(qualifierExpression) : ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(qualifierExpression);
        ExecutableElement compileTimeDeclaration = (ExecutableElement)TreeUtils.elementFromTree(memberReferenceTree);
        if (enclosingType.getKind() == TypeKind.DECLARED && ((AnnotatedTypeMirror.AnnotatedDeclaredType)enclosingType).wasRaw() && memRefKind == JCTree.JCMemberReference.ReferenceKind.UNBOUND && (asSuper = TypesUtils.asSuper((p1 = functionType.getParameterTypes().get(0)).getUnderlyingType(), enclosingType.getUnderlyingType(), ((AnnotatedTypeFactory)this.atypeFactory).getProcessingEnv())) != null) {
            enclosingType = AnnotatedTypes.asSuper(this.atypeFactory, p1, enclosingType);
        }
        if (this.checkMethodReferenceInference(memberReferenceTree, invocationType = ((AnnotatedTypeFactory)this.atypeFactory).methodFromUse((ExpressionTree)memberReferenceTree, (ExecutableElement)compileTimeDeclaration, (AnnotatedTypeMirror)enclosingType).executableType, enclosingType)) {
            return true;
        }
        if (invocationType.getTypeVariables().isEmpty() && !functionType.getTypeVariables().isEmpty()) {
            functionType = functionType.getErased();
        }
        QualifierPolymorphism poly = ((GenericAnnotatedTypeFactory)this.atypeFactory).getQualifierPolymorphism();
        poly.resolve(functionType, invocationType);
        AnnotatedTypeMirror invocationReturnType = compileTimeDeclaration.getKind() == ElementKind.CONSTRUCTOR ? (enclosingType.getKind() == TypeKind.ARRAY ? enclosingType : ((GenericAnnotatedTypeFactory)this.atypeFactory).getResultingTypeOfConstructorMemberReference(memberReferenceTree, invocationType)) : invocationType.getReturnType();
        AnnotatedTypeMirror functionTypeReturnType = functionType.getReturnType();
        if (functionTypeReturnType.getKind() == TypeKind.VOID) {
            functionTypeReturnType = invocationReturnType;
        }
        OverrideChecker overrideChecker = this.createOverrideChecker(memberReferenceTree, invocationType, enclosingType, invocationReturnType, functionType, functionalInterface, functionTypeReturnType);
        return overrideChecker.checkOverride();
    }

    private boolean checkMethodReferenceInference(MemberReferenceTree memberReferenceTree, AnnotatedTypeMirror.AnnotatedExecutableType invocationType, AnnotatedTypeMirror type) {
        boolean requiresInference = false;
        if (!invocationType.getTypeVariables().isEmpty() && (memberReferenceTree.getTypeArguments() == null || memberReferenceTree.getTypeArguments().isEmpty())) {
            requiresInference = true;
        } else if (memberReferenceTree.getMode() == MemberReferenceTree.ReferenceMode.NEW && type.getKind() == TypeKind.DECLARED && ((AnnotatedTypeMirror.AnnotatedDeclaredType)type).wasRaw()) {
            requiresInference = true;
        }
        if (requiresInference) {
            if (this.checker.hasOption("conservativeUninferredTypeArguments")) {
                this.checker.report(Result.warning("methodref.inference.unimplemented", new Object[0]), memberReferenceTree);
            }
            return true;
        }
        return false;
    }

    private Set<ContractsUtils.Postcondition> filterConditionalPostconditions(Set<ContractsUtils.ConditionalPostcondition> conditionalPostconditions, boolean b) {
        LinkedHashSet<ContractsUtils.Postcondition> result = new LinkedHashSet<ContractsUtils.Postcondition>();
        for (ContractsUtils.ConditionalPostcondition p : conditionalPostconditions) {
            if (p.annoResult != b) continue;
            result.add(new ContractsUtils.Postcondition(p.expression, p.annotation, p.contractAnnotation));
        }
        return result;
    }

    private void checkContractsSubset(String overriderMeth, String overriderTyp, String overriddenMeth, String overriddenTyp, Set<Pair<FlowExpressions.Receiver, AnnotationMirror>> mustSubset, Set<Pair<FlowExpressions.Receiver, AnnotationMirror>> set, @CompilerMessageKey String messageKey) {
        for (Pair<FlowExpressions.Receiver, AnnotationMirror> weak : mustSubset) {
            boolean found = false;
            for (Pair<FlowExpressions.Receiver, AnnotationMirror> strong : set) {
                QualifierHierarchy qualifierHierarchy;
                if (!((FlowExpressions.Receiver)weak.first).equals(strong.first) || !(qualifierHierarchy = ((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy()).isSubtype((AnnotationMirror)strong.second, (AnnotationMirror)weak.second)) continue;
                found = true;
                break;
            }
            if (found) continue;
            MethodTree method = this.visitorState.getMethodTree();
            this.checker.report(Result.failure(messageKey, overriderMeth, overriderTyp, overriddenMeth, overriddenTyp, weak.second, weak.first), method);
        }
    }

    private Set<Pair<FlowExpressions.Receiver, AnnotationMirror>> resolveContracts(Set<? extends ContractsUtils.Contract> contractSet, AnnotatedTypeMirror.AnnotatedExecutableType method) {
        HashSet<Pair<FlowExpressions.Receiver, AnnotationMirror>> result = new HashSet<Pair<FlowExpressions.Receiver, AnnotationMirror>>();
        MethodTree methodTree = this.visitorState.getMethodTree();
        TreePath path = ((AnnotatedTypeFactory)this.atypeFactory).getPath(methodTree);
        FlowExpressionParseUtil.FlowExpressionContext flowExprContext = null;
        for (ContractsUtils.Contract contract : contractSet) {
            String expression = contract.expression;
            AnnotationMirror annotation = contract.annotation;
            if (flowExprContext == null) {
                flowExprContext = FlowExpressionParseUtil.FlowExpressionContext.buildContextForMethodDeclaration(methodTree, method.getReceiverType().getUnderlyingType(), (BaseContext)this.checker.getContext());
            }
            annotation = this.standardizeAnnotationFromContract(annotation, flowExprContext, path);
            try {
                FlowExpressions.Receiver expr = FlowExpressionParseUtil.parse(expression, flowExprContext, path, false);
                result.add(Pair.of(expr, annotation));
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                this.checker.report(e.getResult(), methodTree);
            }
        }
        return result;
    }

    protected MemberSelectTree enclosingMemberSelect() {
        TreePath path = this.getCurrentPath();
        assert (path.getLeaf().getKind() == Tree.Kind.IDENTIFIER) : "expected identifier, found: " + path.getLeaf();
        if (path.getParentPath().getLeaf().getKind() == Tree.Kind.MEMBER_SELECT) {
            return (MemberSelectTree)path.getParentPath().getLeaf();
        }
        return null;
    }

    protected Tree enclosingStatement(Tree tree) {
        TreePath path;
        for (path = this.getCurrentPath(); path != null && path.getLeaf() != tree; path = path.getParentPath()) {
        }
        if (path != null) {
            return path.getParentPath().getLeaf();
        }
        return null;
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void p) {
        this.checkAccess(node, p);
        return (Void)super.visitIdentifier(node, p);
    }

    protected void checkAccess(IdentifierTree node, Void p) {
        Element elem;
        ExpressionTree tree;
        MemberSelectTree memberSel = this.enclosingMemberSelect();
        if (memberSel == null) {
            tree = node;
            elem = TreeUtils.elementFromUse(node);
        } else {
            tree = memberSel;
            elem = TreeUtils.elementFromUse(memberSel);
        }
        if (elem == null || !elem.getKind().isField()) {
            return;
        }
        AnnotatedTypeMirror receiver = ((AnnotatedTypeFactory)this.atypeFactory).getReceiverType(tree);
        if (!this.isAccessAllowed(elem, receiver, tree)) {
            this.checker.report(Result.failure("unallowed.access", elem, receiver), node);
        }
    }

    protected boolean isAccessAllowed(Element field, AnnotatedTypeMirror receiver, ExpressionTree accessTree) {
        AnnotationMirror unused = ((AnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(field, Unused.class);
        if (unused == null) {
            return true;
        }
        String when = AnnotationUtils.getElementValueClassName(unused, "when", false).toString();
        if (!AnnotationUtils.containsSameByName(receiver.getAnnotations(), when)) {
            return true;
        }
        Tree tree = this.enclosingStatement(accessTree);
        return tree != null && tree.getKind() == Tree.Kind.ASSIGNMENT && ((AssignmentTree)tree).getVariable() == accessTree && ((AssignmentTree)tree).getExpression().getKind() == Tree.Kind.NULL_LITERAL;
    }

    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedDeclaredType declarationType, AnnotatedTypeMirror.AnnotatedDeclaredType useType, Tree tree) {
        return ((AnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(useType.getErased(), declarationType.getErased());
    }

    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedPrimitiveType type, Tree tree) {
        Set<AnnotationMirror> bounds = ((AnnotatedTypeFactory)this.atypeFactory).getTypeDeclarationBounds(type.getUnderlyingType());
        return ((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(type.getAnnotations(), bounds);
    }

    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedArrayType type, Tree tree) {
        Set<AnnotationMirror> bounds = ((AnnotatedTypeFactory)this.atypeFactory).getTypeDeclarationBounds(type.getUnderlyingType());
        return ((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(type.getAnnotations(), bounds);
    }

    public boolean validateTypeOf(Tree tree) {
        AnnotatedTypeMirror type;
        switch (tree.getKind()) {
            case PRIMITIVE_TYPE: 
            case PARAMETERIZED_TYPE: 
            case TYPE_PARAMETER: 
            case ARRAY_TYPE: 
            case UNBOUNDED_WILDCARD: 
            case EXTENDS_WILDCARD: 
            case SUPER_WILDCARD: 
            case ANNOTATED_TYPE: {
                type = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedTypeFromTypeTree(tree);
                break;
            }
            case METHOD: {
                type = ((GenericAnnotatedTypeFactory)this.atypeFactory).getMethodReturnType((MethodTree)tree);
                if (type != null && type.getKind() != TypeKind.VOID) break;
                return true;
            }
            default: {
                type = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(tree);
            }
        }
        return this.validateType(tree, type);
    }

    protected boolean validateType(Tree tree, AnnotatedTypeMirror type) {
        return this.typeValidator.isValid(type, tree);
    }

    protected TypeValidator createTypeValidator() {
        return new BaseTypeValidator(this.checker, this, (AnnotatedTypeFactory)this.atypeFactory);
    }

    protected final boolean shouldSkipUses(ExpressionTree exprTree) {
        Element elm = TreeUtils.elementFromTree(exprTree);
        return this.checker.shouldSkipUses(elm);
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree node, Void p) {
        Void r = (Void)this.scan(node.getPackageAnnotations(), p);
        r = this.reduce(this.scan(node.getTypeDecls(), p), r);
        return r;
    }

    protected void checkForAnnotatedJdk() {
        if (checkedJDK) {
            return;
        }
        checkedJDK = true;
        if (this.checker.hasOption("nocheckjdk")) {
            return;
        }
        TypeElement objectTE = this.elements.getTypeElement("java.lang.Object");
        List<ExecutableElement> memberMethods = ElementFilter.methodsIn(this.elements.getAllMembers(objectTE));
        for (ExecutableElement m3 : memberMethods) {
            if (!ElementUtils.isMethod(m3, this.objectEquals, this.checker.getProcessingEnvironment())) continue;
            boolean foundJDK = false;
            for (Attribute.TypeCompound tc : ((Symbol)((Object)m3)).getRawTypeAttributes()) {
                if (tc.position.type != TargetType.METHOD_FORMAL_PARAMETER || tc.position.parameter_index != 0 || !tc.type.toString().equals("org.checkerframework.checker.nullness.qual.Nullable")) continue;
                foundJDK = true;
            }
            if (foundJDK) continue;
            String jdkJarName = PluginUtil.getJdkJarName();
            this.checker.message(Diagnostic.Kind.WARNING, "You do not seem to be using the distributed annotated JDK.  To fix the problem, supply javac an argument like:  -Xbootclasspath/p:.../checker/dist/ .  Currently using: " + jdkJarName, new Object[0]);
        }
    }

    public class OverrideChecker {
        protected final String overriderMeth;
        protected final String overriderTyp;
        protected final String overriddenMeth;
        protected final String overriddenTyp;
        protected final Tree overriderTree;
        protected final Boolean methodReference;
        protected final AnnotatedTypeMirror.AnnotatedExecutableType overrider;
        protected final AnnotatedTypeMirror overridingType;
        protected final AnnotatedTypeMirror.AnnotatedExecutableType overridden;
        protected final AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType;
        protected final AnnotatedTypeMirror overriddenReturnType;
        protected final AnnotatedTypeMirror overridingReturnType;

        public OverrideChecker(Tree overriderTree, AnnotatedTypeMirror.AnnotatedExecutableType overrider, AnnotatedTypeMirror overridingType, AnnotatedTypeMirror overridingReturnType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType, AnnotatedTypeMirror overriddenReturnType) {
            this.overriderTree = overriderTree;
            this.overrider = overrider;
            this.overridingType = overridingType;
            this.overridden = overridden;
            this.overriddenType = overriddenType;
            this.overriddenReturnType = overriddenReturnType;
            this.overridingReturnType = overridingReturnType;
            this.overriderMeth = overrider.toString();
            if (overridingType.getKind() == TypeKind.DECLARED) {
                DeclaredType overriderTypeMirror = ((AnnotatedTypeMirror.AnnotatedDeclaredType)overridingType).getUnderlyingType();
                this.overriderTyp = overriderTypeMirror.asElement().toString();
            } else {
                this.overriderTyp = overridingType.toString();
            }
            this.overriddenMeth = overridden.toString();
            this.overriddenTyp = overriddenType.getUnderlyingType().asElement().toString();
            this.methodReference = overriderTree.getKind() == Tree.Kind.MEMBER_REFERENCE;
        }

        public boolean checkOverride() {
            if (BaseTypeVisitor.this.checker.shouldSkipUses(this.overriddenType.getUnderlyingType().asElement())) {
                return true;
            }
            boolean result = this.checkReturn();
            result &= this.checkParameters();
            result = this.methodReference.booleanValue() ? (result &= this.checkMemberReferenceReceivers()) : (result &= this.checkReceiverOverride());
            this.checkPreAndPostConditions();
            this.checkPurity();
            return result;
        }

        private void checkPurity() {
            String msgKey = this.methodReference != false ? "purity.invalid.methodref" : "purity.invalid.overriding";
            HashSet<Pure.Kind> superPurity = new HashSet<Pure.Kind>(PurityUtils.getPurityKinds(BaseTypeVisitor.this.atypeFactory, this.overridden.getElement()));
            HashSet<Pure.Kind> subPurity = new HashSet<Pure.Kind>(PurityUtils.getPurityKinds(BaseTypeVisitor.this.atypeFactory, this.overrider.getElement()));
            if (!subPurity.containsAll(superPurity)) {
                BaseTypeVisitor.this.checker.report(Result.failure(msgKey, this.overriderMeth, this.overriderTyp, this.overriddenMeth, this.overriddenTyp, subPurity, superPurity), this.overriderTree);
            }
        }

        private void checkPreAndPostConditions() {
            String msgKey;
            String string = msgKey = this.methodReference != false ? "methodref" : "override";
            if (this.methodReference.booleanValue()) {
                return;
            }
            ContractsUtils contracts = ContractsUtils.getInstance(BaseTypeVisitor.this.atypeFactory);
            Set<ContractsUtils.Postcondition> superPost = contracts.getPostconditions(this.overridden.getElement());
            Set<ContractsUtils.Postcondition> subPost = contracts.getPostconditions(this.overrider.getElement());
            Set superPost2 = BaseTypeVisitor.this.resolveContracts(superPost, this.overridden);
            Set subPost2 = BaseTypeVisitor.this.resolveContracts(subPost, this.overrider);
            @CompilerMessageKey String postmsg = "contracts.postcondition." + msgKey + ".invalid";
            BaseTypeVisitor.this.checkContractsSubset(this.overriderMeth, this.overriderTyp, this.overriddenMeth, this.overriddenTyp, superPost2, subPost2, postmsg);
            Set<ContractsUtils.Precondition> superPre = contracts.getPreconditions(this.overridden.getElement());
            Set<ContractsUtils.Precondition> subPre = contracts.getPreconditions(this.overrider.getElement());
            Set superPre2 = BaseTypeVisitor.this.resolveContracts(superPre, this.overridden);
            Set subPre2 = BaseTypeVisitor.this.resolveContracts(subPre, this.overrider);
            @CompilerMessageKey String premsg = "contracts.precondition." + msgKey + ".invalid";
            BaseTypeVisitor.this.checkContractsSubset(this.overriderMeth, this.overriderTyp, this.overriddenMeth, this.overriddenTyp, subPre2, superPre2, premsg);
            Set<ContractsUtils.ConditionalPostcondition> superCPost = contracts.getConditionalPostconditions(this.overridden.getElement());
            Set<ContractsUtils.ConditionalPostcondition> subCPost = contracts.getConditionalPostconditions(this.overrider.getElement());
            Set superCPostTrue = BaseTypeVisitor.this.filterConditionalPostconditions(superCPost, true);
            Set subCPostTrue = BaseTypeVisitor.this.filterConditionalPostconditions(subCPost, true);
            Set superCPostTrue2 = BaseTypeVisitor.this.resolveContracts(superCPostTrue, this.overridden);
            Set subCPostTrue2 = BaseTypeVisitor.this.resolveContracts(subCPostTrue, this.overrider);
            @CompilerMessageKey String posttruemsg = "contracts.conditional.postcondition.true." + msgKey + ".invalid";
            BaseTypeVisitor.this.checkContractsSubset(this.overriderMeth, this.overriderTyp, this.overriddenMeth, this.overriddenTyp, superCPostTrue2, subCPostTrue2, posttruemsg);
            Set superCPostFalse = BaseTypeVisitor.this.filterConditionalPostconditions(superCPost, false);
            Set subCPostFalse = BaseTypeVisitor.this.filterConditionalPostconditions(subCPost, false);
            Set superCPostFalse2 = BaseTypeVisitor.this.resolveContracts(superCPostFalse, this.overridden);
            Set subCPostFalse2 = BaseTypeVisitor.this.resolveContracts(subCPostFalse, this.overrider);
            @CompilerMessageKey String postfalsemsg = "contracts.conditional.postcondition.false." + msgKey + ".invalid";
            BaseTypeVisitor.this.checkContractsSubset(this.overriderMeth, this.overriderTyp, this.overriddenMeth, this.overriddenTyp, superCPostFalse2, subCPostFalse2, postfalsemsg);
        }

        private boolean checkMemberReferenceReceivers() {
            AnnotatedTypeMirror receiverArg;
            AnnotatedTypeMirror.AnnotatedDeclaredType receiverDecl;
            JCTree.JCMemberReference memberTree = (JCTree.JCMemberReference)this.overriderTree;
            if (this.overridingType.getKind() == TypeKind.ARRAY) {
                return true;
            }
            if (memberTree.kind == JCTree.JCMemberReference.ReferenceKind.UNBOUND) {
                AnnotatedTypeMirror.AnnotatedDeclaredType overriderReceiver = this.overrider.getReceiverType();
                AnnotatedTypeMirror overriddenReceiver = this.overridden.getParameterTypes().get(0);
                boolean success = ((AnnotatedTypeFactory)BaseTypeVisitor.this.atypeFactory).getTypeHierarchy().isSubtype(overriddenReceiver, overriderReceiver);
                if (!success) {
                    BaseTypeVisitor.this.checker.report(Result.failure("methodref.receiver.invalid", this.overriderMeth, this.overriderTyp, this.overriddenMeth, this.overriddenTyp, overriderReceiver, overriddenReceiver), this.overriderTree);
                }
                return success;
            }
            switch (memberTree.kind) {
                case UNBOUND: {
                    throw new BugInCF("Case UNBOUND should already be handled.");
                }
                case SUPER: {
                    receiverDecl = this.overrider.getReceiverType();
                    receiverArg = ((AnnotatedTypeFactory)BaseTypeVisitor.this.atypeFactory).getAnnotatedType(memberTree.getQualifierExpression());
                    AnnotatedTypeMirror.AnnotatedDeclaredType selfType = ((AnnotatedTypeFactory)BaseTypeVisitor.this.atypeFactory).getSelfType(memberTree);
                    receiverArg.replaceAnnotations(selfType.getAnnotations());
                    break;
                }
                case BOUND: {
                    receiverDecl = this.overrider.getReceiverType();
                    receiverArg = this.overridingType;
                    break;
                }
                case IMPLICIT_INNER: {
                    receiverDecl = this.overrider.getReceiverType();
                    receiverArg = ((AnnotatedTypeFactory)BaseTypeVisitor.this.atypeFactory).getSelfType(memberTree);
                    while (!TypesUtils.isErasedSubtype(receiverArg.getUnderlyingType(), ((AnnotatedTypeMirror)receiverDecl).getUnderlyingType(), BaseTypeVisitor.this.types)) {
                        receiverArg = ((AnnotatedTypeMirror.AnnotatedDeclaredType)receiverArg).getEnclosingType();
                    }
                    break;
                }
                default: {
                    return true;
                }
            }
            boolean success = ((AnnotatedTypeFactory)BaseTypeVisitor.this.atypeFactory).getTypeHierarchy().isSubtype(receiverArg, receiverDecl);
            if (!success) {
                BaseTypeVisitor.this.checker.report(Result.failure("methodref.receiver.bound.invalid", receiverArg, this.overriderMeth, this.overriderTyp, receiverArg, receiverDecl), this.overriderTree);
            }
            return success;
        }

        protected boolean checkReceiverOverride() {
            AnnotatedTypeMirror.AnnotatedDeclaredType overriderReceiver = this.overrider.getReceiverType();
            AnnotatedTypeMirror.AnnotatedDeclaredType overriddenReceiver = this.overridden.getReceiverType();
            QualifierHierarchy qualifierHierarchy = ((AnnotatedTypeFactory)BaseTypeVisitor.this.atypeFactory).getQualifierHierarchy();
            Set<AnnotationMirror> overriderAnnos = overriderReceiver.getAnnotations();
            Set<AnnotationMirror> overriddenAnnos = overriddenReceiver.getAnnotations();
            if (!qualifierHierarchy.isSubtype(overriddenAnnos, overriderAnnos)) {
                Set<AnnotationMirror> declaredAnnos = ((AnnotatedTypeFactory)BaseTypeVisitor.this.atypeFactory).getTypeDeclarationBounds(this.overridingType.getUnderlyingType());
                if (qualifierHierarchy.isSubtype(overriderAnnos, declaredAnnos) && qualifierHierarchy.isSubtype(declaredAnnos, overriderAnnos)) {
                    return true;
                }
                FoundRequired pair = FoundRequired.of((AnnotatedTypeMirror)overriderReceiver, overriddenReceiver);
                BaseTypeVisitor.this.checker.report(Result.failure("override.receiver.invalid", this.overriderMeth, this.overriderTyp, this.overriddenMeth, this.overriddenTyp, pair.found, pair.required), this.overriderTree);
                return false;
            }
            return true;
        }

        private boolean checkParameters() {
            List<AnnotatedTypeMirror> overriderParams = this.overrider.getParameterTypes();
            List<AnnotatedTypeMirror> overriddenParams = this.overridden.getParameterTypes();
            if (this.methodReference.booleanValue()) {
                if (((JCTree.JCMemberReference)this.overriderTree).hasKind(JCTree.JCMemberReference.ReferenceKind.UNBOUND)) {
                    overriddenParams = new ArrayList<AnnotatedTypeMirror>(overriddenParams);
                    overriddenParams.remove(0);
                }
                if (this.overrider.isVarArgs() && !this.overridden.isVarArgs()) {
                    overriderParams = AnnotatedTypes.expandVarArgsFromTypes(this.overrider, overriddenParams);
                }
            }
            boolean result = true;
            for (int i = 0; i < overriderParams.size(); ++i) {
                boolean success = ((AnnotatedTypeFactory)BaseTypeVisitor.this.atypeFactory).getTypeHierarchy().isSubtype(overriddenParams.get(i), overriderParams.get(i));
                if (!success) {
                    success = BaseTypeVisitor.this.testTypevarContainment(overriddenParams.get(i), overriderParams.get(i));
                }
                this.checkParametersMsg(success, i, overriderParams, overriddenParams);
                result &= success;
            }
            return result;
        }

        private void checkParametersMsg(boolean success, int index, List<AnnotatedTypeMirror> overriderParams, List<AnnotatedTypeMirror> overriddenParams) {
            Tree posTree;
            String msgKey = this.methodReference != false ? "methodref.param.invalid" : "override.param.invalid";
            long valuePos = this.overriderTree instanceof MethodTree ? BaseTypeVisitor.this.positions.getStartPosition(BaseTypeVisitor.this.root, ((MethodTree)this.overriderTree).getParameters().get(index)) : BaseTypeVisitor.this.positions.getStartPosition(BaseTypeVisitor.this.root, this.overriderTree);
            Tree tree = posTree = this.overriderTree instanceof MethodTree ? (Tree)((MethodTree)this.overriderTree).getParameters().get(index) : this.overriderTree;
            if (BaseTypeVisitor.this.checker.hasOption("showchecks")) {
                System.out.printf(" %s (line %3d):%n     overrider: %s %s (parameter %d type %s)%n   overridden: %s %s (parameter %d type %s)%n", success ? "success: overridden parameter type is subtype of overriding" : "FAILURE: overridden parameter type is not subtype of overriding", BaseTypeVisitor.this.root.getLineMap() != null ? BaseTypeVisitor.this.root.getLineMap().getLineNumber(valuePos) : -1L, this.overriderMeth, this.overriderTyp, index, overriderParams.get(index).toString(), this.overriddenMeth, this.overriddenTyp, index, overriddenParams.get(index).toString());
            }
            if (!success) {
                FoundRequired pair = FoundRequired.of(overriderParams.get(index), overriddenParams.get(index));
                BaseTypeVisitor.this.checker.report(Result.failure(msgKey, this.overrider.getElement().getParameters().get(index).toString(), this.overriderMeth, this.overriderTyp, this.overriddenMeth, this.overriddenTyp, pair.found, pair.required), posTree);
            }
        }

        private boolean checkReturn() {
            boolean success = true;
            if (this.overridingReturnType.getKind() != TypeKind.VOID) {
                TypeHierarchy typeHierarchy = ((AnnotatedTypeFactory)BaseTypeVisitor.this.atypeFactory).getTypeHierarchy();
                success = typeHierarchy.isSubtype(this.overridingReturnType, this.overriddenReturnType);
                if (!success && !(success = BaseTypeVisitor.this.testTypevarContainment(this.overridingReturnType, this.overriddenReturnType)) && this.methodReference.booleanValue()) {
                    ExecutableElement overridenMethod;
                    boolean isFunctionApply;
                    boolean isCaptureConverted;
                    boolean bl = isCaptureConverted = this.overriddenReturnType.getKind() == TypeKind.TYPEVAR && TypesUtils.isCaptured((TypeVariable)this.overriddenReturnType.getUnderlyingType());
                    if (this.methodReference.booleanValue() && isCaptureConverted && (isFunctionApply = ElementUtils.isMethod(overridenMethod = this.overridden.getElement(), BaseTypeVisitor.this.functionApply, ((AnnotatedTypeFactory)BaseTypeVisitor.this.atypeFactory).getProcessingEnv()))) {
                        AnnotatedTypeMirror overridingUpperBound = ((AnnotatedTypeMirror.AnnotatedTypeVariable)this.overriddenReturnType).getUpperBound();
                        success = typeHierarchy.isSubtype(this.overridingReturnType, overridingUpperBound);
                    }
                }
                this.checkReturnMsg(success);
            }
            return success;
        }

        private void checkReturnMsg(boolean success) {
            Tree posTree;
            String msgKey = this.methodReference != false ? "methodref.return.invalid" : "override.return.invalid";
            long valuePos = this.overriderTree instanceof MethodTree ? BaseTypeVisitor.this.positions.getStartPosition(BaseTypeVisitor.this.root, ((MethodTree)this.overriderTree).getReturnType()) : BaseTypeVisitor.this.positions.getStartPosition(BaseTypeVisitor.this.root, this.overriderTree);
            Tree tree = posTree = this.overriderTree instanceof MethodTree ? ((MethodTree)this.overriderTree).getReturnType() : this.overriderTree;
            if (posTree == null) {
                posTree = this.overriderTree;
            }
            if (BaseTypeVisitor.this.checker.hasOption("showchecks")) {
                System.out.printf(" %s (line %3d):%n     overrider: %s %s (return type %s)%n   overridden: %s %s (return type %s)%n", success ? "success: overriding return type is subtype of overridden" : "FAILURE: overriding return type is not subtype of overridden", BaseTypeVisitor.this.root.getLineMap() != null ? BaseTypeVisitor.this.root.getLineMap().getLineNumber(valuePos) : -1L, this.overriderMeth, this.overriderTyp, this.overrider.getReturnType().toString(), this.overriddenMeth, this.overriddenTyp, this.overridden.getReturnType().toString());
            }
            if (!success) {
                FoundRequired pair = FoundRequired.of(this.overridingReturnType, this.overriddenReturnType);
                BaseTypeVisitor.this.checker.report(Result.failure(msgKey, this.overriderMeth, this.overriderTyp, this.overriddenMeth, this.overriddenTyp, pair.found, pair.required), posTree);
            }
        }
    }

    private static class FoundRequired {
        public final String found;
        public final String required;

        private FoundRequired(AnnotatedTypeMirror found, AnnotatedTypeMirror required) {
            if (BaseTypeVisitor.shouldPrintVerbose(found, required)) {
                this.found = found.toString(true);
                this.required = required.toString(true);
            } else {
                this.found = found.toString();
                this.required = required.toString();
            }
        }

        private FoundRequired(AnnotatedTypeMirror found, AnnotatedTypeParameterBounds required) {
            if (BaseTypeVisitor.shouldPrintVerbose(found, required)) {
                this.found = found.toString(true);
                this.required = required.toString(true);
            } else {
                this.found = found.toString();
                this.required = required.toString();
            }
        }

        static FoundRequired of(AnnotatedTypeMirror found, AnnotatedTypeMirror required) {
            return new FoundRequired(found, required);
        }

        static FoundRequired of(AnnotatedTypeMirror found, AnnotatedTypeParameterBounds required) {
            return new FoundRequired(found, required);
        }
    }
}

