/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.checkerframework.javacutil.BugInCF;

public abstract class AbstractMostlySingleton<T>
implements Set<T> {
    protected State state;
    protected T value;
    protected Collection<T> set;

    @Override
    public int size() {
        switch (this.state) {
            case EMPTY: {
                return 0;
            }
            case SINGLETON: {
                return 1;
            }
            case ANY: {
                return this.set.size();
            }
        }
        throw new BugInCF("Unhandled state " + (Object)((Object)this.state));
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<T> iterator() {
        switch (this.state) {
            case EMPTY: {
                return Collections.emptyIterator();
            }
            case SINGLETON: {
                return new Iterator<T>(){
                    private boolean hasNext = true;

                    @Override
                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    @Override
                    public T next() {
                        if (this.hasNext) {
                            this.hasNext = false;
                            return AbstractMostlySingleton.this.value;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            case ANY: {
                return this.set.iterator();
            }
        }
        throw new BugInCF("Unhandled state " + (Object)((Object)this.state));
    }

    public String toString() {
        switch (this.state) {
            case EMPTY: {
                return "[]";
            }
            case SINGLETON: {
                return "[" + this.value + "]";
            }
            case ANY: {
                return this.set.toString();
            }
        }
        throw new BugInCF("Unhandled state " + (Object)((Object)this.state));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean res = false;
        for (T elem : c) {
            res |= this.add(elem);
        }
        return res;
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <S> S[] toArray(S[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public static enum State {
        EMPTY,
        SINGLETON,
        ANY;

    }
}

