/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.element;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.TargetType;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.element.ElementAnnotationUtil;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.PluginUtil;

abstract class TargetedElementAnnotationApplier {
    protected final AnnotatedTypeMirror type;
    protected final Element element;

    protected abstract TargetType[] annotatedTargets();

    protected abstract TargetType[] validTargets();

    protected abstract Iterable<Attribute.TypeCompound> getRawTypeAttributes();

    protected abstract boolean isAccepted();

    TargetedElementAnnotationApplier(AnnotatedTypeMirror type, Element element) {
        this.type = type;
        this.element = element;
    }

    protected abstract void handleTargeted(List<Attribute.TypeCompound> var1);

    protected void handleValid(List<Attribute.TypeCompound> valid) {
    }

    protected void handleInvalid(List<Attribute.TypeCompound> invalid) {
        ArrayList<Attribute.TypeCompound> remaining = new ArrayList<Attribute.TypeCompound>(invalid.size());
        for (Attribute.TypeCompound tc : invalid) {
            if (tc.getAnnotationType().getKind() == TypeKind.ERROR) continue;
            remaining.add(tc);
        }
        if (!remaining.isEmpty()) {
            throw new BugInCF("handleInvalid(this=" + this.getClass().getName() + "):\nInvalid variable and element passed to extractAndApply;  type: " + this.type + "\n  element: " + this.element + " (kind: " + (Object)((Object)this.element.getKind()) + ")\n  invalid annotations: " + PluginUtil.join(", ", remaining) + "\nTargeted annotations: " + PluginUtil.join(", ", this.annotatedTargets()) + "\nValid annotations: " + PluginUtil.join(", ", this.validTargets()));
        }
    }

    protected Map<TargetClass, List<Attribute.TypeCompound>> sift(Iterable<Attribute.TypeCompound> typeCompounds) {
        EnumMap<TargetClass, List<Attribute.TypeCompound>> targetClassToCompound = new EnumMap<TargetClass, List<Attribute.TypeCompound>>(TargetClass.class);
        for (TargetClass targetClass : TargetClass.values()) {
            targetClassToCompound.put(targetClass, new ArrayList());
        }
        for (Attribute.TypeCompound typeCompound : typeCompounds) {
            TargetType typeCompoundTarget = typeCompound.position.type;
            List destList = ElementAnnotationUtil.contains((Object)typeCompoundTarget, (Object[])this.annotatedTargets()) ? (List)targetClassToCompound.get((Object)TargetClass.TARGETED) : (ElementAnnotationUtil.contains((Object)typeCompoundTarget, (Object[])this.validTargets()) ? (List)targetClassToCompound.get((Object)TargetClass.VALID) : (List)targetClassToCompound.get((Object)TargetClass.INVALID));
            destList.add(typeCompound);
        }
        return targetClassToCompound;
    }

    public void extractAndApply() {
        if (!this.isAccepted()) {
            throw new BugInCF("LocalVariableExtractor.extractAndApply: Invalid variable and element passed to " + this.getClass().getName() + "::extractAndApply (" + this.type + ", " + this.element);
        }
        Map<TargetClass, List<Attribute.TypeCompound>> targetClassToAnno = this.sift(this.getRawTypeAttributes());
        this.handleInvalid(targetClassToAnno.get((Object)TargetClass.INVALID));
        this.handleValid(targetClassToAnno.get((Object)TargetClass.VALID));
        this.handleTargeted(targetClassToAnno.get((Object)TargetClass.TARGETED));
    }

    static enum TargetClass {
        TARGETED,
        VALID,
        INVALID;

    }
}

