/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import scenelib.annotations.el.AnnotationDef;
import scenelib.annotations.field.AnnotationFieldType;

public final class Annotation {
    public final AnnotationDef def;
    public final Map<String, Object> fieldValues;

    public void checkRep() {
        assert (this.fieldValues != null);
        assert (this.fieldValues.keySet() != null);
        assert (this.def != null);
        assert (this.def.fieldTypes != null);
        assert (this.def.fieldTypes.keySet() != null);
        if (!this.fieldValues.keySet().equals(this.def.fieldTypes.keySet())) {
            for (String s2 : this.fieldValues.keySet()) {
                assert (this.def.fieldTypes.containsKey(s2)) : String.format("Annotation contains field %s but AnnotationDef does not%n  annotation: %s%n  def: %s%n", s2, this, this.def);
            }
        }
        for (String fieldname : this.fieldValues.keySet()) {
            String valueString;
            AnnotationFieldType aft = this.def.fieldTypes.get(fieldname);
            Object value = this.fieldValues.get(fieldname);
            String classString = value.getClass().toString();
            if (value instanceof Object[]) {
                Object[] arr = (Object[])value;
                valueString = Arrays.toString(arr);
                classString = classString + " {";
                for (Object elt : arr) {
                    classString = classString + " " + elt.getClass();
                }
                classString = classString + "}";
            } else if (value instanceof Collection) {
                Collection coll = (Collection)value;
                valueString = Arrays.toString(coll.toArray());
                classString = classString + " {";
                for (Object elt : coll) {
                    classString = classString + " " + elt.getClass();
                }
                classString = classString + " }";
            } else {
                valueString = value.toString();
            }
            assert (aft.isValidValue(value)) : String.format("Bad field value%n  %s (%s)%nfor field%n  %s (%s)%nin annotation%n  %s", valueString, classString, aft, aft.getClass(), this.def);
        }
    }

    public Annotation(AnnotationDef def, Map<String, ? extends Object> fields) {
        this.def = def;
        this.fieldValues = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(fields));
        this.checkRep();
    }

    public Annotation(java.lang.annotation.Annotation ja, Map<String, AnnotationDef> adefs) {
        Class<? extends java.lang.annotation.Annotation> jaType = ja.annotationType();
        String name = jaType.getName();
        if (adefs.containsKey(name)) {
            this.def = adefs.get(name);
        } else {
            this.def = AnnotationDef.fromClass(jaType, adefs);
            adefs.put(name, this.def);
        }
        this.fieldValues = new LinkedHashMap<String, Object>();
        try {
            for (String fieldname : this.def.fieldTypes.keySet()) {
                Method m3;
                ArrayList<Object> val;
                AnnotationFieldType aft = this.def.fieldTypes.get(fieldname);
                if (!aft.isValidValue(val = (m3 = jaType.getDeclaredMethod(fieldname, new Class[0])).invoke((Object)ja, new Object[0]))) {
                    ArrayList<Object> vall;
                    Object[] vala;
                    if (val instanceof Class[]) {
                        vala = (Class[])val;
                        vall = new ArrayList<Object>(vala.length);
                        for (Object elt : vala) {
                            vall.add(elt);
                        }
                        val = vall;
                    } else if (val instanceof Object[]) {
                        vala = (Object[])val;
                        vall = new ArrayList(vala.length);
                        for (Object elt : vala) {
                            vall.add(elt.toString());
                        }
                        val = vall;
                    } else {
                        val = ((Object)val).toString();
                    }
                }
                assert (aft.isValidValue(val)) : String.format("invalid value \"%s\" for field \"%s\" of class \"%s\" and expected type \"%s\"; ja=%s", val, val.getClass(), fieldname, aft, ja);
                this.fieldValues.put(fieldname, val);
            }
        }
        catch (NoSuchMethodException e) {
            throw new Error(String.format("no such method (annotation field) in %s%n  from: %s %s", jaType, ja, adefs), e);
        }
        catch (InvocationTargetException e) {
            throw new Error(e);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        this.checkRep();
    }

    public Object getFieldValue(String fieldName) {
        return this.fieldValues.get(fieldName);
    }

    public final AnnotationDef def() {
        return this.def;
    }

    public final boolean equals(Object o) {
        return o instanceof Annotation && this.equals((Annotation)o);
    }

    public boolean equals(Annotation o) {
        return this.def.equals(o.def()) && this.fieldValues.equals(o.fieldValues);
    }

    public int hashCode() {
        return this.def.hashCode() + this.fieldValues.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("@" + this.def.name);
        if (this.fieldValues.size() == 1 && this.fieldValues.containsKey("value")) {
            AnnotationFieldType fieldType = this.def.fieldTypes.get("value");
            result.append('(');
            result.append(fieldType.format(this.fieldValues.get("value")));
            result.append(')');
        } else if (this.fieldValues.size() > 0) {
            result.append('(');
            boolean notfirst = false;
            for (Map.Entry<String, Object> field : this.fieldValues.entrySet()) {
                if (notfirst) {
                    result.append(", ");
                } else {
                    notfirst = true;
                }
                result.append(field.getKey() + "=");
                AnnotationFieldType fieldType = this.def.fieldTypes.get(field.getKey());
                result.append(fieldType.format(field.getValue()));
            }
            result.append(')');
        }
        return result.toString();
    }
}

