/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations;

import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import scenelib.annotations.Annotation;
import scenelib.annotations.AnnotationBuilder;
import scenelib.annotations.AnnotationFactory;
import scenelib.annotations.ArrayBuilder;
import scenelib.annotations.el.AnnotationDef;
import scenelib.annotations.field.AnnotationAFT;
import scenelib.annotations.field.AnnotationFieldType;
import scenelib.annotations.field.ArrayAFT;
import scenelib.annotations.field.EnumAFT;
import scenelib.annotations.field.ScalarAFT;

public abstract class Annotations {
    public static Set<Annotation> noAnnotations = Collections.emptySet();
    public static Map<String, ? extends AnnotationFieldType> noFieldTypes = Collections.emptyMap();
    public static Map<String, ? extends Object> noFieldValues = Collections.emptyMap();
    public static Set<Annotation> typeQualifierMetaAnnotations;
    public static EnumAFT aftRetentionPolicy;
    public static AnnotationDef adRetention;
    public static Annotation aRetentionClass;
    public static Annotation aRetentionRuntime;
    public static Annotation aRetentionSource;
    public static Set<Annotation> asRetentionClass;
    public static Set<Annotation> asRetentionRuntime;
    public static Set<Annotation> asRetentionSource;
    public static AnnotationDef adTarget;
    public static Annotation aTargetTypeUse;
    public static List<Annotation> onlyTypeAnnotationTargets;
    public static AnnotationDef adDocumented;
    public static Annotation aDocumented;
    public static AnnotationDef adNonNull;
    public static Annotation aNonNull;
    public static Set<AnnotationDef> standardDefs;

    private Annotations() {
    }

    static Map<String, ? extends AnnotationFieldType> valueFieldTypeOnly(AnnotationFieldType aft) {
        return Collections.singletonMap("value", aft);
    }

    public static Map<String, ? extends Object> valueFieldOnly(Object valueValue) {
        return Collections.singletonMap("value", valueValue);
    }

    public static AnnotationDef createValueAnnotationDef(String name, Set<Annotation> metaAnnotations, AnnotationFieldType aft, String source) {
        return new AnnotationDef(name, metaAnnotations, Annotations.valueFieldTypeOnly(aft), source);
    }

    public static Annotation createValueAnnotation(AnnotationDef ad, Object value) {
        return new Annotation(ad, Annotations.valueFieldOnly(value));
    }

    public static Annotation getRetentionPolicyMetaAnnotation(RetentionPolicy rp) {
        switch (rp) {
            case CLASS: {
                return aRetentionClass;
            }
            case RUNTIME: {
                return aRetentionRuntime;
            }
            case SOURCE: {
                return aRetentionSource;
            }
        }
        throw new Error("This can't happen");
    }

    public static Set<Annotation> getRetentionPolicyMetaAnnotationSet(RetentionPolicy rp) {
        switch (rp) {
            case CLASS: {
                return asRetentionClass;
            }
            case RUNTIME: {
                return asRetentionRuntime;
            }
            case SOURCE: {
                return asRetentionSource;
            }
        }
        throw new Error("This can't happen");
    }

    private static Object convertAFV(ScalarAFT aft, Object x) {
        if (aft instanceof AnnotationAFT) {
            return Annotations.rebuild((Annotation)x);
        }
        return x;
    }

    public static final Annotation rebuild(Annotation a) {
        AnnotationBuilder ab = AnnotationFactory.saf.beginAnnotation(a.def(), "rebuild " + a.def.source);
        if (ab != null) {
            for (Map.Entry<String, AnnotationFieldType> fieldDef : a.def().fieldTypes.entrySet()) {
                String fieldName = fieldDef.getKey();
                AnnotationFieldType fieldType = fieldDef.getValue();
                Object fieldValue = a.getFieldValue(fieldName);
                if (fieldValue == null) {
                    throw new IllegalArgumentException("annotation has no field value");
                }
                Object nnFieldValue = fieldValue;
                if (fieldType instanceof ArrayAFT) {
                    ArrayAFT aFieldType = (ArrayAFT)fieldType;
                    ArrayBuilder arrb = ab.beginArrayField(fieldName, aFieldType);
                    List l = (List)fieldValue;
                    if (aFieldType.elementType == null) {
                        throw new IllegalArgumentException("annotation field type is missing element type");
                    }
                    ScalarAFT nnElementType = aFieldType.elementType;
                    for (Object o : l) {
                        arrb.appendElement(Annotations.convertAFV(nnElementType, o));
                    }
                    arrb.finish();
                    continue;
                }
                ScalarAFT sFieldType = (ScalarAFT)fieldType;
                ab.addScalarField(fieldName, sFieldType, Annotations.convertAFV(sFieldType, fieldValue));
            }
            return ab.finish();
        }
        return null;
    }

    static {
        aftRetentionPolicy = new EnumAFT("java.lang.annotation.RetentionPolicy");
        adRetention = new AnnotationDef("java.lang.annotation.Retention", "'Retention' in scenelib/annotations/Annotations");
        adRetention.setFieldTypes(Annotations.valueFieldTypeOnly(aftRetentionPolicy));
        aRetentionRuntime = Annotations.createValueAnnotation(adRetention, "RUNTIME");
        Annotations.adRetention.tlAnnotationsHere.add(aRetentionRuntime);
        aRetentionClass = Annotations.createValueAnnotation(adRetention, "CLASS");
        aRetentionSource = Annotations.createValueAnnotation(adRetention, "SOURCE");
        asRetentionClass = Collections.singleton(aRetentionClass);
        asRetentionRuntime = Collections.singleton(aRetentionRuntime);
        asRetentionSource = Collections.singleton(aRetentionSource);
        adDocumented = new AnnotationDef("java.lang.annotation.Documented", "'Documented' in scenelib/annotations/Annotations");
        adDocumented.setFieldTypes(noFieldTypes);
        aDocumented = new Annotation(adDocumented, noFieldValues);
        Annotations.adDocumented.tlAnnotationsHere.add(aDocumented);
        adTarget = Annotations.createValueAnnotationDef("java.lang.annotation.Target", asRetentionRuntime, new ArrayAFT(new EnumAFT("java.lang.annotation.ElementType")), "'Target' in scenelib/annotations/Annotations");
        aTargetTypeUse = Annotations.createValueAnnotation(adTarget, Collections.singletonList("TYPE_USE"));
        onlyTypeAnnotationTargets = Arrays.asList(aTargetTypeUse, Annotations.createValueAnnotation(adTarget, Arrays.asList("TYPE_USE", "TYPE_PARAMETER")), Annotations.createValueAnnotation(adTarget, Arrays.asList("TYPE_PARAMETER", "TYPE_USE")));
        typeQualifierMetaAnnotations = new HashSet<Annotation>();
        typeQualifierMetaAnnotations.add(aRetentionRuntime);
        typeQualifierMetaAnnotations.add(aTargetTypeUse);
        adNonNull = new AnnotationDef("org.checkerframework.checker.nullness.qual.NonNull", typeQualifierMetaAnnotations, noFieldTypes, "'NonNull' in scenelib/annotations/Annotations");
        aNonNull = new Annotation(adNonNull, noFieldValues);
        standardDefs = new LinkedHashSet<AnnotationDef>();
        standardDefs.add(adTarget);
        standardDefs.add(adDocumented);
        standardDefs.add(adRetention);
    }
}

