/*
 * Copyright (c) 1999, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package jdk.javadoc.internal.doclets.toolkit.util;

import org.checkerframework.dataflow.qual.Pure;
import java.lang.annotation.Documented;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.text.CollationKey;
import java.text.Collator;
import java.util.*;
import java.util.AbstractMap.SimpleEntry;
import java.util.Map.Entry;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.ModuleElement.RequiresDirective;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.ElementKindVisitor9;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor9;
import javax.lang.model.util.SimpleTypeVisitor9;
import javax.lang.model.util.TypeKindVisitor9;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileManager.Location;
import javax.tools.StandardLocation;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.DocTree.Kind;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.SerialFieldTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTrees;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.model.JavacTypes;
import jdk.javadoc.internal.doclets.formats.html.SearchIndexItem;
import jdk.javadoc.internal.doclets.toolkit.BaseConfiguration;
import jdk.javadoc.internal.doclets.toolkit.CommentUtils.DocCommentDuo;
import jdk.javadoc.internal.doclets.toolkit.Messages;
import jdk.javadoc.internal.doclets.toolkit.WorkArounds;
import jdk.javadoc.internal.tool.DocEnvImpl;
import static javax.lang.model.element.ElementKind.*;
import static javax.lang.model.element.Modifier.*;
import static javax.lang.model.type.TypeKind.*;
import static com.sun.source.doctree.DocTree.Kind.*;
import static jdk.javadoc.internal.doclets.toolkit.builders.ConstantsSummaryBuilder.MAX_CONSTANT_VALUE_INDEX_LENGTH;

public class Utils {

    public final BaseConfiguration configuration;

    public final Messages messages;

    public final DocTrees docTrees;

    public final Elements elementUtils;

    public final Types typeUtils;

    public final JavaScriptScanner javaScriptScanner;

    public Utils(BaseConfiguration c) {
    }

    public TypeMirror getSymbol(String signature);

    public TypeMirror getObjectType();

    public TypeMirror getExceptionType();

    public TypeMirror getErrorType();

    public TypeMirror getSerializableType();

    public TypeMirror getExternalizableType();

    public TypeMirror getIllegalArgumentExceptionType();

    public TypeMirror getNullPointerExceptionType();

    public TypeMirror getDeprecatedType();

    public TypeMirror getFunctionalInterface();

    public List<Element> excludeDeprecatedMembers(List<? extends Element> members);

    public ExecutableElement findMethod(TypeElement te, ExecutableElement method);

    @Pure
    public boolean isSubclassOf(TypeElement t1, TypeElement t2);

    public boolean executableMembersEqual(ExecutableElement e1, ExecutableElement e2);

    @Pure
    public boolean isCoreClass(TypeElement e);

    public Location getLocationForPackage(PackageElement pd);

    public Location getLocationForModule(ModuleElement mdle);

    @Pure
    public boolean isAnnotated(TypeMirror e);

    @Pure
    public boolean isAnnotated(Element e);

    @Pure
    public boolean isAnnotationType(Element e);

    @Pure
    public boolean isClass(Element e);

    @Pure
    public boolean isConstructor(Element e);

    @Pure
    public boolean isEnum(Element e);

    @Pure
    boolean isEnumConstant(Element e);

    @Pure
    public boolean isField(Element e);

    @Pure
    public boolean isInterface(Element e);

    @Pure
    public boolean isMethod(Element e);

    @Pure
    public boolean isModule(Element e);

    @Pure
    public boolean isPackage(Element e);

    @Pure
    public boolean isAbstract(Element e);

    @Pure
    public boolean isDefault(Element e);

    @Pure
    public boolean isPackagePrivate(Element e);

    @Pure
    public boolean isPrivate(Element e);

    @Pure
    public boolean isProtected(Element e);

    @Pure
    public boolean isPublic(Element e);

    @Pure
    public boolean isProperty(String name);

    public String getPropertyName(String name);

    public String getPropertyLabel(String name);

    @Pure
    public boolean isOverviewElement(Element e);

    @Pure
    public boolean isStatic(Element e);

    @Pure
    public boolean isSerializable(TypeElement e);

    @Pure
    public boolean isExternalizable(TypeElement e);

    public SortedSet<VariableElement> serializableFields(TypeElement aclass);

    public SortedSet<ExecutableElement> serializationMethods(TypeElement aclass);

    public boolean definesSerializableFields(TypeElement aclass);

    public String modifiersToString(Element e, boolean trailingSpace);

    @Pure
    public boolean isFunctionalInterface(AnnotationMirror amirror);

    @Pure
    public boolean isNoType(TypeMirror t);

    @Pure
    public boolean isOrdinaryClass(TypeElement te);

    @Pure
    public boolean isError(TypeElement te);

    @Pure
    public boolean isException(TypeElement te);

    @Pure
    public boolean isPrimitive(TypeMirror t);

    @Pure
    public boolean isExecutableElement(Element e);

    @Pure
    public boolean isVariableElement(Element e);

    @Pure
    public boolean isTypeElement(Element e);

    public String signature(ExecutableElement e);

    public String flatSignature(ExecutableElement e);

    public String makeSignature(ExecutableElement e, boolean full);

    public String makeSignature(ExecutableElement e, boolean full, boolean ignoreTypeParameters);

    public String getTypeSignature(TypeMirror t, boolean qualifiedName, boolean noTypeParameters);

    @Pure
    public boolean isArrayType(TypeMirror t);

    @Pure
    public boolean isDeclaredType(TypeMirror t);

    @Pure
    public boolean isErrorType(TypeMirror t);

    @Pure
    public boolean isIntersectionType(TypeMirror t);

    @Pure
    public boolean isTypeParameterElement(Element e);

    @Pure
    public boolean isTypeVariable(TypeMirror t);

    @Pure
    public boolean isVoid(TypeMirror t);

    @Pure
    public boolean isWildCard(TypeMirror t);

    public boolean ignoreBounds(TypeMirror bound);

    public List<? extends TypeMirror> getBounds(TypeParameterElement tpe);

    public TypeMirror getReturnType(ExecutableElement ee);

    public TypeMirror overriddenType(ExecutableElement method);

    public TypeMirror getSuperType(TypeElement te);

    public TypeElement overriddenClass(ExecutableElement ee);

    public ExecutableElement overriddenMethod(ExecutableElement method);

    public SortedSet<TypeElement> getTypeElementsAsSortedSet(Iterable<TypeElement> typeElements);

    public List<? extends DocTree> getSerialDataTrees(ExecutableElement member);

    public FileObject getFileObject(TypeElement te);

    public TypeMirror getDeclaredType(TypeElement enclosing, TypeMirror target);

    public TypeMirror getDeclaredType(Collection<TypeMirror> values, TypeElement enclosing, TypeMirror target);

    public Set<TypeMirror> getAllInterfaces(TypeElement te);

    public TypeElement findClassInPackageElement(PackageElement pkg, String className);

    public TypeElement findClass(Element element, String className);

    public String quote(String filepath);

    public String parsePackageName(PackageElement p);

    public String replaceText(String originalStr, String oldStr, String newStr);

    @Pure
    public boolean isDocumentedAnnotation(TypeElement annotation);

    @Pure
    public boolean isLinkable(TypeElement typeElem);

    public TypeElement asTypeElement(TypeMirror t);

    public TypeMirror getComponentType(TypeMirror t);

    public String getDimension(TypeMirror t);

    public TypeElement getSuperClass(TypeElement te);

    public TypeElement getFirstVisibleSuperClassAsTypeElement(TypeElement te);

    public TypeMirror getFirstVisibleSuperClass(TypeMirror type);

    public TypeMirror getFirstVisibleSuperClass(TypeElement te);

    public String getTypeElementName(TypeElement te, boolean lowerCaseOnly);

    public String getTypeName(TypeMirror t, boolean fullyQualified);

    public String replaceTabs(String text);

    public CharSequence normalizeNewlines(CharSequence text);

    public void setEnumDocumentation(TypeElement elem);

    public static String toUpperCase(String s);

    public static String toLowerCase(String s);

    @Pure
    public boolean isDeprecated(Element e);

    @Pure
    public boolean isDeprecatedForRemoval(Element e);

    public String propertyName(ExecutableElement e);

    public boolean hasHiddenTag(Element e);

    @Pure
    public boolean isSimpleOverride(ExecutableElement m);

    public SortedSet<TypeElement> filterOutPrivateClasses(Iterable<TypeElement> classlist, boolean javafx);

    public boolean elementsEqual(Element e1, Element e2);

    public int compareStrings(String s1, String s2);

    public int compareCaseCompare(String s1, String s2);

    private static class DocCollator {

        CollationKey getKey(String s);

        public int compare(String s1, String s2);
    }

    public Comparator<Element> makeModuleComparator();

    public Comparator<Element> makeAllClassesComparator();

    public Comparator<Element> makePackageComparator();

    public Comparator<Element> makeDeprecatedComparator();

    public Comparator<SerialFieldTree> makeSerialFieldTreeComparator();

    public Comparator<Element> makeGeneralPurposeComparator();

    public Comparator<Element> makeOverrideUseComparator();

    public Comparator<Element> makeIndexUseComparator();

    public Comparator<TypeMirror> makeTypeMirrorClassUseComparator();

    public Comparator<TypeMirror> makeTypeMirrorIndexUseComparator();

    public String getQualifiedTypeName(TypeMirror t);

    public String getFullyQualifiedName(Element e);

    public String getFullyQualifiedName(Element e, final boolean outer);

    public Comparator<Element> makeClassUseComparator();

    private abstract class ElementComparator implements Comparator<Element> {

        public ElementComparator() {
        }

        protected int compareParameters(boolean caseSensitive, List<? extends VariableElement> params1, List<? extends VariableElement> params2);

        String getParametersAsString(List<? extends VariableElement> params);

        protected int compareNames(Element e1, Element e2);

        protected int compareFullyQualifiedNames(Element e1, Element e2);

        protected int compareElementTypeKinds(Element e1, Element e2);

        boolean hasParameters(Element e);
    }

    public Comparator<SearchIndexItem> makeTypeSearchIndexComparator();

    public Comparator<SearchIndexItem> makeGenericSearchIndexComparator();

    public Iterable<TypeElement> getEnclosedTypeElements(PackageElement pkg);

    public List<Element> getAnnotationMembers(TypeElement aClass);

    public List<Element> getAnnotationFields(TypeElement aClass);

    List<Element> getAnnotationFieldsUnfiltered(TypeElement aClass);

    public List<Element> getAnnotationMethods(TypeElement aClass);

    public List<TypeElement> getAnnotationTypes(Element e);

    public List<TypeElement> getAnnotationTypesUnfiltered(Element e);

    public List<VariableElement> getFields(Element e);

    public List<VariableElement> getFieldsUnfiltered(Element e);

    public List<TypeElement> getClasses(Element e);

    public List<TypeElement> getClassesUnfiltered(Element e);

    public List<ExecutableElement> getConstructors(Element e);

    public List<ExecutableElement> getMethods(Element e);

    List<ExecutableElement> getMethodsUnfiltered(Element e);

    public int getOrdinalValue(VariableElement member);

    public Map<ModuleElement, Set<PackageElement>> getModulePackageMap();

    public Map<ModuleElement, String> getDependentModules(ModuleElement mdle);

    public String getModifiers(RequiresDirective rd);

    public long getLineNumber(Element e);

    public List<ExecutableElement> convertToExecutableElement(List<Element> list);

    public List<TypeElement> convertToTypeElement(List<Element> list);

    public List<VariableElement> convertToVariableElement(List<Element> list);

    public List<TypeElement> getInterfaces(Element e);

    public List<TypeElement> getInterfacesUnfiltered(Element e);

    public List<Element> getEnumConstants(Element e);

    public List<TypeElement> getEnums(Element e);

    public List<TypeElement> getEnumsUnfiltered(Element e);

    public SortedSet<TypeElement> getAllClassesUnfiltered(Element e);

    public SortedSet<TypeElement> getAllClasses(Element e);

    public List<TypeElement> getInnerClasses(Element e);

    public List<TypeElement> getInnerClassesUnfiltered(Element e);

    public List<TypeElement> getOrdinaryClasses(Element e);

    public List<TypeElement> getErrors(Element e);

    public List<TypeElement> getExceptions(Element e);

    List<Element> getItems(Element e, boolean filter, ElementKind select);

    void recursiveGetItems(Collection<Element> list, Element e, boolean filter, ElementKind... select);

    protected boolean shouldDocument(Element e);

    public String getSimpleName(Element e);

    public TypeElement getEnclosingTypeElement(Element e);

    public String constantValueExpresion(VariableElement ve);

    private static class ConstantValueExpression {

        public String constantValueExpression(WorkArounds workArounds, VariableElement ve);
    }

    @Pure
    public boolean isEnclosingPackageIncluded(TypeElement te);

    @Pure
    public boolean isIncluded(Element e);

    @Pure
    public boolean isSpecified(Element e);

    public String getPackageName(PackageElement pkg);

    public String getModuleName(ModuleElement mdle);

    @Pure
    public boolean isAttribute(DocTree doctree);

    @Pure
    public boolean isAuthor(DocTree doctree);

    @Pure
    public boolean isComment(DocTree doctree);

    @Pure
    public boolean isDeprecated(DocTree doctree);

    @Pure
    public boolean isDocComment(DocTree doctree);

    @Pure
    public boolean isDocRoot(DocTree doctree);

    @Pure
    public boolean isEndElement(DocTree doctree);

    @Pure
    public boolean isEntity(DocTree doctree);

    @Pure
    public boolean isErroneous(DocTree doctree);

    @Pure
    public boolean isException(DocTree doctree);

    @Pure
    public boolean isIdentifier(DocTree doctree);

    @Pure
    public boolean isInheritDoc(DocTree doctree);

    @Pure
    public boolean isLink(DocTree doctree);

    @Pure
    public boolean isLinkPlain(DocTree doctree);

    @Pure
    public boolean isLiteral(DocTree doctree);

    @Pure
    public boolean isOther(DocTree doctree);

    @Pure
    public boolean isParam(DocTree doctree);

    @Pure
    public boolean isReference(DocTree doctree);

    @Pure
    public boolean isReturn(DocTree doctree);

    @Pure
    public boolean isSee(DocTree doctree);

    @Pure
    public boolean isSerial(DocTree doctree);

    @Pure
    public boolean isSerialData(DocTree doctree);

    @Pure
    public boolean isSerialField(DocTree doctree);

    @Pure
    public boolean isSince(DocTree doctree);

    @Pure
    public boolean isStartElement(DocTree doctree);

    @Pure
    public boolean isText(DocTree doctree);

    @Pure
    public boolean isThrows(DocTree doctree);

    @Pure
    public boolean isUnknownBlockTag(DocTree doctree);

    @Pure
    public boolean isUnknownInlineTag(DocTree doctree);

    @Pure
    public boolean isValue(DocTree doctree);

    @Pure
    public boolean isVersion(DocTree doctree);

    public CommentHelper getCommentHelper(Element element);

    public void removeCommentHelper(Element element);

    public List<? extends DocTree> filteredList(List<? extends DocTree> dlist, DocTree.Kind... select);

    public List<? extends DocTree> getBlockTags(Element element);

    public List<? extends DocTree> getBlockTags(Element element, DocTree.Kind... kinds);

    public List<? extends DocTree> getBlockTags(Element element, String tagName);

    public boolean hasBlockTag(Element element, DocTree.Kind kind);

    public boolean hasBlockTag(Element element, DocTree.Kind kind, final String tagName);

    public TreePath getTreePath(Element e);

    public DocCommentTree getDocCommentTree0(Element element);

    public void checkJavaScriptInOption(String name, String value);

    @Pure
    boolean isValidDuo(DocCommentDuo duo);

    public DocCommentTree getDocCommentTree(Element element);

    public List<? extends DocTree> getPreamble(Element element);

    public List<? extends DocTree> getFullBody(Element element);

    public List<? extends DocTree> getBody(Element element);

    public List<? extends DocTree> getDeprecatedTrees(Element element);

    public List<? extends DocTree> getProvidesTrees(Element element);

    public List<? extends DocTree> getSeeTrees(Element element);

    public List<? extends DocTree> getSerialTrees(Element element);

    public List<? extends DocTree> getSerialFieldTrees(VariableElement field);

    public List<? extends DocTree> getThrowsTrees(Element element);

    public List<? extends DocTree> getTypeParamTrees(Element element);

    public List<? extends DocTree> getParamTrees(Element element);

    public List<? extends DocTree> getReturnTrees(Element element);

    public List<? extends DocTree> getUsesTrees(Element element);

    public List<? extends DocTree> getFirstSentenceTrees(Element element);

    public ModuleElement containingModule(Element e);

    public PackageElement containingPackage(Element e);

    public TypeElement getTopMostContainingTypeElement(Element e);

    static class WeakSoftHashMap implements Map<Element, CommentHelper> {

        public WeakSoftHashMap(Utils utils) {
        }

        @Override
        public boolean containsKey(Object key);

        @Override
        public Collection<CommentHelper> values();

        @Override
        public boolean containsValue(Object value);

        @Override
        public CommentHelper remove(Object key);

        @Override
        public CommentHelper put(Element key, CommentHelper value);

        @Override
        public CommentHelper get(Object key);

        @Override
        public int size();

        @Override
        @Pure
        public boolean isEmpty();

        @Override
        public void clear();

        public CommentHelper computeIfAbsent(Element key);

        @Override
        public void putAll(Map<? extends Element, ? extends CommentHelper> map);

        @Override
        public Set<Element> keySet();

        @Override
        public Set<Entry<Element, CommentHelper>> entrySet();
    }

    public static class Pair<K, L> {

        public final K first;

        public final L second;

        public Pair(K first, L second) {
        }

        public String toString();
    }
}
