/*
 * Copyright (c) 2003, 2015, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.sun.java.util.jar.pack;

import org.checkerframework.dataflow.qual.Pure;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.Pack200;

@SuppressWarnings({ "removal" })
final class PropMap implements SortedMap<String, String> {

    public String put(String key, String value);

    SortedMap<String, String> prefixMap(String prefix);

    String getProperty(String s);

    String getProperty(String s, String defaultVal);

    String setProperty(String s, String val);

    List<String> getProperties(String prefix);

    boolean getBoolean(String s);

    boolean setBoolean(String s, boolean val);

    int toInteger(String val);

    int toInteger(String val, int def);

    int getInteger(String s, int def);

    int getInteger(String s);

    int setInteger(String s, int val);

    long toLong(String val);

    long getLong(String s);

    long setLong(String s, long val);

    int getTime(String s);

    void list(PrintStream out);

    void list(PrintWriter out);

    @Override
    public int size();

    @Override
    public boolean isEmpty();

    @Override
    @Pure
    public boolean containsKey(Object key);

    @Override
    public boolean containsValue(Object value);

    @Override
    public String get(Object key);

    @Override
    public String remove(Object key);

    @Override
    public void putAll(Map<? extends String, ? extends String> m);

    @Override
    public void clear();

    @Override
    public Set<String> keySet();

    @Override
    public Collection<String> values();

    @Override
    public Set<Map.Entry<String, String>> entrySet();

    @Override
    public Comparator<? super String> comparator();

    @Override
    public SortedMap<String, String> subMap(String fromKey, String toKey);

    @Override
    public SortedMap<String, String> headMap(String toKey);

    @Override
    public SortedMap<String, String> tailMap(String fromKey);

    @Override
    public String firstKey();

    @Override
    public String lastKey();
}
